/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.locker.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.exception.ZKBusinessException;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.locker.remote.LockerLinkageRemote;
import com.zkteco.zkbiosecurity.locker.service.LockerDeviceService;
import com.zkteco.zkbiosecurity.locker.service.LockerLinkageService;
import com.zkteco.zkbiosecurity.locker.vo.LockerLinkageBeanItem;
import com.zkteco.zkbiosecurity.locker.vo.LockerLinkageItem;
import com.zkteco.zkbiosecurity.locker.vo.LockerLinkageSelectDeviceItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class LockerLinkageController
extends BaseController
implements LockerLinkageRemote {
    private static final Logger log = LoggerFactory.getLogger(LockerLinkageController.class);
    @Autowired
    private LockerLinkageService lockerLinkageService;
    @Autowired
    private LockerDeviceService lockerDeviceService;

    @RequiresPermissions(value={"locker:linkage"})
    public ModelAndView index() {
        return new ModelAndView("locker/linkage/lockerLinkage");
    }

    @RequiresPermissions(value={"locker:linkage:add", "locker:linkage:edit"})
    public ModelAndView edit(String id) {
        boolean showLine = this.lockerLinkageService.checkShowLine();
        if (StringUtils.isNotBlank((CharSequence)id)) {
            LockerLinkageItem lockerLinkageItem = this.lockerLinkageService.getLinkageParams(id);
            this.request.setAttribute("item", (Object)lockerLinkageItem);
            if (showLine) {
                List lockerLinkage4LineContactItems = this.lockerLinkageService.getLineContactsByIds(lockerLinkageItem.getLineContactId());
                this.request.setAttribute("contactList", (Object)lockerLinkage4LineContactItems);
            }
        }
        this.request.setAttribute("showLine", (Object)showLine);
        this.request.setAttribute("showWhatsapp", (Object)this.lockerLinkageService.checkShowWhatsapp());
        this.request.setAttribute("showSMS", (Object)this.lockerLinkageService.checkShowSMS());
        return new ModelAndView("locker/linkage/editLockerLinkage");
    }

    @RequiresPermissions(value={"locker:linkage:add", "locker:linkage:edit"})
    @LogRequest(module="locker_module", object="locker_leftMenu_globalLinkage", opType="common_op_edit", requestParams={"name"}, opContent="common_linkIO_linkageName")
    public ZKResultMsg save(LockerLinkageItem item) {
        ZKResultMsg res = new ZKResultMsg();
        String[] deviceIds = this.request.getParameter("deviceIds").split(",");
        String[] triggerCondArray = this.request.getParameter("triggerCond").split(",");
        String[] mailAddr = this.request.getParameter("mailAddr").replaceAll(";", ",").split(",");
        String[] mobileNo = null;
        if (StringUtils.isNotBlank((CharSequence)this.request.getParameter("mobileNo"))) {
            mobileNo = this.request.getParameter("mobileNo").replaceAll(";", ",").split(",");
        }
        String[] whatsappMobileNo = null;
        if (StringUtils.isNotBlank((CharSequence)item.getWhatsappMobileNo())) {
            whatsappMobileNo = item.getWhatsappMobileNo().replaceAll(";", ",").split(",");
        }
        String popUpVideo = this.request.getParameter("popUpVideo");
        String popUpTime = this.request.getParameter("popUpTime");
        String record = this.request.getParameter("record");
        String recordTime = this.request.getParameter("recordTime");
        String capture = this.request.getParameter("capture");
        String captureTime = this.request.getParameter("captureTime");
        String lineContactIds = this.request.getParameter("lineContactId");
        LockerLinkageBeanItem lockerLinkageBean = new LockerLinkageBeanItem();
        lockerLinkageBean.setDeviceIds(deviceIds);
        lockerLinkageBean.setTriggerCondArray(triggerCondArray);
        lockerLinkageBean.setMailAddr(mailAddr);
        lockerLinkageBean.setMobileNo(mobileNo);
        lockerLinkageBean.setLineContactIds(lineContactIds);
        lockerLinkageBean.setWhatsappMobileNo(whatsappMobileNo);
        if (StringUtils.isNotBlank((CharSequence)popUpVideo) && "1".equals(popUpVideo)) {
            lockerLinkageBean.setPopUpTime(Integer.valueOf(Integer.parseInt(popUpTime)));
        }
        if (StringUtils.isNotBlank((CharSequence)record) && "2".equals(record)) {
            lockerLinkageBean.setRecordTime(Integer.valueOf(Integer.parseInt(recordTime)));
        }
        if (StringUtils.isNotBlank((CharSequence)capture) && "3".equals(capture)) {
            lockerLinkageBean.setCapture(capture);
            if (StringUtils.isNotBlank((CharSequence)captureTime)) {
                lockerLinkageBean.setCaptureTime(Integer.valueOf(Integer.parseInt(captureTime)));
            } else {
                lockerLinkageBean.setCaptureTime(Integer.valueOf(0));
            }
        }
        this.lockerLinkageService.saveItem(lockerLinkageBean, item);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @RequiresPermissions(value={"locker:linkage:refresh"})
    public DxGrid list(LockerLinkageItem codition) {
        Pager pager = this.lockerLinkageService.loadPagerAndBuildCondByAuthFilter(this.request.getSession().getId(), codition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, codition.getClass());
    }

    @RequiresPermissions(value={"locker:linkage:del"})
    @LogRequest(module="locker_module", object="locker_leftMenu_globalLinkage", opType="common_op_del", requestParams={"names"}, opContent="common_linkIO_linkageName")
    public ZKResultMsg del(String ids) {
        this.lockerLinkageService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    public String validName(String name) {
        LockerLinkageItem item = this.lockerLinkageService.getItemByName(name);
        return (item == null) + "";
    }

    public DxGrid selectDeviceList(LockerLinkageSelectDeviceItem condition) {
        Pager pager = new Pager();
        if (condition.getType().equals("noSelected")) {
            condition.setSelectDeviceIdsNotIn(condition.getSelectId());
            pager = this.lockerDeviceService.loadSelectPagerByAuthFilter(this.request.getSession().getId(), condition, this.getPageNo(), this.getPageSize());
        } else if (condition.getType().equals("selected")) {
            pager.setData(new ArrayList());
        }
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    public ZKResultMsg checkMailParam() {
        ZKResultMsg zkResultMsg = new ZKResultMsg();
        zkResultMsg.setData((Object)this.lockerLinkageService.completeMailInfo());
        return I18nUtil.i18nMsg((ZKResultMsg)zkResultMsg);
    }

    public ZKResultMsg getLinkTriggerOpt() {
        ZKResultMsg zkResultMsg = new ZKResultMsg();
        String deviceId = this.request.getParameter("devId");
        String accLinkageId = this.request.getParameter("linkageId");
        Map triggerOptMap = this.lockerLinkageService.getLinkTriggerOpt(deviceId, accLinkageId);
        Map eventMap = (Map)triggerOptMap.get("eventMap");
        Map checkEventMap = (Map)triggerOptMap.get("checkEventMap");
        Map checkParentElementMap = (Map)triggerOptMap.get("checkParentElementMap");
        JSONArray triggerOptArray = new JSONArray();
        try {
            JSONArray deviceEvent = new JSONArray();
            JSONObject dataJson = null;
            for (Map.Entry event : eventMap.entrySet()) {
                int eventNo = Integer.parseInt((String)event.getKey());
                dataJson = new JSONObject();
                dataJson.put("id", event.getKey());
                dataJson.put("text", (Object)I18nUtil.i18nCode((String)((String)event.getValue()), (Object[])new Object[0]));
                if (checkEventMap.containsKey(eventNo)) {
                    dataJson.put("checked", (Object)1);
                }
                deviceEvent.add((Object)dataJson);
            }
            ArrayList<String> parentElement = new ArrayList<String>();
            parentElement.add(I18nUtil.i18nCode((String)"common_linkIO_deviceEvent", (Object[])new Object[0]));
            for (int i = 0; i < parentElement.size(); ++i) {
                dataJson = new JSONObject();
                dataJson.put("id", (Object)(i + "_parent"));
                dataJson.put("text", parentElement.get(i));
                dataJson.put("open", (Object)"1");
                if (checkParentElementMap.containsKey(i)) {
                    dataJson.put("checked", (Object)"-1");
                }
                dataJson.put("item", (Object)deviceEvent);
                triggerOptArray.add((Object)dataJson);
            }
        }
        catch (Exception e) {
            throw new ZKBusinessException((Throwable)e);
        }
        zkResultMsg.setData((Object)triggerOptArray);
        return I18nUtil.i18nMsg((ZKResultMsg)zkResultMsg);
    }

    public ZKResultMsg checkTriggerOpt() {
        String devId = this.request.getParameter("devId");
        String triggerOpt = this.request.getParameter("triggerOpt");
        String[] triggerCondArray = new String[]{};
        if (triggerOpt.length() > 0) {
            triggerCondArray = this.request.getParameter("triggerOpt").split(",");
        }
        String[] inAddrArray = this.request.getParameter("inAddr").split(",");
        String linkageId = this.request.getParameter("linkageId");
        ZKResultMsg zkResultMsg = this.lockerLinkageService.checkTriggerOpt(devId, triggerCondArray, inAddrArray, linkageId);
        return I18nUtil.i18nMsg((ZKResultMsg)zkResultMsg);
    }
}

