/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.locker.controller;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.bean.ProcessBean;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.ClassUtil;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.core.web.cache.ProgressCache;
import com.zkteco.zkbiosecurity.locker.remote.LockerDeviceRemote;
import com.zkteco.zkbiosecurity.locker.service.LockerCacheService;
import com.zkteco.zkbiosecurity.locker.service.LockerChannelService;
import com.zkteco.zkbiosecurity.locker.service.LockerDevicePersonService;
import com.zkteco.zkbiosecurity.locker.service.LockerDeviceService;
import com.zkteco.zkbiosecurity.locker.service.LockerLockPersonService;
import com.zkteco.zkbiosecurity.locker.service.LockerParamsService;
import com.zkteco.zkbiosecurity.locker.vo.LockerDeviceItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class LockerDeviceController
extends BaseController
implements LockerDeviceRemote {
    @Autowired
    private LockerDeviceService lockerDeviceService;
    @Autowired
    private LockerLockPersonService lockerLockPersonService;
    @Autowired
    private ProgressCache progressCache;
    @Autowired
    private LockerCacheService lockerCacheService;
    @Autowired
    private LockerDevicePersonService lockerDevicePersonService;
    @Autowired
    private LockerParamsService lockerParamsService;
    @Autowired
    private LockerChannelService lockerChannelService;
    @Value(value="${system.filePath:BioSecurityFile}")
    private String systemFilePath;

    @RequiresPermissions(value={"locker:device"})
    public ModelAndView index() {
        return new ModelAndView("locker/device/lockerDevice");
    }

    @RequiresPermissions(value={"locker:device:edit", "locker:device:add"})
    public ModelAndView edit(String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            this.request.setAttribute("item", (Object)this.lockerDeviceService.getItemById(id));
        }
        return new ModelAndView("locker/device/editLockerDevice");
    }

    public ZKResultMsg save(LockerDeviceItem item) {
        ZKResultMsg res = new ZKResultMsg();
        if (StringUtils.isNotBlank((CharSequence)item.getMd5DeviceSecret())) {
            item.setDeviceSecret(item.getMd5DeviceSecret());
        }
        this.lockerDeviceService.saveItem(item);
        return res;
    }

    @RequiresPermissions(value={"locker:device:refresh"})
    public DxGrid list(LockerDeviceItem condition) {
        Pager pager = this.lockerDeviceService.loadPagerByAuthFilter(this.request.getSession().getId(), condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    public ZKResultMsg del(String ids) {
        this.lockerDeviceService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    public boolean isExistAlias(String alias) {
        return this.lockerDeviceService.isExistAlias(alias);
    }

    public boolean isExistIpAddress(String ipAddress) {
        return this.lockerDeviceService.isExistIpAddress(ipAddress);
    }

    public boolean isExistSn(String sn) {
        return this.lockerDeviceService.isExistSn(sn);
    }

    public boolean isExistDeviceSecret(String deviceSecret) {
        return this.lockerDeviceService.isExistDeviceSecret(deviceSecret);
    }

    public ZKResultMsg getDevciceList() {
        return new ZKResultMsg((Object)this.lockerDeviceService.getDevciceList(this.request.getSession().getId()));
    }

    @RequiresPermissions(value={"pers:person:lockerEdit"})
    public ModelAndView editPersType(String personId) {
        JSONObject jsonObject;
        if (StringUtils.isNotBlank((CharSequence)personId) && (jsonObject = this.lockerLockPersonService.getDevInfoByPersId(personId)) != null) {
            this.request.setAttribute("devInfo", jsonObject.get((Object)"devInfo"));
        }
        return new ModelAndView("locker/person/editPersType");
    }

    @RequiresPermissions(value={"locker:device:clearAdmin"})
    public ZKResultMsg clearAdministrator(String ids) {
        return this.lockerDeviceService.clearAdministrator(ids);
    }

    @RequiresPermissions(value={"locker:device:reboot"})
    @LogRequest(module="locker_module", object="common_leftMenu_device", opType="common_dev_reboot", requestParams={"alias"}, opContent="common_dev_name")
    public ZKResultMsg rebootDevice(String ids) {
        return this.lockerDeviceService.rebootDevice(ids);
    }

    @RequiresPermissions(value={"locker:device:syncTime"})
    @LogRequest(module="locker_module", object="common_leftMenu_device", opType="common_dev_syncTime", requestParams={"alias"}, opContent="common_dev_name")
    public ZKResultMsg syncTime(String devIds) {
        List lockerDeviceItemList;
        if (StringUtils.isNotBlank((CharSequence)devIds) && (lockerDeviceItemList = this.lockerDeviceService.getItemsByIds(devIds)) != null && !lockerDeviceItemList.isEmpty()) {
            this.progressCache.beginProcess(I18nUtil.i18nCode((String)"common_op_processing", (Object[])new Object[0]) + "...<br/>");
            StringBuffer cmdIdBuf = new StringBuffer();
            HashMap devDataMap = Maps.newHashMap();
            LockerDeviceItem dev = null;
            String timeZone = this.lockerDeviceService.getDefaultTimeZone();
            int len = lockerDeviceItemList.size();
            for (int i = 0; i < len; ++i) {
                dev = (LockerDeviceItem)lockerDeviceItemList.get(i);
                int total = (int)((double)(i + 1) * 0.5 / (double)lockerDeviceItemList.size() * 100.0);
                long cmdId = this.lockerDeviceService.syncTime(dev.getSn(), timeZone);
                cmdIdBuf.append(cmdId).append(",");
                devDataMap.put(cmdId, dev.getAlias());
                this.progressCache.setProcess(new ProcessBean(100, total, dev.getAlias() + " : " + I18nUtil.i18nCode((String)"common_dev_cmdSendSucceed", (Object[])new Object[0]) + "...<br/>"));
            }
            this.progressCache.setProcess(new ProcessBean(10, 50, I18nUtil.i18nCode((String)"common_dev_syncTime", (Object[])new Object[0]) + "...<br/>"));
            int j = 1;
            String[] cmdIdArray = cmdIdBuf.toString().split(",");
            int cmdIdArrayLen = cmdIdArray.length;
            for (int index = 0; index < cmdIdArrayLen; ++index) {
                if (cmdIdArray[index].equals("") || Long.parseLong(cmdIdArray[index]) <= 0L) continue;
                Long cmdId = Long.parseLong(cmdIdArray[index]);
                int total = (int)(((double)j * 0.5 + 1.0) / (double)lockerDeviceItemList.size() * 100.0);
                int ret = this.lockerCacheService.searchRedisByKey(cmdId.toString());
                String alias = (String)devDataMap.get(cmdId);
                if (ret >= 0) {
                    this.progressCache.setProcess(new ProcessBean(100, total, alias + ":" + I18nUtil.i18nCode((String)"common_dev_syncTimeSuccess", (Object[])new Object[0]) + "...<br/>"));
                } else {
                    this.progressCache.setProcess(new ProcessBean(100, total, alias + ":" + I18nUtil.i18nCode((String)"common_dev_syncTimeFail", (Object[])new Object[0]) + "...<br/>"));
                }
                ++j;
            }
            this.progressCache.finishProcess(I18nUtil.i18nCode((String)"common_progress_finish", (Object[])new Object[0]));
        }
        return null;
    }

    @RequiresPermissions(value={"locker:device:syncAllData"})
    @LogRequest(module="locker_module", object="common_leftMenu_device", opType="common_dev_syncAllDataToDev", requestParams={"alias"}, opContent="common_dev_name")
    public ZKResultMsg syncAllData(String devIds, String clearData) {
        try {
            this.progressCache.beginProcess(I18nUtil.i18nCode((String)"common_op_processing", (Object[])new Object[0]) + "...<br/>");
            List devList = this.lockerDeviceService.getItemsByIds(devIds);
            int size = devList.size();
            for (int i = 0; i < size; ++i) {
                LockerDeviceItem dev = (LockerDeviceItem)devList.get(i);
                int total = (int)((float)(i + 1) / (float)size * 100.0f);
                int lastTotal = (int)(((double)i + 0.3) / (double)size * 100.0);
                this.progressCache.setProcess(new ProcessBean(30, lastTotal, dev.getAlias() + ":" + I18nUtil.i18nCode((String)"common_dev_syncPrompt", (Object[])new Object[0]) + "<br/>"));
                this.lockerDeviceService.clearCmdCache(dev.getSn(), new String[]{"-1111"});
                this.lockerDeviceService.syncDataToDev(dev.getSn(), clearData);
                this.progressCache.setProcess(new ProcessBean(100, total, dev.getAlias() + ":" + I18nUtil.i18nCode((String)"common_dev_syncSuccess", (Object[])new Object[0]) + "<br/>"));
            }
        }
        catch (Exception e) {
            this.log.error("exception", (Throwable)e);
        }
        return null;
    }

    public ZKResultMsg isOnline(String deviceId) {
        List lockerDeviceItemList = this.lockerDeviceService.getItemsByIds(deviceId);
        StringBuffer offLineAlias = new StringBuffer("");
        StringBuffer offLineIds = new StringBuffer("");
        JSONObject retJson = new JSONObject();
        for (LockerDeviceItem dev : lockerDeviceItemList) {
            if (!this.lockerDeviceService.getStatus(dev.getSn()).equals(String.valueOf(0))) continue;
            offLineIds.append(dev.getId()).append(",");
            offLineAlias.append(dev.getAlias()).append(",");
        }
        retJson.put("ids", (Object)(offLineIds.length() > 0 ? offLineIds.substring(0, offLineIds.length() - 1) : offLineIds.toString()));
        retJson.put("alias", (Object)(offLineAlias.length() > 0 ? offLineAlias.substring(0, offLineAlias.length() - 1) : offLineAlias.toString()));
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg((Object)retJson));
    }

    @RequiresPermissions(value={"locker:device:syncTime"})
    public ModelAndView getDevSyncTimeInfo(String ids, String type, String checkOffline) {
        return this.getDevSyncInfo(ids, type, checkOffline);
    }

    @RequiresPermissions(value={"locker:device:syncAllData"})
    public ModelAndView getDevSyncDateInfo(String ids, String type, String checkOffline) {
        return this.getDevSyncInfo(ids, type, checkOffline);
    }

    private ModelAndView getDevSyncInfo(String ids, String type, String checkOffline) {
        List list = this.lockerDeviceService.getItemsByIds(ids);
        HashMap<String, String> devNameMap = new HashMap<String, String>();
        StringBuffer offlineDevName = new StringBuffer("");
        LockerDeviceItem dev = null;
        StringBuffer retIds = new StringBuffer();
        for (int i = 0; i < list.size(); ++i) {
            String name;
            dev = (LockerDeviceItem)list.get(i);
            if (String.valueOf(1).equals(this.lockerDeviceService.getStatus(dev.getSn()))) {
                name = dev.getDeviceName();
                retIds.append(dev.getId()).append(",");
                devNameMap.put(name, name);
                continue;
            }
            if (StringUtils.isNotBlank((CharSequence)checkOffline)) {
                name = dev.getDeviceName();
                devNameMap.put(name, name);
            } else {
                offlineDevName.append(dev.getAlias()).append(",");
            }
            list.remove(i);
            --i;
        }
        StringBuffer devName = new StringBuffer("");
        boolean isNeed = false;
        for (String key : devNameMap.keySet()) {
            devName.append((String)devNameMap.get(key)).append(":");
            int innerLen = list.size();
            for (int j = 0; j < innerLen; ++j) {
                if (!Pattern.compile(key).matcher(((LockerDeviceItem)list.get(j)).getDeviceName()).find() && !key.equals(((LockerDeviceItem)list.get(j)).getDeviceName()) || !String.valueOf(1).equals(this.lockerDeviceService.getStatus(((LockerDeviceItem)list.get(j)).getSn()))) continue;
                isNeed = true;
                devName.append(((LockerDeviceItem)list.get(j)).getAlias() + "&" + ((LockerDeviceItem)list.get(j)).getId()).append(",");
            }
            if (isNeed) {
                devName.append(";");
                continue;
            }
            if (devName.indexOf(";") < 0) {
                devName = new StringBuffer("");
                continue;
            }
            devName.substring(0, devName.lastIndexOf(";") - 1);
        }
        this.request.setAttribute("retIds", (Object)(retIds.toString().equals("") ? "" : retIds.substring(0, retIds.length() - 1)));
        this.request.setAttribute("devicesName", (Object)(devName.toString().equals("") ? "" : devName.substring(0, devName.length() - 1)));
        this.request.setAttribute("offlineDevName", (Object)(offlineDevName.toString().equals("") ? "" : offlineDevName.substring(0, offlineDevName.length() - 1)));
        if (StringUtils.isNotBlank((CharSequence)checkOffline)) {
            this.request.setAttribute("checkOffline", (Object)checkOffline);
        }
        this.request.setAttribute("opType", (Object)type);
        switch (type) {
            case "uploadTransaction": {
                return new ModelAndView("locker/device/opLockerUploadTransaction");
            }
        }
        return new ModelAndView("locker/device/opLockerSyncDevInfo");
    }

    @RequiresPermissions(value={"locker:device:clearAllAds"})
    @LogRequest(module="locker_module", object="common_leftMenu_device", opType="locker_dev_clearAllAds", requestParams={"alias"}, opContent="common_dev_name")
    public ZKResultMsg clearAllAds(String ids) {
        return this.lockerDeviceService.clearAllAds(ids);
    }

    @RequiresPermissions(value={"locker:device:issuedAdRes"})
    public ModelAndView getDevAdResInfo(String ids) {
        this.request.setAttribute("editPage", (Object)true);
        LockerDeviceItem dev = this.lockerDeviceService.getItemById(ids);
        if (dev != null && String.valueOf(1).equals(this.lockerDeviceService.getStatus(dev.getSn()))) {
            this.request.setAttribute("ids", (Object)ids);
            return new ModelAndView("locker/device/opLockerIssuedAdRes");
        }
        this.request.setAttribute("failedReason", (Object)(dev.getAlias() + I18nUtil.i18nCode((String)"common_dev_offlinePrompt", (Object[])new Object[0])));
        return new ModelAndView("locker/device/opDevOffLineTips");
    }

    public ZKResultMsg issuedAdRes(String ids, MultipartFile[] files) {
        ZKResultMsg resultMsg = new ZKResultMsg();
        ArrayList<File> fileList = new ArrayList<File>();
        File file = null;
        try {
            for (MultipartFile multipartFile : files) {
                if (multipartFile == null) continue;
                file = this.saveFile(multipartFile, multipartFile.getOriginalFilename());
                fileList.add(file);
            }
            this.lockerDeviceService.issuedAdRes(ids, fileList);
        }
        catch (Exception e) {
            resultMsg = ZKResultMsg.failMsg();
            this.log.error("exception ", (Throwable)e);
        }
        return I18nUtil.i18nMsg((ZKResultMsg)resultMsg);
    }

    private File saveFile(MultipartFile devFile, String fileName) throws Exception {
        File file;
        String realPath = this.systemFilePath + "/upload/locker/adResource";
        File tempFile = new File(realPath);
        if (!tempFile.isAbsolute()) {
            realPath = ClassUtil.getRootPath() + "/" + realPath;
            tempFile = new File(realPath);
        }
        if (!tempFile.exists()) {
            tempFile.mkdirs();
        }
        if ((file = new File(realPath + "/" + fileName)).exists()) {
            file.delete();
        }
        devFile.transferTo(file);
        return file;
    }

    public ZKResultMsg isExistDevice() {
        List items = this.lockerDeviceService.getByCondition(new LockerDeviceItem());
        if (items != null && !items.isEmpty()) {
            return I18nUtil.i18nMsg((ZKResultMsg)ZKResultMsg.getFailMsg((String)"locker_param_mulPeopleShareCabinetWarn"));
        }
        return I18nUtil.i18nMsg((ZKResultMsg)ZKResultMsg.successMsg());
    }

    @RequiresPermissions(value={"locker:device:setAdmin"})
    public ModelAndView getDevSetAdminInfo(String ids) {
        this.request.setAttribute("editPage", (Object)true);
        LockerDeviceItem dev = this.lockerDeviceService.getItemById(ids);
        if (dev != null && String.valueOf(1).equals(this.lockerDeviceService.getStatus(dev.getSn()))) {
            this.request.setAttribute("devId", (Object)ids);
            List values = this.lockerDevicePersonService.findPersonIdByDevIdAndType(ids, "1");
            if (values != null) {
                this.request.setAttribute("value", (Object)StringUtils.join((Iterable)values, (String)","));
            }
            return new ModelAndView("locker/device/selectPersonContent");
        }
        this.request.setAttribute("failedReason", (Object)(dev.getAlias() + I18nUtil.i18nCode((String)"common_dev_offlinePrompt", (Object[])new Object[0])));
        return new ModelAndView("locker/device/opDevOffLineTips");
    }

    public ZKResultMsg setAdmin() {
        String devId = this.request.getParameter("devId");
        String persIds = this.request.getParameter("persIds");
        this.lockerDevicePersonService.setAdmin(devId, persIds);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    public ModelAndView getLockerSelectPerson() {
        String devId = this.request.getParameter("devId");
        String lockId = this.request.getParameter("lockId");
        if (StringUtils.isNotBlank((CharSequence)devId) && StringUtils.isNotBlank((CharSequence)lockId)) {
            this.request.setAttribute("editPage", (Object)true);
            LockerDeviceItem dev = this.lockerDeviceService.getItemById(devId);
            if (dev != null && String.valueOf(1).equals(this.lockerDeviceService.getStatus(dev.getSn()))) {
                this.request.setAttribute("devId", (Object)devId);
                this.request.setAttribute("lockId", (Object)lockId);
                String value = this.request.getParameter("value");
                this.request.setAttribute("value", (Object)value);
                String multiplePeopleShareCabinet = this.lockerParamsService.getValByName("locker.multiplePeopleShareCabinet");
                if ("1".equals(multiplePeopleShareCabinet)) {
                    return new ModelAndView("locker/visualPanel/lockerSelectPersonContent");
                }
                return new ModelAndView("locker/visualPanel/lockerSelectPersonRadioContent");
            }
            this.request.setAttribute("failedReason", (Object)(dev.getAlias() + I18nUtil.i18nCode((String)"common_dev_offlinePrompt", (Object[])new Object[0])));
        }
        return new ModelAndView("locker/device/opDevOffLineTips");
    }

    public ModelAndView getChannelByEntityId() {
        String entityId = this.request.getParameter("entityId");
        this.request.setAttribute("entityId", (Object)entityId);
        this.request.setAttribute("entityName", (Object)"LockerDevice");
        String channel2EntityIds = this.lockerChannelService.getBindChannelIds(Arrays.asList(entityId), "LockerDevice");
        this.request.setAttribute("value", (Object)channel2EntityIds);
        return new ModelAndView("locker/device/lockerDeviceSelectChannelContent");
    }

    @RequiresPermissions(value={"locker:device:bindChannel"})
    @LogRequest(module="locker_module", object="common_leftMenu_reader", opType="common_vid_bindOrUnbindChannel", requestParams={}, opContent="common_vid_bindOrUnbindChannel")
    public ZKResultMsg bindOrUnbindChannel() {
        String entityId = this.request.getParameter("entityId");
        String entityName = this.request.getParameter("entityName");
        String channelIds = this.request.getParameter("channelIds");
        ZKResultMsg ret = this.lockerChannelService.bindOrUnbindChannel(channelIds, entityName, entityId);
        return I18nUtil.i18nMsg((ZKResultMsg)ret);
    }

    @RequiresPermissions(value={"locker:device:uploadTransaction"})
    public ModelAndView getUploadTransactionInfo(String ids, String type, String checkOffline) {
        return this.getDevSyncInfo(ids, type, checkOffline);
    }

    @RequiresPermissions(value={"locker:device:uploadTransaction"})
    @LogRequest(module="locker_module", object="common_leftMenu_device", opType="common_dev_getTrans", requestParams={"alias"}, opContent="common_dev_name")
    public ZKResultMsg uploadTransaction(String devIds, String records) {
        String[] devIdArray;
        boolean newLog = "1".equals(records);
        this.progressCache.beginProcess(I18nUtil.i18nCode((String)"common_op_startProcessing", (Object[])new Object[0]) + "...<br/>");
        ArrayList cmdIdList = new ArrayList();
        int total = 0;
        for (String devId : devIdArray = devIds.split(",")) {
            Map devDataMap = this.lockerDeviceService.uploadTransaction(devId, records);
            cmdIdList.addAll(Lists.newArrayList((Object[])((String)devDataMap.get("cmdId")).split(",")));
            this.progressCache.setProcess(new ProcessBean(100, total, (String)devDataMap.get("alias") + ":" + I18nUtil.i18nCode((String)"common_dev_cmdSendSucceed", (Object[])new Object[0]) + "<br/>"));
        }
        int ret = 0;
        if (ret == 0) {
            this.progressCache.finishProcess(I18nUtil.i18nCode((String)"common_progress_finish", (Object[])new Object[0]));
        } else if (ret == -1) {
            this.progressCache.finishProcess("<font class='zk-msg-error'>" + I18nUtil.i18nCode((String)"common_commStatus_getEventFailed", (Object[])new Object[0]) + "...</font><br/>");
        } else if (ret == 1) {
            this.progressCache.finishProcess("<font class='zk-msg-warn'>" + I18nUtil.i18nCode((String)"common_progress_busyFailed", (Object[])new Object[0]) + "</font><br/>");
        }
        return null;
    }

    private int dealQueryDataFromRedis(List<String> cmdIdList, int timeout, ProgressCache dealRate, boolean newLog, boolean isAccount) {
        int ret = 0;
        Object key = null;
        Object dev = null;
        int cmdLen = cmdIdList.size();
        int time = timeout;
        try {
            if (isAccount) {
                // empty if block
            }
            dealRate.setProcess(new ProcessBean(100, 0, I18nUtil.i18nCode((String)"common_op_processing", (Object[])new Object[0]) + "<br/>"));
            int everyProcess = 100 / cmdLen;
            while (time > 0 && cmdIdList.size() != 0) {
                Thread.sleep(4000L);
                time -= 4000;
            }
            if (time <= 0) {
                ret = 1;
            }
        }
        catch (Exception e) {
            ret = -1;
            this.log.error("exception ", (Throwable)e);
        }
        return ret;
    }
}

