/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.util.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Arrays;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;

public class Boxer {
    public static final int HORIZONTAL_SPACER_WIDTH = 5;
    public static final int VERTICAL_SPACER_HEIGHT = 12;
    public static final int HORIZONTAL_ENDER_WIDTH = 12;
    private static final List<Color> COLORS = Arrays.asList(Color.RED, Color.GREEN, Color.BLUE, Color.YELLOW, Color.PINK, Color.ORANGE, Color.MAGENTA, Color.CYAN);

    public static JPanel createTopBox(String title, Border border) {
        JPanel jp = new JPanel();
        BoxLayout bl = new BoxLayout(jp, 0);
        jp.setLayout(bl);
        jp.add(Box.createHorizontalGlue());
        jp.setBorder(BorderFactory.createTitledBorder(border, title));
        return jp;
    }

    public static JPanel createBottomBox(Component content) {
        JPanel jp = new JPanel();
        BoxLayout bl = new BoxLayout(jp, 0);
        jp.setLayout(bl);
        jp.add(Box.createHorizontalGlue());
        jp.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, jp.getBackground().darker()), BorderFactory.createEmptyBorder(5, 0, 0, 0)));
        jp.add(content);
        return jp;
    }

    public static int equaliseWidth(Component ... children) {
        int widthMin = 0;
        int widthPref = 0;
        int widthMax = 0;
        for (Component child : children) {
            if (child.getMinimumSize().getWidth() > (double)widthMin) {
                widthMin = child.getMinimumSize().width;
            }
            if (child.getPreferredSize().getWidth() > (double)widthPref) {
                widthPref = child.getPreferredSize().width;
            }
            if (!(child.getMaximumSize().getWidth() > (double)widthMax)) continue;
            widthMax = child.getMaximumSize().width;
        }
        for (Component child : children) {
            child.setMinimumSize(new Dimension(widthMin, child.getMinimumSize().height));
            child.setPreferredSize(new Dimension(widthPref, child.getPreferredSize().height));
            child.setMaximumSize(new Dimension(widthMax, child.getMaximumSize().height));
        }
        return widthPref;
    }

    public static void highlightBorders(Component parent) {
        JComponent jparent = (JComponent)parent;
        int i = 0;
        for (Component child : jparent.getComponents()) {
            if (!(child instanceof JComponent)) continue;
            JComponent jchild = (JComponent)child;
            Boxer.highlightBorders(jchild);
            if (!(child instanceof JPanel)) continue;
            Color co = COLORS.get(i % COLORS.size());
            ++i;
            jchild.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, co), jchild.getBorder()));
            jchild.setToolTipText(jchild.getSize().width + "," + jchild.getSize().height);
        }
    }

    public static Box.Filler slimHorizontalStrut() {
        return Boxer.slimHorizontalStrut(5);
    }

    public static Box.Filler slimHorizontalStrut(int width) {
        return new Box.Filler(new Dimension(width, 0), new Dimension(width, 0), new Dimension(width, 0));
    }

    public static JPanel horizontalPanel() {
        return Boxer.horizontalPanel(null);
    }

    public static JPanel horizontalPanel(JComponent parent) {
        JPanel panel = new JPanel();
        BoxLayout layout = new BoxLayout(panel, 0);
        panel.setLayout(layout);
        if (null != parent) {
            parent.add(panel);
        }
        return panel;
    }

    public static JPanel verticalPanel() {
        return Boxer.verticalPanel(null);
    }

    public static JPanel verticalPanel(JComponent parent) {
        JPanel panel = new JPanel();
        BoxLayout layout = new BoxLayout(panel, 1);
        panel.setLayout(layout);
        if (null != parent) {
            parent.add(panel);
        }
        return panel;
    }
}

