/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.acc.client;

import com.zkteco.zkbiosecurity.acc.service.AccDoorService;
import com.zkteco.zkbiosecurity.acc.service.AccLevelService;
import com.zkteco.zkbiosecurity.acc.utils.AccUploadPageUtil;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.CollectionUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.license.service.BaseLicenseClientService;
import com.zkteco.zkbiosecurity.license.service.BaseLicenseService;
import com.zkteco.zkbiosecurity.message.bean.ZKMessage;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AccPersonLevelHandle {
    @Autowired
    private AccDoorService accDoorService;
    @Autowired
    private BaseLicenseService baseLicenseService;
    @Autowired
    private BaseLicenseClientService baseLicenseClientService;
    @Autowired
    private AccLevelService accLevelService;

    public ZKResultMsg accPersonLevelUpload() {
        if (StringUtils.isNotBlank((CharSequence)this.baseLicenseService.getAppId())) {
            ZKMessage zkMessage = new ZKMessage();
            zkMessage.setModuleCode("acc");
            zkMessage.setMessageId("accCloudPersonLevelHandle#handlePersonLevelMessage");
            zkMessage.setAppId(this.baseLicenseService.getAppId());
            Long doorCount = this.accDoorService.getDoorCount();
            int pageNo = AccUploadPageUtil.getPage(doorCount);
            int i = 0;
            while (i < pageNo) {
                List accDoorItems = this.accDoorService.getUploadCloudDoor(i, 30);
                if (accDoorItems != null && accDoorItems.size() > 0) {
                    accDoorItems.forEach(accDoorItem -> {
                        List personLevelList = this.accDoorService.getUploadCloudPersonLevel(accDoorItem);
                        List personLevelsList = CollectionUtil.split((Collection)personLevelList, (int)30);
                        personLevelsList.forEach(personLevels -> {
                            zkMessage.setListContent(personLevels);
                            this.baseLicenseClientService.sendMessage(zkMessage);
                        });
                    });
                }
                ++i;
            }
        }
        return ZKResultMsg.successMsg();
    }

    public ZKResultMsg getPersonLevelDoor(ZKMessage message) {
        ZKResultMsg rs = null;
        try {
            Map dataMap = message.getContent();
            String personPin = MapUtils.getString((Map)dataMap, (Object)"personPin");
            boolean isAdmin = MapUtils.getBoolean((Map)dataMap, (Object)"isAdmin", (Boolean)false);
            rs = this.accLevelService.getPersonLevelDoor(personPin, isAdmin);
        }
        catch (Exception e) {
            rs = ZKResultMsg.failMsg();
        }
        return I18nUtil.i18nMsg((ZKResultMsg)rs);
    }
}

