/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.acc.client;

import com.zkteco.zkbiosecurity.acc.service.AccCloudService;
import com.zkteco.zkbiosecurity.acc.service.AccDeviceService;
import com.zkteco.zkbiosecurity.acc.service.AccDoorService;
import com.zkteco.zkbiosecurity.acc.utils.AccUploadPageUtil;
import com.zkteco.zkbiosecurity.auth.service.AuthAreaService;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.CollectionUtil;
import com.zkteco.zkbiosecurity.core.utils.DateUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.license.service.BaseLicenseClientService;
import com.zkteco.zkbiosecurity.license.service.BaseLicenseService;
import com.zkteco.zkbiosecurity.message.bean.ZKMessage;
import com.zkteco.zkbiosecurity.system.app.service.BaseAuthCloudMessageSendService;
import com.zkteco.zkbiosecurity.system.service.BaseSysParamService;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class AccDeviceHandle {
    @Autowired
    private AccDeviceService accDeviceService;
    @Autowired
    private AccDoorService accDoorService;
    @Autowired
    private BaseLicenseService baseLicenseService;
    @Autowired
    private BaseLicenseClientService baseLicenseClientService;
    @Autowired
    private BaseSysParamService baseSysParamService;
    @Autowired
    private AuthAreaService authAreaService;
    @Autowired
    private BaseAuthCloudMessageSendService baseAuthCloudMessageSendService;
    @Autowired
    private AccCloudService accCloudService;

    @Scheduled(cron="0 0/5 * * * ?")
    public ZKResultMsg accDeviceUpload() {
        if (this.baseAuthCloudMessageSendService.isAllowSendBusinessData() && this.accCloudService.isActiveLicense()) {
            Long pushTime = this.accDeviceService.getLastPushTime();
            ZKMessage zkMessage = new ZKMessage();
            zkMessage.setModuleCode("acc");
            zkMessage.setMessageId("accCloudDeviceInfoHandle#getCloudDevice");
            zkMessage.setAppId(this.baseLicenseService.getAppId());
            if (pushTime == null) {
                long count = this.accDeviceService.getDevicesCount();
                if (count > 0L) {
                    int page = AccUploadPageUtil.getPage(count);
                    int i = 0;
                    while (i < page) {
                        List devInfoList = this.accDeviceService.getUploadCloudDevices(i, 30);
                        zkMessage.setListContent(devInfoList);
                        this.baseLicenseClientService.sendMessage(zkMessage);
                        ++i;
                    }
                }
            } else {
                Date lastUpdate = new Date(pushTime);
                List devInfoList = this.accDeviceService.getUploadCloudDevicesByLastPushTime(lastUpdate = DateUtil.addMinute((Date)lastUpdate, (int)-1));
                if (devInfoList != null && !devInfoList.isEmpty()) {
                    List devInfos = CollectionUtil.split((Collection)devInfoList, (int)30);
                    for (List devInfo : devInfos) {
                        zkMessage.setListContent(devInfo);
                        this.baseLicenseClientService.sendMessage(zkMessage);
                    }
                }
            }
            this.accDeviceService.setLastPushTime();
        }
        return ZKResultMsg.successMsg();
    }

    public ZKResultMsg cloudOpenDoor(ZKMessage zkMessage) {
        ZKResultMsg resultMsg = ZKResultMsg.successMsg();
        Map map = zkMessage.getContent();
        String openInterval = MapUtils.getString((Map)map, (Object)"openInterval");
        String operator = MapUtils.getString((Map)map, (Object)"operator");
        boolean isAdmin = MapUtils.getBoolean((Map)map, (Object)"isAdmin", (Boolean)false);
        Map doorMap = (Map)map.get("doors");
        if (doorMap != null && !doorMap.isEmpty()) {
            for (String sn : doorMap.keySet()) {
                String doorNos;
                List doorNoList;
                String doorIds;
                if (doorMap.get(sn) == null || ((List)doorMap.get(sn)).isEmpty() || !StringUtils.isNotBlank((CharSequence)(doorIds = this.accDoorService.getDoorByDevSnAndDoorNos(sn, doorNoList = Arrays.stream((doorNos = StringUtils.join((Iterable)((Iterable)doorMap.get(sn)), (String)",")).split(",")).map(s -> Short.parseShort(s.trim())).collect(Collectors.toList()))))) continue;
                resultMsg = this.accDoorService.operateDoor("openDoor", openInterval, doorIds, operator, isAdmin);
            }
        }
        return I18nUtil.i18nMsg((ZKResultMsg)resultMsg);
    }

    public ZKResultMsg cloudCancelAlarm(ZKMessage zkMessage) {
        ZKResultMsg resultMsg = ZKResultMsg.successMsg();
        Map map = zkMessage.getContent();
        String openInterval = MapUtils.getString((Map)map, (Object)"openInterval");
        String operator = MapUtils.getString((Map)map, (Object)"operator");
        boolean isAdmin = MapUtils.getBoolean((Map)map, (Object)"isAdmin", (Boolean)false);
        Map doorMap = (Map)map.get("doors");
        if (doorMap != null && !doorMap.isEmpty()) {
            for (String sn : doorMap.keySet()) {
                String doorNos;
                List doorNoList;
                String doorIds;
                if (doorMap.get(sn) == null || ((List)doorMap.get(sn)).isEmpty() || !StringUtils.isNotBlank((CharSequence)(doorIds = this.accDoorService.getDoorByDevSnAndDoorNos(sn, doorNoList = Arrays.stream((doorNos = StringUtils.join((Iterable)((Iterable)doorMap.get(sn)), (String)",")).split(",")).map(s -> Short.parseShort(s.trim())).collect(Collectors.toList()))))) continue;
                resultMsg = this.accDoorService.operateDoor("cancelAlarm", openInterval, doorIds, operator, isAdmin);
            }
        }
        return I18nUtil.i18nMsg((ZKResultMsg)resultMsg);
    }
}

