/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.workflow.controller;

import com.alibaba.fastjson.JSONArray;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.zkteco.zkbiosecurity.base.annotation.LogChangeRequest;
import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.bean.SecuritySubject;
import com.zkteco.zkbiosecurity.base.bean.TreeItem;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import com.zkteco.zkbiosecurity.workflow.constants.WorkflowConstants;
import com.zkteco.zkbiosecurity.workflow.remote.WfFlowRemote;
import com.zkteco.zkbiosecurity.workflow.service.WFFlowableService;
import com.zkteco.zkbiosecurity.workflow.service.WfFlowService;
import com.zkteco.zkbiosecurity.workflow.vo.WfFlowItem;
import com.zkteco.zkbiosecurity.workflow.vo.WfFlowNodeItem;
import com.zkteco.zkbiosecurity.workflow.vo.WfGroupPersonSelectItem;
import com.zkteco.zkbiosecurity.workflow.vo.WfPositionItem;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class WfFlowController
extends BaseController
implements WfFlowRemote {
    @Autowired(required=false)
    private WfFlowService wfFlowService;
    @Autowired
    private WFFlowableService wFFlowableService;
    @Autowired
    private HttpServletRequest request = null;

    @RequiresPermissions(value={"wf:flow"})
    public ModelAndView index() {
        this.request.setAttribute("moduleCode", (Object)this.request.getParameter("moduleCode"));
        return new ModelAndView("wf/flow/wfFlow");
    }

    @RequiresPermissions(value={"wf:flow:add", "wf:flow:edit"})
    public ModelAndView edit(String id, String type) {
        String moduleCode = this.request.getParameter("moduleCode");
        if (StringUtils.isNotBlank((CharSequence)id)) {
            WfFlowItem wfFlowItem = this.wfFlowService.getItemById(id);
            if (StringUtils.isNotBlank((CharSequence)type) && "copy".equals(type)) {
                wfFlowItem.setId(null);
                wfFlowItem.setFlowNo(null);
                wfFlowItem.setFlowName(null);
            }
            moduleCode = this.wfFlowService.getModuleCodeByFlowType(wfFlowItem.getFlowType());
            this.request.setAttribute("item", (Object)wfFlowItem);
        }
        this.request.setAttribute("moduleCode", (Object)moduleCode);
        return new ModelAndView("wf/flow/editWfFlow");
    }

    public TreeItem tree() {
        SecuritySubject securitySubject = this.getCurrentSubject();
        String companyId = securitySubject.getCompanyId();
        return this.wfFlowService.getPersPositionTree(companyId);
    }

    public DxGrid listPosition(WfPositionItem condition) {
        Pager pager = this.wfFlowService.listPosition(condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    public List<Map<String, String>> getPersPersonByBlurPin(String pin, String pinOnly) {
        SecuritySubject securitySubject = this.getCurrentSubject();
        String companyId = securitySubject.getCompanyId();
        return this.wfFlowService.getPersPersonByBlurPin(companyId, pin, pinOnly);
    }

    @RequiresPermissions(value={"wf:flow:edit"})
    public ModelAndView editFlowNode() {
        String nodeItem = this.request.getParameter("nodeItem");
        if (StringUtils.isNotBlank((CharSequence)nodeItem)) {
            ObjectMapper objectMapper = new ObjectMapper();
            try {
                WfFlowNodeItem item = (WfFlowNodeItem)objectMapper.readValue(nodeItem, WfFlowNodeItem.class);
                this.request.setAttribute("item", (Object)item);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return new ModelAndView("wf/flow/editWfFlowNode");
    }

    public ModelAndView copy(String id) {
        return this.edit(id, "copy");
    }

    @RequiresPermissions(value={"wf:flow:edit"})
    public ZKResultMsg flowUpdate(String ids, Short valid) {
        ZKResultMsg zKResultMsg = this.wfFlowService.flowUpdate(ids, valid);
        return I18nUtil.i18nMsg((ZKResultMsg)zKResultMsg);
    }

    @RequiresPermissions(value={"wf:flow:edit"})
    @LogChangeRequest(module="workflow_module", object="wf_leftMenu_flow", opType="common_op_edit", vo=WfFlowItem.class, service=WfFlowService.class)
    public ZKResultMsg save(WfFlowItem item) {
        ZKResultMsg res = new ZKResultMsg();
        String wfflowNodeStrs = this.request.getParameter("wfflowNodeStrs");
        List flowNodeItems = JSONArray.parseArray((String)wfflowNodeStrs, WfFlowNodeItem.class);
        item.setWfflowNodeItems(flowNodeItems);
        this.wfFlowService.saveItem(item);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    public DxGrid nodeList(WfFlowNodeItem condition) {
        Pager pager = new Pager();
        pager.setData(new ArrayList());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    public DxGrid list(WfFlowItem condition) {
        condition.setCompanyId(this.getCurrentSubject().getCompanyId());
        String moduleCode = condition.getModuleCode();
        if ("att".equals(moduleCode)) {
            condition.setFlowTypeIn(StringUtils.join((Iterable)WorkflowConstants.ATT_FLOW_TYPE_LIST, (String)","));
        } else if ("oa".equals(moduleCode)) {
            condition.setFlowTypeIn(StringUtils.join((Iterable)WorkflowConstants.OA_FLOW_TYPE_LIST, (String)","));
        } else if ("apt".equals(moduleCode)) {
            condition.setFlowType("oaRoom");
            if (StringUtils.isNotBlank((CharSequence)condition.getPositionName())) {
                condition.setInPositionId(this.wfFlowService.getPositionIdByName(condition.getPositionName()));
            }
        } else if ("oameeting".equals(moduleCode)) {
            condition.setFlowType("oaMeeting");
        } else if ("vis".equals(moduleCode)) {
            condition.setFlowType("vis");
        }
        Pager pager = this.wfFlowService.getItemsByPage((BaseItem)condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @RequiresPermissions(value={"wf:flow:del"})
    @LogRequest(module="workflow_module", object="wf_leftMenu_flow", opType="common_op_del", requestParams={"ids"}, opContent="wf_common_id")
    public ZKResultMsg delete(String ids) {
        this.wfFlowService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    public String isFlowNoExist(String flowNo) {
        String companyId = this.getCurrentSubject().getCompanyId();
        boolean exitFlowNo = this.wfFlowService.isFlowNoExist(companyId, flowNo);
        return String.valueOf(!exitFlowNo);
    }

    public String isFlowNameExist(String flowName) {
        String companyId = this.getCurrentSubject().getCompanyId();
        boolean exitFlowName = this.wfFlowService.isFlowNameExist(companyId, flowName);
        return String.valueOf(!exitFlowName);
    }

    public DxGrid selectList(WfGroupPersonSelectItem condition) {
        condition.setCompanyId(this.getCurrentSubject().getCompanyId());
        if (",".equals(condition.getSelectId())) {
            condition.setSelectId("");
        }
        Pager pager = this.wfFlowService.selectPersonList(condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }
}

