/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.adms.service.impl;

import com.zkteco.ZKCryptoClientService2;
import com.zkteco.util.AdmsBroadcastUtil;
import com.zkteco.zkbiosecurity.adms.bean.SdkResult;
import com.zkteco.zkbiosecurity.adms.service.AdmsSdkService;
import com.zkteco.zkbiosecurity.base.utils.SystemOsUtil;
import com.zkteco.zkbiosecurity.dll.LibraryService;
import java.util.ArrayList;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.CommandLineRunner;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import zk.jni.JavaToAdmsPullSDK;

@Component
@Order(value=131)
public class AdmsSdkServiceImpl
implements AdmsSdkService,
CommandLineRunner {
    Logger log = LoggerFactory.getLogger(this.getClass());
    private static int LOADLIBRARY_FAILURE = -126;
    @Resource
    private LibraryService libraryService;
    private String priKey;
    private String pubKey;
    private String encryptedPubKey;

    public void run(String ... args) throws Exception {
        if (SystemOsUtil.isWindow()) {
            this.killRS485Process();
            this.libraryService.loadLibrary("libareacode");
            this.libraryService.loadLibrary("ZKCommuCryptoClient");
            this.libraryService.loadLibrary("plcomms");
            this.libraryService.loadLibrary("plrscagent");
            this.libraryService.loadLibrary("plrscomm");
            this.libraryService.loadLibrary("pltcpcomm");
            this.libraryService.loadLibrary("plusbcomm");
            this.libraryService.loadLibrary("plcommpro");
            this.libraryService.loadLibrary("ZKCryptoClient2");
        } else if (SystemOsUtil.isLinux()) {
            this.libraryService.loadLibrary("ZKCommuCryptoClient");
            this.libraryService.loadLibrary("pltcpcomm");
            this.libraryService.loadLibrary("pludpcomm");
            this.libraryService.loadLibrary("plcommpro");
            this.libraryService.loadLibrary("zkcryptoclient2");
        }
        if (!SystemOsUtil.isMac()) {
            this.generateRSAKey();
            this.encryptSoftPubKey();
        }
    }

    public SdkResult connect(String connectParam) {
        SdkResult sdkResult = new SdkResult();
        try {
            long result = JavaToAdmsPullSDK.Connect(connectParam);
            if (result > 0L) {
                sdkResult.setResult(result);
                sdkResult.setData(String.valueOf(result));
            } else {
                long error = this.pullLastError().getResult();
                if (error >= 0L) {
                    sdkResult.setResult(0L - error);
                    sdkResult.setData(String.valueOf(0L - error));
                }
            }
        }
        catch (Error e) {
            sdkResult.setResult((long)LOADLIBRARY_FAILURE);
            sdkResult.setData(String.valueOf(LOADLIBRARY_FAILURE));
        }
        return sdkResult;
    }

    public SdkResult connectExt(String connectParam, int[] callbackResult) {
        SdkResult sdkResult = new SdkResult();
        try {
            long result = JavaToAdmsPullSDK.ConnectExt(connectParam, callbackResult);
            if (result <= 0L) {
                sdkResult.setResult((long)callbackResult[0]);
                sdkResult.setData(String.valueOf(callbackResult[0]));
            } else {
                sdkResult.setResult(result);
                sdkResult.setData(String.valueOf(result));
            }
        }
        catch (Error e) {
            sdkResult.setResult((long)LOADLIBRARY_FAILURE);
            sdkResult.setData(String.valueOf(LOADLIBRARY_FAILURE));
        }
        return sdkResult;
    }

    public SdkResult disconnect(long hCommPro) {
        SdkResult sdkResult = new SdkResult();
        try {
            if (hCommPro > 0L) {
                int result = JavaToAdmsPullSDK.Disconnect(hCommPro);
                sdkResult.setResult((long)result);
                sdkResult.setData(String.valueOf(result));
            }
        }
        catch (Error e) {
            sdkResult.setResult((long)LOADLIBRARY_FAILURE);
            sdkResult.setData(String.valueOf(LOADLIBRARY_FAILURE));
        }
        return sdkResult;
    }

    public SdkResult setDeviceParam(long hCommPro, String items) {
        SdkResult sdkResult = new SdkResult();
        try {
            int result = JavaToAdmsPullSDK.SetDeviceParam(hCommPro, items);
            sdkResult.setResult((long)result);
            sdkResult.setData("");
        }
        catch (Error e) {
            sdkResult.setResult((long)LOADLIBRARY_FAILURE);
            this.log.error("error", (Throwable)e);
        }
        return sdkResult;
    }

    public SdkResult getDeviceParam(long hCommPro, byte[] callbackResult, String items) {
        SdkResult sdkResult = new SdkResult();
        try {
            String[] itemArray = items.split(",");
            ArrayList<String> itemList = new ArrayList<String>();
            if (itemArray.length > 30) {
                StringBuilder strBuf = new StringBuilder();
                int i = 0;
                while (i < itemArray.length) {
                    strBuf.append(itemArray[i]).append(",");
                    if (i != 0 && i % 29 == 0) {
                        itemList.add(strBuf.substring(0, strBuf.length() - 1));
                        strBuf = new StringBuilder();
                    }
                    ++i;
                }
                if (strBuf.length() > 0) {
                    itemList.add(strBuf.substring(0, strBuf.length() - 1));
                }
            } else {
                itemList.add(items);
            }
            int result = -1;
            for (String item : itemList) {
                result = JavaToAdmsPullSDK.GetDeviceParam(hCommPro, callbackResult, item);
                if (result < 0) continue;
                sdkResult.setData(StringUtils.isNotBlank((CharSequence)sdkResult.getData()) ? String.valueOf(sdkResult.getData()) + "," + new String(callbackResult, "UTF-8").trim() : new String(callbackResult, "UTF-8").trim());
                sdkResult.setResult((long)result);
                sdkResult.setSuccess(true);
                callbackResult = new byte[2048];
            }
            if (StringUtils.isBlank((CharSequence)sdkResult.getData())) {
                sdkResult.setData("");
                sdkResult.setResult((long)result);
                sdkResult.setSuccess(true);
            }
        }
        catch (Exception e) {
            sdkResult.setResult((long)LOADLIBRARY_FAILURE);
            this.log.error("error", (Throwable)e);
        }
        return sdkResult;
    }

    public SdkResult controlDevice(long hCommPro, int operationID, int param1, int param2, int param3, int param4, String options) {
        SdkResult sdkResult = new SdkResult();
        try {
            int result = JavaToAdmsPullSDK.ControlDevice(hCommPro, operationID, param1, param2, param3, param4, options);
            sdkResult.setResult((long)result);
            sdkResult.setData("");
            sdkResult.setSuccess(true);
        }
        catch (Error e) {
            sdkResult.setResult((long)LOADLIBRARY_FAILURE);
            this.log.error("error", (Throwable)e);
        }
        return sdkResult;
    }

    public SdkResult setDeviceData(long hCommPro, String tableName, String data, String options) {
        SdkResult sdkResult = new SdkResult();
        try {
            int result = JavaToAdmsPullSDK.SetDeviceData(hCommPro, tableName, data, options);
            sdkResult.setResult((long)result);
            sdkResult.setData("");
        }
        catch (Error e) {
            sdkResult.setResult((long)LOADLIBRARY_FAILURE);
            this.log.error("error", (Throwable)e);
        }
        return sdkResult;
    }

    public SdkResult getDeviceData(long hCommPro, byte[] callbackResult, String tableName, String fieldNames, String filter, String options) {
        SdkResult sdkResult = new SdkResult();
        try {
            int result = JavaToAdmsPullSDK.GetDeviceData(hCommPro, callbackResult, tableName, fieldNames, filter, options);
            sdkResult.setResult((long)result);
            sdkResult.setData(new String(callbackResult, "UTF-8").trim());
        }
        catch (Error e) {
            sdkResult.setResult((long)LOADLIBRARY_FAILURE);
            this.log.error("error", (Throwable)e);
        }
        catch (Exception e) {
            this.log.error("exception", (Throwable)e);
        }
        return sdkResult;
    }

    public SdkResult getDeviceDataCount(long hCommPro, String tableName, String filter, String options) {
        SdkResult sdkResult = new SdkResult();
        try {
            int result = JavaToAdmsPullSDK.GetDeviceDataCount(hCommPro, tableName, filter, options);
            sdkResult.setResult((long)result);
            sdkResult.setData("");
        }
        catch (Error e) {
            sdkResult.setResult((long)LOADLIBRARY_FAILURE);
            this.log.error("error", (Throwable)e);
        }
        return sdkResult;
    }

    public SdkResult deleteDeviceData(long hCommPro, String tableName, String data, String options) {
        SdkResult sdkResult = new SdkResult();
        try {
            int result = JavaToAdmsPullSDK.DeleteDeviceData(hCommPro, tableName, data, options);
            sdkResult.setResult((long)result);
            sdkResult.setData("");
        }
        catch (Error e) {
            sdkResult.setResult((long)LOADLIBRARY_FAILURE);
            this.log.error("error", (Throwable)e);
        }
        return sdkResult;
    }

    public SdkResult getRTLog(long hCommPro, byte[] callbackResult) {
        SdkResult sdkResult = new SdkResult();
        try {
            int result = JavaToAdmsPullSDK.GetRTLog(hCommPro, callbackResult);
            sdkResult.setResult((long)result);
            if (result >= 0) {
                sdkResult.setData(new String(callbackResult, "UTF-8").trim());
            } else {
                sdkResult.setData("");
            }
        }
        catch (Exception e) {
            sdkResult.setResult((long)LOADLIBRARY_FAILURE);
            this.log.error("error", (Throwable)e);
        }
        return sdkResult;
    }

    public SdkResult getRTLogExt(long hCommPro, byte[] callbackResult) {
        SdkResult sdkResult = new SdkResult();
        try {
            int result = JavaToAdmsPullSDK.GetRTLogExt(hCommPro, callbackResult);
            sdkResult.setResult((long)result);
            if (result >= 0) {
                sdkResult.setData(new String(callbackResult, "UTF-8").trim());
            } else {
                sdkResult.setData("");
            }
        }
        catch (Exception e) {
            sdkResult.setResult((long)LOADLIBRARY_FAILURE);
            this.log.error("error", (Throwable)e);
        }
        return sdkResult;
    }

    public synchronized SdkResult searchDevice() {
        SdkResult sdkResult = new SdkResult();
        if (SystemOsUtil.isWindow()) {
            int bufferSize = 0x100000;
            byte[] callbackResult = new byte[bufferSize];
            try {
                int result = JavaToAdmsPullSDK.SearchDevice("UDP", "255.255.255.255", callbackResult);
                sdkResult.setResult((long)result);
                if (result > 0) {
                    sdkResult.setData(new String(callbackResult, "UTF-8").trim());
                }
            }
            catch (Exception e) {
                sdkResult.setResult((long)LOADLIBRARY_FAILURE);
                this.log.error("error", (Throwable)e);
            }
        } else if (SystemOsUtil.isLinux()) {
            sdkResult = AdmsBroadcastUtil.searchDevice();
        }
        return sdkResult;
    }

    public SdkResult modifyIPAddress(String buffer) {
        SdkResult sdkResult = new SdkResult();
        if (SystemOsUtil.isWindow()) {
            try {
                int result = JavaToAdmsPullSDK.ModifyIPAddress("UDP", "255.255.255.255", buffer);
                sdkResult.setResult((long)result);
                sdkResult.setData("");
            }
            catch (Error e) {
                sdkResult.setResult((long)LOADLIBRARY_FAILURE);
                this.log.error("error", (Throwable)e);
            }
        } else if (SystemOsUtil.isLinux()) {
            sdkResult = AdmsBroadcastUtil.modifyIPAddress(buffer);
        }
        return sdkResult;
    }

    public SdkResult pullLastError() {
        SdkResult sdkResult = new SdkResult();
        try {
            sdkResult.setResult((long)JavaToAdmsPullSDK.PullLastError());
        }
        catch (Error e) {
            sdkResult.setResult((long)LOADLIBRARY_FAILURE);
            this.log.error("error", (Throwable)e);
        }
        return sdkResult;
    }

    public SdkResult setDeviceFileData(long hCommPro, String fileName, String buffer, int bufferSize, String options) {
        SdkResult sdkResult = new SdkResult();
        try {
            int result = JavaToAdmsPullSDK.SetDeviceFileData(hCommPro, fileName, buffer, bufferSize, options);
            sdkResult.setResult((long)result);
            sdkResult.setData("");
        }
        catch (Error e) {
            sdkResult.setResult((long)LOADLIBRARY_FAILURE);
            this.log.error("error", (Throwable)e);
        }
        return sdkResult;
    }

    public SdkResult getDeviceFileData(long hCommPro, byte[] callbackResult, String fileName, String options) {
        SdkResult sdkResult = new SdkResult();
        try {
            int result = JavaToAdmsPullSDK.GetDeviceFileData(hCommPro, callbackResult, fileName, options);
            sdkResult.setResult((long)result);
            if (result >= 0) {
                sdkResult.setData(new String(callbackResult, "UTF-8").trim());
            } else {
                sdkResult.setData("");
            }
        }
        catch (Exception e) {
            sdkResult.setResult((long)LOADLIBRARY_FAILURE);
            this.log.error("error", (Throwable)e);
        }
        return sdkResult;
    }

    public SdkResult processBackupData(byte[] revBuf, int fileLen, byte[] callbackResult, int outSize) {
        SdkResult sdkResult = new SdkResult();
        try {
            int result = JavaToAdmsPullSDK.ProcessBackupData(revBuf, fileLen, callbackResult, outSize);
            sdkResult.setResult((long)result);
            if (result >= 0) {
                sdkResult.setData(new String(callbackResult, "UTF-8").trim());
            } else {
                sdkResult.setData("");
            }
        }
        catch (Exception e) {
            sdkResult.setResult((long)LOADLIBRARY_FAILURE);
            this.log.error("error", (Throwable)e);
        }
        return sdkResult;
    }

    public synchronized SdkResult searchDeviceEx(String paramItems) {
        SdkResult sdkResult = new SdkResult();
        if (SystemOsUtil.isWindow()) {
            int bufferSize = 0x100000;
            byte[] callbackResult = new byte[bufferSize];
            try {
                int result = JavaToAdmsPullSDK.SearchDeviceEx("UDP", "255.255.255.255", paramItems, callbackResult);
                sdkResult.setResult((long)result);
                if (result > 0) {
                    sdkResult.setData(new String(callbackResult, "UTF-8").trim());
                }
            }
            catch (Exception e) {
                sdkResult.setResult((long)LOADLIBRARY_FAILURE);
                this.log.error("error", (Throwable)e);
            }
        } else if (SystemOsUtil.isLinux()) {
            sdkResult = AdmsBroadcastUtil.searchDeviceEx(paramItems);
        }
        return sdkResult;
    }

    public byte[] decryptDataBase64(String cryptoKey, byte[] encryptByte) {
        byte[] retByte = new byte[]{};
        try {
            byte[] decryptStrByte = new byte[encryptByte.length];
            int[] retDecryptDataSize = new int[]{encryptByte.length};
            int ret = ZKCryptoClientService2.decryptDataBase64(cryptoKey, cryptoKey.length(), encryptByte, retDecryptDataSize[0], decryptStrByte, retDecryptDataSize);
            if (ret >= 0) {
                retByte = new byte[retDecryptDataSize[0]];
                System.arraycopy(decryptStrByte, 0, retByte, 0, retDecryptDataSize[0]);
            }
        }
        catch (Exception e) {
            this.log.error("error", (Throwable)e);
        }
        return retByte;
    }

    private void generateRSAKey() {
        try {
            byte[] bufPubKey = new byte[2048];
            int[] bufPubKeySize = new int[]{2048};
            byte[] bufPriKey = new byte[2048];
            int[] bufPriKeySize = new int[]{2048};
            int ret = ZKCryptoClientService2.generateRSAKey(bufPubKey, bufPubKeySize, bufPriKey, bufPriKeySize);
            if (ret >= 0) {
                this.pubKey = new String(bufPubKey, 0, bufPubKeySize[0], "UTF-8");
                this.priKey = new String(bufPriKey, 0, bufPriKeySize[0], "UTF-8");
            }
        }
        catch (Exception e) {
            this.log.error("error", (Throwable)e);
        }
    }

    private void encryptSoftPubKey() {
        try {
            if (StringUtils.isNotBlank((CharSequence)this.pubKey)) {
                this.encryptedPubKey = ZKCryptoClientService2.encryptSoftPubKey(this.pubKey, this.pubKey.length());
            }
        }
        catch (Exception e) {
            this.log.error("error", (Throwable)e);
        }
    }

    public String getEncryptedPubKey() {
        return this.encryptedPubKey;
    }

    public String getPriKey() {
        return this.priKey;
    }

    public String getEncryptedR2(String devPubKey, int r2) {
        String encryptR2 = null;
        try {
            encryptR2 = ZKCryptoClientService2.encryptR2(devPubKey, devPubKey.length(), r2);
        }
        catch (Exception e) {
            this.log.error("error", (Throwable)e);
        }
        return encryptR2;
    }

    public String getEncryptKey(String encryptedR1, int r2, String priKey) {
        String encryptKet = null;
        try {
            encryptKet = ZKCryptoClientService2.generateEncryptKey(encryptedR1, encryptedR1.length(), r2, priKey, priKey.length());
        }
        catch (Exception e) {
            this.log.error("error", (Throwable)e);
        }
        return encryptKet;
    }

    public String decryptDataBase64(String decryptKey, String encryptStr, String encoding) {
        String decryptData = null;
        try {
            byte[] encryptStrByte = encryptStr.getBytes(encoding);
            byte[] decryptStrByte = new byte[encryptStrByte.length];
            int[] retDecryptDataSize = new int[]{encryptStrByte.length};
            int ret = ZKCryptoClientService2.decryptDataBase64(decryptKey, decryptKey.length(), encryptStrByte, encryptStrByte.length, decryptStrByte, retDecryptDataSize);
            if (ret >= 0) {
                decryptData = new String(decryptStrByte, 0, retDecryptDataSize[0], encoding);
            } else {
                this.log.error("DecryptDataBase64 failed, error code=" + ret);
            }
        }
        catch (Exception e) {
            this.log.error("error", (Throwable)e);
        }
        return decryptData;
    }

    public String encryptDataBase64(String encryptKey, String normalStr, String encoding) {
        String encryptStr = null;
        try {
            byte[] normalStrByte = normalStr.getBytes(encoding);
            int dest = ((normalStrByte.length + 25) * 16 / 16 + 2) / 3 * 4;
            byte[] encryptData = new byte[dest];
            int[] retEncryptDataSize = new int[]{dest};
            int ret = ZKCryptoClientService2.encryptDataBase64(encryptKey, encryptKey.length(), normalStrByte, normalStrByte.length, encryptData, retEncryptDataSize);
            if (ret >= 0) {
                encryptStr = new String(encryptData, 0, retEncryptDataSize[0], encoding);
            } else {
                this.log.error("EncryptDataBase64 failed, error code=" + ret);
            }
        }
        catch (Exception e) {
            this.log.error("error", (Throwable)e);
        }
        return encryptStr;
    }

    public void killRS485Process() {
        try {
            Process proc = Runtime.getRuntime().exec("cmd.exe /c taskkill /im plrscagent.* /f");
            proc.waitFor();
            if (proc.exitValue() != 0) {
                this.log.info("Kill RS485Process failed by PULL!");
            }
        }
        catch (Exception e) {
            this.log.error("Kill RS485Process failed by PULL! error: ", (Throwable)e);
        }
    }
}

