/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.vis.init;

import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.auth.service.AuthPermissionService;
import com.zkteco.zkbiosecurity.auth.vo.AuthPermissionItem;
import com.zkteco.zkbiosecurity.base.utils.VersionUtil;
import com.zkteco.zkbiosecurity.system.service.BaseSysParamService;
import com.zkteco.zkbiosecurity.system.vo.BaseSysParamItem;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component
@Order(value=351)
public class LockerInit
implements CommandLineRunner {
    @Autowired(required=false)
    private AuthPermissionService authPermissionService;
    @Autowired(required=false)
    private BaseSysParamService baseSysParamService;

    public void run(String ... args) throws Exception {
        boolean alreadyInit = this.baseSysParamService.getAlreadyInitModule("LockerInit");
        if (!alreadyInit) {
            this.initAuthPermission();
            this.initLockerParams();
            this.initUpgradeVersion();
            this.baseSysParamService.setAlreadyInitModule("LockerInit");
        }
    }

    private void initAuthPermission() {
        AuthPermissionItem systemItem = new AuthPermissionItem("Locker", "locker_module", "locker", "system", "true", Integer.valueOf(35));
        systemItem = this.authPermissionService.initData(systemItem);
        AuthPermissionItem subMenuItem1 = new AuthPermissionItem("LockerDeviceManagement", "locker_leftMenu_devManagement", "locker:device:management", "menu", "true", Integer.valueOf(1));
        subMenuItem1.setParentId(systemItem.getId());
        subMenuItem1.setActionLink("lockerDevice.do");
        subMenuItem1.setImg("locker_device.png");
        subMenuItem1.setImgHover("locker_device_over.png");
        subMenuItem1 = this.authPermissionService.initData(subMenuItem1);
        AuthPermissionItem subMenuItem = new AuthPermissionItem("LockerDevice", "common_leftMenu_device", "locker:device", "menu", "true", Integer.valueOf(1));
        subMenuItem.setParentId(subMenuItem1.getId());
        subMenuItem.setActionLink("lockerDevice.do");
        subMenuItem = this.authPermissionService.initData(subMenuItem);
        AuthPermissionItem subButtonItem = new AuthPermissionItem("LockerDeviceRefresh", "common_op_refresh", "locker:device:refresh", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("LockerDeviceAdd", "common_op_new", "locker:device:add", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("LockerDeviceEdit", "common_op_edit", "locker:device:edit", "button", "true", Integer.valueOf(3));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("LockerDeviceDel", "common_op_del", "locker:device:del", "button", "true", Integer.valueOf(4));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("LockerDeviceSetAdmin", "locker_dev_setAdmin", "locker:device:setAdmin", "button", "true", Integer.valueOf(5));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("LockerDeviceClearAdmin", "locker_dev_clearAdmin", "locker:device:clearAdmin", "button", "true", Integer.valueOf(6));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("LockerDeviceReboot", "common_dev_reboot", "locker:device:reboot", "button", "true", Integer.valueOf(7));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("LockerDeviceSyncTime", "common_dev_syncTime", "locker:device:syncTime", "button", "true", Integer.valueOf(8));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("LockerDeviceSyncAllData", "common_dev_syncAllDataToDev", "locker:device:syncAllData", "button", "true", Integer.valueOf(9));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("LockerDeviceIssuedAdRes", "locker_dev_issuedAdRes", "locker:device:issuedAdRes", "button", "true", Integer.valueOf(10));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("LockerDeviceClearAllAds", "locker_dev_clearAllAds", "locker:device:clearAllAds", "button", "true", Integer.valueOf(11));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("LockerDeviceBindChannel", "common_vid_bindOrUnbindChannel", "locker:device:bindChannel", "button", "true", Integer.valueOf(12));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subMenuItem = new AuthPermissionItem("LockerParams", "common_leftMenu_paramSet", "locker:params", "menu", "true", Integer.valueOf(2));
        subMenuItem.setParentId(subMenuItem1.getId());
        subMenuItem.setActionLink("lockerParams.do");
        subMenuItem = this.authPermissionService.initData(subMenuItem);
        subButtonItem = new AuthPermissionItem("LockerParamsEdit", "common_op_edit", "locker:params:edit", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subMenuItem = new AuthPermissionItem("LockerVisualPanel", "locker_leftMenu_visualPanel", "locker:visualPanel", "menu", "true", Integer.valueOf(3));
        subMenuItem.setParentId(subMenuItem1.getId());
        subMenuItem.setActionLink("lockerVisualPanel.do");
        subMenuItem = this.authPermissionService.initData(subMenuItem);
        subMenuItem = new AuthPermissionItem("LockerLinkage", "locker_leftMenu_globalLinkage", "locker:linkage", "menu", "true", Integer.valueOf(8));
        subMenuItem.setParentId(subMenuItem1.getId());
        subMenuItem.setActionLink("lockerLinkage.do");
        subMenuItem = this.authPermissionService.initData(subMenuItem);
        subButtonItem = new AuthPermissionItem("LockerLinkageRefresh", "common_op_refresh", "locker:linkage:refresh", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("LockerLinkageAdd", "common_op_new", "locker:linkage:add", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("LockerLinkageEdit", "common_op_edit", "locker:linkage:edit", "button", "true", Integer.valueOf(3));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("LockerLinkageDel", "common_op_del", "locker:linkage:del", "button", "true", Integer.valueOf(4));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subMenuItem1 = new AuthPermissionItem("LockerReports", "locker_leftMenu_transaction", "locker:reports", "menu", "true", Integer.valueOf(2));
        subMenuItem1.setParentId(systemItem.getId());
        subMenuItem1.setActionLink("lockerTransaction.do");
        subMenuItem1.setImg("comm_reports.png");
        subMenuItem1.setImgHover("comm_reports_over.png");
        subMenuItem1 = this.authPermissionService.initData(subMenuItem1);
        subMenuItem = new AuthPermissionItem("LockerTransaction", "common_leftMenu_transaction", "locker:transaction", "menu", "true", Integer.valueOf(1));
        subMenuItem.setParentId(subMenuItem1.getId());
        subMenuItem.setActionLink("lockerTransaction.do");
        subMenuItem = this.authPermissionService.initData(subMenuItem);
        subButtonItem = new AuthPermissionItem("LockerTransactionRefresh", "common_op_refresh", "locker:transaction:refresh", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("LockerTransactionnDel", "common_op_del", "locker:transaction:del", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("LockerTransactionnnExport", "common_op_export", "locker:transaction:export", "button", "true", Integer.valueOf(3));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subMenuItem = this.authPermissionService.getItemByCode("PersPerson");
        if (null != subMenuItem) {
            subButtonItem = new AuthPermissionItem("PersPersonLockerEdit", "pers_person_lockerSet", "pers:person:lockerEdit", "button", "true", Integer.valueOf(109));
            subButtonItem.setParentId(subMenuItem.getId());
            subButtonItem = this.authPermissionService.initData(subButtonItem);
        }
    }

    public void initLockerParams() {
        this.baseSysParamService.initData(new BaseSysParamItem("locker.recordDelCount", "100", "\u8bb0\u5f55\u5faa\u73af\u5220\u9664\u6570\u91cf\u503c"));
        this.baseSysParamService.initData(new BaseSysParamItem("locker.takeOutTemporarily", "1", "\u662f\u5426\u5141\u8bb8\u4e34\u65f6\u53d6\u51fa 1\uff1a\u662f\uff0c 0\uff1a\u5426"));
        this.baseSysParamService.initData(new BaseSysParamItem("locker.multiplePeopleShareCabinet", "0", "\u662f\u5426\u5141\u8bb8\u591a\u4eba\u5171\u7528\u4e00\u4e2a\u67dc 1\uff1a\u662f\uff0c 0\uff1a\u5426"));
        this.baseSysParamService.initData(new BaseSysParamItem("locker.multiplePeopleMaxNum", "2", "\u591a\u4eba\u4e00\u67dc\u4eba\u5458\u6570\u6700\u5927\u503c"));
        this.baseSysParamService.initData(new BaseSysParamItem("locker.capturePhoto.encryptProp", "true", "\u6293\u62cd\u7167\u7247\u52a0\u5bc6\u663e\u793a"));
        JSONObject notificationValues = new JSONObject();
        notificationValues.put("Email", (Object)"1");
        notificationValues.put("SMS", (Object)"1");
        notificationValues.put("Whatsapp", (Object)"1");
        notificationValues.put("Line", (Object)"1");
        this.baseSysParamService.initData(new BaseSysParamItem("lockerMessageNotification", notificationValues.toString(), "base_dataClean_lockerTrans"));
    }

    private void initUpgradeVersion() {
        String curVersion = VersionUtil.getReleaseGitTags((String)"locker");
        if (StringUtils.isNotBlank((CharSequence)curVersion)) {
            BaseSysParamItem baseSysParamItem = this.baseSysParamService.findByParamName("LockerUpgradeVersion");
            if (StringUtils.isBlank((CharSequence)baseSysParamItem.getId())) {
                baseSysParamItem = new BaseSysParamItem("LockerUpgradeVersion", curVersion, "Locker Upgrade Version", Boolean.valueOf(true));
            }
            this.baseSysParamService.saveItem(baseSysParamItem);
        }
    }
}

