/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.posid.vo;

import com.zkteco.zkbiosecurity.base.annotation.Column;
import com.zkteco.zkbiosecurity.base.annotation.Condition;
import com.zkteco.zkbiosecurity.base.annotation.From;
import com.zkteco.zkbiosecurity.base.annotation.GridColumn;
import com.zkteco.zkbiosecurity.base.annotation.GridConfig;
import com.zkteco.zkbiosecurity.base.annotation.OrderBy;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import java.util.Date;

@From(after="POSID_TRANSFER_ACCOUNT t LEFT JOIN POSID_ACCOUNT p ON p.PERSON_PIN = t.SENDER_ID ")
@OrderBy(after="t.CREATE_TIME DESC")
@GridConfig(operate=true, idField="id", winHeight=400, winWidth=600)
public class PosIDTransferAccountItem
extends BaseItem {
    private static final long serialVersionUID = 1L;
    @Column(name="t.ID")
    @GridColumn(checkbox=true, width="40", sort="na", show=false)
    private String id;
    @Column(name="t.ACCOUNT_SEND_TYPE")
    @GridColumn(label="posid_transfer_wallet", width="120", format="1=posid_account_allowance_wallet,0=posid_account_money_wallet")
    private String accountSendType;
    @Column(name="t.ACCOUNT_RECEIVE_TYPE")
    @GridColumn(label="posid_transfer_to_wallet", width="120", format="1=posid_account_allowance_wallet,0=posid_account_money_wallet")
    private String accountReceiveType;
    @Column(name="t.TYPE")
    @GridColumn(label="posid_transfer_type", width="100", format="1=posid_cash_transfer")
    private String type;
    @Column(name="t.SENDER_ID")
    @GridColumn(label="posid_transfer_manual_number", width="120", encryptMode="${pers.pin.encryptMode}", encryptProp="${pers.pin.encryptProp}")
    private String senderId;
    @GridColumn(label="transfer_account_sender_name", width="150", encryptMode="${pers.name.encryptMode}", encryptProp="${pers.name.encryptProp}")
    @Column(name="t.SENDER_NAME")
    private String senderName;
    @Column(name="t.SENDER_DEPT_NAME")
    @GridColumn(label="transfer_account_sender_dept_name", width="150")
    private String senderDeptName;
    @Column(name="t.RECEIVER_ID")
    @GridColumn(label="posid_receive_manual_number", width="120", encryptMode="${pers.pin.encryptMode}", encryptProp="${pers.pin.encryptProp}")
    private String receiverId;
    @Column(name="t.RECEIVER_NAME")
    @GridColumn(label="transfer_account_receiver_name", width="150", encryptMode="${pers.name.encryptMode}", encryptProp="${pers.name.encryptProp}")
    private String receiverName;
    @Column(name="t.RECEIVER_DEPT_NAME")
    @GridColumn(label="transfer_account_receiver_dept_name", width="150")
    private String receiverDeptName;
    @Column(name="t.AMOUNT")
    @GridColumn(label="transfer_account_amount", width="100", columnType="custom", convert="convertFen2Yuan")
    private Integer transferAmt;
    @Column(name="t.NOTE")
    @GridColumn(label="common_remark", width="150", show=false)
    private String note;
    @Column(name="t.CREATE_TIME")
    @GridColumn(label="posid_cus_creatTime", minWidth="170")
    private Date createdTime;
    @Condition(value="p.DEPT_ID", equalTag="in")
    private String inDeptId;
    @Condition(value="p.DEPT_ID IN (SELECT ud.AUTH_DEPT_ID FROM AUTH_USER_DEPT ud WHERE ud.AUTH_USER_ID=''{0}'')")
    private String userId;
    private Integer transferType;
    private String deptId;
    private String isIncludeLower;

    public String getId() {
        return this.id;
    }

    public String getAccountSendType() {
        return this.accountSendType;
    }

    public String getAccountReceiveType() {
        return this.accountReceiveType;
    }

    public String getType() {
        return this.type;
    }

    public String getSenderId() {
        return this.senderId;
    }

    public String getSenderName() {
        return this.senderName;
    }

    public String getSenderDeptName() {
        return this.senderDeptName;
    }

    public String getReceiverId() {
        return this.receiverId;
    }

    public String getReceiverName() {
        return this.receiverName;
    }

    public String getReceiverDeptName() {
        return this.receiverDeptName;
    }

    public Integer getTransferAmt() {
        return this.transferAmt;
    }

    public String getNote() {
        return this.note;
    }

    public Date getCreatedTime() {
        return this.createdTime;
    }

    public String getInDeptId() {
        return this.inDeptId;
    }

    public String getUserId() {
        return this.userId;
    }

    public Integer getTransferType() {
        return this.transferType;
    }

    public String getDeptId() {
        return this.deptId;
    }

    public String getIsIncludeLower() {
        return this.isIncludeLower;
    }

    public PosIDTransferAccountItem setId(String id) {
        this.id = id;
        return this;
    }

    public PosIDTransferAccountItem setAccountSendType(String accountSendType) {
        this.accountSendType = accountSendType;
        return this;
    }

    public PosIDTransferAccountItem setAccountReceiveType(String accountReceiveType) {
        this.accountReceiveType = accountReceiveType;
        return this;
    }

    public PosIDTransferAccountItem setType(String type) {
        this.type = type;
        return this;
    }

    public PosIDTransferAccountItem setSenderId(String senderId) {
        this.senderId = senderId;
        return this;
    }

    public PosIDTransferAccountItem setSenderName(String senderName) {
        this.senderName = senderName;
        return this;
    }

    public PosIDTransferAccountItem setSenderDeptName(String senderDeptName) {
        this.senderDeptName = senderDeptName;
        return this;
    }

    public PosIDTransferAccountItem setReceiverId(String receiverId) {
        this.receiverId = receiverId;
        return this;
    }

    public PosIDTransferAccountItem setReceiverName(String receiverName) {
        this.receiverName = receiverName;
        return this;
    }

    public PosIDTransferAccountItem setReceiverDeptName(String receiverDeptName) {
        this.receiverDeptName = receiverDeptName;
        return this;
    }

    public PosIDTransferAccountItem setTransferAmt(Integer transferAmt) {
        this.transferAmt = transferAmt;
        return this;
    }

    public PosIDTransferAccountItem setNote(String note) {
        this.note = note;
        return this;
    }

    public PosIDTransferAccountItem setCreatedTime(Date createdTime) {
        this.createdTime = createdTime;
        return this;
    }

    public PosIDTransferAccountItem setInDeptId(String inDeptId) {
        this.inDeptId = inDeptId;
        return this;
    }

    public PosIDTransferAccountItem setUserId(String userId) {
        this.userId = userId;
        return this;
    }

    public PosIDTransferAccountItem setTransferType(Integer transferType) {
        this.transferType = transferType;
        return this;
    }

    public PosIDTransferAccountItem setDeptId(String deptId) {
        this.deptId = deptId;
        return this;
    }

    public PosIDTransferAccountItem setIsIncludeLower(String isIncludeLower) {
        this.isIncludeLower = isIncludeLower;
        return this;
    }

    public String toString() {
        return "PosIDTransferAccountItem(id=" + this.getId() + ", accountSendType=" + this.getAccountSendType() + ", accountReceiveType=" + this.getAccountReceiveType() + ", type=" + this.getType() + ", senderId=" + this.getSenderId() + ", senderName=" + this.getSenderName() + ", senderDeptName=" + this.getSenderDeptName() + ", receiverId=" + this.getReceiverId() + ", receiverName=" + this.getReceiverName() + ", receiverDeptName=" + this.getReceiverDeptName() + ", transferAmt=" + this.getTransferAmt() + ", note=" + this.getNote() + ", createdTime=" + this.getCreatedTime() + ", inDeptId=" + this.getInDeptId() + ", userId=" + this.getUserId() + ", transferType=" + this.getTransferType() + ", deptId=" + this.getDeptId() + ", isIncludeLower=" + this.getIsIncludeLower() + ")";
    }
}

