/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.posid.vo;

import com.zkteco.zkbiosecurity.base.annotation.Column;
import com.zkteco.zkbiosecurity.base.annotation.Condition;
import com.zkteco.zkbiosecurity.base.annotation.From;
import com.zkteco.zkbiosecurity.base.annotation.GridColumn;
import com.zkteco.zkbiosecurity.base.annotation.GridConfig;
import com.zkteco.zkbiosecurity.base.annotation.OrderBy;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import java.util.Date;

@From(after="POSID_TRANSACTION t")
@OrderBy(after="t.POS_TIME DESC")
@GridConfig(operate=true, idField="id", winHeight=350, winWidth=600)
public class PosIDTransactionExportItem
extends BaseItem {
    private static final long serialVersionUID = 1L;
    @Column(name="t.ID")
    @GridColumn(checkbox=true, width="40", sort="na")
    private String id;
    @Column(name="t.PERSON_ID")
    @GridColumn(label="posid_card_personNum", show=false)
    private String personId;
    @Column(name="t.PERSON_PIN")
    @GridColumn(label="pers_person_pin", width="100", i18n=true)
    private String personPin;
    @Column(name="t.PERSON_NAME")
    @GridColumn(label="pers_person_name", width="100")
    private String personName;
    @Column(name="t.PERSON_LAST_NAME")
    @GridColumn(label="pers_person_lastName", width="80", showExpression="#language!='zh_CN'")
    private String personLastName;
    @Column(name="t.ACCOUNT_NO")
    @GridColumn(label="posid_card_accountNum", width="90")
    private String accountNo;
    @Column(name="t.TYPE_NAME")
    @GridColumn(label="posid_card_typeName", width="80", format="6=posid_common_consumption,8=posid_cus_supply,9=posid_consumerList_correction,10=posid_consumerList_theTime,11=posid_consumerList_accounting,12=posid_manual_log_flag_offline_consume,13=posid_orderMeal_cancel")
    private Integer typeName;
    @Column(name="t.MONEY")
    @GridColumn(label="posid_cus_money", width="100", columnType="custom")
    private Double money;
    @Column(name="t.MONEY_WALLET_MONEY")
    @GridColumn(label="posid_cus_money_wallet", width="120", columnType="custom", convert="convertFen2Yuan")
    private Double moneyWalletMoney;
    @Column(name="t.ALLOWANCE_WALLET_MONEY")
    @GridColumn(label="posid_cus_allowance_wallet", width="120", columnType="custom", convert="convertFen2Yuan")
    private Double allowanceWalletMoney;
    @Column(name="t.WX_PAY_MONEY")
    @GridColumn(label="posid_cus_wechat_wallet", width="120", columnType="custom", convert="convertFen2Yuan", showExpression="#language=='zh_CN'")
    private Double wxPayMoney;
    @Column(name="t.ALI_PAY_MONEY")
    @GridColumn(label="posid_ali_wallet_consume_money", width="130", columnType="custom", convert="convertFen2Yuan", showExpression="#language=='zh_CN'")
    private Double aliPayMoney;
    @Column(name="t.BALANCE")
    @GridColumn(label="posid_account_balance", width="100", columnType="custom")
    private Double balance;
    @Column(name="t.MONEY_WALLET")
    @GridColumn(label="posid_account_money_wallet", show=true, columnType="custom")
    private Double moneyWallet;
    @Column(name="t.ALLOWANCE_WALLET")
    @GridColumn(label="posid_account_allowance_wallet", show=true, columnType="custom")
    private Double allowanceWallet;
    @Column(name="t.POS_MODEL", equalTag="=")
    @GridColumn(label="posid_consumerList_consumType", width="120", format="1=posid_dev_fixMode,2=posid_dev_amountMode,3=posid_dev_keyValueMode,4=posid_dev_timesMode,5=posid_dev_storeMode,6=posid_dev_timingMode,7=posid_dev_accountingMode,8=posid_leftMenu_handConsume,9=posid_device_error_correction,10=posid_dev_systemError,11=posid_dev_order,12=posid_dev_intelligence")
    private Integer posModel;
    @Column(name="t.DISCOUNT")
    @GridColumn(label="posid_iccard_discount", width="85")
    private Integer discount;
    @Column(name="t.DISCOUNT_MONEY")
    @GridColumn(label="posid_consume_discount_money", columnType="custom", convert="convertFen2Yuan")
    private Double discountMoney;
    @Column(name="t.CONSUME_ORDER")
    @GridColumn(label="posid_consume_order", width="120", format="0=posid_system_onlyCash,1=posid_system_onlySubsidy,2=posid_system_firstCash,3=posid_system_firstSubsidy,4=posid_system_onlyWechat,5=posid_system_firstCash_secondWechat,6=posid_system_firstCash_laseWechat,7=posid_system_firstSubsidy_laseWechat,8=posid_system_onlyAli,9=posid_system_firstCash_secondAli,10=posid_system_firstCash_laseAli,11=posid_system_firstSubsidy_laseAli,12=posid_system_firstSubsidy_secondAli")
    private Integer consumeOrder;
    @Column(name="t.DEPT_ID")
    @GridColumn(label="posid_transaction_deptId", show=false)
    private String deptId;
    @Column(name="t.DEPT_CODE")
    @GridColumn(label="posid_card_deptNum", width="125")
    private String deptCode;
    @Column(name="t.DEPT_NAME")
    @GridColumn(label="posid_card_deptName", width="110")
    private String deptName;
    @Column(name="t.HALLING_ID")
    @GridColumn(label="posid_transaction_hallingId", show=false)
    private String hallingId;
    @Column(name="t.HALLING_CODE")
    @GridColumn(label="posid_transaction_hallingCode", show=false)
    private String hallingCode;
    @Column(name="t.HALLING_NAME")
    @GridColumn(label="posid_diningHall_name", width="110")
    private String hallingName;
    @Column(name="t.MEAL_ID", equalTag="=")
    @GridColumn(label="posid_transaction_posMeal", show=false)
    private String mealId;
    @Column(name="t.MEAL_CODE")
    @GridColumn(label="posid_meal_code", show=false)
    private String mealCode;
    @Column(name="t.MEAL_NAME")
    @GridColumn(label="posid_meal_name", width="80")
    private String mealName;
    @Column(name="t.DEV_SN")
    @GridColumn(label="common_dev_sn", width="100")
    private String devSn;
    @Column(name="t.ACCOUNT_SERIAL")
    @GridColumn(label="posid_card_cardSerial", width="130")
    private Integer accountSerial;
    @Column(name="t.CARD_NO", encryptConverter=true)
    @GridColumn(label="posid_card_cardNo", width="100", encryptMode="${pers.cardNo.encryptMode}", encryptProp="${pers.cardNo.encryptProp}")
    private String cardNo;
    @Column(name="t.POS_FACE_IMG")
    @GridColumn(label="posid_face_img", columnType="custom", convert="changePic", align="center", width="100", isExportExcel=false)
    private String posFaceImg;
    @Column(name="t.POS_TIME")
    @GridColumn(label="posid_cus_time", width="150")
    private Date posTime;
    @Column(name="t.CREATE_TIME")
    @GridColumn(label="posid_common_upload_time", width="150")
    private Date createTime;
    @Column(name="t.CREATER_CODE")
    @GridColumn(label="posid_card_changeOperator", width="70")
    private String createrName;
    @Column(name="t.LOG_FLAG")
    @GridColumn(label="posid_card_logFlag", format="1=posid_device_upload,2=posid_system_add,3=posid_error_correction_compensation,4=posid_manual_log_flag_wechat,5=posid_manual_log_flag_alipay,6=posid_manual_log_flag_offline_consume")
    private Integer logFlag;
    @Column(name="t.IS_EXCEPTION")
    @GridColumn(label="posid_transaction_isException", show=false)
    private Boolean isException;
    @Condition(value="t.POS_TIME", equalTag=">=", toDate=true)
    private String startDatetimeBegin;
    @Condition(value="t.POS_TIME", equalTag="<=", toDate=true)
    private String startDatetimeEnd;
    @Column(name="t.DEV_ALIAS")
    @GridColumn(label="common_dev_sn", width="100", show=false)
    private String devAlias;
    @Condition(value="t.DEPT_ID", equalTag="in")
    private String inDeptId;
    @Condition(value="(t.PERSON_NAME LIKE ''%{0}%'' OR t.PERSON_LAST_NAME LIKE ''%{0}%'')")
    private String likeName;

    public PosIDTransactionExportItem() {
    }

    public PosIDTransactionExportItem(Boolean equals) {
        super(equals);
    }

    public PosIDTransactionExportItem(String id) {
        super(Boolean.valueOf(true));
        this.id = id;
    }

    public PosIDTransactionExportItem(String id, String personId, String personPin, String personName, String personLastName, String deptId, String deptCode, String deptName, String hallingId, String hallingCode, String hallingName, Integer accountSerial, String cardStatus, String accountNo, String devSn, Date posTime, Date createTime, Double money, Double balance, Integer typeName, Integer posModel, String createrName, Integer logFlag, Integer recordType, Boolean isException, String uniqueKey) {
        this.id = id;
        this.personId = personId;
        this.personPin = personPin;
        this.personName = personName;
        this.personLastName = personLastName;
        this.deptId = deptId;
        this.deptCode = deptCode;
        this.deptName = deptName;
        this.hallingId = hallingId;
        this.hallingCode = hallingCode;
        this.hallingName = hallingName;
        this.accountSerial = accountSerial;
        this.accountNo = accountNo;
        this.devSn = devSn;
        this.posTime = posTime;
        this.createTime = createTime;
        this.money = money;
        this.balance = balance;
        this.typeName = typeName;
        this.posModel = posModel;
        this.createrName = createrName;
        this.logFlag = logFlag;
        this.isException = isException;
    }

    public String getId() {
        return this.id;
    }

    public String getPersonId() {
        return this.personId;
    }

    public String getPersonPin() {
        return this.personPin;
    }

    public String getPersonName() {
        return this.personName;
    }

    public String getPersonLastName() {
        return this.personLastName;
    }

    public String getAccountNo() {
        return this.accountNo;
    }

    public Integer getTypeName() {
        return this.typeName;
    }

    public Double getMoney() {
        return this.money;
    }

    public Double getMoneyWalletMoney() {
        return this.moneyWalletMoney;
    }

    public Double getAllowanceWalletMoney() {
        return this.allowanceWalletMoney;
    }

    public Double getWxPayMoney() {
        return this.wxPayMoney;
    }

    public Double getAliPayMoney() {
        return this.aliPayMoney;
    }

    public Double getBalance() {
        return this.balance;
    }

    public Double getMoneyWallet() {
        return this.moneyWallet;
    }

    public Double getAllowanceWallet() {
        return this.allowanceWallet;
    }

    public Integer getPosModel() {
        return this.posModel;
    }

    public Integer getDiscount() {
        return this.discount;
    }

    public Double getDiscountMoney() {
        return this.discountMoney;
    }

    public Integer getConsumeOrder() {
        return this.consumeOrder;
    }

    public String getDeptId() {
        return this.deptId;
    }

    public String getDeptCode() {
        return this.deptCode;
    }

    public String getDeptName() {
        return this.deptName;
    }

    public String getHallingId() {
        return this.hallingId;
    }

    public String getHallingCode() {
        return this.hallingCode;
    }

    public String getHallingName() {
        return this.hallingName;
    }

    public String getMealId() {
        return this.mealId;
    }

    public String getMealCode() {
        return this.mealCode;
    }

    public String getMealName() {
        return this.mealName;
    }

    public String getDevSn() {
        return this.devSn;
    }

    public Integer getAccountSerial() {
        return this.accountSerial;
    }

    public String getCardNo() {
        return this.cardNo;
    }

    public String getPosFaceImg() {
        return this.posFaceImg;
    }

    public Date getPosTime() {
        return this.posTime;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public String getCreaterName() {
        return this.createrName;
    }

    public Integer getLogFlag() {
        return this.logFlag;
    }

    public Boolean getIsException() {
        return this.isException;
    }

    public String getStartDatetimeBegin() {
        return this.startDatetimeBegin;
    }

    public String getStartDatetimeEnd() {
        return this.startDatetimeEnd;
    }

    public String getDevAlias() {
        return this.devAlias;
    }

    public String getInDeptId() {
        return this.inDeptId;
    }

    public String getLikeName() {
        return this.likeName;
    }

    public PosIDTransactionExportItem setId(String id) {
        this.id = id;
        return this;
    }

    public PosIDTransactionExportItem setPersonId(String personId) {
        this.personId = personId;
        return this;
    }

    public PosIDTransactionExportItem setPersonPin(String personPin) {
        this.personPin = personPin;
        return this;
    }

    public PosIDTransactionExportItem setPersonName(String personName) {
        this.personName = personName;
        return this;
    }

    public PosIDTransactionExportItem setPersonLastName(String personLastName) {
        this.personLastName = personLastName;
        return this;
    }

    public PosIDTransactionExportItem setAccountNo(String accountNo) {
        this.accountNo = accountNo;
        return this;
    }

    public PosIDTransactionExportItem setTypeName(Integer typeName) {
        this.typeName = typeName;
        return this;
    }

    public PosIDTransactionExportItem setMoney(Double money) {
        this.money = money;
        return this;
    }

    public PosIDTransactionExportItem setMoneyWalletMoney(Double moneyWalletMoney) {
        this.moneyWalletMoney = moneyWalletMoney;
        return this;
    }

    public PosIDTransactionExportItem setAllowanceWalletMoney(Double allowanceWalletMoney) {
        this.allowanceWalletMoney = allowanceWalletMoney;
        return this;
    }

    public PosIDTransactionExportItem setWxPayMoney(Double wxPayMoney) {
        this.wxPayMoney = wxPayMoney;
        return this;
    }

    public PosIDTransactionExportItem setAliPayMoney(Double aliPayMoney) {
        this.aliPayMoney = aliPayMoney;
        return this;
    }

    public PosIDTransactionExportItem setBalance(Double balance) {
        this.balance = balance;
        return this;
    }

    public PosIDTransactionExportItem setMoneyWallet(Double moneyWallet) {
        this.moneyWallet = moneyWallet;
        return this;
    }

    public PosIDTransactionExportItem setAllowanceWallet(Double allowanceWallet) {
        this.allowanceWallet = allowanceWallet;
        return this;
    }

    public PosIDTransactionExportItem setPosModel(Integer posModel) {
        this.posModel = posModel;
        return this;
    }

    public PosIDTransactionExportItem setDiscount(Integer discount) {
        this.discount = discount;
        return this;
    }

    public PosIDTransactionExportItem setDiscountMoney(Double discountMoney) {
        this.discountMoney = discountMoney;
        return this;
    }

    public PosIDTransactionExportItem setConsumeOrder(Integer consumeOrder) {
        this.consumeOrder = consumeOrder;
        return this;
    }

    public PosIDTransactionExportItem setDeptId(String deptId) {
        this.deptId = deptId;
        return this;
    }

    public PosIDTransactionExportItem setDeptCode(String deptCode) {
        this.deptCode = deptCode;
        return this;
    }

    public PosIDTransactionExportItem setDeptName(String deptName) {
        this.deptName = deptName;
        return this;
    }

    public PosIDTransactionExportItem setHallingId(String hallingId) {
        this.hallingId = hallingId;
        return this;
    }

    public PosIDTransactionExportItem setHallingCode(String hallingCode) {
        this.hallingCode = hallingCode;
        return this;
    }

    public PosIDTransactionExportItem setHallingName(String hallingName) {
        this.hallingName = hallingName;
        return this;
    }

    public PosIDTransactionExportItem setMealId(String mealId) {
        this.mealId = mealId;
        return this;
    }

    public PosIDTransactionExportItem setMealCode(String mealCode) {
        this.mealCode = mealCode;
        return this;
    }

    public PosIDTransactionExportItem setMealName(String mealName) {
        this.mealName = mealName;
        return this;
    }

    public PosIDTransactionExportItem setDevSn(String devSn) {
        this.devSn = devSn;
        return this;
    }

    public PosIDTransactionExportItem setAccountSerial(Integer accountSerial) {
        this.accountSerial = accountSerial;
        return this;
    }

    public PosIDTransactionExportItem setCardNo(String cardNo) {
        this.cardNo = cardNo;
        return this;
    }

    public PosIDTransactionExportItem setPosFaceImg(String posFaceImg) {
        this.posFaceImg = posFaceImg;
        return this;
    }

    public PosIDTransactionExportItem setPosTime(Date posTime) {
        this.posTime = posTime;
        return this;
    }

    public PosIDTransactionExportItem setCreateTime(Date createTime) {
        this.createTime = createTime;
        return this;
    }

    public PosIDTransactionExportItem setCreaterName(String createrName) {
        this.createrName = createrName;
        return this;
    }

    public PosIDTransactionExportItem setLogFlag(Integer logFlag) {
        this.logFlag = logFlag;
        return this;
    }

    public PosIDTransactionExportItem setIsException(Boolean isException) {
        this.isException = isException;
        return this;
    }

    public PosIDTransactionExportItem setStartDatetimeBegin(String startDatetimeBegin) {
        this.startDatetimeBegin = startDatetimeBegin;
        return this;
    }

    public PosIDTransactionExportItem setStartDatetimeEnd(String startDatetimeEnd) {
        this.startDatetimeEnd = startDatetimeEnd;
        return this;
    }

    public PosIDTransactionExportItem setDevAlias(String devAlias) {
        this.devAlias = devAlias;
        return this;
    }

    public PosIDTransactionExportItem setInDeptId(String inDeptId) {
        this.inDeptId = inDeptId;
        return this;
    }

    public PosIDTransactionExportItem setLikeName(String likeName) {
        this.likeName = likeName;
        return this;
    }

    public String toString() {
        return "PosIDTransactionExportItem(id=" + this.getId() + ", personId=" + this.getPersonId() + ", personPin=" + this.getPersonPin() + ", personName=" + this.getPersonName() + ", personLastName=" + this.getPersonLastName() + ", accountNo=" + this.getAccountNo() + ", typeName=" + this.getTypeName() + ", money=" + this.getMoney() + ", moneyWalletMoney=" + this.getMoneyWalletMoney() + ", allowanceWalletMoney=" + this.getAllowanceWalletMoney() + ", wxPayMoney=" + this.getWxPayMoney() + ", aliPayMoney=" + this.getAliPayMoney() + ", balance=" + this.getBalance() + ", moneyWallet=" + this.getMoneyWallet() + ", allowanceWallet=" + this.getAllowanceWallet() + ", posModel=" + this.getPosModel() + ", discount=" + this.getDiscount() + ", discountMoney=" + this.getDiscountMoney() + ", consumeOrder=" + this.getConsumeOrder() + ", deptId=" + this.getDeptId() + ", deptCode=" + this.getDeptCode() + ", deptName=" + this.getDeptName() + ", hallingId=" + this.getHallingId() + ", hallingCode=" + this.getHallingCode() + ", hallingName=" + this.getHallingName() + ", mealId=" + this.getMealId() + ", mealCode=" + this.getMealCode() + ", mealName=" + this.getMealName() + ", devSn=" + this.getDevSn() + ", accountSerial=" + this.getAccountSerial() + ", cardNo=" + this.getCardNo() + ", posFaceImg=" + this.getPosFaceImg() + ", posTime=" + this.getPosTime() + ", createTime=" + this.getCreateTime() + ", createrName=" + this.getCreaterName() + ", logFlag=" + this.getLogFlag() + ", isException=" + this.getIsException() + ", startDatetimeBegin=" + this.getStartDatetimeBegin() + ", startDatetimeEnd=" + this.getStartDatetimeEnd() + ", devAlias=" + this.getDevAlias() + ", inDeptId=" + this.getInDeptId() + ", likeName=" + this.getLikeName() + ")";
    }
}

