/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.posid.vo;

import com.zkteco.zkbiosecurity.base.annotation.Column;
import com.zkteco.zkbiosecurity.base.annotation.Condition;
import com.zkteco.zkbiosecurity.base.annotation.From;
import com.zkteco.zkbiosecurity.base.annotation.GridColumn;
import com.zkteco.zkbiosecurity.base.annotation.GridConfig;
import com.zkteco.zkbiosecurity.base.annotation.GroupBy;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import java.util.UUID;

@From(after="POSID_TRANSACTIONCARD t")
@GroupBy(after="t.PERSON_ID")
@GridConfig(operate=true, idField="id", winHeight=400, winWidth=600)
public class PosIDPersonTopUpItem
extends BaseItem {
    @GridColumn(show=false)
    private String id = UUID.randomUUID().toString();
    @Column(name="t.PERSON_ID")
    private String personId;
    @GridColumn(label="pers_person_pin", width="120", i18n=true, encryptMode="${pers.pin.encryptMode}", encryptProp="${pers.pin.encryptProp}")
    private String personPin;
    @GridColumn(label="pers_person_name", width="120", i18n=true, encryptMode="${pers.name.encryptMode}", encryptProp="${pers.name.encryptProp}")
    private String personName;
    @GridColumn(label="pers_person_lastName", width="80", showExpression="#language!='zh_CN'", encryptMode="${pers.lastName.encryptMode}", encryptProp="${pers.lastName.encryptProp}")
    private String personLastName;
    @Column(name="sum(case t.TYPE when 1 then 1 else 0 end)")
    @GridColumn(label="posid_countTable_sysTopUp_count", width="100")
    private Integer sysTopUpCount;
    @Column(name="sum(case t.TYPE when 1 then t.MONEY else 0 end)")
    @GridColumn(label="posid_countTable_sysTopUp_money", width="110", columnType="custom", convert="convertFen2Yuan")
    private Integer sysTopUpTotal;
    @Column(name="sum(case t.TYPE when 12 then 1 else 0 end)")
    @GridColumn(label="posid_countTable_miniTopUp_count", width="110", showExpression="#language=='zh_CN'")
    private Integer miniTopUpCount;
    @Column(name="sum(case t.TYPE when 12 then t.MONEY else 0 end)")
    @GridColumn(label="posid_countTable_miniTopUp_money", width="110", columnType="custom", convert="convertFen2Yuan", showExpression="#language=='zh_CN'")
    private Integer miniTopUpTotal;
    @Column(name="sum(case t.TYPE when 11 then 1 else 0 end)")
    @GridColumn(label="posid_countTable_barTopUp_count", width="110", showExpression="#language=='zh_CN'")
    private Integer barTopUpCount;
    @Column(name="sum(case t.TYPE when 11 then t.MONEY else 0 end)")
    @GridColumn(label="posid_countTable_barTopUp_money", width="120", columnType="custom", convert="convertFen2Yuan", showExpression="#language=='zh_CN'")
    private Integer barTopUpTotal;
    @Column(name="(sum(case t.TYPE when 1 then 1 else 0 end)+sum(case t.TYPE when 12 then 1 else 0 end)+sum(case t.TYPE when 11 then 1 else 0 end))")
    @GridColumn(label="posid_countTable_total_count", width="100")
    private Integer topUpCount;
    @Column(name="(sum(case t.TYPE when 1 then t.MONEY else 0 end)+sum(case t.TYPE when 12 then t.MONEY else 0 end)+sum(case t.TYPE when 11 then t.MONEY else 0 end))")
    @GridColumn(label="posid_countTable_total_money", width="120", columnType="custom", convert="convertFen2Yuan")
    private Integer topUpTotal;
    @Column(name="sum(case when t.TYPE = 4 then 1 else 0 end)")
    @GridColumn(label="posid_countTable_allowanceTimes", width="80")
    private Integer allowanceCount;
    @Column(name="sum(case when t.TYPE = 4 then t.MONEY else 0 end)")
    @GridColumn(label="posid_incomeExpendConsume_subsidyTotal", width="120", columnType="custom", convert="convertFen2Yuan")
    private Integer allowanceTotal;
    @Column(name="sum(case when t.TYPE = 5 then 1 else 0 end)")
    @GridColumn(label="posid_incomeExpendConsume_refundTimes", width="80")
    private Integer refundCount;
    @Column(name="sum(case when t.TYPE = 5 then t.MONEY else 0 end)")
    @GridColumn(label="posid_incomeExpendConsume_refundTotal", width="120", columnType="custom", convert="convertFen2Yuan")
    private Integer refundTotal;
    @Column(name="sum(case when t.TYPE = 17 then 1 else 0 end)")
    @GridColumn(label="posid_allowance_refund_num", width="100")
    private Integer allowanceRefundCount;
    @Column(name="sum(case when t.TYPE = 17 then t.MONEY else 0 end)")
    @GridColumn(label="posid_allowance_refund_total", width="120", columnType="custom", convert="convertFen2Yuan")
    private Integer allowanceRefundTotal;
    @Column(name="(sum(case t.TYPE when 1 then t.MONEY else 0 end)+sum(case t.TYPE when 12 then t.MONEY else 0 end)+sum(case t.TYPE when 11 then t.MONEY else 0 end)+sum(case t.TYPE when 4 then t.MONEY else 0 end)-sum(case t.TYPE when 5 then t.MONEY else 0 end))")
    @GridColumn(label="posid_countTable_total_actual_money", minWidth="120", width="120", columnType="custom", convert="convertFen2Yuan")
    private Integer actualTopUpTotal;
    @Condition(value="t.CREATE_TIME", equalTag=">=", toDate=true)
    private String opTimeBegin;
    @Condition(value="t.CREATE_TIME", equalTag="<=", toDate=true)
    private String opTimeEnd;
    @Condition(value="t.DEPT_ID", equalTag="in")
    private String inDeptId;
    @Condition(value="t.PERSON_PIN", equalTag="like")
    private String likePersonPin;
    @Condition(value="(t.PERSON_NAME LIKE ''%{0}%'' OR t.PERSON_LAST_NAME LIKE ''%{0}%'')")
    private String likeName;
    @Condition(value="t.DEPT_ID IN (SELECT ud.AUTH_DEPT_ID FROM AUTH_USER_DEPT ud WHERE ud.AUTH_USER_ID=''{0}'')")
    private String userId;
    private String deptId;
    private String isIncludeLower;

    public String getId() {
        return this.id;
    }

    public String getPersonId() {
        return this.personId;
    }

    public String getPersonPin() {
        return this.personPin;
    }

    public String getPersonName() {
        return this.personName;
    }

    public String getPersonLastName() {
        return this.personLastName;
    }

    public Integer getSysTopUpCount() {
        return this.sysTopUpCount;
    }

    public Integer getSysTopUpTotal() {
        return this.sysTopUpTotal;
    }

    public Integer getMiniTopUpCount() {
        return this.miniTopUpCount;
    }

    public Integer getMiniTopUpTotal() {
        return this.miniTopUpTotal;
    }

    public Integer getBarTopUpCount() {
        return this.barTopUpCount;
    }

    public Integer getBarTopUpTotal() {
        return this.barTopUpTotal;
    }

    public Integer getTopUpCount() {
        return this.topUpCount;
    }

    public Integer getTopUpTotal() {
        return this.topUpTotal;
    }

    public Integer getAllowanceCount() {
        return this.allowanceCount;
    }

    public Integer getAllowanceTotal() {
        return this.allowanceTotal;
    }

    public Integer getRefundCount() {
        return this.refundCount;
    }

    public Integer getRefundTotal() {
        return this.refundTotal;
    }

    public Integer getAllowanceRefundCount() {
        return this.allowanceRefundCount;
    }

    public Integer getAllowanceRefundTotal() {
        return this.allowanceRefundTotal;
    }

    public Integer getActualTopUpTotal() {
        return this.actualTopUpTotal;
    }

    public String getOpTimeBegin() {
        return this.opTimeBegin;
    }

    public String getOpTimeEnd() {
        return this.opTimeEnd;
    }

    public String getInDeptId() {
        return this.inDeptId;
    }

    public String getLikePersonPin() {
        return this.likePersonPin;
    }

    public String getLikeName() {
        return this.likeName;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getDeptId() {
        return this.deptId;
    }

    public String getIsIncludeLower() {
        return this.isIncludeLower;
    }

    public PosIDPersonTopUpItem setId(String id) {
        this.id = id;
        return this;
    }

    public PosIDPersonTopUpItem setPersonId(String personId) {
        this.personId = personId;
        return this;
    }

    public PosIDPersonTopUpItem setPersonPin(String personPin) {
        this.personPin = personPin;
        return this;
    }

    public PosIDPersonTopUpItem setPersonName(String personName) {
        this.personName = personName;
        return this;
    }

    public PosIDPersonTopUpItem setPersonLastName(String personLastName) {
        this.personLastName = personLastName;
        return this;
    }

    public PosIDPersonTopUpItem setSysTopUpCount(Integer sysTopUpCount) {
        this.sysTopUpCount = sysTopUpCount;
        return this;
    }

    public PosIDPersonTopUpItem setSysTopUpTotal(Integer sysTopUpTotal) {
        this.sysTopUpTotal = sysTopUpTotal;
        return this;
    }

    public PosIDPersonTopUpItem setMiniTopUpCount(Integer miniTopUpCount) {
        this.miniTopUpCount = miniTopUpCount;
        return this;
    }

    public PosIDPersonTopUpItem setMiniTopUpTotal(Integer miniTopUpTotal) {
        this.miniTopUpTotal = miniTopUpTotal;
        return this;
    }

    public PosIDPersonTopUpItem setBarTopUpCount(Integer barTopUpCount) {
        this.barTopUpCount = barTopUpCount;
        return this;
    }

    public PosIDPersonTopUpItem setBarTopUpTotal(Integer barTopUpTotal) {
        this.barTopUpTotal = barTopUpTotal;
        return this;
    }

    public PosIDPersonTopUpItem setTopUpCount(Integer topUpCount) {
        this.topUpCount = topUpCount;
        return this;
    }

    public PosIDPersonTopUpItem setTopUpTotal(Integer topUpTotal) {
        this.topUpTotal = topUpTotal;
        return this;
    }

    public PosIDPersonTopUpItem setAllowanceCount(Integer allowanceCount) {
        this.allowanceCount = allowanceCount;
        return this;
    }

    public PosIDPersonTopUpItem setAllowanceTotal(Integer allowanceTotal) {
        this.allowanceTotal = allowanceTotal;
        return this;
    }

    public PosIDPersonTopUpItem setRefundCount(Integer refundCount) {
        this.refundCount = refundCount;
        return this;
    }

    public PosIDPersonTopUpItem setRefundTotal(Integer refundTotal) {
        this.refundTotal = refundTotal;
        return this;
    }

    public PosIDPersonTopUpItem setAllowanceRefundCount(Integer allowanceRefundCount) {
        this.allowanceRefundCount = allowanceRefundCount;
        return this;
    }

    public PosIDPersonTopUpItem setAllowanceRefundTotal(Integer allowanceRefundTotal) {
        this.allowanceRefundTotal = allowanceRefundTotal;
        return this;
    }

    public PosIDPersonTopUpItem setActualTopUpTotal(Integer actualTopUpTotal) {
        this.actualTopUpTotal = actualTopUpTotal;
        return this;
    }

    public PosIDPersonTopUpItem setOpTimeBegin(String opTimeBegin) {
        this.opTimeBegin = opTimeBegin;
        return this;
    }

    public PosIDPersonTopUpItem setOpTimeEnd(String opTimeEnd) {
        this.opTimeEnd = opTimeEnd;
        return this;
    }

    public PosIDPersonTopUpItem setInDeptId(String inDeptId) {
        this.inDeptId = inDeptId;
        return this;
    }

    public PosIDPersonTopUpItem setLikePersonPin(String likePersonPin) {
        this.likePersonPin = likePersonPin;
        return this;
    }

    public PosIDPersonTopUpItem setLikeName(String likeName) {
        this.likeName = likeName;
        return this;
    }

    public PosIDPersonTopUpItem setUserId(String userId) {
        this.userId = userId;
        return this;
    }

    public PosIDPersonTopUpItem setDeptId(String deptId) {
        this.deptId = deptId;
        return this;
    }

    public PosIDPersonTopUpItem setIsIncludeLower(String isIncludeLower) {
        this.isIncludeLower = isIncludeLower;
        return this;
    }

    public String toString() {
        return "PosIDPersonTopUpItem(id=" + this.getId() + ", personId=" + this.getPersonId() + ", personPin=" + this.getPersonPin() + ", personName=" + this.getPersonName() + ", personLastName=" + this.getPersonLastName() + ", sysTopUpCount=" + this.getSysTopUpCount() + ", sysTopUpTotal=" + this.getSysTopUpTotal() + ", miniTopUpCount=" + this.getMiniTopUpCount() + ", miniTopUpTotal=" + this.getMiniTopUpTotal() + ", barTopUpCount=" + this.getBarTopUpCount() + ", barTopUpTotal=" + this.getBarTopUpTotal() + ", topUpCount=" + this.getTopUpCount() + ", topUpTotal=" + this.getTopUpTotal() + ", allowanceCount=" + this.getAllowanceCount() + ", allowanceTotal=" + this.getAllowanceTotal() + ", refundCount=" + this.getRefundCount() + ", refundTotal=" + this.getRefundTotal() + ", allowanceRefundCount=" + this.getAllowanceRefundCount() + ", allowanceRefundTotal=" + this.getAllowanceRefundTotal() + ", actualTopUpTotal=" + this.getActualTopUpTotal() + ", opTimeBegin=" + this.getOpTimeBegin() + ", opTimeEnd=" + this.getOpTimeEnd() + ", inDeptId=" + this.getInDeptId() + ", likePersonPin=" + this.getLikePersonPin() + ", likeName=" + this.getLikeName() + ", userId=" + this.getUserId() + ", deptId=" + this.getDeptId() + ", isIncludeLower=" + this.getIsIncludeLower() + ")";
    }
}

