/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.posid.vo;

import com.zkteco.zkbiosecurity.base.annotation.Column;
import com.zkteco.zkbiosecurity.base.annotation.Condition;
import com.zkteco.zkbiosecurity.base.annotation.From;
import com.zkteco.zkbiosecurity.base.annotation.GridColumn;
import com.zkteco.zkbiosecurity.base.annotation.GridConfig;
import com.zkteco.zkbiosecurity.base.annotation.GroupBy;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import java.util.Date;
import java.util.UUID;

@From(after="POSID_OFFLINE_CONSUME t LEFT JOIN POSID_ACCOUNT a ON t.PIN = a.PERSON_PIN")
@GroupBy(after="t.PIN")
@GridConfig(operate=true, idField="id", winHeight=350, winWidth=600)
public class PosIDPersonOfflineConsumeItem
extends BaseItem {
    @GridColumn(checkbox=true, width="40", sort="na", show=false)
    private String id = UUID.randomUUID().toString();
    @Column(name="t.PIN")
    @GridColumn(label="pers_person_pin", width="100", encryptMode="${pers.pin.encryptMode}", encryptProp="${pers.pin.encryptProp}")
    private String pin;
    @GridColumn(label="pers_person_name", width="100", sort="na", encryptMode="${pers.name.encryptMode}", encryptProp="${pers.name.encryptProp}")
    private String personName;
    @GridColumn(label="pers_person_lastName", width="80", showExpression="#language!='zh_CN'", sort="na", encryptMode="${pers.lastName.encryptMode}", encryptProp="${pers.lastName.encryptProp}")
    private String personLastName;
    @GridColumn(label="posid_card_deptName", width="110", sort="na")
    private String deptName;
    @GridColumn(label="posid_card_blance", width="120", columnType="custom", convert="convertFen2Yuan")
    private Integer balance;
    @GridColumn(label="posid_card_sendCardDate", width="240")
    private Date issueDate;
    @GridColumn(label="posid_offline_pending_review", width="120")
    private Long pendingReview;
    @Condition(value="a.DEPT_ID", equalTag="in")
    private String inDeptId;
    private String deptId;
    private String isIncludeLower;

    public String getId() {
        return this.id;
    }

    public String getPin() {
        return this.pin;
    }

    public String getPersonName() {
        return this.personName;
    }

    public String getPersonLastName() {
        return this.personLastName;
    }

    public String getDeptName() {
        return this.deptName;
    }

    public Integer getBalance() {
        return this.balance;
    }

    public Date getIssueDate() {
        return this.issueDate;
    }

    public Long getPendingReview() {
        return this.pendingReview;
    }

    public String getInDeptId() {
        return this.inDeptId;
    }

    public String getDeptId() {
        return this.deptId;
    }

    public String getIsIncludeLower() {
        return this.isIncludeLower;
    }

    public PosIDPersonOfflineConsumeItem setId(String id) {
        this.id = id;
        return this;
    }

    public PosIDPersonOfflineConsumeItem setPin(String pin) {
        this.pin = pin;
        return this;
    }

    public PosIDPersonOfflineConsumeItem setPersonName(String personName) {
        this.personName = personName;
        return this;
    }

    public PosIDPersonOfflineConsumeItem setPersonLastName(String personLastName) {
        this.personLastName = personLastName;
        return this;
    }

    public PosIDPersonOfflineConsumeItem setDeptName(String deptName) {
        this.deptName = deptName;
        return this;
    }

    public PosIDPersonOfflineConsumeItem setBalance(Integer balance) {
        this.balance = balance;
        return this;
    }

    public PosIDPersonOfflineConsumeItem setIssueDate(Date issueDate) {
        this.issueDate = issueDate;
        return this;
    }

    public PosIDPersonOfflineConsumeItem setPendingReview(Long pendingReview) {
        this.pendingReview = pendingReview;
        return this;
    }

    public PosIDPersonOfflineConsumeItem setInDeptId(String inDeptId) {
        this.inDeptId = inDeptId;
        return this;
    }

    public PosIDPersonOfflineConsumeItem setDeptId(String deptId) {
        this.deptId = deptId;
        return this;
    }

    public PosIDPersonOfflineConsumeItem setIsIncludeLower(String isIncludeLower) {
        this.isIncludeLower = isIncludeLower;
        return this;
    }

    public String toString() {
        return "PosIDPersonOfflineConsumeItem(id=" + this.getId() + ", pin=" + this.getPin() + ", personName=" + this.getPersonName() + ", personLastName=" + this.getPersonLastName() + ", deptName=" + this.getDeptName() + ", balance=" + this.getBalance() + ", issueDate=" + this.getIssueDate() + ", pendingReview=" + this.getPendingReview() + ", inDeptId=" + this.getInDeptId() + ", deptId=" + this.getDeptId() + ", isIncludeLower=" + this.getIsIncludeLower() + ")";
    }
}

