/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.posid.vo;

import com.zkteco.zkbiosecurity.base.annotation.Column;
import com.zkteco.zkbiosecurity.base.annotation.Condition;
import com.zkteco.zkbiosecurity.base.annotation.From;
import com.zkteco.zkbiosecurity.base.annotation.GridColumn;
import com.zkteco.zkbiosecurity.base.annotation.GridConfig;
import com.zkteco.zkbiosecurity.base.annotation.GroupBy;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import java.util.Map;
import java.util.UUID;

@From(after="POSID_TRANSACTION t")
@GroupBy(after="t.PERSON_ID")
@GridConfig(operate=true, idField="id", winHeight=400, winWidth=600)
public class PosIDPersonConsumeItem
extends BaseItem {
    @GridColumn(show=false)
    private String id;
    @Column(name="t.PERSON_ID")
    private String personId;
    @GridColumn(label="pers_person_pin", width="100", i18n=true, encryptMode="${pers.pin.encryptMode}", encryptProp="${pers.pin.encryptProp}")
    private String personPin;
    @GridColumn(label="pers_person_name", width="80", i18n=true, encryptMode="${pers.name.encryptMode}", encryptProp="${pers.name.encryptProp}")
    private String personName;
    @GridColumn(label="pers_person_lastName", width="80", showExpression="#language!='zh_CN'", encryptMode="${pers.lastName.encryptMode}", encryptProp="${pers.lastName.encryptProp}")
    private String personLastName;
    @GridColumn(dynamicColumn="mealDetailDyna")
    private Map<String, Object> mealDetailMap;
    @Column(name="sum(case when t.type_name = 6  then 1 else 0 end)")
    @GridColumn(label="posid_countTable_conTimes", width="120", show=false)
    private Integer conTimes;
    @Column(name="SUM(CASE WHEN t.TYPE_NAME != 9 AND t.TYPE_NAME != 13 THEN t.MONEY_WALLET_MONEY ELSE 0 END)")
    @GridColumn(label="posid_cus_money_wallet", width="130", columnType="custom", convert="convertFen2Yuan")
    private Integer moneyWalletMoney;
    @Column(name="SUM(CASE WHEN t.TYPE_NAME != 9 AND t.TYPE_NAME != 13 THEN t.ALLOWANCE_WALLET_MONEY ELSE 0 END)")
    @GridColumn(label="posid_cus_allowance_wallet", width="130", columnType="custom", convert="convertFen2Yuan")
    private Integer allowanceWalletMoney;
    @Column(name="sum(case when t.type_name = 8  then 1 else 0 end)")
    @GridColumn(label="posid_countTable_suppleTimes", width="100")
    private Integer suppletimes;
    @Column(name="sum(case when t.type_name = 8  then t.money else 0 end)")
    @GridColumn(label="posid_countTable_suppleTotal", width="160", columnType="custom", convert="convertFen2Yuan")
    private Integer suppletotal;
    @Column(name="sum(case when t.type_name = 9  then 1 else 0 end)")
    @GridColumn(label="posid_countTable_errorTimes", width="100")
    private Integer errortimes;
    @Column(name="sum(case when t.type_name = 9  then t.money else 0 end)")
    @GridColumn(label="posid_countTable_errorTotal", width="80", columnType="custom", convert="convertFen2Yuan")
    private Integer errortotal;
    @Column(name="sum(case when t.type_name = 6  then t.discount_money  else 0 end)")
    @GridColumn(label="posid_consume_discount_money_sum", width="115", columnType="custom", convert="convertFen2Yuan")
    private Integer discountMoney;
    @Column(name="sum(case when t.type_name = 6 then 1 else 0 end)")
    @GridColumn(label="posid_countTable_actualTimes", width="110")
    private Integer actualtimes;
    @Column(name="sum(case when t.type_name = 6  then t.money else 0 end)")
    @GridColumn(label="posid_countTable_equipTotal", width="110", columnType="custom", convert="convertFen2Yuan")
    private Integer equipTotal;
    @Column(name="cast((sum(case when t.type_name = 6  then t.money else 0 end)+sum(case when t.type_name = 8  then t.money else 0 end)) as decimal(18,2))")
    @GridColumn(label="posid_countTable_sysTotal", width="130", columnType="custom", convert="convertFen2Yuan")
    private Integer sysTotal;
    @Column(name="cast((sum(case when t.type_name = 6  then t.money else 0 end)+sum(case when t.type_name = 11  then t.money else 0 end)) as decimal(18,2))")
    @GridColumn(label="posid_countTable_containAccTotal", width="150", minWidth="150", columnType="custom", convert="convertFen2Yuan")
    private Integer containAccTotal;
    @Column(name="sum(case when t.type_name = 6  then t.money else 0 end)")
    @GridColumn(label="posid_countTable_consumTotal", width="115", columnType="custom", convert="convertFen2Yuan", show=false)
    private Integer consumtotal;
    @Column(name="sum(case when t.type_name = 10 then 1 else 0 end)")
    @GridColumn(label="posid_countTable_orderTimes", width="70", show=false)
    private Integer ordertimes;
    @Column(name="sum(case when t.type_name = 11  then 1 else 0 end)")
    @GridColumn(label="posid_countTable_accountTimes", width="70", show=false)
    private Integer accounttimes;
    @Column(name="sum(case when t.type_name = 11  then t.money else 0 end)")
    @GridColumn(label="posid_countTable_accountTotal", width="80", columnType="custom", convert="convertFen2Yuan", show=false)
    private Integer accountTotal;
    @GridColumn(label="posid_countTable_conTimeStr", minWidth="160", width="170", sort="na")
    private String posTime;
    @Condition(value="t.POS_TIME", equalTag=">=", toDate=true)
    private String opTimeBegin;
    @Condition(value="t.POS_TIME", equalTag="<=", toDate=true)
    private String opTimeEnd;
    @Condition(value="t.DEPT_ID", equalTag="in")
    private String inDeptId;
    @Condition(value="(t.PERSON_NAME LIKE ''%{0}%'' OR t.PERSON_LAST_NAME LIKE ''%{0}%'')")
    private String likeName;
    @Condition(value="t.DEV_SN", equalTag="=")
    private String devSn;
    @Condition(value="t.DEPT_ID IN (SELECT ud.AUTH_DEPT_ID FROM AUTH_USER_DEPT ud WHERE ud.AUTH_USER_ID=''{0}'')")
    private String userId;
    @Condition(value="t.HALLING_ID IN (SELECT pd.ID FROM POSID_DININGHALL pd WHERE pd.AUTH_AREA_ID IN (SELECT ud.AUTH_AREA_ID FROM AUTH_USER_AREA ud WHERE ud.AUTH_USER_ID=''{0}''))")
    private String diningAreaByUserId;
    @Condition(value="t.PERSON_PIN", equalTag="=")
    private String eqlPersonPin;
    private String deptId;
    private String isIncludeLower;

    public PosIDPersonConsumeItem() {
        this.id = UUID.randomUUID().toString();
    }

    public PosIDPersonConsumeItem(Boolean equals) {
        super(equals);
    }

    public PosIDPersonConsumeItem(String id) {
        super(Boolean.valueOf(true));
        this.id = id;
    }

    public PosIDPersonConsumeItem(Boolean equals, String id, String personPin, String personName, String personLastName, Integer conTimes, Integer suppletotal, Integer consumtotal, Integer errortimes, Integer suppletimes, Integer errortotal, Integer ordertimes, Integer accounttimes, Integer accountTotal, Integer actualtimes, Integer equipTotal, Integer sysTotal, Integer containAccTotal) {
        this.id = id;
        this.personPin = personPin;
        this.personName = personName;
        this.personLastName = personLastName;
        this.conTimes = conTimes;
        this.suppletotal = suppletotal;
        this.consumtotal = consumtotal;
        this.errortimes = errortimes;
        this.suppletimes = suppletimes;
        this.errortotal = errortotal;
        this.ordertimes = ordertimes;
        this.accounttimes = accounttimes;
        this.accountTotal = accountTotal;
        this.actualtimes = actualtimes;
        this.equipTotal = equipTotal;
        this.sysTotal = sysTotal;
        this.containAccTotal = containAccTotal;
    }

    public String getId() {
        return this.id;
    }

    public String getPersonId() {
        return this.personId;
    }

    public String getPersonPin() {
        return this.personPin;
    }

    public String getPersonName() {
        return this.personName;
    }

    public String getPersonLastName() {
        return this.personLastName;
    }

    public Map<String, Object> getMealDetailMap() {
        return this.mealDetailMap;
    }

    public Integer getConTimes() {
        return this.conTimes;
    }

    public Integer getMoneyWalletMoney() {
        return this.moneyWalletMoney;
    }

    public Integer getAllowanceWalletMoney() {
        return this.allowanceWalletMoney;
    }

    public Integer getSuppletimes() {
        return this.suppletimes;
    }

    public Integer getSuppletotal() {
        return this.suppletotal;
    }

    public Integer getErrortimes() {
        return this.errortimes;
    }

    public Integer getErrortotal() {
        return this.errortotal;
    }

    public Integer getDiscountMoney() {
        return this.discountMoney;
    }

    public Integer getActualtimes() {
        return this.actualtimes;
    }

    public Integer getEquipTotal() {
        return this.equipTotal;
    }

    public Integer getSysTotal() {
        return this.sysTotal;
    }

    public Integer getContainAccTotal() {
        return this.containAccTotal;
    }

    public Integer getConsumtotal() {
        return this.consumtotal;
    }

    public Integer getOrdertimes() {
        return this.ordertimes;
    }

    public Integer getAccounttimes() {
        return this.accounttimes;
    }

    public Integer getAccountTotal() {
        return this.accountTotal;
    }

    public String getPosTime() {
        return this.posTime;
    }

    public String getOpTimeBegin() {
        return this.opTimeBegin;
    }

    public String getOpTimeEnd() {
        return this.opTimeEnd;
    }

    public String getInDeptId() {
        return this.inDeptId;
    }

    public String getLikeName() {
        return this.likeName;
    }

    public String getDevSn() {
        return this.devSn;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getDiningAreaByUserId() {
        return this.diningAreaByUserId;
    }

    public String getEqlPersonPin() {
        return this.eqlPersonPin;
    }

    public String getDeptId() {
        return this.deptId;
    }

    public String getIsIncludeLower() {
        return this.isIncludeLower;
    }

    public PosIDPersonConsumeItem setId(String id) {
        this.id = id;
        return this;
    }

    public PosIDPersonConsumeItem setPersonId(String personId) {
        this.personId = personId;
        return this;
    }

    public PosIDPersonConsumeItem setPersonPin(String personPin) {
        this.personPin = personPin;
        return this;
    }

    public PosIDPersonConsumeItem setPersonName(String personName) {
        this.personName = personName;
        return this;
    }

    public PosIDPersonConsumeItem setPersonLastName(String personLastName) {
        this.personLastName = personLastName;
        return this;
    }

    public PosIDPersonConsumeItem setMealDetailMap(Map<String, Object> mealDetailMap) {
        this.mealDetailMap = mealDetailMap;
        return this;
    }

    public PosIDPersonConsumeItem setConTimes(Integer conTimes) {
        this.conTimes = conTimes;
        return this;
    }

    public PosIDPersonConsumeItem setMoneyWalletMoney(Integer moneyWalletMoney) {
        this.moneyWalletMoney = moneyWalletMoney;
        return this;
    }

    public PosIDPersonConsumeItem setAllowanceWalletMoney(Integer allowanceWalletMoney) {
        this.allowanceWalletMoney = allowanceWalletMoney;
        return this;
    }

    public PosIDPersonConsumeItem setSuppletimes(Integer suppletimes) {
        this.suppletimes = suppletimes;
        return this;
    }

    public PosIDPersonConsumeItem setSuppletotal(Integer suppletotal) {
        this.suppletotal = suppletotal;
        return this;
    }

    public PosIDPersonConsumeItem setErrortimes(Integer errortimes) {
        this.errortimes = errortimes;
        return this;
    }

    public PosIDPersonConsumeItem setErrortotal(Integer errortotal) {
        this.errortotal = errortotal;
        return this;
    }

    public PosIDPersonConsumeItem setDiscountMoney(Integer discountMoney) {
        this.discountMoney = discountMoney;
        return this;
    }

    public PosIDPersonConsumeItem setActualtimes(Integer actualtimes) {
        this.actualtimes = actualtimes;
        return this;
    }

    public PosIDPersonConsumeItem setEquipTotal(Integer equipTotal) {
        this.equipTotal = equipTotal;
        return this;
    }

    public PosIDPersonConsumeItem setSysTotal(Integer sysTotal) {
        this.sysTotal = sysTotal;
        return this;
    }

    public PosIDPersonConsumeItem setContainAccTotal(Integer containAccTotal) {
        this.containAccTotal = containAccTotal;
        return this;
    }

    public PosIDPersonConsumeItem setConsumtotal(Integer consumtotal) {
        this.consumtotal = consumtotal;
        return this;
    }

    public PosIDPersonConsumeItem setOrdertimes(Integer ordertimes) {
        this.ordertimes = ordertimes;
        return this;
    }

    public PosIDPersonConsumeItem setAccounttimes(Integer accounttimes) {
        this.accounttimes = accounttimes;
        return this;
    }

    public PosIDPersonConsumeItem setAccountTotal(Integer accountTotal) {
        this.accountTotal = accountTotal;
        return this;
    }

    public PosIDPersonConsumeItem setPosTime(String posTime) {
        this.posTime = posTime;
        return this;
    }

    public PosIDPersonConsumeItem setOpTimeBegin(String opTimeBegin) {
        this.opTimeBegin = opTimeBegin;
        return this;
    }

    public PosIDPersonConsumeItem setOpTimeEnd(String opTimeEnd) {
        this.opTimeEnd = opTimeEnd;
        return this;
    }

    public PosIDPersonConsumeItem setInDeptId(String inDeptId) {
        this.inDeptId = inDeptId;
        return this;
    }

    public PosIDPersonConsumeItem setLikeName(String likeName) {
        this.likeName = likeName;
        return this;
    }

    public PosIDPersonConsumeItem setDevSn(String devSn) {
        this.devSn = devSn;
        return this;
    }

    public PosIDPersonConsumeItem setUserId(String userId) {
        this.userId = userId;
        return this;
    }

    public PosIDPersonConsumeItem setDiningAreaByUserId(String diningAreaByUserId) {
        this.diningAreaByUserId = diningAreaByUserId;
        return this;
    }

    public PosIDPersonConsumeItem setEqlPersonPin(String eqlPersonPin) {
        this.eqlPersonPin = eqlPersonPin;
        return this;
    }

    public PosIDPersonConsumeItem setDeptId(String deptId) {
        this.deptId = deptId;
        return this;
    }

    public PosIDPersonConsumeItem setIsIncludeLower(String isIncludeLower) {
        this.isIncludeLower = isIncludeLower;
        return this;
    }

    public String toString() {
        return "PosIDPersonConsumeItem(id=" + this.getId() + ", personId=" + this.getPersonId() + ", personPin=" + this.getPersonPin() + ", personName=" + this.getPersonName() + ", personLastName=" + this.getPersonLastName() + ", mealDetailMap=" + this.getMealDetailMap() + ", conTimes=" + this.getConTimes() + ", moneyWalletMoney=" + this.getMoneyWalletMoney() + ", allowanceWalletMoney=" + this.getAllowanceWalletMoney() + ", suppletimes=" + this.getSuppletimes() + ", suppletotal=" + this.getSuppletotal() + ", errortimes=" + this.getErrortimes() + ", errortotal=" + this.getErrortotal() + ", discountMoney=" + this.getDiscountMoney() + ", actualtimes=" + this.getActualtimes() + ", equipTotal=" + this.getEquipTotal() + ", sysTotal=" + this.getSysTotal() + ", containAccTotal=" + this.getContainAccTotal() + ", consumtotal=" + this.getConsumtotal() + ", ordertimes=" + this.getOrdertimes() + ", accounttimes=" + this.getAccounttimes() + ", accountTotal=" + this.getAccountTotal() + ", posTime=" + this.getPosTime() + ", opTimeBegin=" + this.getOpTimeBegin() + ", opTimeEnd=" + this.getOpTimeEnd() + ", inDeptId=" + this.getInDeptId() + ", likeName=" + this.getLikeName() + ", devSn=" + this.getDevSn() + ", userId=" + this.getUserId() + ", diningAreaByUserId=" + this.getDiningAreaByUserId() + ", eqlPersonPin=" + this.getEqlPersonPin() + ", deptId=" + this.getDeptId() + ", isIncludeLower=" + this.getIsIncludeLower() + ")";
    }
}

