/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.posid.vo;

import com.zkteco.zkbiosecurity.base.annotation.Column;
import com.zkteco.zkbiosecurity.base.annotation.Condition;
import com.zkteco.zkbiosecurity.base.annotation.From;
import com.zkteco.zkbiosecurity.base.annotation.GridColumn;
import com.zkteco.zkbiosecurity.base.annotation.GridConfig;
import com.zkteco.zkbiosecurity.base.annotation.GroupBy;
import com.zkteco.zkbiosecurity.base.annotation.Where;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import java.util.Map;
import java.util.UUID;

@From(after="POSID_TRANSACTION t")
@Where(after="AND t.TYPE_NAME != 9 AND t.TYPE_NAME != 13")
@GroupBy(after="t.PERSON_ID")
@GridConfig(operate=true, idField="id", winHeight=400, winWidth=600)
public class PosIDPersMealSummaryItem
extends BaseItem {
    @GridColumn(show=false)
    private String id = UUID.randomUUID().toString();
    @Column(name="t.PERSON_ID")
    private String personId;
    @GridColumn(label="pers_person_pin", width="100", i18n=true, sort="na", encryptMode="${pers.pin.encryptMode}", encryptProp="${pers.pin.encryptProp}")
    private String personPin;
    @GridColumn(label="pers_person_name", width="100", sort="na", encryptMode="${pers.name.encryptMode}", encryptProp="${pers.name.encryptProp}")
    private String personName;
    @GridColumn(label="pers_person_lastName", width="80", showExpression="#language!='zh_CN'", sort="na", encryptMode="${pers.lastName.encryptMode}", encryptProp="${pers.lastName.encryptProp}")
    private String personLastName;
    @GridColumn(label="posid_card_deptName", width="110", sort="na")
    private String deptName;
    @GridColumn(dynamicColumn="mealDetailDyna")
    private Map<String, Object> mealDetailMap;
    @Column(name="COUNT(t.ID)")
    @GridColumn(label="posid_countTable_total_times", width="120")
    private Integer totalTimes;
    @Column(name="SUM(t.MONEY)")
    @GridColumn(label="posid_countTable_total_amount", minWidth="120", columnType="custom", convert="convertFen2Yuan")
    private Integer totalAmount;
    @Condition(value="t.POS_TIME", equalTag=">=", toDate=true)
    private String startDatetimeBegin;
    @Condition(value="t.POS_TIME", equalTag="<=", toDate=true)
    private String startDatetimeEnd;
    @Condition(value="(t.PERSON_NAME LIKE ''%{0}%'' OR t.PERSON_LAST_NAME LIKE ''%{0}%'')")
    private String likeName;
    @Condition(value="t.DEPT_NAME", equalTag="like")
    private String liekDeptName;
    @Condition(value="t.PERSON_PIN", equalTag="like")
    private String likePersonPin;
    @Condition(value="t.DEPT_ID", equalTag="in")
    private String inDeptId;
    @Condition(value="t.DEPT_ID IN (SELECT ud.AUTH_DEPT_ID FROM AUTH_USER_DEPT ud WHERE ud.AUTH_USER_ID=''{0}'')")
    private String userId;
    @Condition(value="t.HALLING_ID IN (SELECT pd.ID FROM POSID_DININGHALL pd WHERE pd.AUTH_AREA_ID IN (SELECT ud.AUTH_AREA_ID FROM AUTH_USER_AREA ud WHERE ud.AUTH_USER_ID=''{0}''))")
    private String diningAreaByUserId;
    private String deptId;
    private String isIncludeLower;

    public String getId() {
        return this.id;
    }

    public String getPersonId() {
        return this.personId;
    }

    public String getPersonPin() {
        return this.personPin;
    }

    public String getPersonName() {
        return this.personName;
    }

    public String getPersonLastName() {
        return this.personLastName;
    }

    public String getDeptName() {
        return this.deptName;
    }

    public Map<String, Object> getMealDetailMap() {
        return this.mealDetailMap;
    }

    public Integer getTotalTimes() {
        return this.totalTimes;
    }

    public Integer getTotalAmount() {
        return this.totalAmount;
    }

    public String getStartDatetimeBegin() {
        return this.startDatetimeBegin;
    }

    public String getStartDatetimeEnd() {
        return this.startDatetimeEnd;
    }

    public String getLikeName() {
        return this.likeName;
    }

    public String getLiekDeptName() {
        return this.liekDeptName;
    }

    public String getLikePersonPin() {
        return this.likePersonPin;
    }

    public String getInDeptId() {
        return this.inDeptId;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getDiningAreaByUserId() {
        return this.diningAreaByUserId;
    }

    public String getDeptId() {
        return this.deptId;
    }

    public String getIsIncludeLower() {
        return this.isIncludeLower;
    }

    public PosIDPersMealSummaryItem setId(String id) {
        this.id = id;
        return this;
    }

    public PosIDPersMealSummaryItem setPersonId(String personId) {
        this.personId = personId;
        return this;
    }

    public PosIDPersMealSummaryItem setPersonPin(String personPin) {
        this.personPin = personPin;
        return this;
    }

    public PosIDPersMealSummaryItem setPersonName(String personName) {
        this.personName = personName;
        return this;
    }

    public PosIDPersMealSummaryItem setPersonLastName(String personLastName) {
        this.personLastName = personLastName;
        return this;
    }

    public PosIDPersMealSummaryItem setDeptName(String deptName) {
        this.deptName = deptName;
        return this;
    }

    public PosIDPersMealSummaryItem setMealDetailMap(Map<String, Object> mealDetailMap) {
        this.mealDetailMap = mealDetailMap;
        return this;
    }

    public PosIDPersMealSummaryItem setTotalTimes(Integer totalTimes) {
        this.totalTimes = totalTimes;
        return this;
    }

    public PosIDPersMealSummaryItem setTotalAmount(Integer totalAmount) {
        this.totalAmount = totalAmount;
        return this;
    }

    public PosIDPersMealSummaryItem setStartDatetimeBegin(String startDatetimeBegin) {
        this.startDatetimeBegin = startDatetimeBegin;
        return this;
    }

    public PosIDPersMealSummaryItem setStartDatetimeEnd(String startDatetimeEnd) {
        this.startDatetimeEnd = startDatetimeEnd;
        return this;
    }

    public PosIDPersMealSummaryItem setLikeName(String likeName) {
        this.likeName = likeName;
        return this;
    }

    public PosIDPersMealSummaryItem setLiekDeptName(String liekDeptName) {
        this.liekDeptName = liekDeptName;
        return this;
    }

    public PosIDPersMealSummaryItem setLikePersonPin(String likePersonPin) {
        this.likePersonPin = likePersonPin;
        return this;
    }

    public PosIDPersMealSummaryItem setInDeptId(String inDeptId) {
        this.inDeptId = inDeptId;
        return this;
    }

    public PosIDPersMealSummaryItem setUserId(String userId) {
        this.userId = userId;
        return this;
    }

    public PosIDPersMealSummaryItem setDiningAreaByUserId(String diningAreaByUserId) {
        this.diningAreaByUserId = diningAreaByUserId;
        return this;
    }

    public PosIDPersMealSummaryItem setDeptId(String deptId) {
        this.deptId = deptId;
        return this;
    }

    public PosIDPersMealSummaryItem setIsIncludeLower(String isIncludeLower) {
        this.isIncludeLower = isIncludeLower;
        return this;
    }

    public String toString() {
        return "PosIDPersMealSummaryItem(id=" + this.getId() + ", personId=" + this.getPersonId() + ", personPin=" + this.getPersonPin() + ", personName=" + this.getPersonName() + ", personLastName=" + this.getPersonLastName() + ", deptName=" + this.getDeptName() + ", mealDetailMap=" + this.getMealDetailMap() + ", totalTimes=" + this.getTotalTimes() + ", totalAmount=" + this.getTotalAmount() + ", startDatetimeBegin=" + this.getStartDatetimeBegin() + ", startDatetimeEnd=" + this.getStartDatetimeEnd() + ", likeName=" + this.getLikeName() + ", liekDeptName=" + this.getLiekDeptName() + ", likePersonPin=" + this.getLikePersonPin() + ", inDeptId=" + this.getInDeptId() + ", userId=" + this.getUserId() + ", diningAreaByUserId=" + this.getDiningAreaByUserId() + ", deptId=" + this.getDeptId() + ", isIncludeLower=" + this.getIsIncludeLower() + ")";
    }
}

