/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.posid.vo;

import com.zkteco.zkbiosecurity.base.annotation.Column;
import com.zkteco.zkbiosecurity.base.annotation.Condition;
import com.zkteco.zkbiosecurity.base.annotation.From;
import com.zkteco.zkbiosecurity.base.annotation.GridColumn;
import com.zkteco.zkbiosecurity.base.annotation.GridConfig;
import com.zkteco.zkbiosecurity.base.annotation.OrderBy;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.posid.vo.PosIDTransactionDetailItem;
import java.util.Date;
import java.util.List;

@From(after="POSID_OUTERTRANSACTION t")
@OrderBy(after="t.POS_TIME DESC")
@GridConfig(operate=true, idField="id", winHeight=350, winWidth=600)
public class PosIDOuterTransactionItem
extends BaseItem {
    private static final long serialVersionUID = 1L;
    @Column(name="t.ID")
    @GridColumn(checkbox=true, width="40", sort="na")
    private String id;
    @Column(name="t.WXALIPAY")
    @GridColumn(label="posid_card_pay_type", width="100", format="1=posid_manual_log_flag_wechat,2=posid_manual_log_flag_alipay,3=posid_digital_yuan")
    private String wxAlipay;
    @Column(name="t.MONEY")
    @GridColumn(label="posid_cus_money", width="100", columnType="custom", convert="convertFen2Yuan")
    private Integer money;
    @Column(name="t.BARCODE")
    @GridColumn(label="posid_dev_payment_barcode", width="150")
    private String barcode;
    @Column(name="t.TYPE_NAME")
    @GridColumn(label="posid_card_typeName", width="80", format="6=posid_common_consumption,8=posid_cus_supply,9=posid_consumerList_correction,10=posid_consumerList_theTime,11=posid_consumerList_accounting")
    private Integer typeName;
    @Column(name="t.POS_MODEL", equalTag="=")
    @GridColumn(label="posid_consumerList_consumType", width="120", format="1=posid_dev_fixMode,2=posid_dev_amountMode,3=posid_dev_keyValueMode,4=posid_dev_timesMode,5=posid_dev_storeMode,6=posid_dev_timingMode,7=posid_dev_accountingMode,8=posid_leftMenu_handConsume,9=posid_device_error_correction,10=posid_dev_systemError,11=posid_dev_order,12=posid_dev_intelligence")
    private Integer posModel;
    @Column(name="t.HALLING_ID")
    @GridColumn(label="posid_transaction_hallingId", show=false)
    private String hallingId;
    @Column(name="t.HALLING_CODE")
    @GridColumn(label="posid_transaction_hallingCode", show=false)
    private String hallingCode;
    @Column(name="t.HALLING_NAME")
    @GridColumn(label="posid_diningHall_name", width="110")
    private String hallingName;
    @Column(name="t.MEAL_ID", equalTag="=")
    @GridColumn(label="posid_transaction_posMeal", show=false)
    private String mealId;
    @Column(name="t.MEAL_CODE")
    @GridColumn(label="posid_meal_code", show=false)
    private String mealCode;
    @Column(name="t.MEAL_NAME")
    @GridColumn(label="posid_meal_name", width="80")
    private String mealName;
    @Column(name="t.DEV_SN")
    @GridColumn(label="common_dev_sn", width="100")
    private String devSn;
    @Column(name="t.POS_TIME")
    @GridColumn(label="posid_cus_time", width="150")
    private Date posTime;
    @Column(name="t.POS_TRANS_NO")
    @GridColumn(label="posid_cus_transNo", width="150")
    private String posTransNo;
    @Column(name="t.POS_UUID")
    @GridColumn(label="posid_order_originalTradeNo", width="150")
    private String posUUID;
    @Column(name="t.CREATE_TIME")
    @GridColumn(label="posid_common_upload_time", width="150")
    private Date createTime;
    @Column(name="t.CREATER_CODE")
    @GridColumn(label="posid_card_changeOperator", width="70")
    private String createrName;
    @Column(name="t.LOG_FLAG")
    @GridColumn(label="posid_card_logFlag", format="1=posid_device_upload,2=posid_system_add,3=posid_error_correction_compensation,4=posid_manual_log_flag_wechat,5=posid_manual_log_flag_alipay,6=posid_manual_log_flag_offline_consume")
    private Integer logFlag;
    @Column(name="t.IS_EXCEPTION")
    @GridColumn(label="posid_transaction_isException", show=false)
    private Boolean isException;
    @Condition(value="t.POS_TIME", equalTag=">=", toDate=true)
    private String startDatetimeBegin;
    @Condition(value="t.POS_TIME", equalTag="<=", toDate=true)
    private String startDatetimeEnd;
    @Condition(value="t.HALLING_ID IN (SELECT pd.ID FROM POSID_DININGHALL pd WHERE pd.AUTH_AREA_ID IN (SELECT ud.AUTH_AREA_ID FROM AUTH_USER_AREA ud WHERE ud.AUTH_USER_ID=''{0}''))")
    private String diningAreaByUserId;
    @Column(name="t.DEV_ALIAS")
    @GridColumn(label="common_dev_sn", width="100", show=false)
    private String devAlias;
    private Integer hallingType;
    private List<PosIDTransactionDetailItem> posIDTransactionDetailItems;

    public PosIDOuterTransactionItem() {
    }

    public PosIDOuterTransactionItem(Boolean equals) {
        super(equals);
    }

    public PosIDOuterTransactionItem(String id) {
        super(Boolean.valueOf(true));
        this.id = id;
    }

    public PosIDOuterTransactionItem(String id, String hallingId, String hallingCode, String hallingName, String devSn, Date posTime, Date createTime, Integer money, Integer typeName, Integer posModel, String createrName, Integer logFlag, Boolean isException) {
        this.id = id;
        this.hallingId = hallingId;
        this.hallingCode = hallingCode;
        this.hallingName = hallingName;
        this.devSn = devSn;
        this.posTime = posTime;
        this.createTime = createTime;
        this.money = money;
        this.typeName = typeName;
        this.posModel = posModel;
        this.createrName = createrName;
        this.logFlag = logFlag;
        this.isException = isException;
    }

    public String getId() {
        return this.id;
    }

    public String getWxAlipay() {
        return this.wxAlipay;
    }

    public Integer getMoney() {
        return this.money;
    }

    public String getBarcode() {
        return this.barcode;
    }

    public Integer getTypeName() {
        return this.typeName;
    }

    public Integer getPosModel() {
        return this.posModel;
    }

    public String getHallingId() {
        return this.hallingId;
    }

    public String getHallingCode() {
        return this.hallingCode;
    }

    public String getHallingName() {
        return this.hallingName;
    }

    public String getMealId() {
        return this.mealId;
    }

    public String getMealCode() {
        return this.mealCode;
    }

    public String getMealName() {
        return this.mealName;
    }

    public String getDevSn() {
        return this.devSn;
    }

    public Date getPosTime() {
        return this.posTime;
    }

    public String getPosTransNo() {
        return this.posTransNo;
    }

    public String getPosUUID() {
        return this.posUUID;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public String getCreaterName() {
        return this.createrName;
    }

    public Integer getLogFlag() {
        return this.logFlag;
    }

    public Boolean getIsException() {
        return this.isException;
    }

    public String getStartDatetimeBegin() {
        return this.startDatetimeBegin;
    }

    public String getStartDatetimeEnd() {
        return this.startDatetimeEnd;
    }

    public String getDiningAreaByUserId() {
        return this.diningAreaByUserId;
    }

    public String getDevAlias() {
        return this.devAlias;
    }

    public Integer getHallingType() {
        return this.hallingType;
    }

    public List<PosIDTransactionDetailItem> getPosIDTransactionDetailItems() {
        return this.posIDTransactionDetailItems;
    }

    public PosIDOuterTransactionItem setId(String id) {
        this.id = id;
        return this;
    }

    public PosIDOuterTransactionItem setWxAlipay(String wxAlipay) {
        this.wxAlipay = wxAlipay;
        return this;
    }

    public PosIDOuterTransactionItem setMoney(Integer money) {
        this.money = money;
        return this;
    }

    public PosIDOuterTransactionItem setBarcode(String barcode) {
        this.barcode = barcode;
        return this;
    }

    public PosIDOuterTransactionItem setTypeName(Integer typeName) {
        this.typeName = typeName;
        return this;
    }

    public PosIDOuterTransactionItem setPosModel(Integer posModel) {
        this.posModel = posModel;
        return this;
    }

    public PosIDOuterTransactionItem setHallingId(String hallingId) {
        this.hallingId = hallingId;
        return this;
    }

    public PosIDOuterTransactionItem setHallingCode(String hallingCode) {
        this.hallingCode = hallingCode;
        return this;
    }

    public PosIDOuterTransactionItem setHallingName(String hallingName) {
        this.hallingName = hallingName;
        return this;
    }

    public PosIDOuterTransactionItem setMealId(String mealId) {
        this.mealId = mealId;
        return this;
    }

    public PosIDOuterTransactionItem setMealCode(String mealCode) {
        this.mealCode = mealCode;
        return this;
    }

    public PosIDOuterTransactionItem setMealName(String mealName) {
        this.mealName = mealName;
        return this;
    }

    public PosIDOuterTransactionItem setDevSn(String devSn) {
        this.devSn = devSn;
        return this;
    }

    public PosIDOuterTransactionItem setPosTime(Date posTime) {
        this.posTime = posTime;
        return this;
    }

    public PosIDOuterTransactionItem setPosTransNo(String posTransNo) {
        this.posTransNo = posTransNo;
        return this;
    }

    public PosIDOuterTransactionItem setPosUUID(String posUUID) {
        this.posUUID = posUUID;
        return this;
    }

    public PosIDOuterTransactionItem setCreateTime(Date createTime) {
        this.createTime = createTime;
        return this;
    }

    public PosIDOuterTransactionItem setCreaterName(String createrName) {
        this.createrName = createrName;
        return this;
    }

    public PosIDOuterTransactionItem setLogFlag(Integer logFlag) {
        this.logFlag = logFlag;
        return this;
    }

    public PosIDOuterTransactionItem setIsException(Boolean isException) {
        this.isException = isException;
        return this;
    }

    public PosIDOuterTransactionItem setStartDatetimeBegin(String startDatetimeBegin) {
        this.startDatetimeBegin = startDatetimeBegin;
        return this;
    }

    public PosIDOuterTransactionItem setStartDatetimeEnd(String startDatetimeEnd) {
        this.startDatetimeEnd = startDatetimeEnd;
        return this;
    }

    public PosIDOuterTransactionItem setDiningAreaByUserId(String diningAreaByUserId) {
        this.diningAreaByUserId = diningAreaByUserId;
        return this;
    }

    public PosIDOuterTransactionItem setDevAlias(String devAlias) {
        this.devAlias = devAlias;
        return this;
    }

    public PosIDOuterTransactionItem setHallingType(Integer hallingType) {
        this.hallingType = hallingType;
        return this;
    }

    public PosIDOuterTransactionItem setPosIDTransactionDetailItems(List<PosIDTransactionDetailItem> posIDTransactionDetailItems) {
        this.posIDTransactionDetailItems = posIDTransactionDetailItems;
        return this;
    }

    public String toString() {
        return "PosIDOuterTransactionItem(id=" + this.getId() + ", wxAlipay=" + this.getWxAlipay() + ", money=" + this.getMoney() + ", barcode=" + this.getBarcode() + ", typeName=" + this.getTypeName() + ", posModel=" + this.getPosModel() + ", hallingId=" + this.getHallingId() + ", hallingCode=" + this.getHallingCode() + ", hallingName=" + this.getHallingName() + ", mealId=" + this.getMealId() + ", mealCode=" + this.getMealCode() + ", mealName=" + this.getMealName() + ", devSn=" + this.getDevSn() + ", posTime=" + this.getPosTime() + ", posTransNo=" + this.getPosTransNo() + ", posUUID=" + this.getPosUUID() + ", createTime=" + this.getCreateTime() + ", createrName=" + this.getCreaterName() + ", logFlag=" + this.getLogFlag() + ", isException=" + this.getIsException() + ", startDatetimeBegin=" + this.getStartDatetimeBegin() + ", startDatetimeEnd=" + this.getStartDatetimeEnd() + ", diningAreaByUserId=" + this.getDiningAreaByUserId() + ", devAlias=" + this.getDevAlias() + ", hallingType=" + this.getHallingType() + ", posIDTransactionDetailItems=" + this.getPosIDTransactionDetailItems() + ")";
    }
}

