/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.posid.vo;

import com.zkteco.zkbiosecurity.base.annotation.Column;
import com.zkteco.zkbiosecurity.base.annotation.Condition;
import com.zkteco.zkbiosecurity.base.annotation.From;
import com.zkteco.zkbiosecurity.base.annotation.GridColumn;
import com.zkteco.zkbiosecurity.base.annotation.GridConfig;
import com.zkteco.zkbiosecurity.base.annotation.GroupBy;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import java.util.Date;
import java.util.UUID;

@From(after="POSID_OUT_STOCK o LEFT JOIN POSID_TRANSACTION t ON o.TRANSACTION_ID=t.ID")
@GroupBy(after="o.PRODUCT_ID, o.PRODUCT_NAME")
@GridConfig(operate=true, idField="id", winHeight=360, winWidth=450)
public class PosIDOutStockSumItem
extends BaseItem {
    private static final long serialVersionUID = 1L;
    @GridColumn(show=false)
    private String id = UUID.randomUUID().toString();
    @Column(name="o.PRODUCT_NAME")
    @GridColumn(label="posid_storeDetail_name", width="200")
    private String productName;
    @Column(name="SUM(o.NUM)")
    @GridColumn(label="posid_outStock_num", width="180")
    private Integer num;
    @Column(name="SUM(o.TOTAL_PRICE)")
    @GridColumn(label="posid_outStock_total", width="200", columnType="custom", convert="convertFen2Yuan")
    private Integer totalPrice;
    @Column(name="SUM(o.TOTAL_COST)")
    @GridColumn(label="posid_profit_price", width="200", columnType="custom", convert="convertFen2Yuan")
    private Integer totalCost;
    @Column(name="SUM(o.TOTAL_PROFIT)")
    @GridColumn(label="posid_profit_profit", width="200", columnType="custom", convert="convertFen2Yuan")
    private Integer totalProfit;
    @Condition(value="o.CREATE_TIME", equalTag=">=", toDate=true)
    private Date startDatetimeBegin;
    @Condition(value="o.CREATE_TIME", equalTag="<=", toDate=true)
    private Date startDatetimeEnd;
    @Condition(value="o.PRODUCT_NAME", equalTag="like")
    private String likeName;
    @Condition(value="o.STATUS", equalTag="=")
    private Integer status;
    private String outStockTime;
    @GridColumn(label="posid_countTable_conTimeStr", minWidth="160", width="170", sort="na")
    private String posTime;
    @Condition(value="t.HALLING_ID IN (SELECT pd.ID FROM POSID_DININGHALL pd WHERE pd.AUTH_AREA_ID IN (SELECT ud.AUTH_AREA_ID FROM AUTH_USER_AREA ud WHERE ud.AUTH_USER_ID=''{0}''))")
    private String diningAreaByUserId;

    public String getId() {
        return this.id;
    }

    public String getProductName() {
        return this.productName;
    }

    public Integer getNum() {
        return this.num;
    }

    public Integer getTotalPrice() {
        return this.totalPrice;
    }

    public Integer getTotalCost() {
        return this.totalCost;
    }

    public Integer getTotalProfit() {
        return this.totalProfit;
    }

    public Date getStartDatetimeBegin() {
        return this.startDatetimeBegin;
    }

    public Date getStartDatetimeEnd() {
        return this.startDatetimeEnd;
    }

    public String getLikeName() {
        return this.likeName;
    }

    public Integer getStatus() {
        return this.status;
    }

    public String getOutStockTime() {
        return this.outStockTime;
    }

    public String getPosTime() {
        return this.posTime;
    }

    public String getDiningAreaByUserId() {
        return this.diningAreaByUserId;
    }

    public PosIDOutStockSumItem setId(String id) {
        this.id = id;
        return this;
    }

    public PosIDOutStockSumItem setProductName(String productName) {
        this.productName = productName;
        return this;
    }

    public PosIDOutStockSumItem setNum(Integer num) {
        this.num = num;
        return this;
    }

    public PosIDOutStockSumItem setTotalPrice(Integer totalPrice) {
        this.totalPrice = totalPrice;
        return this;
    }

    public PosIDOutStockSumItem setTotalCost(Integer totalCost) {
        this.totalCost = totalCost;
        return this;
    }

    public PosIDOutStockSumItem setTotalProfit(Integer totalProfit) {
        this.totalProfit = totalProfit;
        return this;
    }

    public PosIDOutStockSumItem setStartDatetimeBegin(Date startDatetimeBegin) {
        this.startDatetimeBegin = startDatetimeBegin;
        return this;
    }

    public PosIDOutStockSumItem setStartDatetimeEnd(Date startDatetimeEnd) {
        this.startDatetimeEnd = startDatetimeEnd;
        return this;
    }

    public PosIDOutStockSumItem setLikeName(String likeName) {
        this.likeName = likeName;
        return this;
    }

    public PosIDOutStockSumItem setStatus(Integer status) {
        this.status = status;
        return this;
    }

    public PosIDOutStockSumItem setOutStockTime(String outStockTime) {
        this.outStockTime = outStockTime;
        return this;
    }

    public PosIDOutStockSumItem setPosTime(String posTime) {
        this.posTime = posTime;
        return this;
    }

    public PosIDOutStockSumItem setDiningAreaByUserId(String diningAreaByUserId) {
        this.diningAreaByUserId = diningAreaByUserId;
        return this;
    }

    public String toString() {
        return "PosIDOutStockSumItem(id=" + this.getId() + ", productName=" + this.getProductName() + ", num=" + this.getNum() + ", totalPrice=" + this.getTotalPrice() + ", totalCost=" + this.getTotalCost() + ", totalProfit=" + this.getTotalProfit() + ", startDatetimeBegin=" + this.getStartDatetimeBegin() + ", startDatetimeEnd=" + this.getStartDatetimeEnd() + ", likeName=" + this.getLikeName() + ", status=" + this.getStatus() + ", outStockTime=" + this.getOutStockTime() + ", posTime=" + this.getPosTime() + ", diningAreaByUserId=" + this.getDiningAreaByUserId() + ")";
    }
}

