/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.posid.vo;

import com.zkteco.zkbiosecurity.base.annotation.Column;
import com.zkteco.zkbiosecurity.base.annotation.Condition;
import com.zkteco.zkbiosecurity.base.annotation.From;
import com.zkteco.zkbiosecurity.base.annotation.GridColumn;
import com.zkteco.zkbiosecurity.base.annotation.GridConfig;
import com.zkteco.zkbiosecurity.base.annotation.GridOperate;
import com.zkteco.zkbiosecurity.base.annotation.GroupBy;
import com.zkteco.zkbiosecurity.base.annotation.OrderBy;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import java.util.Date;
import java.util.UUID;

@From(after="POSID_ORDER_PRODUCT t LEFT JOIN POSID_ORDER_PRODUCT_MEAL m ON m.ORDER_PRODUCT_ID = t.ID ")
@GroupBy(after="%s")
@OrderBy(after="%s DESC")
@GridConfig(operate=true, idField="id", winHeight=400, winWidth=600, operates={@GridOperate(type="custom", permission="posid:orderProductSummary:storeDetailList", click="storeDetailList", label="posid_orderMeal_variety_dishes")})
public class PosIDOrderProductSumItem
extends BaseItem {
    @GridColumn(show=false)
    private String id = UUID.randomUUID().toString();
    @Column(name="%s")
    @GridColumn(label="posid_orderMeal_create_time", width="120")
    private String orderTime;
    @Column(name="count(m.id)")
    @GridColumn(label="posid_orderMeal_status_zero", width="120", columnType="custom", convert="getOrderedMeals")
    private String orderedMeals;
    @Column(name="sum(case when m.STATUS = 0 AND m.MEAL_END_TIME >= %s then 1 else 0 end)")
    @GridColumn(label="posid_orderMeal_status_three", width="120", columnType="custom", convert="getNoMeals")
    private String noMeals;
    @Column(name="sum(case when m.STATUS = 1  then 1 else 0 end)")
    @GridColumn(label="posid_orderMeal_status_one", width="120", columnType="custom", convert="getDinnerAlreadyServed")
    private String dinnerAlreadyServed;
    @Column(name="sum(case when m.STATUS = 2  then 1 else 0 end)")
    @GridColumn(label="posid_orderMeal_status_two", width="120", columnType="custom", convert="getCancelled")
    private String cancelled;
    @Column(name="sum(case when m.STATUS = 0 AND m.MEAL_END_TIME < %s  then 1 else 0 end)")
    @GridColumn(label="posid_orderMeal_status_four", width="120", columnType="custom", convert="getExpired")
    private String expired;
    @Condition(value="t.HALLING_ID", equalTag="=")
    private String hallingId;
    @Condition(value="t.ORDER_DATE", equalTag=">=")
    private Date startTime;
    @Condition(value="t.ORDER_DATE", equalTag="<=")
    private Date endTime;

    public String getId() {
        return this.id;
    }

    public String getOrderTime() {
        return this.orderTime;
    }

    public String getOrderedMeals() {
        return this.orderedMeals;
    }

    public String getNoMeals() {
        return this.noMeals;
    }

    public String getDinnerAlreadyServed() {
        return this.dinnerAlreadyServed;
    }

    public String getCancelled() {
        return this.cancelled;
    }

    public String getExpired() {
        return this.expired;
    }

    public String getHallingId() {
        return this.hallingId;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public PosIDOrderProductSumItem setId(String id) {
        this.id = id;
        return this;
    }

    public PosIDOrderProductSumItem setOrderTime(String orderTime) {
        this.orderTime = orderTime;
        return this;
    }

    public PosIDOrderProductSumItem setOrderedMeals(String orderedMeals) {
        this.orderedMeals = orderedMeals;
        return this;
    }

    public PosIDOrderProductSumItem setNoMeals(String noMeals) {
        this.noMeals = noMeals;
        return this;
    }

    public PosIDOrderProductSumItem setDinnerAlreadyServed(String dinnerAlreadyServed) {
        this.dinnerAlreadyServed = dinnerAlreadyServed;
        return this;
    }

    public PosIDOrderProductSumItem setCancelled(String cancelled) {
        this.cancelled = cancelled;
        return this;
    }

    public PosIDOrderProductSumItem setExpired(String expired) {
        this.expired = expired;
        return this;
    }

    public PosIDOrderProductSumItem setHallingId(String hallingId) {
        this.hallingId = hallingId;
        return this;
    }

    public PosIDOrderProductSumItem setStartTime(Date startTime) {
        this.startTime = startTime;
        return this;
    }

    public PosIDOrderProductSumItem setEndTime(Date endTime) {
        this.endTime = endTime;
        return this;
    }

    public String toString() {
        return "PosIDOrderProductSumItem(id=" + this.getId() + ", orderTime=" + this.getOrderTime() + ", orderedMeals=" + this.getOrderedMeals() + ", noMeals=" + this.getNoMeals() + ", dinnerAlreadyServed=" + this.getDinnerAlreadyServed() + ", cancelled=" + this.getCancelled() + ", expired=" + this.getExpired() + ", hallingId=" + this.getHallingId() + ", startTime=" + this.getStartTime() + ", endTime=" + this.getEndTime() + ")";
    }
}

