/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.posid.vo;

import com.zkteco.zkbiosecurity.base.annotation.Column;
import com.zkteco.zkbiosecurity.base.annotation.Condition;
import com.zkteco.zkbiosecurity.base.annotation.From;
import com.zkteco.zkbiosecurity.base.annotation.GridColumn;
import com.zkteco.zkbiosecurity.base.annotation.GridConfig;
import com.zkteco.zkbiosecurity.base.annotation.GridOperate;
import com.zkteco.zkbiosecurity.base.annotation.OrderBy;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import java.util.Date;

@From(after="POSID_ORDER_PRODUCT_MEAL m LEFT JOIN POSID_ORDER_PRODUCT p ON p.ID = m.ORDER_PRODUCT_ID ")
@OrderBy(after="p.ORDER_DATE DESC")
@GridConfig(operate=true, idField="id", winHeight=400, winWidth=600, operates={@GridOperate(type="custom", permission="posid:orderProductSummary:storeDetailList", click="getOrderStoreDetail", label="posid_orderMeal_variety_dishes")})
public class PosIDOrderProductMealListItem
extends BaseItem {
    @Column(name="m.ID")
    @GridColumn(checkbox=false, width="40", sort="na", show=false)
    private String id;
    @Column(name="p.PERSON_PIN")
    @GridColumn(label="pers_person_pin", width="120", i18n=true, encryptMode="${pers.pin.encryptMode}", encryptProp="${pers.pin.encryptProp}")
    private String personPin;
    @Column(name="p.PERSON_NAME")
    @GridColumn(label="pers_person_name", width="120", encryptMode="${pers.name.encryptMode}", encryptProp="${pers.name.encryptProp}")
    private String personName;
    @Column(name="p.DEPT_NAME")
    @GridColumn(label="posid_card_deptName", width="120")
    private String deptName;
    @Column(name="m.MEAL_NAME")
    @GridColumn(label="posid_meal_name", width="120")
    private String mealName;
    @Column(name="case when m.STATUS = 0 AND m.MEAL_END_TIME < %s then 3 else m.STATUS end")
    @GridColumn(label="common_status", width="120", format="0=posid_orderMeal_status_three,1=posid_orderMeal_status_one,2=posid_orderMeal_status_two,3=posid_orderMeal_status_four")
    private Integer status;
    @Column(name="m.POS_TIME")
    @GridColumn(label="posid_orderMeal_meal_time", width="150")
    private Date posTime;
    @Column(name="m.MEAL_PRICE")
    @GridColumn(label="posid_storeDetail_money", width="120", columnType="custom", convert="convertFen2Yuan")
    private Integer mealPrice;
    @Condition(value="p.HALLING_ID", equalTag="=")
    private String hallingId;
    @Condition(value="m.MEAL_ID", equalTag="=")
    private String mealId;
    @Condition(value="p.ORDER_DATE", equalTag=">=")
    private Date startTime;
    @Condition(value="p.ORDER_DATE", equalTag="<=")
    private Date endTime;
    private String orderTime;
    @Condition(value="m.MEAL_END_TIME", equalTag=">=")
    private Date notEatenMealEndTime;
    @Condition(value="m.MEAL_END_TIME", equalTag="<")
    private Date expiredMealEndTime;
    @Condition(value="m.STATUS", equalTag="=")
    private Integer orderMealStatusEql;

    public String getId() {
        return this.id;
    }

    public String getPersonPin() {
        return this.personPin;
    }

    public String getPersonName() {
        return this.personName;
    }

    public String getDeptName() {
        return this.deptName;
    }

    public String getMealName() {
        return this.mealName;
    }

    public Integer getStatus() {
        return this.status;
    }

    public Date getPosTime() {
        return this.posTime;
    }

    public Integer getMealPrice() {
        return this.mealPrice;
    }

    public String getHallingId() {
        return this.hallingId;
    }

    public String getMealId() {
        return this.mealId;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public String getOrderTime() {
        return this.orderTime;
    }

    public Date getNotEatenMealEndTime() {
        return this.notEatenMealEndTime;
    }

    public Date getExpiredMealEndTime() {
        return this.expiredMealEndTime;
    }

    public Integer getOrderMealStatusEql() {
        return this.orderMealStatusEql;
    }

    public PosIDOrderProductMealListItem setId(String id) {
        this.id = id;
        return this;
    }

    public PosIDOrderProductMealListItem setPersonPin(String personPin) {
        this.personPin = personPin;
        return this;
    }

    public PosIDOrderProductMealListItem setPersonName(String personName) {
        this.personName = personName;
        return this;
    }

    public PosIDOrderProductMealListItem setDeptName(String deptName) {
        this.deptName = deptName;
        return this;
    }

    public PosIDOrderProductMealListItem setMealName(String mealName) {
        this.mealName = mealName;
        return this;
    }

    public PosIDOrderProductMealListItem setStatus(Integer status) {
        this.status = status;
        return this;
    }

    public PosIDOrderProductMealListItem setPosTime(Date posTime) {
        this.posTime = posTime;
        return this;
    }

    public PosIDOrderProductMealListItem setMealPrice(Integer mealPrice) {
        this.mealPrice = mealPrice;
        return this;
    }

    public PosIDOrderProductMealListItem setHallingId(String hallingId) {
        this.hallingId = hallingId;
        return this;
    }

    public PosIDOrderProductMealListItem setMealId(String mealId) {
        this.mealId = mealId;
        return this;
    }

    public PosIDOrderProductMealListItem setStartTime(Date startTime) {
        this.startTime = startTime;
        return this;
    }

    public PosIDOrderProductMealListItem setEndTime(Date endTime) {
        this.endTime = endTime;
        return this;
    }

    public PosIDOrderProductMealListItem setOrderTime(String orderTime) {
        this.orderTime = orderTime;
        return this;
    }

    public PosIDOrderProductMealListItem setNotEatenMealEndTime(Date notEatenMealEndTime) {
        this.notEatenMealEndTime = notEatenMealEndTime;
        return this;
    }

    public PosIDOrderProductMealListItem setExpiredMealEndTime(Date expiredMealEndTime) {
        this.expiredMealEndTime = expiredMealEndTime;
        return this;
    }

    public PosIDOrderProductMealListItem setOrderMealStatusEql(Integer orderMealStatusEql) {
        this.orderMealStatusEql = orderMealStatusEql;
        return this;
    }

    public String toString() {
        return "PosIDOrderProductMealListItem(id=" + this.getId() + ", personPin=" + this.getPersonPin() + ", personName=" + this.getPersonName() + ", deptName=" + this.getDeptName() + ", mealName=" + this.getMealName() + ", status=" + this.getStatus() + ", posTime=" + this.getPosTime() + ", mealPrice=" + this.getMealPrice() + ", hallingId=" + this.getHallingId() + ", mealId=" + this.getMealId() + ", startTime=" + this.getStartTime() + ", endTime=" + this.getEndTime() + ", orderTime=" + this.getOrderTime() + ", notEatenMealEndTime=" + this.getNotEatenMealEndTime() + ", expiredMealEndTime=" + this.getExpiredMealEndTime() + ", orderMealStatusEql=" + this.getOrderMealStatusEql() + ")";
    }
}

