/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.posid.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.zkteco.zkbiosecurity.base.annotation.Column;
import com.zkteco.zkbiosecurity.base.annotation.Condition;
import com.zkteco.zkbiosecurity.base.annotation.From;
import com.zkteco.zkbiosecurity.base.annotation.GridColumn;
import com.zkteco.zkbiosecurity.base.annotation.GridConfig;
import com.zkteco.zkbiosecurity.base.annotation.GridOperate;
import com.zkteco.zkbiosecurity.base.annotation.OrderBy;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.posid.vo.PosIDOrderProductMealItem;
import java.util.Date;
import java.util.List;
import org.springframework.format.annotation.DateTimeFormat;

@From(after="POSID_ORDER_PRODUCT t")
@OrderBy(after="t.CREATE_TIME DESC")
@GridConfig(operate=true, idField="id", winHeight=300, winWidth=420, operates={@GridOperate(type="custom", permission="posid:mealConsumeDetail:refresh", click="listMeal", label="posid_card_view")})
public class PosIDOrderProductItem
extends BaseItem {
    private static final long serialVersionUID = 1L;
    @Column(name="t.ID")
    @GridColumn(checkbox=true, width="40", sort="na", show=false)
    private String id;
    @Column(name="t.ID")
    @GridColumn(label="posid_card_orderId", width="300")
    private String orderId;
    @Column(name="t.PERSON_ID")
    @GridColumn(label="posid_card_personNum", show=false)
    private String personId;
    @Column(name="t.PERSON_PIN")
    @GridColumn(label="pers_person_pin", width="150", i18n=true, encryptMode="${pers.pin.encryptMode}", encryptProp="${pers.pin.encryptProp}")
    private String personPin;
    @Column(name="t.PERSON_NAME")
    @GridColumn(label="pers_person_name", width="150", encryptMode="${pers.name.encryptMode}", encryptProp="${pers.name.encryptProp}")
    private String personName;
    @Column(name="t.PERSON_LAST_NAME")
    @GridColumn(label="pers_person_lastName", width="80", showExpression="#language!='zh_CN'", encryptMode="${pers.lastName.encryptMode}", encryptProp="${pers.lastName.encryptProp}")
    private String personLastName;
    @Column(name="t.DEPT_ID")
    @GridColumn(label="posid_transaction_deptId", show=false)
    private String deptId;
    @Column(name="t.DEPT_CODE")
    @GridColumn(label="posid_card_deptNum", width="150", show=false)
    private String deptCode;
    @Column(name="t.DEPT_NAME")
    @GridColumn(label="posid_card_deptName", width="150")
    private String deptName;
    @Column(name="t.HALLING_ID")
    @GridColumn(label="posid_transaction_hallingId", show=false)
    private String hallingId;
    @Column(name="t.HALLING_CODE")
    @GridColumn(label="posid_transaction_hallingCode", show=false)
    private String hallingCode;
    @Column(name="t.HALLING_NAME")
    @GridColumn(label="posid_diningHall_name", width="150")
    private String hallingName;
    @Column(name="t.HALLING_IMAGE_PATH")
    @GridColumn(label="posid_diningHall_img", width="150", columnType="custom", convert="changePic", align="center", show=false)
    private String hallingImagePath;
    @Column(name="t.HALLING_TYPE")
    @GridColumn(label="posid_diningHall_type", width="150", format="0=posid_diningHall_canteen,1=posid_diningHall_supermarket")
    private Integer hallingType;
    @Column(name="t.ORDER_PRICE")
    @GridColumn(label="posid_card_orderMoney", width="150", columnType="custom", convert="convertFen2Yuan")
    private Integer orderPrice;
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", timezone="GMT+8")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Column(name="t.ORDER_DATE")
    @GridColumn(label="posid_orderMeal_time", width="150", columnType="custom", convert="timeToYmd")
    private Date orderDate;
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", timezone="GMT+8")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Column(name="t.CREATE_TIME")
    @GridColumn(label="posid_card_orderTime", width="150")
    private Date createTime;
    @Condition(value="t.CREATE_TIME", equalTag=">=", toDate=true)
    private String opTimeBegin;
    @Condition(value="t.CREATE_TIME", equalTag="<=", toDate=true)
    private String opTimeEnd;
    @Condition(value="t.ORDER_DATE", equalTag=">=", toDate=true)
    private String opOrderTimeBegin;
    @Condition(value="t.ORDER_DATE", equalTag="<=", toDate=true)
    private String opOrderTimeEnd;
    @Condition(value="t.DEPT_ID", equalTag="in")
    private String inDeptId;
    @Condition(value="t.PERSON_PIN", equalTag="=")
    private String eqlPersonPin;
    @Condition(value="t.DEPT_ID IN (SELECT ud.AUTH_DEPT_ID FROM AUTH_USER_DEPT ud WHERE ud.AUTH_USER_ID=''{0}'')")
    private String userId;
    @Condition(value="t.HALLING_ID IN (SELECT pd.ID FROM POSID_DININGHALL pd WHERE pd.AUTH_AREA_ID IN (SELECT ud.AUTH_AREA_ID FROM AUTH_USER_AREA ud WHERE ud.AUTH_USER_ID=''{0}''))")
    private String diningAreaByUserId;
    private String isIncludeLower;
    private List<PosIDOrderProductMealItem> orderProductMealList;

    public PosIDOrderProductItem(String id) {
        this.id = id;
    }

    public PosIDOrderProductItem() {
    }

    public String getId() {
        return this.id;
    }

    public String getOrderId() {
        return this.orderId;
    }

    public String getPersonId() {
        return this.personId;
    }

    public String getPersonPin() {
        return this.personPin;
    }

    public String getPersonName() {
        return this.personName;
    }

    public String getPersonLastName() {
        return this.personLastName;
    }

    public String getDeptId() {
        return this.deptId;
    }

    public String getDeptCode() {
        return this.deptCode;
    }

    public String getDeptName() {
        return this.deptName;
    }

    public String getHallingId() {
        return this.hallingId;
    }

    public String getHallingCode() {
        return this.hallingCode;
    }

    public String getHallingName() {
        return this.hallingName;
    }

    public String getHallingImagePath() {
        return this.hallingImagePath;
    }

    public Integer getHallingType() {
        return this.hallingType;
    }

    public Integer getOrderPrice() {
        return this.orderPrice;
    }

    public Date getOrderDate() {
        return this.orderDate;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public String getOpTimeBegin() {
        return this.opTimeBegin;
    }

    public String getOpTimeEnd() {
        return this.opTimeEnd;
    }

    public String getOpOrderTimeBegin() {
        return this.opOrderTimeBegin;
    }

    public String getOpOrderTimeEnd() {
        return this.opOrderTimeEnd;
    }

    public String getInDeptId() {
        return this.inDeptId;
    }

    public String getEqlPersonPin() {
        return this.eqlPersonPin;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getDiningAreaByUserId() {
        return this.diningAreaByUserId;
    }

    public String getIsIncludeLower() {
        return this.isIncludeLower;
    }

    public List<PosIDOrderProductMealItem> getOrderProductMealList() {
        return this.orderProductMealList;
    }

    public PosIDOrderProductItem setId(String id) {
        this.id = id;
        return this;
    }

    public PosIDOrderProductItem setOrderId(String orderId) {
        this.orderId = orderId;
        return this;
    }

    public PosIDOrderProductItem setPersonId(String personId) {
        this.personId = personId;
        return this;
    }

    public PosIDOrderProductItem setPersonPin(String personPin) {
        this.personPin = personPin;
        return this;
    }

    public PosIDOrderProductItem setPersonName(String personName) {
        this.personName = personName;
        return this;
    }

    public PosIDOrderProductItem setPersonLastName(String personLastName) {
        this.personLastName = personLastName;
        return this;
    }

    public PosIDOrderProductItem setDeptId(String deptId) {
        this.deptId = deptId;
        return this;
    }

    public PosIDOrderProductItem setDeptCode(String deptCode) {
        this.deptCode = deptCode;
        return this;
    }

    public PosIDOrderProductItem setDeptName(String deptName) {
        this.deptName = deptName;
        return this;
    }

    public PosIDOrderProductItem setHallingId(String hallingId) {
        this.hallingId = hallingId;
        return this;
    }

    public PosIDOrderProductItem setHallingCode(String hallingCode) {
        this.hallingCode = hallingCode;
        return this;
    }

    public PosIDOrderProductItem setHallingName(String hallingName) {
        this.hallingName = hallingName;
        return this;
    }

    public PosIDOrderProductItem setHallingImagePath(String hallingImagePath) {
        this.hallingImagePath = hallingImagePath;
        return this;
    }

    public PosIDOrderProductItem setHallingType(Integer hallingType) {
        this.hallingType = hallingType;
        return this;
    }

    public PosIDOrderProductItem setOrderPrice(Integer orderPrice) {
        this.orderPrice = orderPrice;
        return this;
    }

    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", timezone="GMT+8")
    public PosIDOrderProductItem setOrderDate(Date orderDate) {
        this.orderDate = orderDate;
        return this;
    }

    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", timezone="GMT+8")
    public PosIDOrderProductItem setCreateTime(Date createTime) {
        this.createTime = createTime;
        return this;
    }

    public PosIDOrderProductItem setOpTimeBegin(String opTimeBegin) {
        this.opTimeBegin = opTimeBegin;
        return this;
    }

    public PosIDOrderProductItem setOpTimeEnd(String opTimeEnd) {
        this.opTimeEnd = opTimeEnd;
        return this;
    }

    public PosIDOrderProductItem setOpOrderTimeBegin(String opOrderTimeBegin) {
        this.opOrderTimeBegin = opOrderTimeBegin;
        return this;
    }

    public PosIDOrderProductItem setOpOrderTimeEnd(String opOrderTimeEnd) {
        this.opOrderTimeEnd = opOrderTimeEnd;
        return this;
    }

    public PosIDOrderProductItem setInDeptId(String inDeptId) {
        this.inDeptId = inDeptId;
        return this;
    }

    public PosIDOrderProductItem setEqlPersonPin(String eqlPersonPin) {
        this.eqlPersonPin = eqlPersonPin;
        return this;
    }

    public PosIDOrderProductItem setUserId(String userId) {
        this.userId = userId;
        return this;
    }

    public PosIDOrderProductItem setDiningAreaByUserId(String diningAreaByUserId) {
        this.diningAreaByUserId = diningAreaByUserId;
        return this;
    }

    public PosIDOrderProductItem setIsIncludeLower(String isIncludeLower) {
        this.isIncludeLower = isIncludeLower;
        return this;
    }

    public PosIDOrderProductItem setOrderProductMealList(List<PosIDOrderProductMealItem> orderProductMealList) {
        this.orderProductMealList = orderProductMealList;
        return this;
    }

    public String toString() {
        return "PosIDOrderProductItem(id=" + this.getId() + ", orderId=" + this.getOrderId() + ", personId=" + this.getPersonId() + ", personPin=" + this.getPersonPin() + ", personName=" + this.getPersonName() + ", personLastName=" + this.getPersonLastName() + ", deptId=" + this.getDeptId() + ", deptCode=" + this.getDeptCode() + ", deptName=" + this.getDeptName() + ", hallingId=" + this.getHallingId() + ", hallingCode=" + this.getHallingCode() + ", hallingName=" + this.getHallingName() + ", hallingImagePath=" + this.getHallingImagePath() + ", hallingType=" + this.getHallingType() + ", orderPrice=" + this.getOrderPrice() + ", orderDate=" + this.getOrderDate() + ", createTime=" + this.getCreateTime() + ", opTimeBegin=" + this.getOpTimeBegin() + ", opTimeEnd=" + this.getOpTimeEnd() + ", opOrderTimeBegin=" + this.getOpOrderTimeBegin() + ", opOrderTimeEnd=" + this.getOpOrderTimeEnd() + ", inDeptId=" + this.getInDeptId() + ", eqlPersonPin=" + this.getEqlPersonPin() + ", userId=" + this.getUserId() + ", diningAreaByUserId=" + this.getDiningAreaByUserId() + ", isIncludeLower=" + this.getIsIncludeLower() + ", orderProductMealList=" + this.getOrderProductMealList() + ")";
    }
}

