/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.posid.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.zkteco.zkbiosecurity.base.annotation.Column;
import com.zkteco.zkbiosecurity.base.annotation.Condition;
import com.zkteco.zkbiosecurity.base.annotation.From;
import com.zkteco.zkbiosecurity.base.annotation.GridColumn;
import com.zkteco.zkbiosecurity.base.annotation.GridConfig;
import com.zkteco.zkbiosecurity.base.annotation.OrderBy;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import java.util.Date;
import org.springframework.format.annotation.DateTimeFormat;

@From(after="POSID_ORDER_MEAL t ")
@OrderBy(after="t.CREATE_TIME DESC")
@GridConfig(operate=true, idField="id", winHeight=300, winWidth=420, operates={})
public class PosIDOrderMealItem
extends BaseItem {
    private static final long serialVersionUID = 1L;
    @Column(name="t.ID")
    @GridColumn(checkbox=true, width="40", sort="na")
    private String id;
    @Column(name="t.DEPT_ID")
    @GridColumn(label="posid_transaction_deptId", show=false)
    private String deptId;
    @Column(name="t.PIN")
    @GridColumn(label="pers_person_pin", width="100", i18n=true, encryptMode="${pers.pin.encryptMode}", encryptProp="${pers.pin.encryptProp}")
    private String pin;
    @Column(name="t.PERSON_NAME")
    @GridColumn(label="pers_person_name", width="100", encryptMode="${pers.name.encryptMode}", encryptProp="${pers.name.encryptProp}")
    private String personName;
    @Column(name="t.SN")
    @GridColumn(label="common_dev_sn", width="100")
    private String sn;
    @Column(name="t.HALLING_ID")
    @GridColumn(label="posid_transaction_hallingId", show=false)
    private String hallingId;
    @Column(name="t.HALLING_CODE")
    @GridColumn(label="posid_transaction_hallingCode", show=false)
    private String hallingCode;
    @Column(name="t.HALLING_NAME")
    @GridColumn(label="posid_diningHall_name", width="110")
    private String hallingName;
    @Column(name="t.MEAL_ID")
    @GridColumn(label="posid_transaction_posMeal", show=false)
    private String mealId;
    @Column(name="t.MEAL_NAME")
    @GridColumn(label="posid_meal_name", width="200")
    private String mealName;
    @Column(name="t.STATUS")
    @GridColumn(label="posid_orderMeal_status", width="150", format="0=posid_orderMeal_status_zero,1=posid_orderMeal_status_one,2=posid_orderMeal_status_two,3=posid_orderMeal_status_three", show=true)
    private Integer status;
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", timezone="GMT+8")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Column(name="t.ORDER_TIME")
    @GridColumn(label="posid_orderMeal_create_time", width="150")
    private Date orderTime;
    @Column(name="t.ORDER_END_TIME")
    private Date orderEndTime;
    @Column(name="t.CREATE_TIME")
    @GridColumn(label="posid_cus_creatTime", width="150")
    private Date createTime;
    @Condition(value="t.SN", equalTag="in")
    private String inDeviceSn;
    @Condition(value="t.DEPT_ID", equalTag="in")
    private String inDeptId;
    @Condition(value="t.PIN", equalTag="in")
    private String inPersonPin;
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", timezone="GMT+8")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Condition(value="t.CREATE_TIME", equalTag=">=")
    private Date startDatetimeBegin;
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", timezone="GMT+8")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Condition(value="t.CREATE_TIME", equalTag="<=")
    private Date startDatetimeEnd;
    @Condition(value="t.ORDER_TIME", equalTag="<")
    private Date historyTime;
    @Condition(value="t.ORDER_END_TIME", equalTag="<")
    private Date noMeals;
    @Condition(value="t.ORDER_END_TIME", equalTag=">=")
    private Date timeMeals;
    @Condition(value="t.DEPT_ID IN (SELECT ud.AUTH_DEPT_ID FROM AUTH_USER_DEPT ud WHERE ud.AUTH_USER_ID=''{0}'')")
    private String userId;
    @Condition(value="t.HALLING_ID IN (SELECT pd.ID FROM POSID_DININGHALL pd WHERE pd.AUTH_AREA_ID IN (SELECT ud.AUTH_AREA_ID FROM AUTH_USER_AREA ud WHERE ud.AUTH_USER_ID=''{0}''))")
    private String diningAreaByUserId;
    @Condition(value="t.PIN", equalTag="=")
    private String eqlPersonPin;
    private String isIncludeLower;

    public PosIDOrderMealItem(String id) {
        this.id = id;
    }

    public PosIDOrderMealItem() {
    }

    public String getId() {
        return this.id;
    }

    public String getDeptId() {
        return this.deptId;
    }

    public String getPin() {
        return this.pin;
    }

    public String getPersonName() {
        return this.personName;
    }

    public String getSn() {
        return this.sn;
    }

    public String getHallingId() {
        return this.hallingId;
    }

    public String getHallingCode() {
        return this.hallingCode;
    }

    public String getHallingName() {
        return this.hallingName;
    }

    public String getMealId() {
        return this.mealId;
    }

    public String getMealName() {
        return this.mealName;
    }

    public Integer getStatus() {
        return this.status;
    }

    public Date getOrderTime() {
        return this.orderTime;
    }

    public Date getOrderEndTime() {
        return this.orderEndTime;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public String getInDeviceSn() {
        return this.inDeviceSn;
    }

    public String getInDeptId() {
        return this.inDeptId;
    }

    public String getInPersonPin() {
        return this.inPersonPin;
    }

    public Date getStartDatetimeBegin() {
        return this.startDatetimeBegin;
    }

    public Date getStartDatetimeEnd() {
        return this.startDatetimeEnd;
    }

    public Date getHistoryTime() {
        return this.historyTime;
    }

    public Date getNoMeals() {
        return this.noMeals;
    }

    public Date getTimeMeals() {
        return this.timeMeals;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getDiningAreaByUserId() {
        return this.diningAreaByUserId;
    }

    public String getEqlPersonPin() {
        return this.eqlPersonPin;
    }

    public String getIsIncludeLower() {
        return this.isIncludeLower;
    }

    public PosIDOrderMealItem setId(String id) {
        this.id = id;
        return this;
    }

    public PosIDOrderMealItem setDeptId(String deptId) {
        this.deptId = deptId;
        return this;
    }

    public PosIDOrderMealItem setPin(String pin) {
        this.pin = pin;
        return this;
    }

    public PosIDOrderMealItem setPersonName(String personName) {
        this.personName = personName;
        return this;
    }

    public PosIDOrderMealItem setSn(String sn) {
        this.sn = sn;
        return this;
    }

    public PosIDOrderMealItem setHallingId(String hallingId) {
        this.hallingId = hallingId;
        return this;
    }

    public PosIDOrderMealItem setHallingCode(String hallingCode) {
        this.hallingCode = hallingCode;
        return this;
    }

    public PosIDOrderMealItem setHallingName(String hallingName) {
        this.hallingName = hallingName;
        return this;
    }

    public PosIDOrderMealItem setMealId(String mealId) {
        this.mealId = mealId;
        return this;
    }

    public PosIDOrderMealItem setMealName(String mealName) {
        this.mealName = mealName;
        return this;
    }

    public PosIDOrderMealItem setStatus(Integer status) {
        this.status = status;
        return this;
    }

    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", timezone="GMT+8")
    public PosIDOrderMealItem setOrderTime(Date orderTime) {
        this.orderTime = orderTime;
        return this;
    }

    public PosIDOrderMealItem setOrderEndTime(Date orderEndTime) {
        this.orderEndTime = orderEndTime;
        return this;
    }

    public PosIDOrderMealItem setCreateTime(Date createTime) {
        this.createTime = createTime;
        return this;
    }

    public PosIDOrderMealItem setInDeviceSn(String inDeviceSn) {
        this.inDeviceSn = inDeviceSn;
        return this;
    }

    public PosIDOrderMealItem setInDeptId(String inDeptId) {
        this.inDeptId = inDeptId;
        return this;
    }

    public PosIDOrderMealItem setInPersonPin(String inPersonPin) {
        this.inPersonPin = inPersonPin;
        return this;
    }

    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", timezone="GMT+8")
    public PosIDOrderMealItem setStartDatetimeBegin(Date startDatetimeBegin) {
        this.startDatetimeBegin = startDatetimeBegin;
        return this;
    }

    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", timezone="GMT+8")
    public PosIDOrderMealItem setStartDatetimeEnd(Date startDatetimeEnd) {
        this.startDatetimeEnd = startDatetimeEnd;
        return this;
    }

    public PosIDOrderMealItem setHistoryTime(Date historyTime) {
        this.historyTime = historyTime;
        return this;
    }

    public PosIDOrderMealItem setNoMeals(Date noMeals) {
        this.noMeals = noMeals;
        return this;
    }

    public PosIDOrderMealItem setTimeMeals(Date timeMeals) {
        this.timeMeals = timeMeals;
        return this;
    }

    public PosIDOrderMealItem setUserId(String userId) {
        this.userId = userId;
        return this;
    }

    public PosIDOrderMealItem setDiningAreaByUserId(String diningAreaByUserId) {
        this.diningAreaByUserId = diningAreaByUserId;
        return this;
    }

    public PosIDOrderMealItem setEqlPersonPin(String eqlPersonPin) {
        this.eqlPersonPin = eqlPersonPin;
        return this;
    }

    public PosIDOrderMealItem setIsIncludeLower(String isIncludeLower) {
        this.isIncludeLower = isIncludeLower;
        return this;
    }

    public String toString() {
        return "PosIDOrderMealItem(id=" + this.getId() + ", deptId=" + this.getDeptId() + ", pin=" + this.getPin() + ", personName=" + this.getPersonName() + ", sn=" + this.getSn() + ", hallingId=" + this.getHallingId() + ", hallingCode=" + this.getHallingCode() + ", hallingName=" + this.getHallingName() + ", mealId=" + this.getMealId() + ", mealName=" + this.getMealName() + ", status=" + this.getStatus() + ", orderTime=" + this.getOrderTime() + ", orderEndTime=" + this.getOrderEndTime() + ", createTime=" + this.getCreateTime() + ", inDeviceSn=" + this.getInDeviceSn() + ", inDeptId=" + this.getInDeptId() + ", inPersonPin=" + this.getInPersonPin() + ", startDatetimeBegin=" + this.getStartDatetimeBegin() + ", startDatetimeEnd=" + this.getStartDatetimeEnd() + ", historyTime=" + this.getHistoryTime() + ", noMeals=" + this.getNoMeals() + ", timeMeals=" + this.getTimeMeals() + ", userId=" + this.getUserId() + ", diningAreaByUserId=" + this.getDiningAreaByUserId() + ", eqlPersonPin=" + this.getEqlPersonPin() + ", isIncludeLower=" + this.getIsIncludeLower() + ")";
    }
}

