/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.posid.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.zkteco.zkbiosecurity.base.annotation.Column;
import com.zkteco.zkbiosecurity.base.annotation.Condition;
import com.zkteco.zkbiosecurity.base.annotation.From;
import com.zkteco.zkbiosecurity.base.annotation.GridColumn;
import com.zkteco.zkbiosecurity.base.annotation.GridConfig;
import com.zkteco.zkbiosecurity.base.annotation.OrderBy;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import java.util.Date;
import org.springframework.format.annotation.DateTimeFormat;

@From(after="POSID_OFFLINE_CONSUME t")
@OrderBy(after="t.POS_TIME DESC")
@GridConfig(operate=true, idField="id", winHeight=350, winWidth=600)
public class PosIDOfflineConsumeItem
extends BaseItem {
    private static final long serialVersionUID = 1L;
    @Column(name="t.ONLY_STATUS")
    @GridColumn(show=false)
    private String onlyStatus;
    @Column(name="t.ID")
    @GridColumn(checkbox=true, width="40", sort="na")
    private String id;
    @Column(name="t.PIN", equalTag="=")
    @GridColumn(label="pers_person_pin", width="100", i18n=true, encryptMode="${pers.pin.encryptMode}", encryptProp="${pers.pin.encryptProp}")
    private String pin;
    @Column(name="t.MONEY")
    @GridColumn(label="posid_cus_money", width="100", columnType="custom", convert="convertFen2Yuan")
    private Integer money;
    @Column(name="t.SN")
    @GridColumn(label="common_dev_sn", width="100")
    private String sn;
    @Column(name="t.POS_MODEL", equalTag="=")
    @GridColumn(label="posid_consumerList_consumType", width="80", format="1=posid_dev_fixMode,2=posid_dev_amountMode,3=posid_dev_keyValueMode,4=posid_dev_timesMode,5=posid_dev_storeMode,6=posid_dev_timingMode,7=posid_dev_accountingMode,8=posid_leftMenu_handConsume,9=posid_device_error_correction,10=posid_dev_systemError,11=posid_dev_order,12=posid_dev_intelligence")
    private Integer posModel;
    @Column(name="t.STATUS")
    @GridColumn(label="posid_allowance_isCheckOrNot", columnType="custom", convert="isCheckToString", width="120")
    private Integer status;
    @Column(name="t.POS_FACE_IMG")
    @GridColumn(label="posid_face_img", columnType="custom", convert="changePic", align="center", width="100")
    private String posFaceImg;
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", timezone="GMT+8")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Column(name="t.POS_TIME")
    @GridColumn(label="posid_cus_time", width="150")
    private Date posTime;
    @Column(name="t.CREATE_TIME")
    @GridColumn(label="posid_common_upload_time", minWidth="150")
    private Date createTime;
    @Condition(value="t.POS_TIME", equalTag=">=")
    private Date startTime;
    @Condition(value="t.POS_TIME", equalTag="<=")
    private Date endTime;
    private String accountId;

    public String getOnlyStatus() {
        return this.onlyStatus;
    }

    public String getId() {
        return this.id;
    }

    public String getPin() {
        return this.pin;
    }

    public Integer getMoney() {
        return this.money;
    }

    public String getSn() {
        return this.sn;
    }

    public Integer getPosModel() {
        return this.posModel;
    }

    public Integer getStatus() {
        return this.status;
    }

    public String getPosFaceImg() {
        return this.posFaceImg;
    }

    public Date getPosTime() {
        return this.posTime;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public String getAccountId() {
        return this.accountId;
    }

    public PosIDOfflineConsumeItem setOnlyStatus(String onlyStatus) {
        this.onlyStatus = onlyStatus;
        return this;
    }

    public PosIDOfflineConsumeItem setId(String id) {
        this.id = id;
        return this;
    }

    public PosIDOfflineConsumeItem setPin(String pin) {
        this.pin = pin;
        return this;
    }

    public PosIDOfflineConsumeItem setMoney(Integer money) {
        this.money = money;
        return this;
    }

    public PosIDOfflineConsumeItem setSn(String sn) {
        this.sn = sn;
        return this;
    }

    public PosIDOfflineConsumeItem setPosModel(Integer posModel) {
        this.posModel = posModel;
        return this;
    }

    public PosIDOfflineConsumeItem setStatus(Integer status) {
        this.status = status;
        return this;
    }

    public PosIDOfflineConsumeItem setPosFaceImg(String posFaceImg) {
        this.posFaceImg = posFaceImg;
        return this;
    }

    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", timezone="GMT+8")
    public PosIDOfflineConsumeItem setPosTime(Date posTime) {
        this.posTime = posTime;
        return this;
    }

    public PosIDOfflineConsumeItem setCreateTime(Date createTime) {
        this.createTime = createTime;
        return this;
    }

    public PosIDOfflineConsumeItem setStartTime(Date startTime) {
        this.startTime = startTime;
        return this;
    }

    public PosIDOfflineConsumeItem setEndTime(Date endTime) {
        this.endTime = endTime;
        return this;
    }

    public PosIDOfflineConsumeItem setAccountId(String accountId) {
        this.accountId = accountId;
        return this;
    }

    public String toString() {
        return "PosIDOfflineConsumeItem(onlyStatus=" + this.getOnlyStatus() + ", id=" + this.getId() + ", pin=" + this.getPin() + ", money=" + this.getMoney() + ", sn=" + this.getSn() + ", posModel=" + this.getPosModel() + ", status=" + this.getStatus() + ", posFaceImg=" + this.getPosFaceImg() + ", posTime=" + this.getPosTime() + ", createTime=" + this.getCreateTime() + ", startTime=" + this.getStartTime() + ", endTime=" + this.getEndTime() + ", accountId=" + this.getAccountId() + ")";
    }
}

