/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.posid.vo;

import com.zkteco.zkbiosecurity.base.annotation.Column;
import com.zkteco.zkbiosecurity.base.annotation.Condition;
import com.zkteco.zkbiosecurity.base.annotation.From;
import com.zkteco.zkbiosecurity.base.annotation.GridColumn;
import com.zkteco.zkbiosecurity.base.annotation.GridConfig;
import com.zkteco.zkbiosecurity.base.annotation.GroupBy;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import java.util.UUID;

@From(after="POSID_TRANSACTION t")
@GroupBy(after="t.PERSON_ID")
@GridConfig(operate=true, idField="id", winHeight=400, winWidth=600)
public class PosIDMonthlyTransactionItem
extends BaseItem {
    @GridColumn(show=false)
    private String id = UUID.randomUUID().toString();
    @Column(name="t.PERSON_ID")
    private String personId;
    @Column(name="SUM(CASE t.TYPE_NAME WHEN 6 THEN 1 WHEN 12 THEN 1 WHEN 10 THEN 1 ELSE 0 END)")
    private Integer consumeCount;
    @Column(name="SUM(CASE t.TYPE_NAME WHEN 6 THEN t.MONEY WHEN 12 THEN t.MONEY ELSE 0 END)")
    @GridColumn(label="posid_cus_money", width="110", columnType="custom", convert="convertFen2Yuan", sort="na")
    private Integer consumeMoney;
    @Column(name="SUM(CASE t.TYPE_NAME WHEN 8 THEN t.MONEY ELSE 0 END)")
    @GridColumn(label="posid_countTable_replenishment_amount", width="110", columnType="custom", convert="convertFen2Yuan", sort="na")
    private Integer replenishmentAmount;
    @Column(name="(SUM (CASE t.TYPE_NAME WHEN 6 THEN t.MONEY WHEN 8 THEN t.MONEY WHEN 12 THEN t.MONEY ELSE 0 END))")
    @GridColumn(label="posid_countTable_total_expenditure", width="110", columnType="custom", convert="convertFen2Yuan", sort="na")
    private Integer totalExpenditure;
    @Column(name="SUM(CASE t.TYPE_NAME WHEN 9 THEN 1 ELSE 0 END)")
    private Integer correctionCount;
    @Column(name="SUM(CASE t.TYPE_NAME WHEN 9 THEN t.MONEY ELSE 0 END)")
    @GridColumn(label="posid_countTable_correction_amount", width="110", columnType="custom", convert="convertFen2Yuan", sort="na")
    private Integer correctionAmount;
    @Condition(value="t.PERSON_ID", equalTag="in")
    private String inPersonId;
    @Condition(value="(t.PERSON_NAME LIKE ''%{0}%'' OR t.PERSON_LAST_NAME LIKE ''%{0}%'')")
    private String likeName;
    @Condition(value="t.DEPT_NAME", equalTag="like")
    private String liekDeptName;
    @Condition(value="t.PERSON_PIN", equalTag="like")
    private String likePersonPin;
    @Condition(value="t.DEPT_ID", equalTag="in")
    private String inDeptId;
    @Condition(value="t.CREATE_TIME", equalTag=">=", toDate=true)
    protected String startDatetimeBegin;
    @Condition(value="t.CREATE_TIME", equalTag="<=", toDate=true)
    protected String startDatetimeEnd;
    @Condition(value="t.DEPT_ID IN (SELECT ud.AUTH_DEPT_ID FROM AUTH_USER_DEPT ud WHERE ud.AUTH_USER_ID=''{0}'')")
    private String userId;
    @Condition(value="t.HALLING_ID IN (SELECT pd.ID FROM POSID_DININGHALL pd WHERE pd.AUTH_AREA_ID IN (SELECT ud.AUTH_AREA_ID FROM AUTH_USER_AREA ud WHERE ud.AUTH_USER_ID=''{0}''))")
    private String diningAreaByUserId;

    public String getId() {
        return this.id;
    }

    public String getPersonId() {
        return this.personId;
    }

    public Integer getConsumeCount() {
        return this.consumeCount;
    }

    public Integer getConsumeMoney() {
        return this.consumeMoney;
    }

    public Integer getReplenishmentAmount() {
        return this.replenishmentAmount;
    }

    public Integer getTotalExpenditure() {
        return this.totalExpenditure;
    }

    public Integer getCorrectionCount() {
        return this.correctionCount;
    }

    public Integer getCorrectionAmount() {
        return this.correctionAmount;
    }

    public String getInPersonId() {
        return this.inPersonId;
    }

    public String getLikeName() {
        return this.likeName;
    }

    public String getLiekDeptName() {
        return this.liekDeptName;
    }

    public String getLikePersonPin() {
        return this.likePersonPin;
    }

    public String getInDeptId() {
        return this.inDeptId;
    }

    public String getStartDatetimeBegin() {
        return this.startDatetimeBegin;
    }

    public String getStartDatetimeEnd() {
        return this.startDatetimeEnd;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getDiningAreaByUserId() {
        return this.diningAreaByUserId;
    }

    public PosIDMonthlyTransactionItem setId(String id) {
        this.id = id;
        return this;
    }

    public PosIDMonthlyTransactionItem setPersonId(String personId) {
        this.personId = personId;
        return this;
    }

    public PosIDMonthlyTransactionItem setConsumeCount(Integer consumeCount) {
        this.consumeCount = consumeCount;
        return this;
    }

    public PosIDMonthlyTransactionItem setConsumeMoney(Integer consumeMoney) {
        this.consumeMoney = consumeMoney;
        return this;
    }

    public PosIDMonthlyTransactionItem setReplenishmentAmount(Integer replenishmentAmount) {
        this.replenishmentAmount = replenishmentAmount;
        return this;
    }

    public PosIDMonthlyTransactionItem setTotalExpenditure(Integer totalExpenditure) {
        this.totalExpenditure = totalExpenditure;
        return this;
    }

    public PosIDMonthlyTransactionItem setCorrectionCount(Integer correctionCount) {
        this.correctionCount = correctionCount;
        return this;
    }

    public PosIDMonthlyTransactionItem setCorrectionAmount(Integer correctionAmount) {
        this.correctionAmount = correctionAmount;
        return this;
    }

    public PosIDMonthlyTransactionItem setInPersonId(String inPersonId) {
        this.inPersonId = inPersonId;
        return this;
    }

    public PosIDMonthlyTransactionItem setLikeName(String likeName) {
        this.likeName = likeName;
        return this;
    }

    public PosIDMonthlyTransactionItem setLiekDeptName(String liekDeptName) {
        this.liekDeptName = liekDeptName;
        return this;
    }

    public PosIDMonthlyTransactionItem setLikePersonPin(String likePersonPin) {
        this.likePersonPin = likePersonPin;
        return this;
    }

    public PosIDMonthlyTransactionItem setInDeptId(String inDeptId) {
        this.inDeptId = inDeptId;
        return this;
    }

    public PosIDMonthlyTransactionItem setStartDatetimeBegin(String startDatetimeBegin) {
        this.startDatetimeBegin = startDatetimeBegin;
        return this;
    }

    public PosIDMonthlyTransactionItem setStartDatetimeEnd(String startDatetimeEnd) {
        this.startDatetimeEnd = startDatetimeEnd;
        return this;
    }

    public PosIDMonthlyTransactionItem setUserId(String userId) {
        this.userId = userId;
        return this;
    }

    public PosIDMonthlyTransactionItem setDiningAreaByUserId(String diningAreaByUserId) {
        this.diningAreaByUserId = diningAreaByUserId;
        return this;
    }

    public String toString() {
        return "PosIDMonthlyTransactionItem(id=" + this.getId() + ", personId=" + this.getPersonId() + ", consumeCount=" + this.getConsumeCount() + ", consumeMoney=" + this.getConsumeMoney() + ", replenishmentAmount=" + this.getReplenishmentAmount() + ", totalExpenditure=" + this.getTotalExpenditure() + ", correctionCount=" + this.getCorrectionCount() + ", correctionAmount=" + this.getCorrectionAmount() + ", inPersonId=" + this.getInPersonId() + ", likeName=" + this.getLikeName() + ", liekDeptName=" + this.getLiekDeptName() + ", likePersonPin=" + this.getLikePersonPin() + ", inDeptId=" + this.getInDeptId() + ", startDatetimeBegin=" + this.getStartDatetimeBegin() + ", startDatetimeEnd=" + this.getStartDatetimeEnd() + ", userId=" + this.getUserId() + ", diningAreaByUserId=" + this.getDiningAreaByUserId() + ")";
    }
}

