/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.posid.vo;

import com.zkteco.zkbiosecurity.base.annotation.Column;
import com.zkteco.zkbiosecurity.base.annotation.Condition;
import com.zkteco.zkbiosecurity.base.annotation.From;
import com.zkteco.zkbiosecurity.base.annotation.GridColumn;
import com.zkteco.zkbiosecurity.base.annotation.GridConfig;
import com.zkteco.zkbiosecurity.base.annotation.Where;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import java.util.UUID;

@From(after="POSID_TRANSACTIONCARD t LEFT JOIN POSID_ACCOUNT p ON p.PERSON_ID = t.PERSON_ID")
@Where(after="AND p.PERSON_ID IS NOT NULL")
@GridConfig(operate=true, idField="id", winHeight=400, winWidth=600)
public class PosIDMonthlyTransactionCardSumItem
extends BaseItem {
    @GridColumn(show=false)
    private String id = UUID.randomUUID().toString();
    @Column(name="SUM(CASE t.TYPE WHEN 1 THEN t.MONEY WHEN 11 THEN t.MONEY ELSE 0 END)")
    @GridColumn(label="posid_card_topUpSolde", width="110", columnType="custom", convert="convertFen2Yuan", sort="na")
    private Integer topUpSolde;
    @Column(name="SUM(CASE t.TYPE WHEN 1 THEN 1 ELSE 0 END)")
    private Integer topUpCashCount;
    @Column(name="SUM(CASE t.TYPE WHEN 1 THEN t.MONEY ELSE 0 END)")
    private Integer topUpCashMoney;
    @Column(name="SUM(CASE t.TYPE WHEN 4 THEN 1 ELSE 0 END)")
    private Integer allowanceCount;
    @Column(name="SUM(CASE t.TYPE WHEN 2 THEN 1 WHEN 3 THEN 1 WHEN 12 THEN 1 WHEN 11 THEN 1 ELSE 0 END)")
    private Integer topUpNatCount;
    @Column(name="SUM(CASE t.TYPE WHEN 2 THEN t.MONEY WHEN 3 THEN t.MONEY WHEN 12 THEN t.MONEY WHEN 11 THEN t.MONEY ELSE 0 END)")
    private Integer topUpNatMoney;
    @Column(name="SUM(CASE t.TYPE WHEN 2 THEN 1 WHEN 1 THEN 1 WHEN 3 THEN 1 WHEN 12 THEN 1 WHEN 11 THEN 1 ELSE 0 END)")
    private Integer topUpSoldeCount;
    @Column(name="SUM(CASE t.TYPE WHEN 2 THEN t.MONEY WHEN 1 THEN t.MONEY WHEN 3 THEN t.MONEY WHEN 12 THEN t.MONEY WHEN 11 THEN t.MONEY ELSE 0 END)")
    private Integer topUpSoldeMoney;
    @Column(name="SUM(CASE t.TYPE WHEN 4 THEN t.MONEY ELSE 0 END)")
    @GridColumn(label="posid_allowance_money", width="110", columnType="custom", convert="convertFen2Yuan", sort="na")
    private Integer allowanceMoney;
    @Column(name="SUM(CASE t.TYPE WHEN 1 THEN t.MONEY WHEN 11 THEN t.MONEY WHEN 4 THEN t.MONEY ELSE 0 END)")
    @GridColumn(label="posid_countTable_total_income", width="110", columnType="custom", convert="convertFen2Yuan", sort="na")
    private Integer totalIncome;
    @Column(name="SUM(CASE t.TYPE WHEN 5 THEN 1 ELSE 0 END)")
    private Integer refundSoldeCount;
    @Column(name="SUM(CASE t.TYPE WHEN 5 THEN t.MONEY ELSE 0 END)")
    @GridColumn(label="posid_card_refundSolde", width="110", columnType="custom", convert="convertFen2Yuan", sort="na")
    private Integer refundSolde;
    @Column(name="SUM(CASE t.TYPE WHEN 17 THEN 1 ELSE 0 END)")
    @GridColumn(label="posid_allowance_refund_num", width="100")
    private Integer allowanceRefundCount;
    @Column(name="SUM(CASE t.TYPE WHEN 17 THEN t.MONEY ELSE 0 END)")
    @GridColumn(label="posid_allowance_refund_money", width="120", columnType="custom", convert="convertFen2Yuan")
    private Integer allowanceRefundTotal;
    @Condition(value="(t.PERSON_NAME LIKE ''%{0}%'' OR t.PERSON_LAST_NAME LIKE ''%{0}%'')")
    private String likeName;
    @Condition(value="t.DEPT_NAME", equalTag="like")
    private String liekDeptName;
    @Condition(value="t.PERSON_PIN", equalTag="like")
    private String likePersonPin;
    @Condition(value="t.DEPT_ID", equalTag="in")
    private String inDeptId;
    @Condition(value="t.CREATE_TIME", equalTag=">=", toDate=true)
    protected String startDatetimeBegin;
    @Condition(value="t.CREATE_TIME", equalTag="<=", toDate=true)
    protected String startDatetimeEnd;
    @Condition(value="t.DEPT_ID IN (SELECT ud.AUTH_DEPT_ID FROM AUTH_USER_DEPT ud WHERE ud.AUTH_USER_ID=''{0}'')")
    private String userId;

    public String getId() {
        return this.id;
    }

    public Integer getTopUpSolde() {
        return this.topUpSolde;
    }

    public Integer getTopUpCashCount() {
        return this.topUpCashCount;
    }

    public Integer getTopUpCashMoney() {
        return this.topUpCashMoney;
    }

    public Integer getAllowanceCount() {
        return this.allowanceCount;
    }

    public Integer getTopUpNatCount() {
        return this.topUpNatCount;
    }

    public Integer getTopUpNatMoney() {
        return this.topUpNatMoney;
    }

    public Integer getTopUpSoldeCount() {
        return this.topUpSoldeCount;
    }

    public Integer getTopUpSoldeMoney() {
        return this.topUpSoldeMoney;
    }

    public Integer getAllowanceMoney() {
        return this.allowanceMoney;
    }

    public Integer getTotalIncome() {
        return this.totalIncome;
    }

    public Integer getRefundSoldeCount() {
        return this.refundSoldeCount;
    }

    public Integer getRefundSolde() {
        return this.refundSolde;
    }

    public Integer getAllowanceRefundCount() {
        return this.allowanceRefundCount;
    }

    public Integer getAllowanceRefundTotal() {
        return this.allowanceRefundTotal;
    }

    public String getLikeName() {
        return this.likeName;
    }

    public String getLiekDeptName() {
        return this.liekDeptName;
    }

    public String getLikePersonPin() {
        return this.likePersonPin;
    }

    public String getInDeptId() {
        return this.inDeptId;
    }

    public String getStartDatetimeBegin() {
        return this.startDatetimeBegin;
    }

    public String getStartDatetimeEnd() {
        return this.startDatetimeEnd;
    }

    public String getUserId() {
        return this.userId;
    }

    public PosIDMonthlyTransactionCardSumItem setId(String id) {
        this.id = id;
        return this;
    }

    public PosIDMonthlyTransactionCardSumItem setTopUpSolde(Integer topUpSolde) {
        this.topUpSolde = topUpSolde;
        return this;
    }

    public PosIDMonthlyTransactionCardSumItem setTopUpCashCount(Integer topUpCashCount) {
        this.topUpCashCount = topUpCashCount;
        return this;
    }

    public PosIDMonthlyTransactionCardSumItem setTopUpCashMoney(Integer topUpCashMoney) {
        this.topUpCashMoney = topUpCashMoney;
        return this;
    }

    public PosIDMonthlyTransactionCardSumItem setAllowanceCount(Integer allowanceCount) {
        this.allowanceCount = allowanceCount;
        return this;
    }

    public PosIDMonthlyTransactionCardSumItem setTopUpNatCount(Integer topUpNatCount) {
        this.topUpNatCount = topUpNatCount;
        return this;
    }

    public PosIDMonthlyTransactionCardSumItem setTopUpNatMoney(Integer topUpNatMoney) {
        this.topUpNatMoney = topUpNatMoney;
        return this;
    }

    public PosIDMonthlyTransactionCardSumItem setTopUpSoldeCount(Integer topUpSoldeCount) {
        this.topUpSoldeCount = topUpSoldeCount;
        return this;
    }

    public PosIDMonthlyTransactionCardSumItem setTopUpSoldeMoney(Integer topUpSoldeMoney) {
        this.topUpSoldeMoney = topUpSoldeMoney;
        return this;
    }

    public PosIDMonthlyTransactionCardSumItem setAllowanceMoney(Integer allowanceMoney) {
        this.allowanceMoney = allowanceMoney;
        return this;
    }

    public PosIDMonthlyTransactionCardSumItem setTotalIncome(Integer totalIncome) {
        this.totalIncome = totalIncome;
        return this;
    }

    public PosIDMonthlyTransactionCardSumItem setRefundSoldeCount(Integer refundSoldeCount) {
        this.refundSoldeCount = refundSoldeCount;
        return this;
    }

    public PosIDMonthlyTransactionCardSumItem setRefundSolde(Integer refundSolde) {
        this.refundSolde = refundSolde;
        return this;
    }

    public PosIDMonthlyTransactionCardSumItem setAllowanceRefundCount(Integer allowanceRefundCount) {
        this.allowanceRefundCount = allowanceRefundCount;
        return this;
    }

    public PosIDMonthlyTransactionCardSumItem setAllowanceRefundTotal(Integer allowanceRefundTotal) {
        this.allowanceRefundTotal = allowanceRefundTotal;
        return this;
    }

    public PosIDMonthlyTransactionCardSumItem setLikeName(String likeName) {
        this.likeName = likeName;
        return this;
    }

    public PosIDMonthlyTransactionCardSumItem setLiekDeptName(String liekDeptName) {
        this.liekDeptName = liekDeptName;
        return this;
    }

    public PosIDMonthlyTransactionCardSumItem setLikePersonPin(String likePersonPin) {
        this.likePersonPin = likePersonPin;
        return this;
    }

    public PosIDMonthlyTransactionCardSumItem setInDeptId(String inDeptId) {
        this.inDeptId = inDeptId;
        return this;
    }

    public PosIDMonthlyTransactionCardSumItem setStartDatetimeBegin(String startDatetimeBegin) {
        this.startDatetimeBegin = startDatetimeBegin;
        return this;
    }

    public PosIDMonthlyTransactionCardSumItem setStartDatetimeEnd(String startDatetimeEnd) {
        this.startDatetimeEnd = startDatetimeEnd;
        return this;
    }

    public PosIDMonthlyTransactionCardSumItem setUserId(String userId) {
        this.userId = userId;
        return this;
    }

    public String toString() {
        return "PosIDMonthlyTransactionCardSumItem(id=" + this.getId() + ", topUpSolde=" + this.getTopUpSolde() + ", topUpCashCount=" + this.getTopUpCashCount() + ", topUpCashMoney=" + this.getTopUpCashMoney() + ", allowanceCount=" + this.getAllowanceCount() + ", topUpNatCount=" + this.getTopUpNatCount() + ", topUpNatMoney=" + this.getTopUpNatMoney() + ", topUpSoldeCount=" + this.getTopUpSoldeCount() + ", topUpSoldeMoney=" + this.getTopUpSoldeMoney() + ", allowanceMoney=" + this.getAllowanceMoney() + ", totalIncome=" + this.getTotalIncome() + ", refundSoldeCount=" + this.getRefundSoldeCount() + ", refundSolde=" + this.getRefundSolde() + ", allowanceRefundCount=" + this.getAllowanceRefundCount() + ", allowanceRefundTotal=" + this.getAllowanceRefundTotal() + ", likeName=" + this.getLikeName() + ", liekDeptName=" + this.getLiekDeptName() + ", likePersonPin=" + this.getLikePersonPin() + ", inDeptId=" + this.getInDeptId() + ", startDatetimeBegin=" + this.getStartDatetimeBegin() + ", startDatetimeEnd=" + this.getStartDatetimeEnd() + ", userId=" + this.getUserId() + ")";
    }
}

