/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.posid.vo;

import com.zkteco.zkbiosecurity.base.annotation.Column;
import com.zkteco.zkbiosecurity.base.annotation.Condition;
import com.zkteco.zkbiosecurity.base.annotation.From;
import com.zkteco.zkbiosecurity.base.annotation.GridColumn;
import com.zkteco.zkbiosecurity.base.annotation.GridConfig;
import com.zkteco.zkbiosecurity.base.annotation.OrderBy;
import com.zkteco.zkbiosecurity.base.annotation.Where;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import java.util.UUID;

@From(after="POSID_ACCOUNT t")
@Where(after="AND t.PERSON_ID IS NOT NULL")
@OrderBy(after="t.CREATE_TIME DESC")
@GridConfig(operate=true, idField="id", winHeight=400, winWidth=600)
public class PosIDMonthlyStatementItem
extends BaseItem {
    @GridColumn(show=false)
    private String id = UUID.randomUUID().toString();
    @Column(name="t.PERSON_ID")
    private String personId;
    @Column(name="t.PERSON_PIN")
    @GridColumn(label="pers_person_pin", width="100", i18n=true, encryptMode="${pers.pin.encryptMode}", encryptProp="${pers.pin.encryptProp}")
    private String personPin;
    @GridColumn(label="pers_person_name", width="120", sort="na", encryptMode="${pers.name.encryptMode}", encryptProp="${pers.name.encryptProp}")
    private String personName;
    @GridColumn(label="pers_person_lastName", width="120", showExpression="#language!='zh_CN'", sort="na", encryptMode="${pers.lastName.encryptMode}", encryptProp="${pers.lastName.encryptProp}")
    private String personLastName;
    @GridColumn(label="posid_card_deptName", width="120", sort="na")
    private String deptName;
    @GridColumn(label="posid_countTable_monthly_star_amount", width="140", columnType="custom", convert="convertFen2Yuan", sort="na")
    private Integer monthlyStarAmount;
    @GridColumn(label="posid_countTable_monthly_end_amount", width="140", columnType="custom", convert="convertFen2Yuan", sort="na")
    private Integer monthlyEndAmount;
    @GridColumn(label="posid_recharge_cashCount", width="140", sort="na")
    private Integer topUpCashCount;
    @GridColumn(label="posid_recharge_cashMoney", width="140", columnType="custom", convert="convertFen2Yuan", sort="na")
    private Integer topUpCashMoney;
    @GridColumn(label="posid_countTable_allowanceTimes", width="140", sort="na")
    private Integer allowanceCount;
    @GridColumn(label="posid_allowance_money", width="140", columnType="custom", convert="convertFen2Yuan", sort="na")
    private Integer allowanceMoney;
    @GridColumn(label="posid_recharge_natCount", width="140", sort="na", showExpression="#language=='zh_CN'")
    private Integer topUpNatCount;
    @GridColumn(label="posid_recharge_natMoney", width="140", columnType="custom", convert="convertFen2Yuan", sort="na", showExpression="#language=='zh_CN'")
    private Integer topUpNatMoney;
    @GridColumn(label="posid_countTable_errorTimes", width="140", sort="na")
    private Integer correctionCount;
    @GridColumn(label="posid_countTable_correction_amount", width="140", columnType="custom", convert="convertFen2Yuan", sort="na")
    private Integer correctionAmount;
    @GridColumn(label="posid_countTable_topUpSoldeCount", width="140", sort="na")
    private Integer topUpSoldeCount;
    @GridColumn(label="posid_countTable_topUpSoldeMoney", width="140", columnType="custom", convert="convertFen2Yuan", sort="na")
    private Integer topUpSoldeMoney;
    @GridColumn(label="posid_countTable_conTimes", width="140", sort="na")
    private Integer consumeCount;
    @GridColumn(label="posid_cus_money", width="140", columnType="custom", convert="convertFen2Yuan", sort="na")
    private Integer consumeMoney;
    @GridColumn(label="posid_countTable_replenishment_amount", width="140", columnType="custom", convert="convertFen2Yuan", sort="na")
    private Integer replenishmentAmount;
    @GridColumn(label="posid_incomeExpendConsume_refundTimes", width="140", sort="na")
    private Integer refundSoldeCount;
    @GridColumn(label="posid_card_refundSolde", width="140", columnType="custom", convert="convertFen2Yuan", sort="na")
    private Integer refundSolde;
    @GridColumn(label="posid_allowance_refund_num", width="100")
    private Integer allowanceRefundCount;
    @GridColumn(label="posid_allowance_refund_money", width="120", columnType="custom", convert="convertFen2Yuan")
    private Integer allowanceRefundTotal;
    @GridColumn(label="posid_countTable_total_expenditure", width="140", columnType="custom", convert="convertFen2Yuan", sort="na")
    private Integer totalExpenditure;
    @GridColumn(label="posid_countTable_total_income", width="140", columnType="custom", convert="convertFen2Yuan", sort="na")
    private Integer totalIncome;
    @Condition(value="(t.PERSON_NAME LIKE ''%{0}%'' OR t.PERSON_LAST_NAME LIKE ''%{0}%'')")
    private String likeName;
    @Condition(value="t.DEPT_NAME", equalTag="like")
    private String liekDeptName;
    @Condition(value="t.PERSON_PIN", equalTag="like")
    private String likePersonPin;
    @Condition(value="t.DEPT_ID", equalTag="in")
    private String inDeptId;
    @Condition(value="t.DEPT_ID IN (SELECT ud.AUTH_DEPT_ID FROM AUTH_USER_DEPT ud WHERE ud.AUTH_USER_ID=''{0}'')")
    private String userId;
    private String deptId;
    private String isIncludeLower;
    private String startDatetimeBegin;
    private String startDatetimeEnd;
    private String startDateSqlFormat;
    private String endDateSqlFormat;
    private String diningAreaByUserId;

    public String getId() {
        return this.id;
    }

    public String getPersonId() {
        return this.personId;
    }

    public String getPersonPin() {
        return this.personPin;
    }

    public String getPersonName() {
        return this.personName;
    }

    public String getPersonLastName() {
        return this.personLastName;
    }

    public String getDeptName() {
        return this.deptName;
    }

    public Integer getMonthlyStarAmount() {
        return this.monthlyStarAmount;
    }

    public Integer getMonthlyEndAmount() {
        return this.monthlyEndAmount;
    }

    public Integer getTopUpCashCount() {
        return this.topUpCashCount;
    }

    public Integer getTopUpCashMoney() {
        return this.topUpCashMoney;
    }

    public Integer getAllowanceCount() {
        return this.allowanceCount;
    }

    public Integer getAllowanceMoney() {
        return this.allowanceMoney;
    }

    public Integer getTopUpNatCount() {
        return this.topUpNatCount;
    }

    public Integer getTopUpNatMoney() {
        return this.topUpNatMoney;
    }

    public Integer getCorrectionCount() {
        return this.correctionCount;
    }

    public Integer getCorrectionAmount() {
        return this.correctionAmount;
    }

    public Integer getTopUpSoldeCount() {
        return this.topUpSoldeCount;
    }

    public Integer getTopUpSoldeMoney() {
        return this.topUpSoldeMoney;
    }

    public Integer getConsumeCount() {
        return this.consumeCount;
    }

    public Integer getConsumeMoney() {
        return this.consumeMoney;
    }

    public Integer getReplenishmentAmount() {
        return this.replenishmentAmount;
    }

    public Integer getRefundSoldeCount() {
        return this.refundSoldeCount;
    }

    public Integer getRefundSolde() {
        return this.refundSolde;
    }

    public Integer getAllowanceRefundCount() {
        return this.allowanceRefundCount;
    }

    public Integer getAllowanceRefundTotal() {
        return this.allowanceRefundTotal;
    }

    public Integer getTotalExpenditure() {
        return this.totalExpenditure;
    }

    public Integer getTotalIncome() {
        return this.totalIncome;
    }

    public String getLikeName() {
        return this.likeName;
    }

    public String getLiekDeptName() {
        return this.liekDeptName;
    }

    public String getLikePersonPin() {
        return this.likePersonPin;
    }

    public String getInDeptId() {
        return this.inDeptId;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getDeptId() {
        return this.deptId;
    }

    public String getIsIncludeLower() {
        return this.isIncludeLower;
    }

    public String getStartDatetimeBegin() {
        return this.startDatetimeBegin;
    }

    public String getStartDatetimeEnd() {
        return this.startDatetimeEnd;
    }

    public String getStartDateSqlFormat() {
        return this.startDateSqlFormat;
    }

    public String getEndDateSqlFormat() {
        return this.endDateSqlFormat;
    }

    public String getDiningAreaByUserId() {
        return this.diningAreaByUserId;
    }

    public PosIDMonthlyStatementItem setId(String id) {
        this.id = id;
        return this;
    }

    public PosIDMonthlyStatementItem setPersonId(String personId) {
        this.personId = personId;
        return this;
    }

    public PosIDMonthlyStatementItem setPersonPin(String personPin) {
        this.personPin = personPin;
        return this;
    }

    public PosIDMonthlyStatementItem setPersonName(String personName) {
        this.personName = personName;
        return this;
    }

    public PosIDMonthlyStatementItem setPersonLastName(String personLastName) {
        this.personLastName = personLastName;
        return this;
    }

    public PosIDMonthlyStatementItem setDeptName(String deptName) {
        this.deptName = deptName;
        return this;
    }

    public PosIDMonthlyStatementItem setMonthlyStarAmount(Integer monthlyStarAmount) {
        this.monthlyStarAmount = monthlyStarAmount;
        return this;
    }

    public PosIDMonthlyStatementItem setMonthlyEndAmount(Integer monthlyEndAmount) {
        this.monthlyEndAmount = monthlyEndAmount;
        return this;
    }

    public PosIDMonthlyStatementItem setTopUpCashCount(Integer topUpCashCount) {
        this.topUpCashCount = topUpCashCount;
        return this;
    }

    public PosIDMonthlyStatementItem setTopUpCashMoney(Integer topUpCashMoney) {
        this.topUpCashMoney = topUpCashMoney;
        return this;
    }

    public PosIDMonthlyStatementItem setAllowanceCount(Integer allowanceCount) {
        this.allowanceCount = allowanceCount;
        return this;
    }

    public PosIDMonthlyStatementItem setAllowanceMoney(Integer allowanceMoney) {
        this.allowanceMoney = allowanceMoney;
        return this;
    }

    public PosIDMonthlyStatementItem setTopUpNatCount(Integer topUpNatCount) {
        this.topUpNatCount = topUpNatCount;
        return this;
    }

    public PosIDMonthlyStatementItem setTopUpNatMoney(Integer topUpNatMoney) {
        this.topUpNatMoney = topUpNatMoney;
        return this;
    }

    public PosIDMonthlyStatementItem setCorrectionCount(Integer correctionCount) {
        this.correctionCount = correctionCount;
        return this;
    }

    public PosIDMonthlyStatementItem setCorrectionAmount(Integer correctionAmount) {
        this.correctionAmount = correctionAmount;
        return this;
    }

    public PosIDMonthlyStatementItem setTopUpSoldeCount(Integer topUpSoldeCount) {
        this.topUpSoldeCount = topUpSoldeCount;
        return this;
    }

    public PosIDMonthlyStatementItem setTopUpSoldeMoney(Integer topUpSoldeMoney) {
        this.topUpSoldeMoney = topUpSoldeMoney;
        return this;
    }

    public PosIDMonthlyStatementItem setConsumeCount(Integer consumeCount) {
        this.consumeCount = consumeCount;
        return this;
    }

    public PosIDMonthlyStatementItem setConsumeMoney(Integer consumeMoney) {
        this.consumeMoney = consumeMoney;
        return this;
    }

    public PosIDMonthlyStatementItem setReplenishmentAmount(Integer replenishmentAmount) {
        this.replenishmentAmount = replenishmentAmount;
        return this;
    }

    public PosIDMonthlyStatementItem setRefundSoldeCount(Integer refundSoldeCount) {
        this.refundSoldeCount = refundSoldeCount;
        return this;
    }

    public PosIDMonthlyStatementItem setRefundSolde(Integer refundSolde) {
        this.refundSolde = refundSolde;
        return this;
    }

    public PosIDMonthlyStatementItem setAllowanceRefundCount(Integer allowanceRefundCount) {
        this.allowanceRefundCount = allowanceRefundCount;
        return this;
    }

    public PosIDMonthlyStatementItem setAllowanceRefundTotal(Integer allowanceRefundTotal) {
        this.allowanceRefundTotal = allowanceRefundTotal;
        return this;
    }

    public PosIDMonthlyStatementItem setTotalExpenditure(Integer totalExpenditure) {
        this.totalExpenditure = totalExpenditure;
        return this;
    }

    public PosIDMonthlyStatementItem setTotalIncome(Integer totalIncome) {
        this.totalIncome = totalIncome;
        return this;
    }

    public PosIDMonthlyStatementItem setLikeName(String likeName) {
        this.likeName = likeName;
        return this;
    }

    public PosIDMonthlyStatementItem setLiekDeptName(String liekDeptName) {
        this.liekDeptName = liekDeptName;
        return this;
    }

    public PosIDMonthlyStatementItem setLikePersonPin(String likePersonPin) {
        this.likePersonPin = likePersonPin;
        return this;
    }

    public PosIDMonthlyStatementItem setInDeptId(String inDeptId) {
        this.inDeptId = inDeptId;
        return this;
    }

    public PosIDMonthlyStatementItem setUserId(String userId) {
        this.userId = userId;
        return this;
    }

    public PosIDMonthlyStatementItem setDeptId(String deptId) {
        this.deptId = deptId;
        return this;
    }

    public PosIDMonthlyStatementItem setIsIncludeLower(String isIncludeLower) {
        this.isIncludeLower = isIncludeLower;
        return this;
    }

    public PosIDMonthlyStatementItem setStartDatetimeBegin(String startDatetimeBegin) {
        this.startDatetimeBegin = startDatetimeBegin;
        return this;
    }

    public PosIDMonthlyStatementItem setStartDatetimeEnd(String startDatetimeEnd) {
        this.startDatetimeEnd = startDatetimeEnd;
        return this;
    }

    public PosIDMonthlyStatementItem setStartDateSqlFormat(String startDateSqlFormat) {
        this.startDateSqlFormat = startDateSqlFormat;
        return this;
    }

    public PosIDMonthlyStatementItem setEndDateSqlFormat(String endDateSqlFormat) {
        this.endDateSqlFormat = endDateSqlFormat;
        return this;
    }

    public PosIDMonthlyStatementItem setDiningAreaByUserId(String diningAreaByUserId) {
        this.diningAreaByUserId = diningAreaByUserId;
        return this;
    }

    public String toString() {
        return "PosIDMonthlyStatementItem(id=" + this.getId() + ", personId=" + this.getPersonId() + ", personPin=" + this.getPersonPin() + ", personName=" + this.getPersonName() + ", personLastName=" + this.getPersonLastName() + ", deptName=" + this.getDeptName() + ", monthlyStarAmount=" + this.getMonthlyStarAmount() + ", monthlyEndAmount=" + this.getMonthlyEndAmount() + ", topUpCashCount=" + this.getTopUpCashCount() + ", topUpCashMoney=" + this.getTopUpCashMoney() + ", allowanceCount=" + this.getAllowanceCount() + ", allowanceMoney=" + this.getAllowanceMoney() + ", topUpNatCount=" + this.getTopUpNatCount() + ", topUpNatMoney=" + this.getTopUpNatMoney() + ", correctionCount=" + this.getCorrectionCount() + ", correctionAmount=" + this.getCorrectionAmount() + ", topUpSoldeCount=" + this.getTopUpSoldeCount() + ", topUpSoldeMoney=" + this.getTopUpSoldeMoney() + ", consumeCount=" + this.getConsumeCount() + ", consumeMoney=" + this.getConsumeMoney() + ", replenishmentAmount=" + this.getReplenishmentAmount() + ", refundSoldeCount=" + this.getRefundSoldeCount() + ", refundSolde=" + this.getRefundSolde() + ", allowanceRefundCount=" + this.getAllowanceRefundCount() + ", allowanceRefundTotal=" + this.getAllowanceRefundTotal() + ", totalExpenditure=" + this.getTotalExpenditure() + ", totalIncome=" + this.getTotalIncome() + ", likeName=" + this.getLikeName() + ", liekDeptName=" + this.getLiekDeptName() + ", likePersonPin=" + this.getLikePersonPin() + ", inDeptId=" + this.getInDeptId() + ", userId=" + this.getUserId() + ", deptId=" + this.getDeptId() + ", isIncludeLower=" + this.getIsIncludeLower() + ", startDatetimeBegin=" + this.getStartDatetimeBegin() + ", startDatetimeEnd=" + this.getStartDatetimeEnd() + ", startDateSqlFormat=" + this.getStartDateSqlFormat() + ", endDateSqlFormat=" + this.getEndDateSqlFormat() + ", diningAreaByUserId=" + this.getDiningAreaByUserId() + ")";
    }
}

