/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.posid.vo;

import com.zkteco.zkbiosecurity.base.annotation.Column;
import com.zkteco.zkbiosecurity.base.annotation.Condition;
import com.zkteco.zkbiosecurity.base.annotation.From;
import com.zkteco.zkbiosecurity.base.annotation.GridColumn;
import com.zkteco.zkbiosecurity.base.annotation.GridConfig;
import com.zkteco.zkbiosecurity.base.annotation.OrderBy;
import com.zkteco.zkbiosecurity.base.annotation.Where;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import java.util.UUID;

@From(after="POSID_ACCOUNT t")
@Where(after="AND t.PERSON_ID IS NOT NULL")
@OrderBy(after="t.CREATE_TIME DESC")
@GridConfig(operate=true, idField="id", winHeight=400, winWidth=600)
public class PosIDMonthlyStatementExportItem
extends BaseItem {
    @GridColumn(show=false)
    private String id = UUID.randomUUID().toString();
    @Column(name="t.PERSON_ID")
    private String personId;
    @Column(name="t.PERSON_PIN")
    @GridColumn(label="pers_person_pin", width="100", i18n=true, encryptMode="${pers.pin.encryptMode}", encryptProp="${pers.pin.encryptProp}")
    private String personPin;
    @GridColumn(label="pers_person_name", width="100", sort="na", encryptMode="${pers.name.encryptMode}", encryptProp="${pers.name.encryptProp}")
    private String personName;
    @GridColumn(label="pers_person_lastName", width="80", showExpression="#language!='zh_CN'", sort="na", encryptMode="${pers.lastName.encryptMode}", encryptProp="${pers.lastName.encryptProp}")
    private String personLastName;
    @GridColumn(label="posid_card_deptName", width="110", sort="na")
    private String deptName;
    @GridColumn(label="posid_countTable_monthly_star_amount", width="110", columnType="custom", convert="convertFen2Yuan", sort="na")
    private Double monthlyStarAmount;
    @GridColumn(label="posid_countTable_monthly_end_amount", width="110", columnType="custom", convert="convertFen2Yuan", sort="na")
    private Double monthlyEndAmount;
    @GridColumn(label="posid_recharge_cashCount", width="140", sort="na")
    private Integer topUpCashCount;
    @GridColumn(label="posid_recharge_cashMoney", width="140", columnType="custom", convert="convertFen2Yuan", sort="na")
    private Double topUpCashMoney;
    @GridColumn(label="posid_card_topUpSolde", width="110", columnType="custom", convert="convertFen2Yuan", sort="na", show=false)
    private Double topUpSolde;
    @GridColumn(label="posid_countTable_allowanceTimes", width="140", sort="na")
    private Integer allowanceCount;
    @GridColumn(label="posid_allowance_money", width="110", columnType="custom", convert="convertFen2Yuan", sort="na")
    private Double allowanceMoney;
    @GridColumn(label="posid_recharge_natCount", width="140", sort="na", showExpression="#language=='zh_CN'")
    private Integer topUpNatCount;
    @GridColumn(label="posid_recharge_natMoney", width="140", columnType="custom", convert="convertFen2Yuan", sort="na", showExpression="#language=='zh_CN'")
    private Double topUpNatMoney;
    @GridColumn(label="posid_countTable_errorTimes", width="140", sort="na")
    private Integer correctionCount;
    @GridColumn(label="posid_countTable_correction_amount", width="110", columnType="custom", convert="convertFen2Yuan", sort="na")
    private Double correctionAmount;
    @GridColumn(label="posid_countTable_topUpSoldeCount", width="140", sort="na")
    private Integer topUpSoldeCount;
    @GridColumn(label="posid_countTable_topUpSoldeMoney", width="140", columnType="custom", convert="convertFen2Yuan", sort="na")
    private Double topUpSoldeMoney;
    @GridColumn(label="posid_countTable_conTimes", width="140", sort="na")
    private Integer consumeCount;
    @GridColumn(label="posid_cus_money", width="110", columnType="custom", convert="convertFen2Yuan", sort="na")
    private Double consumeMoney;
    @GridColumn(label="posid_countTable_replenishment_amount", width="110", columnType="custom", convert="convertFen2Yuan", sort="na", show=false)
    private Double replenishmentAmount;
    @GridColumn(label="posid_incomeExpendConsume_refundTimes", width="140", sort="na")
    private Integer refundSoldeCount;
    @GridColumn(label="posid_card_refundSolde", width="110", columnType="custom", convert="convertFen2Yuan", sort="na")
    private Double refundSolde;
    @GridColumn(label="posid_allowance_refund_num", width="100")
    private Integer allowanceRefundCount;
    @GridColumn(label="posid_allowance_refund_money", width="120", columnType="custom", convert="convertFen2Yuan")
    private Double allowanceRefundTotal;
    @GridColumn(label="posid_countTable_total_expenditure", width="110", columnType="custom", convert="convertFen2Yuan", sort="na")
    private Double totalExpenditure;
    @GridColumn(label="posid_countTable_total_income", width="110", columnType="custom", convert="convertFen2Yuan", sort="na")
    private Double totalIncome;
    @Condition(value="(t.PERSON_NAME LIKE ''%{0}%'' OR t.PERSON_LAST_NAME LIKE ''%{0}%'')")
    private String likeName;
    @Condition(value="t.DEPT_NAME", equalTag="like")
    private String liekDeptName;
    @Condition(value="t.PERSON_PIN", equalTag="like")
    private String likePersonPin;
    @Condition(value="t.DEPT_ID", equalTag="in")
    private String inDeptId;
    protected String startDatetimeBegin;
    protected String startDatetimeEnd;

    public String getId() {
        return this.id;
    }

    public String getPersonId() {
        return this.personId;
    }

    public String getPersonPin() {
        return this.personPin;
    }

    public String getPersonName() {
        return this.personName;
    }

    public String getPersonLastName() {
        return this.personLastName;
    }

    public String getDeptName() {
        return this.deptName;
    }

    public Double getMonthlyStarAmount() {
        return this.monthlyStarAmount;
    }

    public Double getMonthlyEndAmount() {
        return this.monthlyEndAmount;
    }

    public Integer getTopUpCashCount() {
        return this.topUpCashCount;
    }

    public Double getTopUpCashMoney() {
        return this.topUpCashMoney;
    }

    public Double getTopUpSolde() {
        return this.topUpSolde;
    }

    public Integer getAllowanceCount() {
        return this.allowanceCount;
    }

    public Double getAllowanceMoney() {
        return this.allowanceMoney;
    }

    public Integer getTopUpNatCount() {
        return this.topUpNatCount;
    }

    public Double getTopUpNatMoney() {
        return this.topUpNatMoney;
    }

    public Integer getCorrectionCount() {
        return this.correctionCount;
    }

    public Double getCorrectionAmount() {
        return this.correctionAmount;
    }

    public Integer getTopUpSoldeCount() {
        return this.topUpSoldeCount;
    }

    public Double getTopUpSoldeMoney() {
        return this.topUpSoldeMoney;
    }

    public Integer getConsumeCount() {
        return this.consumeCount;
    }

    public Double getConsumeMoney() {
        return this.consumeMoney;
    }

    public Double getReplenishmentAmount() {
        return this.replenishmentAmount;
    }

    public Integer getRefundSoldeCount() {
        return this.refundSoldeCount;
    }

    public Double getRefundSolde() {
        return this.refundSolde;
    }

    public Integer getAllowanceRefundCount() {
        return this.allowanceRefundCount;
    }

    public Double getAllowanceRefundTotal() {
        return this.allowanceRefundTotal;
    }

    public Double getTotalExpenditure() {
        return this.totalExpenditure;
    }

    public Double getTotalIncome() {
        return this.totalIncome;
    }

    public String getLikeName() {
        return this.likeName;
    }

    public String getLiekDeptName() {
        return this.liekDeptName;
    }

    public String getLikePersonPin() {
        return this.likePersonPin;
    }

    public String getInDeptId() {
        return this.inDeptId;
    }

    public String getStartDatetimeBegin() {
        return this.startDatetimeBegin;
    }

    public String getStartDatetimeEnd() {
        return this.startDatetimeEnd;
    }

    public PosIDMonthlyStatementExportItem setId(String id) {
        this.id = id;
        return this;
    }

    public PosIDMonthlyStatementExportItem setPersonId(String personId) {
        this.personId = personId;
        return this;
    }

    public PosIDMonthlyStatementExportItem setPersonPin(String personPin) {
        this.personPin = personPin;
        return this;
    }

    public PosIDMonthlyStatementExportItem setPersonName(String personName) {
        this.personName = personName;
        return this;
    }

    public PosIDMonthlyStatementExportItem setPersonLastName(String personLastName) {
        this.personLastName = personLastName;
        return this;
    }

    public PosIDMonthlyStatementExportItem setDeptName(String deptName) {
        this.deptName = deptName;
        return this;
    }

    public PosIDMonthlyStatementExportItem setMonthlyStarAmount(Double monthlyStarAmount) {
        this.monthlyStarAmount = monthlyStarAmount;
        return this;
    }

    public PosIDMonthlyStatementExportItem setMonthlyEndAmount(Double monthlyEndAmount) {
        this.monthlyEndAmount = monthlyEndAmount;
        return this;
    }

    public PosIDMonthlyStatementExportItem setTopUpCashCount(Integer topUpCashCount) {
        this.topUpCashCount = topUpCashCount;
        return this;
    }

    public PosIDMonthlyStatementExportItem setTopUpCashMoney(Double topUpCashMoney) {
        this.topUpCashMoney = topUpCashMoney;
        return this;
    }

    public PosIDMonthlyStatementExportItem setTopUpSolde(Double topUpSolde) {
        this.topUpSolde = topUpSolde;
        return this;
    }

    public PosIDMonthlyStatementExportItem setAllowanceCount(Integer allowanceCount) {
        this.allowanceCount = allowanceCount;
        return this;
    }

    public PosIDMonthlyStatementExportItem setAllowanceMoney(Double allowanceMoney) {
        this.allowanceMoney = allowanceMoney;
        return this;
    }

    public PosIDMonthlyStatementExportItem setTopUpNatCount(Integer topUpNatCount) {
        this.topUpNatCount = topUpNatCount;
        return this;
    }

    public PosIDMonthlyStatementExportItem setTopUpNatMoney(Double topUpNatMoney) {
        this.topUpNatMoney = topUpNatMoney;
        return this;
    }

    public PosIDMonthlyStatementExportItem setCorrectionCount(Integer correctionCount) {
        this.correctionCount = correctionCount;
        return this;
    }

    public PosIDMonthlyStatementExportItem setCorrectionAmount(Double correctionAmount) {
        this.correctionAmount = correctionAmount;
        return this;
    }

    public PosIDMonthlyStatementExportItem setTopUpSoldeCount(Integer topUpSoldeCount) {
        this.topUpSoldeCount = topUpSoldeCount;
        return this;
    }

    public PosIDMonthlyStatementExportItem setTopUpSoldeMoney(Double topUpSoldeMoney) {
        this.topUpSoldeMoney = topUpSoldeMoney;
        return this;
    }

    public PosIDMonthlyStatementExportItem setConsumeCount(Integer consumeCount) {
        this.consumeCount = consumeCount;
        return this;
    }

    public PosIDMonthlyStatementExportItem setConsumeMoney(Double consumeMoney) {
        this.consumeMoney = consumeMoney;
        return this;
    }

    public PosIDMonthlyStatementExportItem setReplenishmentAmount(Double replenishmentAmount) {
        this.replenishmentAmount = replenishmentAmount;
        return this;
    }

    public PosIDMonthlyStatementExportItem setRefundSoldeCount(Integer refundSoldeCount) {
        this.refundSoldeCount = refundSoldeCount;
        return this;
    }

    public PosIDMonthlyStatementExportItem setRefundSolde(Double refundSolde) {
        this.refundSolde = refundSolde;
        return this;
    }

    public PosIDMonthlyStatementExportItem setAllowanceRefundCount(Integer allowanceRefundCount) {
        this.allowanceRefundCount = allowanceRefundCount;
        return this;
    }

    public PosIDMonthlyStatementExportItem setAllowanceRefundTotal(Double allowanceRefundTotal) {
        this.allowanceRefundTotal = allowanceRefundTotal;
        return this;
    }

    public PosIDMonthlyStatementExportItem setTotalExpenditure(Double totalExpenditure) {
        this.totalExpenditure = totalExpenditure;
        return this;
    }

    public PosIDMonthlyStatementExportItem setTotalIncome(Double totalIncome) {
        this.totalIncome = totalIncome;
        return this;
    }

    public PosIDMonthlyStatementExportItem setLikeName(String likeName) {
        this.likeName = likeName;
        return this;
    }

    public PosIDMonthlyStatementExportItem setLiekDeptName(String liekDeptName) {
        this.liekDeptName = liekDeptName;
        return this;
    }

    public PosIDMonthlyStatementExportItem setLikePersonPin(String likePersonPin) {
        this.likePersonPin = likePersonPin;
        return this;
    }

    public PosIDMonthlyStatementExportItem setInDeptId(String inDeptId) {
        this.inDeptId = inDeptId;
        return this;
    }

    public PosIDMonthlyStatementExportItem setStartDatetimeBegin(String startDatetimeBegin) {
        this.startDatetimeBegin = startDatetimeBegin;
        return this;
    }

    public PosIDMonthlyStatementExportItem setStartDatetimeEnd(String startDatetimeEnd) {
        this.startDatetimeEnd = startDatetimeEnd;
        return this;
    }

    public String toString() {
        return "PosIDMonthlyStatementExportItem(id=" + this.getId() + ", personId=" + this.getPersonId() + ", personPin=" + this.getPersonPin() + ", personName=" + this.getPersonName() + ", personLastName=" + this.getPersonLastName() + ", deptName=" + this.getDeptName() + ", monthlyStarAmount=" + this.getMonthlyStarAmount() + ", monthlyEndAmount=" + this.getMonthlyEndAmount() + ", topUpCashCount=" + this.getTopUpCashCount() + ", topUpCashMoney=" + this.getTopUpCashMoney() + ", topUpSolde=" + this.getTopUpSolde() + ", allowanceCount=" + this.getAllowanceCount() + ", allowanceMoney=" + this.getAllowanceMoney() + ", topUpNatCount=" + this.getTopUpNatCount() + ", topUpNatMoney=" + this.getTopUpNatMoney() + ", correctionCount=" + this.getCorrectionCount() + ", correctionAmount=" + this.getCorrectionAmount() + ", topUpSoldeCount=" + this.getTopUpSoldeCount() + ", topUpSoldeMoney=" + this.getTopUpSoldeMoney() + ", consumeCount=" + this.getConsumeCount() + ", consumeMoney=" + this.getConsumeMoney() + ", replenishmentAmount=" + this.getReplenishmentAmount() + ", refundSoldeCount=" + this.getRefundSoldeCount() + ", refundSolde=" + this.getRefundSolde() + ", allowanceRefundCount=" + this.getAllowanceRefundCount() + ", allowanceRefundTotal=" + this.getAllowanceRefundTotal() + ", totalExpenditure=" + this.getTotalExpenditure() + ", totalIncome=" + this.getTotalIncome() + ", likeName=" + this.getLikeName() + ", liekDeptName=" + this.getLiekDeptName() + ", likePersonPin=" + this.getLikePersonPin() + ", inDeptId=" + this.getInDeptId() + ", startDatetimeBegin=" + this.getStartDatetimeBegin() + ", startDatetimeEnd=" + this.getStartDatetimeEnd() + ")";
    }
}

