/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.posid.vo;

import com.zkteco.zkbiosecurity.base.annotation.Column;
import com.zkteco.zkbiosecurity.base.annotation.Condition;
import com.zkteco.zkbiosecurity.base.annotation.From;
import com.zkteco.zkbiosecurity.base.annotation.GridColumn;
import com.zkteco.zkbiosecurity.base.annotation.GridConfig;
import com.zkteco.zkbiosecurity.base.annotation.GroupBy;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import java.util.UUID;

@From(after="POSID_TRANSACTION T")
@GroupBy(after="t.HALLING_ID,T.HALLING_NAME,T.MEAL_ID,t.MEAL_CODE")
@GridConfig(operate=true, idField="id", winHeight=400, winWidth=600)
public class PosIDMealConsumeItem
extends BaseItem
implements Comparable {
    @GridColumn(show=false)
    private String id;
    @Column(name="t.HALLING_ID")
    private String hallingId;
    @Column(name="t.HALLING_NAME")
    @GridColumn(label="posid_diningHall_name", width="110", sort="na", i18n=true)
    private String hallingName;
    @Column(name="t.MEAL_ID")
    @GridColumn(label="posid_meal_name", width="70", show=false)
    private String mealId;
    @Column(name="t.MEAL_CODE")
    @GridColumn(show=false)
    private String mealCode;
    @GridColumn(label="posid_meal_name", width="85", sort="na", i18n=true)
    @Condition(value="t.MEAL_NAME", equalTag="like")
    private String mealName;
    @Column(name="sum(case when t.type_name = 6  then 1 else 0 end)")
    @GridColumn(label="posid_countTable_conTimes", width="100")
    private Integer conTimes;
    @Column(name="SUM(CASE WHEN t.TYPE_NAME != 9 AND t.TYPE_NAME != 13 THEN t.MONEY_WALLET_MONEY ELSE 0 END)")
    @GridColumn(label="posid_countTable_conCash", width="115", columnType="custom", convert="convertFen2Yuan")
    private Integer consumCash;
    @Column(name="SUM(CASE WHEN t.TYPE_NAME != 9 AND t.TYPE_NAME != 13 THEN t.ALLOWANCE_WALLET_MONEY ELSE 0 END)")
    @GridColumn(label="posid_countTable_conSubsidy", width="115", columnType="custom", convert="convertFen2Yuan")
    private Integer consumSubsidy;
    @Column(name="sum(case when t.type_name = 6  then t.money  else 0 end)")
    @GridColumn(label="posid_countTable_conTotal", width="115", columnType="custom", convert="convertFen2Yuan")
    private Integer consumtotal;
    @Column(name="sum(case when t.type_name = 6  then t.discount_money  else 0 end)")
    @GridColumn(label="posid_consume_discount_money_sum", width="115", columnType="custom", convert="convertFen2Yuan", show=false)
    private Integer discountMoney;
    @Column(name="sum(case when t.type_name = 9  then 1 else 0 end)")
    @GridColumn(label="posid_countTable_errorTimes", width="110")
    private Integer errortimes;
    @Column(name="sum(case when t.type_name = 9  then t.money else 0 end)")
    @GridColumn(label="posid_countTable_errorTotal", width="135", columnType="custom", convert="convertFen2Yuan")
    private Integer errortotal;
    @Column(name="sum(case when t.type_name = 10 then 1 else 0 end)")
    @GridColumn(label="posid_countTable_orderTimes", width="105")
    private Integer ordertimes;
    @Column(name="sum(case when t.type_name = 8  then 1 else 0 end)")
    @GridColumn(label="posid_countTable_suppleTimes", width="130")
    private Integer suppletimes;
    @Column(name="sum(case when t.type_name = 8  then t.money else 0 end)")
    @GridColumn(label="posid_countTable_suppleTotal", width="130", columnType="custom", convert="convertFen2Yuan")
    private Integer suppletotal;
    @Column(name="sum(case when t.type_name = 11  then 1 else 0 end)")
    @GridColumn(label="posid_countTable_accountTimes", width="165", show=false)
    private Integer accounttimes;
    @Column(name="sum(case when t.type_name = 11  then t.money else 0 end)")
    @GridColumn(label="posid_countTable_accountTotal", width="110", columnType="custom", convert="convertFen2Yuan", show=false)
    private Integer accountTotal;
    @Column(name="sum(case when t.type_name = 6 then 1 else 0 end)")
    @GridColumn(label="posid_countTable_actualTimes", width="120")
    private Integer actualtimes;
    @Column(name="sum(case when t.type_name = 6  then t.money else 0 end)")
    @GridColumn(label="posid_countTable_equipTotal", width="130", columnType="custom", convert="convertFen2Yuan")
    private Integer equipTotal;
    @Column(name="(sum(case when t.type_name = 6  then t.money else 0 end)+sum(case when t.type_name = 8  then t.money else 0 end))")
    @GridColumn(label="posid_countTable_sysTotal", width="150", columnType="custom", convert="convertFen2Yuan")
    private Integer sysTotal;
    @Column(name="(sum(case when t.type_name = 6  then t.money else 0 end)+sum(case when t.type_name = 11  then t.money else 0 end))")
    @GridColumn(label="posid_countTable_containAccTotal", width="150", columnType="custom", convert="convertFen2Yuan")
    private Integer containAccTotal;
    @GridColumn(label="posid_countTable_conTimeStr", minWidth="175", width="180", sort="na")
    private String posTime;
    @Condition(value="t.POS_TIME", equalTag=">=", toDate=true)
    private String opTimeBegin;
    @Condition(value="t.POS_TIME", equalTag="<=", toDate=true)
    private String opTimeEnd;
    @Condition(value="t.DEPT_ID", equalTag="in")
    private String inDeptId;
    @Condition(value="t.DEV_SN", equalTag="=")
    private String devSn;
    @Condition(value="t.DEPT_ID IN (SELECT ud.AUTH_DEPT_ID FROM AUTH_USER_DEPT ud WHERE ud.AUTH_USER_ID=''{0}'')")
    private String userId;
    @Condition(value="t.HALLING_ID IN (SELECT pd.ID FROM POSID_DININGHALL pd WHERE pd.AUTH_AREA_ID IN (SELECT ud.AUTH_AREA_ID FROM AUTH_USER_AREA ud WHERE ud.AUTH_USER_ID=''{0}''))")
    private String diningAreaByUserId;
    private String deptId;
    private String isIncludeLower;

    public PosIDMealConsumeItem() {
        this.id = UUID.randomUUID().toString();
    }

    public PosIDMealConsumeItem(Boolean equals) {
        super(equals);
    }

    public PosIDMealConsumeItem(String id) {
        super(Boolean.valueOf(true));
        this.id = id;
    }

    public PosIDMealConsumeItem(String id, String mealCode, String mealName, Integer conTimes, Integer consumtotal, Integer ordertimes, Integer errortimes, Integer errortotal, Integer suppletimes, Integer suppletotal, Integer accounttimes, Integer accountTotal, Integer actualtimes, Integer equipTotal, Integer sysTotal, Integer containAccTotal) {
        this.id = id;
        this.mealCode = mealCode;
        this.mealName = mealName;
        this.conTimes = conTimes;
        this.consumtotal = consumtotal;
        this.ordertimes = ordertimes;
        this.errortimes = errortimes;
        this.errortotal = errortotal;
        this.suppletimes = suppletimes;
        this.suppletotal = suppletotal;
        this.accounttimes = accounttimes;
        this.accountTotal = accountTotal;
        this.actualtimes = actualtimes;
        this.equipTotal = equipTotal;
        this.sysTotal = sysTotal;
        this.containAccTotal = containAccTotal;
    }

    public int compareTo(Object o) {
        PosIDMealConsumeItem mealItem = (PosIDMealConsumeItem)o;
        String code = mealItem.getMealCode();
        return this.mealCode.compareTo(code);
    }

    public String getId() {
        return this.id;
    }

    public String getHallingId() {
        return this.hallingId;
    }

    public String getHallingName() {
        return this.hallingName;
    }

    public String getMealId() {
        return this.mealId;
    }

    public String getMealCode() {
        return this.mealCode;
    }

    public String getMealName() {
        return this.mealName;
    }

    public Integer getConTimes() {
        return this.conTimes;
    }

    public Integer getConsumCash() {
        return this.consumCash;
    }

    public Integer getConsumSubsidy() {
        return this.consumSubsidy;
    }

    public Integer getConsumtotal() {
        return this.consumtotal;
    }

    public Integer getDiscountMoney() {
        return this.discountMoney;
    }

    public Integer getErrortimes() {
        return this.errortimes;
    }

    public Integer getErrortotal() {
        return this.errortotal;
    }

    public Integer getOrdertimes() {
        return this.ordertimes;
    }

    public Integer getSuppletimes() {
        return this.suppletimes;
    }

    public Integer getSuppletotal() {
        return this.suppletotal;
    }

    public Integer getAccounttimes() {
        return this.accounttimes;
    }

    public Integer getAccountTotal() {
        return this.accountTotal;
    }

    public Integer getActualtimes() {
        return this.actualtimes;
    }

    public Integer getEquipTotal() {
        return this.equipTotal;
    }

    public Integer getSysTotal() {
        return this.sysTotal;
    }

    public Integer getContainAccTotal() {
        return this.containAccTotal;
    }

    public String getPosTime() {
        return this.posTime;
    }

    public String getOpTimeBegin() {
        return this.opTimeBegin;
    }

    public String getOpTimeEnd() {
        return this.opTimeEnd;
    }

    public String getInDeptId() {
        return this.inDeptId;
    }

    public String getDevSn() {
        return this.devSn;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getDiningAreaByUserId() {
        return this.diningAreaByUserId;
    }

    public String getDeptId() {
        return this.deptId;
    }

    public String getIsIncludeLower() {
        return this.isIncludeLower;
    }

    public PosIDMealConsumeItem setId(String id) {
        this.id = id;
        return this;
    }

    public PosIDMealConsumeItem setHallingId(String hallingId) {
        this.hallingId = hallingId;
        return this;
    }

    public PosIDMealConsumeItem setHallingName(String hallingName) {
        this.hallingName = hallingName;
        return this;
    }

    public PosIDMealConsumeItem setMealId(String mealId) {
        this.mealId = mealId;
        return this;
    }

    public PosIDMealConsumeItem setMealCode(String mealCode) {
        this.mealCode = mealCode;
        return this;
    }

    public PosIDMealConsumeItem setMealName(String mealName) {
        this.mealName = mealName;
        return this;
    }

    public PosIDMealConsumeItem setConTimes(Integer conTimes) {
        this.conTimes = conTimes;
        return this;
    }

    public PosIDMealConsumeItem setConsumCash(Integer consumCash) {
        this.consumCash = consumCash;
        return this;
    }

    public PosIDMealConsumeItem setConsumSubsidy(Integer consumSubsidy) {
        this.consumSubsidy = consumSubsidy;
        return this;
    }

    public PosIDMealConsumeItem setConsumtotal(Integer consumtotal) {
        this.consumtotal = consumtotal;
        return this;
    }

    public PosIDMealConsumeItem setDiscountMoney(Integer discountMoney) {
        this.discountMoney = discountMoney;
        return this;
    }

    public PosIDMealConsumeItem setErrortimes(Integer errortimes) {
        this.errortimes = errortimes;
        return this;
    }

    public PosIDMealConsumeItem setErrortotal(Integer errortotal) {
        this.errortotal = errortotal;
        return this;
    }

    public PosIDMealConsumeItem setOrdertimes(Integer ordertimes) {
        this.ordertimes = ordertimes;
        return this;
    }

    public PosIDMealConsumeItem setSuppletimes(Integer suppletimes) {
        this.suppletimes = suppletimes;
        return this;
    }

    public PosIDMealConsumeItem setSuppletotal(Integer suppletotal) {
        this.suppletotal = suppletotal;
        return this;
    }

    public PosIDMealConsumeItem setAccounttimes(Integer accounttimes) {
        this.accounttimes = accounttimes;
        return this;
    }

    public PosIDMealConsumeItem setAccountTotal(Integer accountTotal) {
        this.accountTotal = accountTotal;
        return this;
    }

    public PosIDMealConsumeItem setActualtimes(Integer actualtimes) {
        this.actualtimes = actualtimes;
        return this;
    }

    public PosIDMealConsumeItem setEquipTotal(Integer equipTotal) {
        this.equipTotal = equipTotal;
        return this;
    }

    public PosIDMealConsumeItem setSysTotal(Integer sysTotal) {
        this.sysTotal = sysTotal;
        return this;
    }

    public PosIDMealConsumeItem setContainAccTotal(Integer containAccTotal) {
        this.containAccTotal = containAccTotal;
        return this;
    }

    public PosIDMealConsumeItem setPosTime(String posTime) {
        this.posTime = posTime;
        return this;
    }

    public PosIDMealConsumeItem setOpTimeBegin(String opTimeBegin) {
        this.opTimeBegin = opTimeBegin;
        return this;
    }

    public PosIDMealConsumeItem setOpTimeEnd(String opTimeEnd) {
        this.opTimeEnd = opTimeEnd;
        return this;
    }

    public PosIDMealConsumeItem setInDeptId(String inDeptId) {
        this.inDeptId = inDeptId;
        return this;
    }

    public PosIDMealConsumeItem setDevSn(String devSn) {
        this.devSn = devSn;
        return this;
    }

    public PosIDMealConsumeItem setUserId(String userId) {
        this.userId = userId;
        return this;
    }

    public PosIDMealConsumeItem setDiningAreaByUserId(String diningAreaByUserId) {
        this.diningAreaByUserId = diningAreaByUserId;
        return this;
    }

    public PosIDMealConsumeItem setDeptId(String deptId) {
        this.deptId = deptId;
        return this;
    }

    public PosIDMealConsumeItem setIsIncludeLower(String isIncludeLower) {
        this.isIncludeLower = isIncludeLower;
        return this;
    }

    public String toString() {
        return "PosIDMealConsumeItem(id=" + this.getId() + ", hallingId=" + this.getHallingId() + ", hallingName=" + this.getHallingName() + ", mealId=" + this.getMealId() + ", mealCode=" + this.getMealCode() + ", mealName=" + this.getMealName() + ", conTimes=" + this.getConTimes() + ", consumCash=" + this.getConsumCash() + ", consumSubsidy=" + this.getConsumSubsidy() + ", consumtotal=" + this.getConsumtotal() + ", discountMoney=" + this.getDiscountMoney() + ", errortimes=" + this.getErrortimes() + ", errortotal=" + this.getErrortotal() + ", ordertimes=" + this.getOrdertimes() + ", suppletimes=" + this.getSuppletimes() + ", suppletotal=" + this.getSuppletotal() + ", accounttimes=" + this.getAccounttimes() + ", accountTotal=" + this.getAccountTotal() + ", actualtimes=" + this.getActualtimes() + ", equipTotal=" + this.getEquipTotal() + ", sysTotal=" + this.getSysTotal() + ", containAccTotal=" + this.getContainAccTotal() + ", posTime=" + this.getPosTime() + ", opTimeBegin=" + this.getOpTimeBegin() + ", opTimeEnd=" + this.getOpTimeEnd() + ", inDeptId=" + this.getInDeptId() + ", devSn=" + this.getDevSn() + ", userId=" + this.getUserId() + ", diningAreaByUserId=" + this.getDiningAreaByUserId() + ", deptId=" + this.getDeptId() + ", isIncludeLower=" + this.getIsIncludeLower() + ")";
    }
}

