/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.posid.vo;

import com.zkteco.zkbiosecurity.base.annotation.Column;
import com.zkteco.zkbiosecurity.base.annotation.Condition;
import com.zkteco.zkbiosecurity.base.annotation.From;
import com.zkteco.zkbiosecurity.base.annotation.GridColumn;
import com.zkteco.zkbiosecurity.base.annotation.GridConfig;
import com.zkteco.zkbiosecurity.base.annotation.GroupBy;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import java.util.UUID;

@From(after="POSID_TRANSACTION T")
@GroupBy(after="t.HALLING_ID,T.HALLING_NAME,T.MEAL_ID,t.MEAL_CODE")
@GridConfig(operate=true, idField="id", winHeight=400, winWidth=600)
public class PosIDMealConsumeExportItem
extends BaseItem
implements Comparable {
    @GridColumn(show=false)
    private String id;
    @Column(name="t.HALLING_ID")
    private String hallingId;
    @Column(name="t.HALLING_NAME")
    @GridColumn(label="posid_diningHall_name", width="110", sort="na", i18n=true)
    private String hallingName;
    @Column(name="t.MEAL_ID")
    @GridColumn(label="posid_meal_name", width="70", show=false)
    private String mealId;
    @Column(name="t.MEAL_CODE")
    @GridColumn(show=false)
    private String mealCode;
    @GridColumn(label="posid_meal_name", width="85", sort="na", i18n=true)
    @Condition(value="t.MEAL_NAME", equalTag="like")
    private String mealName;
    @Column(name="sum(case when t.TYPE_NAME = 6  then 1 else 0 end)")
    @GridColumn(label="posid_countTable_conTimes", width="120")
    private Integer conTimes;
    @Column(name="sum(case when t.type_name = 6  then t.MONEY_WALLET_MONEY  else 0 end)")
    @GridColumn(label="posid_countTable_conCash", width="115", columnType="custom", convert="convertFen2Yuan")
    private Double consumCash;
    @Column(name="sum(case when t.type_name = 6  then t.ALLOWANCE_WALLET_MONEY  else 0 end)")
    @GridColumn(label="posid_countTable_conSubsidy", width="115", columnType="custom", convert="convertFen2Yuan")
    private Double consumSubsidy;
    @Column(name="sum(case when t.TYPE_NAME = 6  then t.MONEY  else 0 end)")
    @GridColumn(label="posid_countTable_conTotal", width="115", columnType="custom", convert="convertFen2Yuan")
    private Double consumtotal;
    @Column(name="sum(case when t.TYPE_NAME = 6  then t.DISCOUNT_MONEY  else 0 end)")
    @GridColumn(label="posid_consume_discount_money_sum", width="115", columnType="custom", convert="convertFen2Yuan", show=false)
    private Double discountMoney;
    @Column(name="sum(case when t.TYPE_NAME = 9  then 1 else 0 end)")
    @GridColumn(label="posid_countTable_errorTimes", width="110")
    private Integer errortimes;
    @Column(name="sum(case when t.TYPE_NAME = 9  then t.MONEY else 0 end)")
    @GridColumn(label="posid_countTable_errorTotal", width="135", columnType="custom", convert="convertFen2Yuan")
    private Double errortotal;
    @Column(name="sum(case when t.TYPE_NAME = 10 then 1 else 0 end)")
    @GridColumn(label="posid_countTable_orderTimes", width="105")
    private Integer ordertimes;
    @Column(name="sum(case when t.TYPE_NAME = 8  then 1 else 0 end)")
    @GridColumn(label="posid_countTable_suppleTimes", width="130")
    private Integer suppletimes;
    @Column(name="sum(case when t.TYPE_NAME = 8  then t.MONEY else 0 end)")
    @GridColumn(label="posid_countTable_suppleTotal", width="130", columnType="custom", convert="convertFen2Yuan")
    private Double suppletotal;
    @Column(name="sum(case when t.TYPE_NAME = 11  then 1 else 0 end)")
    @GridColumn(label="posid_countTable_accountTimes", width="165", show=false)
    private Integer accounttimes;
    @Column(name="sum(case when t.TYPE_NAME = 11  then t.MONEY else 0 end)")
    @GridColumn(label="posid_countTable_accountTotal", width="110", columnType="custom", convert="convertFen2Yuan", show=false)
    private Double accountTotal;
    @Column(name="sum(case when t.TYPE_NAME = 6 then 1 else 0 end)")
    @GridColumn(label="posid_countTable_actualTimes", width="120")
    private Integer actualtimes;
    @Column(name="sum(case when t.TYPE_NAME = 6  then t.MONEY else 0 end)")
    @GridColumn(label="posid_countTable_equipTotal", width="130", columnType="custom", convert="convertFen2Yuan")
    private Double equipTotal;
    @Column(name="(sum(case when t.TYPE_NAME = 6  then t.MONEY else 0 end)+sum(case when t.type_name = 8  then t.money else 0 end))")
    @GridColumn(label="posid_countTable_sysTotal", width="150", columnType="custom", convert="convertFen2Yuan")
    private Double sysTotal;
    @Column(name="(sum(case when t.TYPE_NAME = 6  then t.MONEY else 0 end)+sum(case when t.TYPE_NAME = 11  then t.MONEY else 0 end))")
    @GridColumn(label="posid_countTable_containAccTotal", width="150", columnType="custom", convert="convertFen2Yuan")
    private Double containAccTotal;
    @GridColumn(label="posid_countTable_conTimeStr", minWidth="175", width="180", sort="na")
    private String posTime;
    @Condition(value="t.POS_TIME", equalTag=">=", toDate=true)
    private String opTimeBegin;
    @Condition(value="t.POS_TIME", equalTag="<=", toDate=true)
    private String opTimeEnd;
    @Condition(value="t.DEPT_ID", equalTag="in")
    private String inDeptId;
    @Condition(value="t.DEV_SN", equalTag="=")
    private String devSn;

    public PosIDMealConsumeExportItem() {
        this.id = UUID.randomUUID().toString();
    }

    public PosIDMealConsumeExportItem(Boolean equals) {
        super(equals);
    }

    public PosIDMealConsumeExportItem(String id) {
        super(Boolean.valueOf(true));
        this.id = id;
    }

    public PosIDMealConsumeExportItem(String id, String mealCode, String mealName, Integer conTimes, Double consumtotal, Integer ordertimes, Integer errortimes, Double errortotal, Integer suppletimes, Double suppletotal, Integer accounttimes, Double accountTotal, Integer actualtimes, Double equipTotal, Double sysTotal, Double containAccTotal) {
        this.id = id;
        this.mealCode = mealCode;
        this.mealName = mealName;
        this.conTimes = conTimes;
        this.consumtotal = consumtotal;
        this.ordertimes = ordertimes;
        this.errortimes = errortimes;
        this.errortotal = errortotal;
        this.suppletimes = suppletimes;
        this.suppletotal = suppletotal;
        this.accounttimes = accounttimes;
        this.accountTotal = accountTotal;
        this.actualtimes = actualtimes;
        this.equipTotal = equipTotal;
        this.sysTotal = sysTotal;
        this.containAccTotal = containAccTotal;
    }

    public int compareTo(Object o) {
        PosIDMealConsumeExportItem mealItem = (PosIDMealConsumeExportItem)o;
        String code = mealItem.getMealCode();
        return this.mealCode.compareTo(code);
    }

    public String getId() {
        return this.id;
    }

    public String getHallingId() {
        return this.hallingId;
    }

    public String getHallingName() {
        return this.hallingName;
    }

    public String getMealId() {
        return this.mealId;
    }

    public String getMealCode() {
        return this.mealCode;
    }

    public String getMealName() {
        return this.mealName;
    }

    public Integer getConTimes() {
        return this.conTimes;
    }

    public Double getConsumCash() {
        return this.consumCash;
    }

    public Double getConsumSubsidy() {
        return this.consumSubsidy;
    }

    public Double getConsumtotal() {
        return this.consumtotal;
    }

    public Double getDiscountMoney() {
        return this.discountMoney;
    }

    public Integer getErrortimes() {
        return this.errortimes;
    }

    public Double getErrortotal() {
        return this.errortotal;
    }

    public Integer getOrdertimes() {
        return this.ordertimes;
    }

    public Integer getSuppletimes() {
        return this.suppletimes;
    }

    public Double getSuppletotal() {
        return this.suppletotal;
    }

    public Integer getAccounttimes() {
        return this.accounttimes;
    }

    public Double getAccountTotal() {
        return this.accountTotal;
    }

    public Integer getActualtimes() {
        return this.actualtimes;
    }

    public Double getEquipTotal() {
        return this.equipTotal;
    }

    public Double getSysTotal() {
        return this.sysTotal;
    }

    public Double getContainAccTotal() {
        return this.containAccTotal;
    }

    public String getPosTime() {
        return this.posTime;
    }

    public String getOpTimeBegin() {
        return this.opTimeBegin;
    }

    public String getOpTimeEnd() {
        return this.opTimeEnd;
    }

    public String getInDeptId() {
        return this.inDeptId;
    }

    public String getDevSn() {
        return this.devSn;
    }

    public PosIDMealConsumeExportItem setId(String id) {
        this.id = id;
        return this;
    }

    public PosIDMealConsumeExportItem setHallingId(String hallingId) {
        this.hallingId = hallingId;
        return this;
    }

    public PosIDMealConsumeExportItem setHallingName(String hallingName) {
        this.hallingName = hallingName;
        return this;
    }

    public PosIDMealConsumeExportItem setMealId(String mealId) {
        this.mealId = mealId;
        return this;
    }

    public PosIDMealConsumeExportItem setMealCode(String mealCode) {
        this.mealCode = mealCode;
        return this;
    }

    public PosIDMealConsumeExportItem setMealName(String mealName) {
        this.mealName = mealName;
        return this;
    }

    public PosIDMealConsumeExportItem setConTimes(Integer conTimes) {
        this.conTimes = conTimes;
        return this;
    }

    public PosIDMealConsumeExportItem setConsumCash(Double consumCash) {
        this.consumCash = consumCash;
        return this;
    }

    public PosIDMealConsumeExportItem setConsumSubsidy(Double consumSubsidy) {
        this.consumSubsidy = consumSubsidy;
        return this;
    }

    public PosIDMealConsumeExportItem setConsumtotal(Double consumtotal) {
        this.consumtotal = consumtotal;
        return this;
    }

    public PosIDMealConsumeExportItem setDiscountMoney(Double discountMoney) {
        this.discountMoney = discountMoney;
        return this;
    }

    public PosIDMealConsumeExportItem setErrortimes(Integer errortimes) {
        this.errortimes = errortimes;
        return this;
    }

    public PosIDMealConsumeExportItem setErrortotal(Double errortotal) {
        this.errortotal = errortotal;
        return this;
    }

    public PosIDMealConsumeExportItem setOrdertimes(Integer ordertimes) {
        this.ordertimes = ordertimes;
        return this;
    }

    public PosIDMealConsumeExportItem setSuppletimes(Integer suppletimes) {
        this.suppletimes = suppletimes;
        return this;
    }

    public PosIDMealConsumeExportItem setSuppletotal(Double suppletotal) {
        this.suppletotal = suppletotal;
        return this;
    }

    public PosIDMealConsumeExportItem setAccounttimes(Integer accounttimes) {
        this.accounttimes = accounttimes;
        return this;
    }

    public PosIDMealConsumeExportItem setAccountTotal(Double accountTotal) {
        this.accountTotal = accountTotal;
        return this;
    }

    public PosIDMealConsumeExportItem setActualtimes(Integer actualtimes) {
        this.actualtimes = actualtimes;
        return this;
    }

    public PosIDMealConsumeExportItem setEquipTotal(Double equipTotal) {
        this.equipTotal = equipTotal;
        return this;
    }

    public PosIDMealConsumeExportItem setSysTotal(Double sysTotal) {
        this.sysTotal = sysTotal;
        return this;
    }

    public PosIDMealConsumeExportItem setContainAccTotal(Double containAccTotal) {
        this.containAccTotal = containAccTotal;
        return this;
    }

    public PosIDMealConsumeExportItem setPosTime(String posTime) {
        this.posTime = posTime;
        return this;
    }

    public PosIDMealConsumeExportItem setOpTimeBegin(String opTimeBegin) {
        this.opTimeBegin = opTimeBegin;
        return this;
    }

    public PosIDMealConsumeExportItem setOpTimeEnd(String opTimeEnd) {
        this.opTimeEnd = opTimeEnd;
        return this;
    }

    public PosIDMealConsumeExportItem setInDeptId(String inDeptId) {
        this.inDeptId = inDeptId;
        return this;
    }

    public PosIDMealConsumeExportItem setDevSn(String devSn) {
        this.devSn = devSn;
        return this;
    }

    public String toString() {
        return "PosIDMealConsumeExportItem(id=" + this.getId() + ", hallingId=" + this.getHallingId() + ", hallingName=" + this.getHallingName() + ", mealId=" + this.getMealId() + ", mealCode=" + this.getMealCode() + ", mealName=" + this.getMealName() + ", conTimes=" + this.getConTimes() + ", consumCash=" + this.getConsumCash() + ", consumSubsidy=" + this.getConsumSubsidy() + ", consumtotal=" + this.getConsumtotal() + ", discountMoney=" + this.getDiscountMoney() + ", errortimes=" + this.getErrortimes() + ", errortotal=" + this.getErrortotal() + ", ordertimes=" + this.getOrdertimes() + ", suppletimes=" + this.getSuppletimes() + ", suppletotal=" + this.getSuppletotal() + ", accounttimes=" + this.getAccounttimes() + ", accountTotal=" + this.getAccountTotal() + ", actualtimes=" + this.getActualtimes() + ", equipTotal=" + this.getEquipTotal() + ", sysTotal=" + this.getSysTotal() + ", containAccTotal=" + this.getContainAccTotal() + ", posTime=" + this.getPosTime() + ", opTimeBegin=" + this.getOpTimeBegin() + ", opTimeEnd=" + this.getOpTimeEnd() + ", inDeptId=" + this.getInDeptId() + ", devSn=" + this.getDevSn() + ")";
    }
}

