/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.posid.vo;

import com.zkteco.zkbiosecurity.base.annotation.Column;
import com.zkteco.zkbiosecurity.base.annotation.Condition;
import com.zkteco.zkbiosecurity.base.annotation.From;
import com.zkteco.zkbiosecurity.base.annotation.GridColumn;
import com.zkteco.zkbiosecurity.base.annotation.GridConfig;
import com.zkteco.zkbiosecurity.base.annotation.GroupBy;
import com.zkteco.zkbiosecurity.base.annotation.Where;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;

@From(after="POSID_TRANSACTION t")
@Where(after="AND t.TYPE_NAME != 9 AND t.TYPE_NAME != 13")
@GroupBy(after="t.MEAL_CODE")
@GridConfig(operate=true, idField="id", winHeight=400, winWidth=600)
public class PosIDDiningHallMealGroupItem
extends BaseItem {
    @GridColumn(show=false)
    private String id;
    @Column(name="t.MEAL_CODE")
    private String mealCode;
    @Column(name="COUNT(t.ID)")
    private Integer totalTimes;
    @Column(name="SUM(t.MONEY)")
    private Integer totalAmount;
    @Condition(value="t.POS_TIME", equalTag=">=", toDate=true)
    private String startDatetimeBegin;
    @Condition(value="t.POS_TIME", equalTag="<=", toDate=true)
    private String startDatetimeEnd;
    @Condition(value="(t.PERSON_NAME LIKE ''%{0}%'' OR t.PERSON_LAST_NAME LIKE ''%{0}%'')")
    private String likeName;
    @Condition(value="t.DEPT_NAME", equalTag="like")
    private String liekDeptName;
    @Condition(value="t.HALLING_NAME", equalTag="like")
    private String hallingName;
    @Condition(value="t.PERSON_ID", equalTag="=")
    private String personId;
    @Condition(value="t.HALLING_ID", equalTag="=")
    private String hallingId;
    @Condition(value="t.DEPT_ID", equalTag="in")
    private String inDeptId;
    @Condition(value="t.POS_TIME", equalTag=">=", toDate=true)
    private String opTimeBegin;
    @Condition(value="t.POS_TIME", equalTag="<=", toDate=true)
    private String opTimeEnd;
    @Condition(value="t.DEPT_ID IN (SELECT ud.AUTH_DEPT_ID FROM AUTH_USER_DEPT ud WHERE ud.AUTH_USER_ID=''{0}'')")
    private String userId;
    @Condition(value="t.HALLING_ID IN (SELECT pd.ID FROM POSID_DININGHALL pd WHERE pd.AUTH_AREA_ID IN (SELECT ud.AUTH_AREA_ID FROM AUTH_USER_AREA ud WHERE ud.AUTH_USER_ID=''{0}''))")
    private String diningAreaByUserId;

    public String getId() {
        return this.id;
    }

    public String getMealCode() {
        return this.mealCode;
    }

    public Integer getTotalTimes() {
        return this.totalTimes;
    }

    public Integer getTotalAmount() {
        return this.totalAmount;
    }

    public String getStartDatetimeBegin() {
        return this.startDatetimeBegin;
    }

    public String getStartDatetimeEnd() {
        return this.startDatetimeEnd;
    }

    public String getLikeName() {
        return this.likeName;
    }

    public String getLiekDeptName() {
        return this.liekDeptName;
    }

    public String getHallingName() {
        return this.hallingName;
    }

    public String getPersonId() {
        return this.personId;
    }

    public String getHallingId() {
        return this.hallingId;
    }

    public String getInDeptId() {
        return this.inDeptId;
    }

    public String getOpTimeBegin() {
        return this.opTimeBegin;
    }

    public String getOpTimeEnd() {
        return this.opTimeEnd;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getDiningAreaByUserId() {
        return this.diningAreaByUserId;
    }

    public PosIDDiningHallMealGroupItem setId(String id) {
        this.id = id;
        return this;
    }

    public PosIDDiningHallMealGroupItem setMealCode(String mealCode) {
        this.mealCode = mealCode;
        return this;
    }

    public PosIDDiningHallMealGroupItem setTotalTimes(Integer totalTimes) {
        this.totalTimes = totalTimes;
        return this;
    }

    public PosIDDiningHallMealGroupItem setTotalAmount(Integer totalAmount) {
        this.totalAmount = totalAmount;
        return this;
    }

    public PosIDDiningHallMealGroupItem setStartDatetimeBegin(String startDatetimeBegin) {
        this.startDatetimeBegin = startDatetimeBegin;
        return this;
    }

    public PosIDDiningHallMealGroupItem setStartDatetimeEnd(String startDatetimeEnd) {
        this.startDatetimeEnd = startDatetimeEnd;
        return this;
    }

    public PosIDDiningHallMealGroupItem setLikeName(String likeName) {
        this.likeName = likeName;
        return this;
    }

    public PosIDDiningHallMealGroupItem setLiekDeptName(String liekDeptName) {
        this.liekDeptName = liekDeptName;
        return this;
    }

    public PosIDDiningHallMealGroupItem setHallingName(String hallingName) {
        this.hallingName = hallingName;
        return this;
    }

    public PosIDDiningHallMealGroupItem setPersonId(String personId) {
        this.personId = personId;
        return this;
    }

    public PosIDDiningHallMealGroupItem setHallingId(String hallingId) {
        this.hallingId = hallingId;
        return this;
    }

    public PosIDDiningHallMealGroupItem setInDeptId(String inDeptId) {
        this.inDeptId = inDeptId;
        return this;
    }

    public PosIDDiningHallMealGroupItem setOpTimeBegin(String opTimeBegin) {
        this.opTimeBegin = opTimeBegin;
        return this;
    }

    public PosIDDiningHallMealGroupItem setOpTimeEnd(String opTimeEnd) {
        this.opTimeEnd = opTimeEnd;
        return this;
    }

    public PosIDDiningHallMealGroupItem setUserId(String userId) {
        this.userId = userId;
        return this;
    }

    public PosIDDiningHallMealGroupItem setDiningAreaByUserId(String diningAreaByUserId) {
        this.diningAreaByUserId = diningAreaByUserId;
        return this;
    }

    public String toString() {
        return "PosIDDiningHallMealGroupItem(id=" + this.getId() + ", mealCode=" + this.getMealCode() + ", totalTimes=" + this.getTotalTimes() + ", totalAmount=" + this.getTotalAmount() + ", startDatetimeBegin=" + this.getStartDatetimeBegin() + ", startDatetimeEnd=" + this.getStartDatetimeEnd() + ", likeName=" + this.getLikeName() + ", liekDeptName=" + this.getLiekDeptName() + ", hallingName=" + this.getHallingName() + ", personId=" + this.getPersonId() + ", hallingId=" + this.getHallingId() + ", inDeptId=" + this.getInDeptId() + ", opTimeBegin=" + this.getOpTimeBegin() + ", opTimeEnd=" + this.getOpTimeEnd() + ", userId=" + this.getUserId() + ", diningAreaByUserId=" + this.getDiningAreaByUserId() + ")";
    }
}

