/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.posid.vo;

import com.zkteco.zkbiosecurity.base.annotation.Column;
import com.zkteco.zkbiosecurity.base.annotation.Condition;
import com.zkteco.zkbiosecurity.base.annotation.From;
import com.zkteco.zkbiosecurity.base.annotation.GridColumn;
import com.zkteco.zkbiosecurity.base.annotation.GridConfig;
import com.zkteco.zkbiosecurity.base.annotation.GroupBy;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import java.util.Map;
import java.util.UUID;

@From(after="POSID_TRANSACTION t")
@GroupBy(after=" t.HALLING_ID")
@GridConfig(operate=true, idField="id", winHeight=400, winWidth=600)
public class PosIDDiningHallConsumeItem
extends BaseItem
implements Comparable {
    @GridColumn(show=false)
    private String id;
    @Column(name="t.HALLING_ID")
    @GridColumn(label="posid_diningHall_name", width="70", show=false)
    private String hallingId;
    @Condition(value="t.HALLING_NAME", equalTag="like")
    @GridColumn(label="posid_diningHall_name", width="110", sort="na", i18n=true)
    private String hallingName;
    @GridColumn(dynamicColumn="mealDetailDyna")
    private Map<String, Object> mealDetailMap;
    @Column(name="SUM(CASE WHEN t.TYPE_NAME != 9 AND t.TYPE_NAME != 13 THEN 1 ELSE 0 END)")
    @GridColumn(label="posid_countTable_total_times", width="120")
    private Integer totalTimes;
    @Column(name="SUM(CASE WHEN t.TYPE_NAME != 9 AND t.TYPE_NAME != 13 THEN t.MONEY ELSE 0 END)")
    @GridColumn(label="posid_countTable_total_amount", minWidth="120", columnType="custom", convert="convertFen2Yuan")
    private Integer totalAmount;
    @Column(name="sum(case when t.type_name = 6  then 1 else 0 end)")
    @GridColumn(label="posid_countTable_conTimes", width="120", show=false)
    private Integer conTimes;
    @Column(name="sum(case when t.type_name = 6  then t.money  else 0 end)")
    @GridColumn(label="posid_countTable_consumTotal", width="120", columnType="custom", convert="convertFen2Yuan", show=false)
    private Integer consumtotal;
    @Column(name="SUM(CASE WHEN t.TYPE_NAME != 9 AND t.TYPE_NAME != 13 THEN t.MONEY_WALLET_MONEY ELSE 0 END)")
    @GridColumn(label="posid_countTable_conCash", width="120", columnType="custom", convert="convertFen2Yuan")
    private Integer consumtotalCash;
    @Column(name="SUM(CASE WHEN t.TYPE_NAME != 9 AND t.TYPE_NAME != 13 THEN t.ALLOWANCE_WALLET_MONEY ELSE 0 END)")
    @GridColumn(label="posid_countTable_conSubsidy", width="120", columnType="custom", convert="convertFen2Yuan")
    private Integer consumtotalAllow;
    @Column(name="sum(case when t.type_name = 6  then t.discount_money  else 0 end)")
    @GridColumn(label="posid_consume_discount_money_sum", width="115", columnType="custom", convert="convertFen2Yuan")
    private Integer discountMoney;
    @Column(name="sum(case when t.type_name = 10 then 1 else 0 end)")
    @GridColumn(label="posid_countTable_orderTimes", width="105", show=false)
    private Integer ordertimes;
    @Column(name="sum(case when t.type_name = 9  then 1 else 0 end)")
    @GridColumn(label="posid_countTable_errorTimes", width="110")
    private Integer errortimes;
    @Column(name="sum(case when t.type_name = 9  then t.money else 0 end)")
    @GridColumn(label="posid_countTable_errorTotal", width="140", columnType="custom", convert="convertFen2Yuan")
    private Integer errortotal;
    @Column(name="sum(case when t.type_name = 8  then 1 else 0 end)")
    @GridColumn(label="posid_countTable_suppleTimes", width="140")
    private Integer suppletimes;
    @Column(name="sum(case when t.type_name = 8  then t.money else 0 end)")
    @GridColumn(label="posid_countTable_suppleTotal", width="160", columnType="custom", convert="convertFen2Yuan")
    private Integer suppletotal;
    @Column(name="sum(case when t.type_name = 11  then 1 else 0 end)")
    @GridColumn(label="posid_countTable_accountTimes", width="115", show=false)
    private Integer accounttimes;
    @Column(name="sum(case when t.type_name = 11  then t.money else 0 end)")
    @GridColumn(label="posid_countTable_accountTotal", width="105", columnType="custom", convert="convertFen2Yuan", show=false)
    private Integer accountTotal;
    @Column(name="sum(case when t.type_name = 6 then 1 else 0 end)")
    @GridColumn(label="posid_countTable_actualTimes", width="120")
    private Integer actualtimes;
    @Column(name="sum(case when t.type_name = 6  then t.money else 0 end)")
    @GridColumn(label="posid_countTable_equipTotal", width="130", columnType="custom", convert="convertFen2Yuan")
    private Integer equipTotal;
    @Column(name="sum(case when t.type_name = 6  then t.money else 0 end)")
    @GridColumn(label="posid_countTable_sysTotalCons", width="150", columnType="custom", convert="convertFen2Yuan")
    private Integer sysTotal1;
    @Column(name="(sum(case when t.type_name = 6  then t.money else 0 end)+sum(case when t.type_name = 8  then t.money else 0 end))")
    @GridColumn(label="posid_countTable_sysTotal", width="150", columnType="custom", convert="convertFen2Yuan")
    private Integer sysTotal;
    @Column(name="(sum(case when t.type_name = 6  then t.money else 0 end)+sum(case when t.type_name = 11  then t.money else 0 end))")
    @GridColumn(label="posid_countTable_containAccTotal", width="150", columnType="custom", convert="convertFen2Yuan", show=false)
    private Integer containAccTotal;
    @GridColumn(label="posid_countTable_conTimeStr", minWidth="160", width="170", sort="na")
    private String posTime;
    @Condition(value="t.POS_TIME", equalTag=">=", toDate=true)
    private String opTimeBegin;
    @Condition(value="t.POS_TIME", equalTag="<=", toDate=true)
    private String opTimeEnd;
    @Condition(value="t.DEPT_ID", equalTag="in")
    private String inDeptId;
    @Condition(value="t.DEPT_ID IN (SELECT ud.AUTH_DEPT_ID FROM AUTH_USER_DEPT ud WHERE ud.AUTH_USER_ID=''{0}'')")
    private String userId;
    @Condition(value="t.HALLING_ID IN (SELECT pd.ID FROM POSID_DININGHALL pd WHERE pd.AUTH_AREA_ID IN (SELECT ud.AUTH_AREA_ID FROM AUTH_USER_AREA ud WHERE ud.AUTH_USER_ID=''{0}''))")
    private String diningAreaByUserId;
    private String deptId;
    private String isIncludeLower;

    public PosIDDiningHallConsumeItem() {
        this.id = UUID.randomUUID().toString();
    }

    public PosIDDiningHallConsumeItem(Boolean equals) {
        super(equals);
    }

    public PosIDDiningHallConsumeItem(String id) {
        super(Boolean.valueOf(true));
        this.id = id;
    }

    public PosIDDiningHallConsumeItem(String id, String hallingName, Integer conTimes, Integer consumtotal, Integer ordertimes, Integer errortimes, Integer errortotal, Integer suppletimes, Integer suppletotal, Integer accounttimes, Integer accountTotal, Integer actualtimes, Integer equipTotal, Integer sysTotal, Integer containAccTotal) {
        this.id = id;
        this.hallingName = hallingName;
        this.conTimes = conTimes;
        this.consumtotal = consumtotal;
        this.ordertimes = ordertimes;
        this.errortimes = errortimes;
        this.errortotal = errortotal;
        this.suppletimes = suppletimes;
        this.suppletotal = suppletotal;
        this.accounttimes = accounttimes;
        this.accountTotal = accountTotal;
        this.actualtimes = actualtimes;
        this.equipTotal = equipTotal;
        this.sysTotal = sysTotal;
        this.containAccTotal = containAccTotal;
    }

    public int compareTo(Object o) {
        PosIDDiningHallConsumeItem diningHallItem = (PosIDDiningHallConsumeItem)o;
        String hallingName = diningHallItem.getHallingName();
        if (null != hallingName) {
            return this.hallingName.compareTo(hallingName);
        }
        return -1;
    }

    public String getId() {
        return this.id;
    }

    public String getHallingId() {
        return this.hallingId;
    }

    public String getHallingName() {
        return this.hallingName;
    }

    public Map<String, Object> getMealDetailMap() {
        return this.mealDetailMap;
    }

    public Integer getTotalTimes() {
        return this.totalTimes;
    }

    public Integer getTotalAmount() {
        return this.totalAmount;
    }

    public Integer getConTimes() {
        return this.conTimes;
    }

    public Integer getConsumtotal() {
        return this.consumtotal;
    }

    public Integer getConsumtotalCash() {
        return this.consumtotalCash;
    }

    public Integer getConsumtotalAllow() {
        return this.consumtotalAllow;
    }

    public Integer getDiscountMoney() {
        return this.discountMoney;
    }

    public Integer getOrdertimes() {
        return this.ordertimes;
    }

    public Integer getErrortimes() {
        return this.errortimes;
    }

    public Integer getErrortotal() {
        return this.errortotal;
    }

    public Integer getSuppletimes() {
        return this.suppletimes;
    }

    public Integer getSuppletotal() {
        return this.suppletotal;
    }

    public Integer getAccounttimes() {
        return this.accounttimes;
    }

    public Integer getAccountTotal() {
        return this.accountTotal;
    }

    public Integer getActualtimes() {
        return this.actualtimes;
    }

    public Integer getEquipTotal() {
        return this.equipTotal;
    }

    public Integer getSysTotal1() {
        return this.sysTotal1;
    }

    public Integer getSysTotal() {
        return this.sysTotal;
    }

    public Integer getContainAccTotal() {
        return this.containAccTotal;
    }

    public String getPosTime() {
        return this.posTime;
    }

    public String getOpTimeBegin() {
        return this.opTimeBegin;
    }

    public String getOpTimeEnd() {
        return this.opTimeEnd;
    }

    public String getInDeptId() {
        return this.inDeptId;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getDiningAreaByUserId() {
        return this.diningAreaByUserId;
    }

    public String getDeptId() {
        return this.deptId;
    }

    public String getIsIncludeLower() {
        return this.isIncludeLower;
    }

    public PosIDDiningHallConsumeItem setId(String id) {
        this.id = id;
        return this;
    }

    public PosIDDiningHallConsumeItem setHallingId(String hallingId) {
        this.hallingId = hallingId;
        return this;
    }

    public PosIDDiningHallConsumeItem setHallingName(String hallingName) {
        this.hallingName = hallingName;
        return this;
    }

    public PosIDDiningHallConsumeItem setMealDetailMap(Map<String, Object> mealDetailMap) {
        this.mealDetailMap = mealDetailMap;
        return this;
    }

    public PosIDDiningHallConsumeItem setTotalTimes(Integer totalTimes) {
        this.totalTimes = totalTimes;
        return this;
    }

    public PosIDDiningHallConsumeItem setTotalAmount(Integer totalAmount) {
        this.totalAmount = totalAmount;
        return this;
    }

    public PosIDDiningHallConsumeItem setConTimes(Integer conTimes) {
        this.conTimes = conTimes;
        return this;
    }

    public PosIDDiningHallConsumeItem setConsumtotal(Integer consumtotal) {
        this.consumtotal = consumtotal;
        return this;
    }

    public PosIDDiningHallConsumeItem setConsumtotalCash(Integer consumtotalCash) {
        this.consumtotalCash = consumtotalCash;
        return this;
    }

    public PosIDDiningHallConsumeItem setConsumtotalAllow(Integer consumtotalAllow) {
        this.consumtotalAllow = consumtotalAllow;
        return this;
    }

    public PosIDDiningHallConsumeItem setDiscountMoney(Integer discountMoney) {
        this.discountMoney = discountMoney;
        return this;
    }

    public PosIDDiningHallConsumeItem setOrdertimes(Integer ordertimes) {
        this.ordertimes = ordertimes;
        return this;
    }

    public PosIDDiningHallConsumeItem setErrortimes(Integer errortimes) {
        this.errortimes = errortimes;
        return this;
    }

    public PosIDDiningHallConsumeItem setErrortotal(Integer errortotal) {
        this.errortotal = errortotal;
        return this;
    }

    public PosIDDiningHallConsumeItem setSuppletimes(Integer suppletimes) {
        this.suppletimes = suppletimes;
        return this;
    }

    public PosIDDiningHallConsumeItem setSuppletotal(Integer suppletotal) {
        this.suppletotal = suppletotal;
        return this;
    }

    public PosIDDiningHallConsumeItem setAccounttimes(Integer accounttimes) {
        this.accounttimes = accounttimes;
        return this;
    }

    public PosIDDiningHallConsumeItem setAccountTotal(Integer accountTotal) {
        this.accountTotal = accountTotal;
        return this;
    }

    public PosIDDiningHallConsumeItem setActualtimes(Integer actualtimes) {
        this.actualtimes = actualtimes;
        return this;
    }

    public PosIDDiningHallConsumeItem setEquipTotal(Integer equipTotal) {
        this.equipTotal = equipTotal;
        return this;
    }

    public PosIDDiningHallConsumeItem setSysTotal1(Integer sysTotal1) {
        this.sysTotal1 = sysTotal1;
        return this;
    }

    public PosIDDiningHallConsumeItem setSysTotal(Integer sysTotal) {
        this.sysTotal = sysTotal;
        return this;
    }

    public PosIDDiningHallConsumeItem setContainAccTotal(Integer containAccTotal) {
        this.containAccTotal = containAccTotal;
        return this;
    }

    public PosIDDiningHallConsumeItem setPosTime(String posTime) {
        this.posTime = posTime;
        return this;
    }

    public PosIDDiningHallConsumeItem setOpTimeBegin(String opTimeBegin) {
        this.opTimeBegin = opTimeBegin;
        return this;
    }

    public PosIDDiningHallConsumeItem setOpTimeEnd(String opTimeEnd) {
        this.opTimeEnd = opTimeEnd;
        return this;
    }

    public PosIDDiningHallConsumeItem setInDeptId(String inDeptId) {
        this.inDeptId = inDeptId;
        return this;
    }

    public PosIDDiningHallConsumeItem setUserId(String userId) {
        this.userId = userId;
        return this;
    }

    public PosIDDiningHallConsumeItem setDiningAreaByUserId(String diningAreaByUserId) {
        this.diningAreaByUserId = diningAreaByUserId;
        return this;
    }

    public PosIDDiningHallConsumeItem setDeptId(String deptId) {
        this.deptId = deptId;
        return this;
    }

    public PosIDDiningHallConsumeItem setIsIncludeLower(String isIncludeLower) {
        this.isIncludeLower = isIncludeLower;
        return this;
    }

    public String toString() {
        return "PosIDDiningHallConsumeItem(id=" + this.getId() + ", hallingId=" + this.getHallingId() + ", hallingName=" + this.getHallingName() + ", mealDetailMap=" + this.getMealDetailMap() + ", totalTimes=" + this.getTotalTimes() + ", totalAmount=" + this.getTotalAmount() + ", conTimes=" + this.getConTimes() + ", consumtotal=" + this.getConsumtotal() + ", consumtotalCash=" + this.getConsumtotalCash() + ", consumtotalAllow=" + this.getConsumtotalAllow() + ", discountMoney=" + this.getDiscountMoney() + ", ordertimes=" + this.getOrdertimes() + ", errortimes=" + this.getErrortimes() + ", errortotal=" + this.getErrortotal() + ", suppletimes=" + this.getSuppletimes() + ", suppletotal=" + this.getSuppletotal() + ", accounttimes=" + this.getAccounttimes() + ", accountTotal=" + this.getAccountTotal() + ", actualtimes=" + this.getActualtimes() + ", equipTotal=" + this.getEquipTotal() + ", sysTotal1=" + this.getSysTotal1() + ", sysTotal=" + this.getSysTotal() + ", containAccTotal=" + this.getContainAccTotal() + ", posTime=" + this.getPosTime() + ", opTimeBegin=" + this.getOpTimeBegin() + ", opTimeEnd=" + this.getOpTimeEnd() + ", inDeptId=" + this.getInDeptId() + ", userId=" + this.getUserId() + ", diningAreaByUserId=" + this.getDiningAreaByUserId() + ", deptId=" + this.getDeptId() + ", isIncludeLower=" + this.getIsIncludeLower() + ")";
    }
}

