/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.posid.vo;

import com.zkteco.zkbiosecurity.base.annotation.Column;
import com.zkteco.zkbiosecurity.base.annotation.Condition;
import com.zkteco.zkbiosecurity.base.annotation.From;
import com.zkteco.zkbiosecurity.base.annotation.GridColumn;
import com.zkteco.zkbiosecurity.base.annotation.GridConfig;
import com.zkteco.zkbiosecurity.base.annotation.GroupBy;
import com.zkteco.zkbiosecurity.base.annotation.Where;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import java.util.UUID;

@From(after="POSID_TRANSACTION t ")
@Where(after="AND t.DEV_SN IS NOT NULL")
@GroupBy(after=" t.DEV_SN ")
@GridConfig(operate=true, idField="id", winHeight=400, winWidth=600)
public class PosIDDeviceConsumeItem
extends BaseItem {
    @GridColumn(show=false)
    private String id;
    @Condition(value="t.DEV_ALIAS", equalTag="like")
    @GridColumn(label="common_dev_name", width="90", i18n=true)
    private String devAlias;
    @Column(name="t.DEV_SN")
    @GridColumn(label="common_dev_sn", width="130", i18n=true)
    private String devSn;
    @Column(name="SUM(CASE WHEN t.TYPE_NAME != 9 AND t.TYPE_NAME != 13 THEN t.MONEY_WALLET_MONEY ELSE 0 END)")
    @GridColumn(label="posid_countTable_conCash", width="115", columnType="custom", convert="convertFen2Yuan")
    private Integer consumCash;
    @Column(name="SUM(CASE WHEN t.TYPE_NAME != 9 AND t.TYPE_NAME != 13 THEN t.ALLOWANCE_WALLET_MONEY ELSE 0 END)")
    @GridColumn(label="posid_countTable_conSubsidy", width="115", columnType="custom", convert="convertFen2Yuan")
    private Integer consumSubsidy;
    @Column(name="sum(case when t.type_name = 6  then 1 else 0 end)")
    @GridColumn(label="posid_countTable_conTimes", width="120")
    private Integer conTimes;
    @Column(name="sum(case when t.type_name = 6  then t.money  else 0 end)")
    @GridColumn(label="posid_countTable_consumTotal", width="120", columnType="custom", convert="convertFen2Yuan")
    private Integer consumtotal;
    @Column(name="sum(case when t.type_name = 10 then 1 else 0 end)")
    @GridColumn(label="posid_countTable_orderTimes", width="100")
    private Integer ordertimes;
    @Column(name="sum(case when t.type_name = 6  then t.discount_money  else 0 end)")
    @GridColumn(label="posid_consume_discount_money_sum", width="115", columnType="custom", convert="convertFen2Yuan")
    private Integer discountMoney;
    @Column(name="sum(case when t.type_name = 9  then 1 else 0 end)")
    @GridColumn(label="posid_countTable_errorTimes", width="80")
    private Integer errortimes;
    @Column(name="sum(case when t.type_name = 9  then t.money else 0 end)")
    @GridColumn(label="posid_countTable_errorTotal", width="80", columnType="custom", convert="convertFen2Yuan")
    private Integer errortotal;
    @Column(name="sum(case when t.type_name = 8  then 1 else 0 end)")
    @GridColumn(label="posid_countTable_suppleTimes", width="70")
    private Integer suppletimes;
    @Column(name="sum(case when t.type_name = 8  then t.money else 0 end)")
    @GridColumn(label="posid_countTable_suppleTotal", width="80", columnType="custom", convert="convertFen2Yuan")
    private Integer suppletotal;
    @Column(name="sum(case when t.type_name = 11  then 1 else 0 end)")
    @GridColumn(label="posid_countTable_accountTimes", width="70", show=false)
    private Integer accounttimes;
    @Column(name="sum(case when t.type_name = 11  then t.money else 0 end)")
    @GridColumn(label="posid_countTable_accountTotal", width="80", columnType="custom", convert="convertFen2Yuan", show=false)
    private Integer accountTotal;
    @Column(name="sum(case when t.type_name = 6 then 1 else 0 end)")
    @GridColumn(label="posid_countTable_actualTimes", width="120")
    private Integer actualtimes;
    @Column(name="sum(case when t.type_name = 6  then t.money else 0 end)")
    @GridColumn(label="posid_countTable_equipTotal", width="130", columnType="custom", convert="convertFen2Yuan", show=false)
    private Integer equipTotal;
    @Column(name="(sum(case when t.type_name = 6  then t.money else 0 end)+sum(case when t.type_name = 8  then t.money else 0 end))")
    @GridColumn(label="posid_countTable_sysTotal", width="150", columnType="custom", convert="convertFen2Yuan")
    private Integer sysTotal;
    @Column(name="(sum(case when t.type_name = 6  then t.money else 0 end)+sum(case when t.type_name = 11  then t.money else 0 end))")
    @GridColumn(label="posid_countTable_containAccTotal", width="150", columnType="custom", convert="convertFen2Yuan", show=false)
    private Integer containAccTotal;
    @GridColumn(label="posid_countTable_conTimeStr", minWidth="160", width="170", sort="na")
    private String posTime;
    @Condition(value="t.POS_TIME", equalTag=">=", toDate=true)
    private String opTimeBegin;
    @Condition(value="t.POS_TIME", equalTag="<=", toDate=true)
    private String opTimeEnd;
    @Condition(value="t.DEPT_ID", equalTag="in")
    private String inDeptId;
    @Condition(value="t.DEPT_ID IN (SELECT ud.AUTH_DEPT_ID FROM AUTH_USER_DEPT ud WHERE ud.AUTH_USER_ID=''{0}'')")
    private String userId;
    @Condition(value="t.HALLING_ID IN (SELECT pd.ID FROM POSID_DININGHALL pd WHERE pd.AUTH_AREA_ID IN (SELECT ud.AUTH_AREA_ID FROM AUTH_USER_AREA ud WHERE ud.AUTH_USER_ID=''{0}''))")
    private String diningAreaByUserId;
    private String deptId;
    private String isIncludeLower;

    public PosIDDeviceConsumeItem() {
        this.id = UUID.randomUUID().toString();
    }

    public PosIDDeviceConsumeItem(Boolean equals) {
        super(equals);
    }

    public PosIDDeviceConsumeItem(String id) {
        super(Boolean.valueOf(true));
        this.id = id;
    }

    public PosIDDeviceConsumeItem(Boolean equals, String id, String devAlias, String devSn, Integer conTimes, Integer consumtotal, Integer ordertimes, Integer errortimes, Integer errortotal, Integer suppletimes, Integer suppletotal, Integer accounttimes, Integer accountTotal, Integer actualtimes, Integer equipTotal, Integer sysTotal, Integer containAccTotal) {
        super(equals);
        this.id = id;
        this.devAlias = devAlias;
        this.devSn = devSn;
        this.conTimes = conTimes;
        this.consumtotal = consumtotal;
        this.ordertimes = ordertimes;
        this.errortimes = errortimes;
        this.errortotal = errortotal;
        this.suppletimes = suppletimes;
        this.suppletotal = suppletotal;
        this.accounttimes = accounttimes;
        this.accountTotal = accountTotal;
        this.actualtimes = actualtimes;
        this.equipTotal = equipTotal;
        this.sysTotal = sysTotal;
        this.containAccTotal = containAccTotal;
    }

    public String getId() {
        return this.id;
    }

    public String getDevAlias() {
        return this.devAlias;
    }

    public String getDevSn() {
        return this.devSn;
    }

    public Integer getConsumCash() {
        return this.consumCash;
    }

    public Integer getConsumSubsidy() {
        return this.consumSubsidy;
    }

    public Integer getConTimes() {
        return this.conTimes;
    }

    public Integer getConsumtotal() {
        return this.consumtotal;
    }

    public Integer getOrdertimes() {
        return this.ordertimes;
    }

    public Integer getDiscountMoney() {
        return this.discountMoney;
    }

    public Integer getErrortimes() {
        return this.errortimes;
    }

    public Integer getErrortotal() {
        return this.errortotal;
    }

    public Integer getSuppletimes() {
        return this.suppletimes;
    }

    public Integer getSuppletotal() {
        return this.suppletotal;
    }

    public Integer getAccounttimes() {
        return this.accounttimes;
    }

    public Integer getAccountTotal() {
        return this.accountTotal;
    }

    public Integer getActualtimes() {
        return this.actualtimes;
    }

    public Integer getEquipTotal() {
        return this.equipTotal;
    }

    public Integer getSysTotal() {
        return this.sysTotal;
    }

    public Integer getContainAccTotal() {
        return this.containAccTotal;
    }

    public String getPosTime() {
        return this.posTime;
    }

    public String getOpTimeBegin() {
        return this.opTimeBegin;
    }

    public String getOpTimeEnd() {
        return this.opTimeEnd;
    }

    public String getInDeptId() {
        return this.inDeptId;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getDiningAreaByUserId() {
        return this.diningAreaByUserId;
    }

    public String getDeptId() {
        return this.deptId;
    }

    public String getIsIncludeLower() {
        return this.isIncludeLower;
    }

    public PosIDDeviceConsumeItem setId(String id) {
        this.id = id;
        return this;
    }

    public PosIDDeviceConsumeItem setDevAlias(String devAlias) {
        this.devAlias = devAlias;
        return this;
    }

    public PosIDDeviceConsumeItem setDevSn(String devSn) {
        this.devSn = devSn;
        return this;
    }

    public PosIDDeviceConsumeItem setConsumCash(Integer consumCash) {
        this.consumCash = consumCash;
        return this;
    }

    public PosIDDeviceConsumeItem setConsumSubsidy(Integer consumSubsidy) {
        this.consumSubsidy = consumSubsidy;
        return this;
    }

    public PosIDDeviceConsumeItem setConTimes(Integer conTimes) {
        this.conTimes = conTimes;
        return this;
    }

    public PosIDDeviceConsumeItem setConsumtotal(Integer consumtotal) {
        this.consumtotal = consumtotal;
        return this;
    }

    public PosIDDeviceConsumeItem setOrdertimes(Integer ordertimes) {
        this.ordertimes = ordertimes;
        return this;
    }

    public PosIDDeviceConsumeItem setDiscountMoney(Integer discountMoney) {
        this.discountMoney = discountMoney;
        return this;
    }

    public PosIDDeviceConsumeItem setErrortimes(Integer errortimes) {
        this.errortimes = errortimes;
        return this;
    }

    public PosIDDeviceConsumeItem setErrortotal(Integer errortotal) {
        this.errortotal = errortotal;
        return this;
    }

    public PosIDDeviceConsumeItem setSuppletimes(Integer suppletimes) {
        this.suppletimes = suppletimes;
        return this;
    }

    public PosIDDeviceConsumeItem setSuppletotal(Integer suppletotal) {
        this.suppletotal = suppletotal;
        return this;
    }

    public PosIDDeviceConsumeItem setAccounttimes(Integer accounttimes) {
        this.accounttimes = accounttimes;
        return this;
    }

    public PosIDDeviceConsumeItem setAccountTotal(Integer accountTotal) {
        this.accountTotal = accountTotal;
        return this;
    }

    public PosIDDeviceConsumeItem setActualtimes(Integer actualtimes) {
        this.actualtimes = actualtimes;
        return this;
    }

    public PosIDDeviceConsumeItem setEquipTotal(Integer equipTotal) {
        this.equipTotal = equipTotal;
        return this;
    }

    public PosIDDeviceConsumeItem setSysTotal(Integer sysTotal) {
        this.sysTotal = sysTotal;
        return this;
    }

    public PosIDDeviceConsumeItem setContainAccTotal(Integer containAccTotal) {
        this.containAccTotal = containAccTotal;
        return this;
    }

    public PosIDDeviceConsumeItem setPosTime(String posTime) {
        this.posTime = posTime;
        return this;
    }

    public PosIDDeviceConsumeItem setOpTimeBegin(String opTimeBegin) {
        this.opTimeBegin = opTimeBegin;
        return this;
    }

    public PosIDDeviceConsumeItem setOpTimeEnd(String opTimeEnd) {
        this.opTimeEnd = opTimeEnd;
        return this;
    }

    public PosIDDeviceConsumeItem setInDeptId(String inDeptId) {
        this.inDeptId = inDeptId;
        return this;
    }

    public PosIDDeviceConsumeItem setUserId(String userId) {
        this.userId = userId;
        return this;
    }

    public PosIDDeviceConsumeItem setDiningAreaByUserId(String diningAreaByUserId) {
        this.diningAreaByUserId = diningAreaByUserId;
        return this;
    }

    public PosIDDeviceConsumeItem setDeptId(String deptId) {
        this.deptId = deptId;
        return this;
    }

    public PosIDDeviceConsumeItem setIsIncludeLower(String isIncludeLower) {
        this.isIncludeLower = isIncludeLower;
        return this;
    }

    public String toString() {
        return "PosIDDeviceConsumeItem(id=" + this.getId() + ", devAlias=" + this.getDevAlias() + ", devSn=" + this.getDevSn() + ", consumCash=" + this.getConsumCash() + ", consumSubsidy=" + this.getConsumSubsidy() + ", conTimes=" + this.getConTimes() + ", consumtotal=" + this.getConsumtotal() + ", ordertimes=" + this.getOrdertimes() + ", discountMoney=" + this.getDiscountMoney() + ", errortimes=" + this.getErrortimes() + ", errortotal=" + this.getErrortotal() + ", suppletimes=" + this.getSuppletimes() + ", suppletotal=" + this.getSuppletotal() + ", accounttimes=" + this.getAccounttimes() + ", accountTotal=" + this.getAccountTotal() + ", actualtimes=" + this.getActualtimes() + ", equipTotal=" + this.getEquipTotal() + ", sysTotal=" + this.getSysTotal() + ", containAccTotal=" + this.getContainAccTotal() + ", posTime=" + this.getPosTime() + ", opTimeBegin=" + this.getOpTimeBegin() + ", opTimeEnd=" + this.getOpTimeEnd() + ", inDeptId=" + this.getInDeptId() + ", userId=" + this.getUserId() + ", diningAreaByUserId=" + this.getDiningAreaByUserId() + ", deptId=" + this.getDeptId() + ", isIncludeLower=" + this.getIsIncludeLower() + ")";
    }
}

