/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.posid.vo;

import com.zkteco.zkbiosecurity.base.annotation.Column;
import com.zkteco.zkbiosecurity.base.annotation.Condition;
import com.zkteco.zkbiosecurity.base.annotation.From;
import com.zkteco.zkbiosecurity.base.annotation.GridColumn;
import com.zkteco.zkbiosecurity.base.annotation.GridConfig;
import com.zkteco.zkbiosecurity.base.annotation.GroupBy;
import com.zkteco.zkbiosecurity.base.annotation.Where;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import java.util.Map;
import java.util.UUID;

@From(after="POSID_TRANSACTION t")
@Where(after="AND t.DEV_SN IS NOT NULL AND t.TYPE_NAME != 9 AND t.TYPE_NAME != 13")
@GroupBy(after="t.DEV_SN")
@GridConfig(operate=true, idField="id", winHeight=400, winWidth=600)
public class PosIDDevMealSummaryItem
extends BaseItem {
    @GridColumn(show=false)
    private String id = UUID.randomUUID().toString();
    @Column(name="t.DEV_SN")
    @GridColumn(label="common_dev_sn", width="100", i18n=true)
    private String devSn;
    @GridColumn(label="common_dev_name", width="100", sort="na")
    private String devAlias;
    @GridColumn(dynamicColumn="mealDetailDyna")
    private Map<String, Object> mealDetailMap;
    @Column(name="COUNT(t.ID)")
    @GridColumn(label="posid_countTable_total_times", width="120")
    private Integer totalTimes;
    @Column(name="SUM(t.MONEY)")
    @GridColumn(label="posid_countTable_total_amount", minWidth="120", columnType="custom", convert="convertFen2Yuan")
    private Integer totalAmount;
    @Condition(value="t.POS_TIME", equalTag=">=", toDate=true)
    private String startDatetimeBegin;
    @Condition(value="t.POS_TIME", equalTag="<=", toDate=true)
    private String startDatetimeEnd;
    @Condition(value="t.DEV_ALIAS", equalTag="like")
    private String likeDevAlias;
    @Condition(value="t.DEPT_ID", equalTag="in")
    private String inDeptId;
    @Condition(value="t.DEPT_ID IN (SELECT ud.AUTH_DEPT_ID FROM AUTH_USER_DEPT ud WHERE ud.AUTH_USER_ID=''{0}'')")
    private String userId;
    @Condition(value="t.HALLING_ID IN (SELECT pd.ID FROM POSID_DININGHALL pd WHERE pd.AUTH_AREA_ID IN (SELECT ud.AUTH_AREA_ID FROM AUTH_USER_AREA ud WHERE ud.AUTH_USER_ID=''{0}''))")
    private String diningAreaByUserId;
    private String deptId;
    private String isIncludeLower;

    public String getId() {
        return this.id;
    }

    public String getDevSn() {
        return this.devSn;
    }

    public String getDevAlias() {
        return this.devAlias;
    }

    public Map<String, Object> getMealDetailMap() {
        return this.mealDetailMap;
    }

    public Integer getTotalTimes() {
        return this.totalTimes;
    }

    public Integer getTotalAmount() {
        return this.totalAmount;
    }

    public String getStartDatetimeBegin() {
        return this.startDatetimeBegin;
    }

    public String getStartDatetimeEnd() {
        return this.startDatetimeEnd;
    }

    public String getLikeDevAlias() {
        return this.likeDevAlias;
    }

    public String getInDeptId() {
        return this.inDeptId;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getDiningAreaByUserId() {
        return this.diningAreaByUserId;
    }

    public String getDeptId() {
        return this.deptId;
    }

    public String getIsIncludeLower() {
        return this.isIncludeLower;
    }

    public PosIDDevMealSummaryItem setId(String id) {
        this.id = id;
        return this;
    }

    public PosIDDevMealSummaryItem setDevSn(String devSn) {
        this.devSn = devSn;
        return this;
    }

    public PosIDDevMealSummaryItem setDevAlias(String devAlias) {
        this.devAlias = devAlias;
        return this;
    }

    public PosIDDevMealSummaryItem setMealDetailMap(Map<String, Object> mealDetailMap) {
        this.mealDetailMap = mealDetailMap;
        return this;
    }

    public PosIDDevMealSummaryItem setTotalTimes(Integer totalTimes) {
        this.totalTimes = totalTimes;
        return this;
    }

    public PosIDDevMealSummaryItem setTotalAmount(Integer totalAmount) {
        this.totalAmount = totalAmount;
        return this;
    }

    public PosIDDevMealSummaryItem setStartDatetimeBegin(String startDatetimeBegin) {
        this.startDatetimeBegin = startDatetimeBegin;
        return this;
    }

    public PosIDDevMealSummaryItem setStartDatetimeEnd(String startDatetimeEnd) {
        this.startDatetimeEnd = startDatetimeEnd;
        return this;
    }

    public PosIDDevMealSummaryItem setLikeDevAlias(String likeDevAlias) {
        this.likeDevAlias = likeDevAlias;
        return this;
    }

    public PosIDDevMealSummaryItem setInDeptId(String inDeptId) {
        this.inDeptId = inDeptId;
        return this;
    }

    public PosIDDevMealSummaryItem setUserId(String userId) {
        this.userId = userId;
        return this;
    }

    public PosIDDevMealSummaryItem setDiningAreaByUserId(String diningAreaByUserId) {
        this.diningAreaByUserId = diningAreaByUserId;
        return this;
    }

    public PosIDDevMealSummaryItem setDeptId(String deptId) {
        this.deptId = deptId;
        return this;
    }

    public PosIDDevMealSummaryItem setIsIncludeLower(String isIncludeLower) {
        this.isIncludeLower = isIncludeLower;
        return this;
    }

    public String toString() {
        return "PosIDDevMealSummaryItem(id=" + this.getId() + ", devSn=" + this.getDevSn() + ", devAlias=" + this.getDevAlias() + ", mealDetailMap=" + this.getMealDetailMap() + ", totalTimes=" + this.getTotalTimes() + ", totalAmount=" + this.getTotalAmount() + ", startDatetimeBegin=" + this.getStartDatetimeBegin() + ", startDatetimeEnd=" + this.getStartDatetimeEnd() + ", likeDevAlias=" + this.getLikeDevAlias() + ", inDeptId=" + this.getInDeptId() + ", userId=" + this.getUserId() + ", diningAreaByUserId=" + this.getDiningAreaByUserId() + ", deptId=" + this.getDeptId() + ", isIncludeLower=" + this.getIsIncludeLower() + ")";
    }
}

