/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.posid.vo;

import com.zkteco.zkbiosecurity.base.annotation.Column;
import com.zkteco.zkbiosecurity.base.annotation.Condition;
import com.zkteco.zkbiosecurity.base.annotation.From;
import com.zkteco.zkbiosecurity.base.annotation.GridColumn;
import com.zkteco.zkbiosecurity.base.annotation.GridConfig;
import com.zkteco.zkbiosecurity.base.annotation.GroupBy;
import com.zkteco.zkbiosecurity.base.annotation.Where;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;

@From(after="POSID_TRANSACTION t")
@Where(after="AND t.TYPE_NAME != 9 AND t.TYPE_NAME != 13")
@GroupBy(after="t.MEAL_CODE")
@GridConfig(operate=true, idField="id", winHeight=400, winWidth=600)
public class PosIDDevMealGroupItem
extends BaseItem {
    @GridColumn(show=false)
    private String id;
    @Column(name="t.MEAL_CODE")
    private String mealCode;
    @Column(name="COUNT(t.ID)")
    private Integer totalTimes;
    @Column(name="SUM(t.MONEY)")
    private Integer totalAmount;
    @Condition(value="t.POS_TIME", equalTag=">=", toDate=true)
    private String startDatetimeBegin;
    @Condition(value="t.POS_TIME", equalTag="<=", toDate=true)
    private String startDatetimeEnd;
    @Condition(value="t.DEV_SN", equalTag="like")
    private String devSn;
    @Condition(value="t.DEPT_ID", equalTag="in")
    private String inDeptId;
    @Condition(value="t.DEV_ALIAS", equalTag="like")
    private String likeDevAlias;
    @Condition(value="t.DEPT_ID IN (SELECT ud.AUTH_DEPT_ID FROM AUTH_USER_DEPT ud WHERE ud.AUTH_USER_ID=''{0}'')")
    private String userId;
    @Condition(value="t.HALLING_ID IN (SELECT pd.ID FROM POSID_DININGHALL pd WHERE pd.AUTH_AREA_ID IN (SELECT ud.AUTH_AREA_ID FROM AUTH_USER_AREA ud WHERE ud.AUTH_USER_ID=''{0}''))")
    private String diningAreaByUserId;

    public String getId() {
        return this.id;
    }

    public String getMealCode() {
        return this.mealCode;
    }

    public Integer getTotalTimes() {
        return this.totalTimes;
    }

    public Integer getTotalAmount() {
        return this.totalAmount;
    }

    public String getStartDatetimeBegin() {
        return this.startDatetimeBegin;
    }

    public String getStartDatetimeEnd() {
        return this.startDatetimeEnd;
    }

    public String getDevSn() {
        return this.devSn;
    }

    public String getInDeptId() {
        return this.inDeptId;
    }

    public String getLikeDevAlias() {
        return this.likeDevAlias;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getDiningAreaByUserId() {
        return this.diningAreaByUserId;
    }

    public PosIDDevMealGroupItem setId(String id) {
        this.id = id;
        return this;
    }

    public PosIDDevMealGroupItem setMealCode(String mealCode) {
        this.mealCode = mealCode;
        return this;
    }

    public PosIDDevMealGroupItem setTotalTimes(Integer totalTimes) {
        this.totalTimes = totalTimes;
        return this;
    }

    public PosIDDevMealGroupItem setTotalAmount(Integer totalAmount) {
        this.totalAmount = totalAmount;
        return this;
    }

    public PosIDDevMealGroupItem setStartDatetimeBegin(String startDatetimeBegin) {
        this.startDatetimeBegin = startDatetimeBegin;
        return this;
    }

    public PosIDDevMealGroupItem setStartDatetimeEnd(String startDatetimeEnd) {
        this.startDatetimeEnd = startDatetimeEnd;
        return this;
    }

    public PosIDDevMealGroupItem setDevSn(String devSn) {
        this.devSn = devSn;
        return this;
    }

    public PosIDDevMealGroupItem setInDeptId(String inDeptId) {
        this.inDeptId = inDeptId;
        return this;
    }

    public PosIDDevMealGroupItem setLikeDevAlias(String likeDevAlias) {
        this.likeDevAlias = likeDevAlias;
        return this;
    }

    public PosIDDevMealGroupItem setUserId(String userId) {
        this.userId = userId;
        return this;
    }

    public PosIDDevMealGroupItem setDiningAreaByUserId(String diningAreaByUserId) {
        this.diningAreaByUserId = diningAreaByUserId;
        return this;
    }

    public String toString() {
        return "PosIDDevMealGroupItem(id=" + this.getId() + ", mealCode=" + this.getMealCode() + ", totalTimes=" + this.getTotalTimes() + ", totalAmount=" + this.getTotalAmount() + ", startDatetimeBegin=" + this.getStartDatetimeBegin() + ", startDatetimeEnd=" + this.getStartDatetimeEnd() + ", devSn=" + this.getDevSn() + ", inDeptId=" + this.getInDeptId() + ", likeDevAlias=" + this.getLikeDevAlias() + ", userId=" + this.getUserId() + ", diningAreaByUserId=" + this.getDiningAreaByUserId() + ")";
    }
}

