/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.posid.vo;

import com.zkteco.zkbiosecurity.base.annotation.Column;
import com.zkteco.zkbiosecurity.base.annotation.Condition;
import com.zkteco.zkbiosecurity.base.annotation.From;
import com.zkteco.zkbiosecurity.base.annotation.GridColumn;
import com.zkteco.zkbiosecurity.base.annotation.GridConfig;
import com.zkteco.zkbiosecurity.base.annotation.GroupBy;
import com.zkteco.zkbiosecurity.base.annotation.OrderBy;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import java.util.UUID;

@From(after="POSID_TRANSACTION T")
@GroupBy(after=" T.DEPT_ID, T.DEPT_NAME")
@OrderBy(after="T.DEPT_ID")
@GridConfig(operate=true, idField="id", winHeight=400, winWidth=600)
public class PosIDDeptConsumeItem
extends BaseItem {
    @GridColumn(show=false)
    private String id;
    @Column(name="t.DEPT_ID")
    @GridColumn(label="posid_transaction_deptId", show=false)
    private String deptId;
    @Column(name="t.DEPT_NAME")
    @GridColumn(label="posid_card_deptName", width="110", i18n=true)
    private String deptName;
    @Column(name="sum(case when t.type_name = 6  then 1 else 0 end)")
    @GridColumn(label="posid_countTable_conTimes", width="120")
    private Integer conTimes;
    @Column(name="sum(case when t.type_name = 6  then t.money  else 0 end)")
    @GridColumn(label="posid_countTable_consumTotal", width="115", columnType="custom", convert="convertFen2Yuan")
    private Integer consumtotal;
    @Column(name="sum(case when t.type_name = 6  then t.discount_money  else 0 end)")
    @GridColumn(label="posid_consume_discount_money_sum", width="115", columnType="custom", convert="convertFen2Yuan")
    private Integer discountMoney;
    @Column(name="sum(case when t.type_name = 10 then 1 else 0 end)")
    @GridColumn(label="posid_countTable_orderTimes", width="100")
    private Integer ordertimes;
    @Column(name="sum(case when t.type_name = 9  then 1 else 0 end)")
    @GridColumn(label="posid_countTable_errorTimes", width="170")
    private Integer errortimes;
    @Column(name="sum(case when t.type_name = 9  then t.money else 0 end)")
    @GridColumn(label="posid_countTable_errorTotal", width="135", columnType="custom", convert="convertFen2Yuan")
    private Integer errortotal;
    @Column(name="(sum(case when t.type_name = 8  then 1 else 0 end))")
    @GridColumn(label="posid_countTable_suppleTimes", width="130")
    private Integer suppletimes;
    @Column(name="sum(case when t.type_name = 8  then t.money else 0 end)")
    @GridColumn(label="posid_countTable_suppleTotal", width="160", columnType="custom", convert="convertFen2Yuan")
    private Integer suppletotal;
    @Column(name="(sum(case when t.type_name = 11  then 1 else 0 end))")
    @GridColumn(label="posid_countTable_accountTimes", width="70", show=false)
    private Integer accounttimes;
    @Column(name="sum(case when t.type_name = 11  then t.money else 0 end)")
    @GridColumn(label="posid_countTable_accountTotal", width="80", columnType="custom", convert="convertFen2Yuan", show=false)
    private Integer accountTotal;
    @Column(name="sum(case when t.type_name = 6 then 1 else 0 end)")
    @GridColumn(label="posid_countTable_actualTimes", width="120")
    private Integer actualtimes;
    @Column(name="sum(case when t.type_name = 6  then t.money else 0 end)")
    @GridColumn(label="posid_countTable_equipTotal", width="130", columnType="custom", convert="convertFen2Yuan")
    private Integer equipTotal;
    @Column(name="(sum(case when t.type_name = 6  then t.money else 0 end)+sum(case when t.type_name = 8  then t.money else 0 end))")
    @GridColumn(label="posid_countTable_sysTotal", width="150", columnType="custom", convert="convertFen2Yuan")
    private Integer sysTotal;
    @Column(name="(sum(case when t.type_name = 6  then t.money else 0 end)+sum(case when t.type_name = 11  then t.money else 0 end))")
    @GridColumn(label="posid_countTable_containAccTotal", width="150", columnType="custom", convert="convertFen2Yuan")
    private Integer containAccTotal;
    @GridColumn(label="posid_countTable_conTimeStr", minWidth="160", width="170", sort="na")
    private String posTime;
    @Condition(value="t.POS_TIME", equalTag=">=", toDate=true)
    private String opTimeBegin;
    @Condition(value="t.POS_TIME", equalTag="<=", toDate=true)
    private String opTimeEnd;
    @Condition(value="t.DEPT_ID", equalTag="in")
    private String inDeptId;
    @Condition(value="t.DEPT_ID IN (SELECT ud.AUTH_DEPT_ID FROM AUTH_USER_DEPT ud WHERE ud.AUTH_USER_ID=''{0}'')")
    private String userId;
    @Condition(value="t.HALLING_ID IN (SELECT pd.ID FROM POSID_DININGHALL pd WHERE pd.AUTH_AREA_ID IN (SELECT ud.AUTH_AREA_ID FROM AUTH_USER_AREA ud WHERE ud.AUTH_USER_ID=''{0}''))")
    private String diningAreaByUserId;
    private String isIncludeLower;

    public PosIDDeptConsumeItem() {
        this.id = UUID.randomUUID().toString();
    }

    public PosIDDeptConsumeItem(Boolean equals) {
        super(equals);
    }

    public PosIDDeptConsumeItem(String id) {
        super(Boolean.valueOf(true));
        this.id = id;
    }

    public PosIDDeptConsumeItem(Boolean equals, String id, String deptName, Integer conTimes, Integer consumtotal, Integer ordertimes, Integer errortimes, Integer errortotal, Integer suppletimes, Integer suppletotal, Integer accounttimes, Integer accountTotal, Integer actualtimes, Integer equipTotal, Integer sysTotal, Integer containAccTotal) {
        super(equals);
        this.id = id;
        this.deptName = deptName;
        this.conTimes = conTimes;
        this.consumtotal = consumtotal;
        this.ordertimes = ordertimes;
        this.errortimes = errortimes;
        this.errortotal = errortotal;
        this.suppletimes = suppletimes;
        this.suppletotal = suppletotal;
        this.accounttimes = accounttimes;
        this.accountTotal = accountTotal;
        this.actualtimes = actualtimes;
        this.equipTotal = equipTotal;
        this.sysTotal = sysTotal;
        this.containAccTotal = containAccTotal;
    }

    public String getId() {
        return this.id;
    }

    public String getDeptId() {
        return this.deptId;
    }

    public String getDeptName() {
        return this.deptName;
    }

    public Integer getConTimes() {
        return this.conTimes;
    }

    public Integer getConsumtotal() {
        return this.consumtotal;
    }

    public Integer getDiscountMoney() {
        return this.discountMoney;
    }

    public Integer getOrdertimes() {
        return this.ordertimes;
    }

    public Integer getErrortimes() {
        return this.errortimes;
    }

    public Integer getErrortotal() {
        return this.errortotal;
    }

    public Integer getSuppletimes() {
        return this.suppletimes;
    }

    public Integer getSuppletotal() {
        return this.suppletotal;
    }

    public Integer getAccounttimes() {
        return this.accounttimes;
    }

    public Integer getAccountTotal() {
        return this.accountTotal;
    }

    public Integer getActualtimes() {
        return this.actualtimes;
    }

    public Integer getEquipTotal() {
        return this.equipTotal;
    }

    public Integer getSysTotal() {
        return this.sysTotal;
    }

    public Integer getContainAccTotal() {
        return this.containAccTotal;
    }

    public String getPosTime() {
        return this.posTime;
    }

    public String getOpTimeBegin() {
        return this.opTimeBegin;
    }

    public String getOpTimeEnd() {
        return this.opTimeEnd;
    }

    public String getInDeptId() {
        return this.inDeptId;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getDiningAreaByUserId() {
        return this.diningAreaByUserId;
    }

    public String getIsIncludeLower() {
        return this.isIncludeLower;
    }

    public PosIDDeptConsumeItem setId(String id) {
        this.id = id;
        return this;
    }

    public PosIDDeptConsumeItem setDeptId(String deptId) {
        this.deptId = deptId;
        return this;
    }

    public PosIDDeptConsumeItem setDeptName(String deptName) {
        this.deptName = deptName;
        return this;
    }

    public PosIDDeptConsumeItem setConTimes(Integer conTimes) {
        this.conTimes = conTimes;
        return this;
    }

    public PosIDDeptConsumeItem setConsumtotal(Integer consumtotal) {
        this.consumtotal = consumtotal;
        return this;
    }

    public PosIDDeptConsumeItem setDiscountMoney(Integer discountMoney) {
        this.discountMoney = discountMoney;
        return this;
    }

    public PosIDDeptConsumeItem setOrdertimes(Integer ordertimes) {
        this.ordertimes = ordertimes;
        return this;
    }

    public PosIDDeptConsumeItem setErrortimes(Integer errortimes) {
        this.errortimes = errortimes;
        return this;
    }

    public PosIDDeptConsumeItem setErrortotal(Integer errortotal) {
        this.errortotal = errortotal;
        return this;
    }

    public PosIDDeptConsumeItem setSuppletimes(Integer suppletimes) {
        this.suppletimes = suppletimes;
        return this;
    }

    public PosIDDeptConsumeItem setSuppletotal(Integer suppletotal) {
        this.suppletotal = suppletotal;
        return this;
    }

    public PosIDDeptConsumeItem setAccounttimes(Integer accounttimes) {
        this.accounttimes = accounttimes;
        return this;
    }

    public PosIDDeptConsumeItem setAccountTotal(Integer accountTotal) {
        this.accountTotal = accountTotal;
        return this;
    }

    public PosIDDeptConsumeItem setActualtimes(Integer actualtimes) {
        this.actualtimes = actualtimes;
        return this;
    }

    public PosIDDeptConsumeItem setEquipTotal(Integer equipTotal) {
        this.equipTotal = equipTotal;
        return this;
    }

    public PosIDDeptConsumeItem setSysTotal(Integer sysTotal) {
        this.sysTotal = sysTotal;
        return this;
    }

    public PosIDDeptConsumeItem setContainAccTotal(Integer containAccTotal) {
        this.containAccTotal = containAccTotal;
        return this;
    }

    public PosIDDeptConsumeItem setPosTime(String posTime) {
        this.posTime = posTime;
        return this;
    }

    public PosIDDeptConsumeItem setOpTimeBegin(String opTimeBegin) {
        this.opTimeBegin = opTimeBegin;
        return this;
    }

    public PosIDDeptConsumeItem setOpTimeEnd(String opTimeEnd) {
        this.opTimeEnd = opTimeEnd;
        return this;
    }

    public PosIDDeptConsumeItem setInDeptId(String inDeptId) {
        this.inDeptId = inDeptId;
        return this;
    }

    public PosIDDeptConsumeItem setUserId(String userId) {
        this.userId = userId;
        return this;
    }

    public PosIDDeptConsumeItem setDiningAreaByUserId(String diningAreaByUserId) {
        this.diningAreaByUserId = diningAreaByUserId;
        return this;
    }

    public PosIDDeptConsumeItem setIsIncludeLower(String isIncludeLower) {
        this.isIncludeLower = isIncludeLower;
        return this;
    }

    public String toString() {
        return "PosIDDeptConsumeItem(id=" + this.getId() + ", deptId=" + this.getDeptId() + ", deptName=" + this.getDeptName() + ", conTimes=" + this.getConTimes() + ", consumtotal=" + this.getConsumtotal() + ", discountMoney=" + this.getDiscountMoney() + ", ordertimes=" + this.getOrdertimes() + ", errortimes=" + this.getErrortimes() + ", errortotal=" + this.getErrortotal() + ", suppletimes=" + this.getSuppletimes() + ", suppletotal=" + this.getSuppletotal() + ", accounttimes=" + this.getAccounttimes() + ", accountTotal=" + this.getAccountTotal() + ", actualtimes=" + this.getActualtimes() + ", equipTotal=" + this.getEquipTotal() + ", sysTotal=" + this.getSysTotal() + ", containAccTotal=" + this.getContainAccTotal() + ", posTime=" + this.getPosTime() + ", opTimeBegin=" + this.getOpTimeBegin() + ", opTimeEnd=" + this.getOpTimeEnd() + ", inDeptId=" + this.getInDeptId() + ", userId=" + this.getUserId() + ", diningAreaByUserId=" + this.getDiningAreaByUserId() + ", isIncludeLower=" + this.getIsIncludeLower() + ")";
    }
}

