/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.posid.vo;

import com.zkteco.zkbiosecurity.base.annotation.Column;
import com.zkteco.zkbiosecurity.base.annotation.Condition;
import com.zkteco.zkbiosecurity.base.annotation.From;
import com.zkteco.zkbiosecurity.base.annotation.GridColumn;
import com.zkteco.zkbiosecurity.base.annotation.GridConfig;
import com.zkteco.zkbiosecurity.base.annotation.OrderBy;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import java.util.Date;

@From(after="POSID_ORDER_MEAL t LEFT JOIN AUTH_DEPARTMENT d ON d.ID = t.DEPT_ID ")
@OrderBy(after="t.ORDER_TIME DESC")
@GridConfig(operate=true, idField="id", winHeight=400, winWidth=600, operates={})
public class PosIDCusOrderMealListItem
extends BaseItem {
    @Column(name="t.ID")
    @GridColumn(checkbox=false, width="40", sort="na", show=false)
    private String id;
    @Column(name="t.PIN")
    @GridColumn(label="pers_person_pin", width="120", i18n=true, encryptMode="${pers.pin.encryptMode}", encryptProp="${pers.pin.encryptProp}")
    private String personPin;
    @Column(name="t.PERSON_NAME")
    @GridColumn(label="pers_person_name", width="120", encryptMode="${pers.name.encryptMode}", encryptProp="${pers.name.encryptProp}")
    private String personName;
    @Column(name="d.NAME")
    @GridColumn(label="posid_card_deptName", width="120")
    private String deptName;
    @Column(name="t.MEAL_NAME")
    @GridColumn(label="posid_meal_name", width="120")
    private String mealName;
    @Column(name="t.STATUS")
    @GridColumn(label="common_status", width="120", format="0=posid_orderMeal_status_three,1=posid_orderMeal_status_one,2=posid_orderMeal_status_two,3=posid_orderMeal_status_four")
    private Integer status;
    @Column(name="t.ORDER_END_TIME")
    private Date orderEndTime;
    @Condition(value="t.HALLING_ID", equalTag="=")
    private String hallingId;
    @Condition(value="t.MEAL_ID", equalTag="=")
    private String mealId;
    @Condition(value="t.ORDER_TIME", equalTag=">=")
    private Date startTime;
    @Condition(value="t.ORDER_TIME", equalTag="<=")
    private Date endTime;
    private String orderTime;
    @Condition(value="t.ORDER_END_TIME", equalTag=">=")
    private Date notEatenMealEndTime;
    @Condition(value="t.ORDER_END_TIME", equalTag="<")
    private Date expiredMealEndTime;
    @Condition(value="t.STATUS", equalTag="=")
    private Integer orderMealStatusEql;
    @Condition(value="t.DEPT_ID IN (SELECT ud.AUTH_DEPT_ID FROM AUTH_USER_DEPT ud WHERE ud.AUTH_USER_ID=''{0}'')")
    private String userId;

    public String getId() {
        return this.id;
    }

    public String getPersonPin() {
        return this.personPin;
    }

    public String getPersonName() {
        return this.personName;
    }

    public String getDeptName() {
        return this.deptName;
    }

    public String getMealName() {
        return this.mealName;
    }

    public Integer getStatus() {
        return this.status;
    }

    public Date getOrderEndTime() {
        return this.orderEndTime;
    }

    public String getHallingId() {
        return this.hallingId;
    }

    public String getMealId() {
        return this.mealId;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public String getOrderTime() {
        return this.orderTime;
    }

    public Date getNotEatenMealEndTime() {
        return this.notEatenMealEndTime;
    }

    public Date getExpiredMealEndTime() {
        return this.expiredMealEndTime;
    }

    public Integer getOrderMealStatusEql() {
        return this.orderMealStatusEql;
    }

    public String getUserId() {
        return this.userId;
    }

    public PosIDCusOrderMealListItem setId(String id) {
        this.id = id;
        return this;
    }

    public PosIDCusOrderMealListItem setPersonPin(String personPin) {
        this.personPin = personPin;
        return this;
    }

    public PosIDCusOrderMealListItem setPersonName(String personName) {
        this.personName = personName;
        return this;
    }

    public PosIDCusOrderMealListItem setDeptName(String deptName) {
        this.deptName = deptName;
        return this;
    }

    public PosIDCusOrderMealListItem setMealName(String mealName) {
        this.mealName = mealName;
        return this;
    }

    public PosIDCusOrderMealListItem setStatus(Integer status) {
        this.status = status;
        return this;
    }

    public PosIDCusOrderMealListItem setOrderEndTime(Date orderEndTime) {
        this.orderEndTime = orderEndTime;
        return this;
    }

    public PosIDCusOrderMealListItem setHallingId(String hallingId) {
        this.hallingId = hallingId;
        return this;
    }

    public PosIDCusOrderMealListItem setMealId(String mealId) {
        this.mealId = mealId;
        return this;
    }

    public PosIDCusOrderMealListItem setStartTime(Date startTime) {
        this.startTime = startTime;
        return this;
    }

    public PosIDCusOrderMealListItem setEndTime(Date endTime) {
        this.endTime = endTime;
        return this;
    }

    public PosIDCusOrderMealListItem setOrderTime(String orderTime) {
        this.orderTime = orderTime;
        return this;
    }

    public PosIDCusOrderMealListItem setNotEatenMealEndTime(Date notEatenMealEndTime) {
        this.notEatenMealEndTime = notEatenMealEndTime;
        return this;
    }

    public PosIDCusOrderMealListItem setExpiredMealEndTime(Date expiredMealEndTime) {
        this.expiredMealEndTime = expiredMealEndTime;
        return this;
    }

    public PosIDCusOrderMealListItem setOrderMealStatusEql(Integer orderMealStatusEql) {
        this.orderMealStatusEql = orderMealStatusEql;
        return this;
    }

    public PosIDCusOrderMealListItem setUserId(String userId) {
        this.userId = userId;
        return this;
    }

    public String toString() {
        return "PosIDCusOrderMealListItem(id=" + this.getId() + ", personPin=" + this.getPersonPin() + ", personName=" + this.getPersonName() + ", deptName=" + this.getDeptName() + ", mealName=" + this.getMealName() + ", status=" + this.getStatus() + ", orderEndTime=" + this.getOrderEndTime() + ", hallingId=" + this.getHallingId() + ", mealId=" + this.getMealId() + ", startTime=" + this.getStartTime() + ", endTime=" + this.getEndTime() + ", orderTime=" + this.getOrderTime() + ", notEatenMealEndTime=" + this.getNotEatenMealEndTime() + ", expiredMealEndTime=" + this.getExpiredMealEndTime() + ", orderMealStatusEql=" + this.getOrderMealStatusEql() + ", userId=" + this.getUserId() + ")";
    }
}

