/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.posid.vo;

import com.zkteco.zkbiosecurity.base.annotation.Column;
import com.zkteco.zkbiosecurity.base.annotation.Condition;
import com.zkteco.zkbiosecurity.base.annotation.From;
import com.zkteco.zkbiosecurity.base.annotation.GridColumn;
import com.zkteco.zkbiosecurity.base.annotation.GridConfig;
import com.zkteco.zkbiosecurity.base.annotation.GroupBy;
import com.zkteco.zkbiosecurity.base.annotation.OrderBy;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import java.util.Date;
import java.util.UUID;

@From(after="POSID_ORDER_MEAL t")
@GroupBy(after="%s")
@OrderBy(after="%s DESC")
@GridConfig(operate=true, idField="id", winHeight=400, winWidth=600, operates={})
public class PosIDCusOrderMealItem
extends BaseItem {
    @GridColumn(show=false)
    private String id = UUID.randomUUID().toString();
    @Column(name="%s")
    @GridColumn(label="posid_orderMeal_create_time", width="120")
    private String orderTime;
    @Column(name="count(t.id)")
    @GridColumn(label="posid_orderMeal_status_zero", width="120", columnType="custom", convert="getOrderedMeals", sort="na")
    private String orderedMeals;
    @Column(name="sum(case when t.STATUS = 0 AND t.ORDER_END_TIME >= %s then 1 else 0 end)")
    @GridColumn(label="posid_orderMeal_status_three", width="120", columnType="custom", convert="getNoMeals", sort="na")
    private String noMeals;
    @Column(name="sum(case when t.STATUS = 1  then 1 else 0 end)")
    @GridColumn(label="posid_orderMeal_status_one", width="120", columnType="custom", convert="getDinnerAlreadyServed", sort="na")
    private String dinnerAlreadyServed;
    @Column(name="sum(case when t.STATUS = 2  then 1 else 0 end)")
    @GridColumn(label="posid_orderMeal_status_two", width="120", columnType="custom", convert="getCancelled", sort="na")
    private String cancelled;
    @Column(name="sum(case when t.STATUS = 0 AND t.ORDER_END_TIME < %s  then 1 else 0 end)")
    @GridColumn(label="posid_orderMeal_status_four", width="120", columnType="custom", convert="getExpired", sort="na")
    private String expired;
    @Condition(value="t.HALLING_ID", equalTag="=")
    private String hallingId;
    @Condition(value="t.ORDER_TIME", equalTag=">=")
    private Date startTime;
    @Condition(value="t.ORDER_TIME", equalTag="<=")
    private Date endTime;
    @Condition(value="t.DEPT_ID IN (SELECT ud.AUTH_DEPT_ID FROM AUTH_USER_DEPT ud WHERE ud.AUTH_USER_ID=''{0}'')")
    private String userId;

    public String getId() {
        return this.id;
    }

    public String getOrderTime() {
        return this.orderTime;
    }

    public String getOrderedMeals() {
        return this.orderedMeals;
    }

    public String getNoMeals() {
        return this.noMeals;
    }

    public String getDinnerAlreadyServed() {
        return this.dinnerAlreadyServed;
    }

    public String getCancelled() {
        return this.cancelled;
    }

    public String getExpired() {
        return this.expired;
    }

    public String getHallingId() {
        return this.hallingId;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public String getUserId() {
        return this.userId;
    }

    public PosIDCusOrderMealItem setId(String id) {
        this.id = id;
        return this;
    }

    public PosIDCusOrderMealItem setOrderTime(String orderTime) {
        this.orderTime = orderTime;
        return this;
    }

    public PosIDCusOrderMealItem setOrderedMeals(String orderedMeals) {
        this.orderedMeals = orderedMeals;
        return this;
    }

    public PosIDCusOrderMealItem setNoMeals(String noMeals) {
        this.noMeals = noMeals;
        return this;
    }

    public PosIDCusOrderMealItem setDinnerAlreadyServed(String dinnerAlreadyServed) {
        this.dinnerAlreadyServed = dinnerAlreadyServed;
        return this;
    }

    public PosIDCusOrderMealItem setCancelled(String cancelled) {
        this.cancelled = cancelled;
        return this;
    }

    public PosIDCusOrderMealItem setExpired(String expired) {
        this.expired = expired;
        return this;
    }

    public PosIDCusOrderMealItem setHallingId(String hallingId) {
        this.hallingId = hallingId;
        return this;
    }

    public PosIDCusOrderMealItem setStartTime(Date startTime) {
        this.startTime = startTime;
        return this;
    }

    public PosIDCusOrderMealItem setEndTime(Date endTime) {
        this.endTime = endTime;
        return this;
    }

    public PosIDCusOrderMealItem setUserId(String userId) {
        this.userId = userId;
        return this;
    }

    public String toString() {
        return "PosIDCusOrderMealItem(id=" + this.getId() + ", orderTime=" + this.getOrderTime() + ", orderedMeals=" + this.getOrderedMeals() + ", noMeals=" + this.getNoMeals() + ", dinnerAlreadyServed=" + this.getDinnerAlreadyServed() + ", cancelled=" + this.getCancelled() + ", expired=" + this.getExpired() + ", hallingId=" + this.getHallingId() + ", startTime=" + this.getStartTime() + ", endTime=" + this.getEndTime() + ", userId=" + this.getUserId() + ")";
    }
}

