/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.posid.vo;

import com.zkteco.zkbiosecurity.base.annotation.Column;
import com.zkteco.zkbiosecurity.base.annotation.Condition;
import com.zkteco.zkbiosecurity.base.annotation.From;
import com.zkteco.zkbiosecurity.base.annotation.GridColumn;
import com.zkteco.zkbiosecurity.base.annotation.GridConfig;
import com.zkteco.zkbiosecurity.base.annotation.OrderBy;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;

@From(after="POSID_ACCOUNT t")
@OrderBy(after="t.CREATE_TIME DESC")
@GridConfig(operate=true, idField="id", winHeight=580, winWidth=650)
public class PosIDAccountWalletItem
extends BaseItem {
    private static final long serialVersionUID = 1L;
    @Column(name="t.ID")
    @GridColumn(checkbox=true, width="40", sort="na", show=false)
    private String id;
    @Column(name="t.PERSON_ID")
    private String personId;
    @Column(name="t.BALANCE")
    @GridColumn(label="posid_card_blance", width="120", columnType="custom", convert="convertFen2Yuan")
    private Integer balance;
    @GridColumn(label="posid_account_money_wallet", sort="na", width="120", columnType="custom", convert="convertFen2Yuan")
    private Integer posMoneyWallet;
    @GridColumn(label="posid_account_allowance_wallet", sort="na", width="120", columnType="custom", convert="convertFen2Yuan")
    private Integer posAllowanceWallet;
    @Column(name="t.PERSON_PIN")
    @GridColumn(label="pers_person_pin", width="120", encryptMode="${pers.pin.encryptMode}", encryptProp="${pers.pin.encryptProp}")
    private String personPin;
    @Column(name="t.PERSON_NAME")
    @GridColumn(label="pers_person_name", width="120", encryptMode="${pers.name.encryptMode}", encryptProp="${pers.name.encryptProp}")
    private String personName;
    @Column(name="t.PERSON_LAST_NAME")
    @GridColumn(label="pers_person_lastName", width="120", showExpression="#language!='zh_CN'", encryptMode="${pers.lastName.encryptMode}", encryptProp="${pers.lastName.encryptProp}")
    private String personLastName;
    @Column(name="t.ACCOUNT_NO")
    @GridColumn(label="posid_card_accountNum", width="120")
    private String accountNo;
    @Column(name="t.IS_VALID")
    @GridColumn(label="posid_card_isValid", columnType="custom", convert="availableToString", width="80")
    private Integer available;
    @Condition(value="(t.PERSON_NAME LIKE ''%{0}%'' OR t.PERSON_LAST_NAME LIKE ''%{0}%'')")
    private String likeName;
    @Condition(value="t.DEPT_ID", equalTag="in")
    private String inDeptId;
    @Condition(value="t.DEPT_ID IN (SELECT ud.AUTH_DEPT_ID FROM AUTH_USER_DEPT ud WHERE ud.AUTH_USER_ID=''{0}'')")
    private String userId;
    private String deptId;
    private String isIncludeLower;

    public String getId() {
        return this.id;
    }

    public String getPersonId() {
        return this.personId;
    }

    public Integer getBalance() {
        return this.balance;
    }

    public Integer getPosMoneyWallet() {
        return this.posMoneyWallet;
    }

    public Integer getPosAllowanceWallet() {
        return this.posAllowanceWallet;
    }

    public String getPersonPin() {
        return this.personPin;
    }

    public String getPersonName() {
        return this.personName;
    }

    public String getPersonLastName() {
        return this.personLastName;
    }

    public String getAccountNo() {
        return this.accountNo;
    }

    public Integer getAvailable() {
        return this.available;
    }

    public String getLikeName() {
        return this.likeName;
    }

    public String getInDeptId() {
        return this.inDeptId;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getDeptId() {
        return this.deptId;
    }

    public String getIsIncludeLower() {
        return this.isIncludeLower;
    }

    public PosIDAccountWalletItem setId(String id) {
        this.id = id;
        return this;
    }

    public PosIDAccountWalletItem setPersonId(String personId) {
        this.personId = personId;
        return this;
    }

    public PosIDAccountWalletItem setBalance(Integer balance) {
        this.balance = balance;
        return this;
    }

    public PosIDAccountWalletItem setPosMoneyWallet(Integer posMoneyWallet) {
        this.posMoneyWallet = posMoneyWallet;
        return this;
    }

    public PosIDAccountWalletItem setPosAllowanceWallet(Integer posAllowanceWallet) {
        this.posAllowanceWallet = posAllowanceWallet;
        return this;
    }

    public PosIDAccountWalletItem setPersonPin(String personPin) {
        this.personPin = personPin;
        return this;
    }

    public PosIDAccountWalletItem setPersonName(String personName) {
        this.personName = personName;
        return this;
    }

    public PosIDAccountWalletItem setPersonLastName(String personLastName) {
        this.personLastName = personLastName;
        return this;
    }

    public PosIDAccountWalletItem setAccountNo(String accountNo) {
        this.accountNo = accountNo;
        return this;
    }

    public PosIDAccountWalletItem setAvailable(Integer available) {
        this.available = available;
        return this;
    }

    public PosIDAccountWalletItem setLikeName(String likeName) {
        this.likeName = likeName;
        return this;
    }

    public PosIDAccountWalletItem setInDeptId(String inDeptId) {
        this.inDeptId = inDeptId;
        return this;
    }

    public PosIDAccountWalletItem setUserId(String userId) {
        this.userId = userId;
        return this;
    }

    public PosIDAccountWalletItem setDeptId(String deptId) {
        this.deptId = deptId;
        return this;
    }

    public PosIDAccountWalletItem setIsIncludeLower(String isIncludeLower) {
        this.isIncludeLower = isIncludeLower;
        return this;
    }

    public String toString() {
        return "PosIDAccountWalletItem(id=" + this.getId() + ", personId=" + this.getPersonId() + ", balance=" + this.getBalance() + ", posMoneyWallet=" + this.getPosMoneyWallet() + ", posAllowanceWallet=" + this.getPosAllowanceWallet() + ", personPin=" + this.getPersonPin() + ", personName=" + this.getPersonName() + ", personLastName=" + this.getPersonLastName() + ", accountNo=" + this.getAccountNo() + ", available=" + this.getAvailable() + ", likeName=" + this.getLikeName() + ", inDeptId=" + this.getInDeptId() + ", userId=" + this.getUserId() + ", deptId=" + this.getDeptId() + ", isIncludeLower=" + this.getIsIncludeLower() + ")";
    }
}

