/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.posid.init;

import com.zkteco.zkbiosecurity.auth.service.AuthAreaService;
import com.zkteco.zkbiosecurity.auth.service.AuthPermissionService;
import com.zkteco.zkbiosecurity.auth.vo.AuthAreaItem;
import com.zkteco.zkbiosecurity.auth.vo.AuthPermissionItem;
import com.zkteco.zkbiosecurity.base.utils.VersionUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.posid.constants.PosIDConstants;
import com.zkteco.zkbiosecurity.posid.service.PosIDAccountKindService;
import com.zkteco.zkbiosecurity.posid.service.PosIDBatchTimeService;
import com.zkteco.zkbiosecurity.posid.service.PosIDDiningHallService;
import com.zkteco.zkbiosecurity.posid.service.PosIDFaceConsumeDeviceService;
import com.zkteco.zkbiosecurity.posid.service.PosIDMealService;
import com.zkteco.zkbiosecurity.posid.service.PosIDRechargeMoneyService;
import com.zkteco.zkbiosecurity.posid.service.PosIDSplitTimeService;
import com.zkteco.zkbiosecurity.posid.vo.PosIDAccountKindItem;
import com.zkteco.zkbiosecurity.posid.vo.PosIDBatchTimeItem;
import com.zkteco.zkbiosecurity.posid.vo.PosIDDiningHallItem;
import com.zkteco.zkbiosecurity.posid.vo.PosIDMealItem;
import com.zkteco.zkbiosecurity.posid.vo.PosIDRechargeMoneyItem;
import com.zkteco.zkbiosecurity.posid.vo.PosIDSplitTimeItem;
import com.zkteco.zkbiosecurity.system.service.BaseSysParamService;
import com.zkteco.zkbiosecurity.system.vo.BaseSysParamItem;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.CommandLineRunner;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component
@Order(value=50)
public class PosIDInit
implements CommandLineRunner {
    @Autowired
    private AuthPermissionService authPermissionService;
    @Autowired
    private BaseSysParamService baseSysParamService;
    @Autowired
    private PosIDSplitTimeService posIDSplitTimeService;
    @Autowired
    private PosIDBatchTimeService posIDBatchTimeService;
    @Autowired
    private PosIDDiningHallService posIDDiningHallService;
    @Autowired
    private PosIDMealService posIDMealService;
    @Autowired
    private PosIDAccountKindService posIDAccountKindService;
    @Autowired
    private PosIDFaceConsumeDeviceService posIDFaceConsumeDeviceService;
    @Autowired
    private PosIDRechargeMoneyService posIDRechargeMoneyService;
    @Value(value="${system.language}")
    private String language;
    @Autowired(required=false)
    private AuthAreaService authAreaService;

    public void run(String ... args) throws Exception {
        boolean alreadyInit = this.baseSysParamService.getAlreadyInitModule("PosIDInit");
        if (!alreadyInit) {
            this.initAuthPermission();
            this.initPosSplitTime();
            this.initPosBatchTime();
            this.initPosDiningHall();
            this.initPosMeal();
            this.initPosIDAccountKind();
            this.initPosSystemParam();
            this.initPosIDRechargeMoney();
            this.initUpgradeVersion();
            this.baseSysParamService.setAlreadyInitModule("PosIDInit");
        }
        this.posIDFaceConsumeDeviceService.initDeviceCache();
    }

    private void initAuthPermission() {
        AuthPermissionItem systemItem = new AuthPermissionItem("PosID", "posid_module", "posid", "system", "true", Integer.valueOf(5));
        systemItem = this.authPermissionService.saveItem(systemItem);
        AuthPermissionItem subMenuItem1 = new AuthPermissionItem("PosIDBaseInfo", "posid_leftMenu_basicInfo", "posid:base:info", "menu", "true", Integer.valueOf(1));
        subMenuItem1.setParentId(systemItem.getId());
        subMenuItem1.setActionLink("posIDSplitTime.do");
        subMenuItem1.setImg("posid_basic.png");
        subMenuItem1.setImgHover("posid_basic_over.png");
        subMenuItem1 = this.authPermissionService.saveItem(subMenuItem1);
        AuthPermissionItem subMenuItem = new AuthPermissionItem("PosIDSplitTime", "posid_leftMenu_splitTime", "posid:splitTime", "menu", "true", Integer.valueOf(1));
        subMenuItem.setParentId(subMenuItem1.getId());
        subMenuItem.setActionLink("posIDSplitTime.do");
        subMenuItem = this.authPermissionService.saveItem(subMenuItem);
        AuthPermissionItem subButtonItem = new AuthPermissionItem("PosIDSplitTimeEdit", "common_op_edit", "posid:splitTime:edit", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("PosIDSplitTimeRefresh", "common_op_refresh", "posid:splitTime:refresh", "button", "true", Integer.valueOf(3));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subMenuItem = new AuthPermissionItem("PosIDBatchTime", "posid_leftMenu_batchTime", "posid:batchTime", "menu", "true", Integer.valueOf(2));
        subMenuItem.setParentId(subMenuItem1.getId());
        subMenuItem.setActionLink("posIDBatchTime.do");
        subMenuItem = this.authPermissionService.saveItem(subMenuItem);
        subButtonItem = new AuthPermissionItem("PosIDBatchTimeEdit", "common_op_edit", "posid:batchTime:edit", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("PosIDBatchTimeRefresh", "common_op_refresh", "posid:batchTime:refresh", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("PosIDBatchTimeDel", "common_op_del", "posid:batchTime:del", "button", "true", Integer.valueOf(3));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subMenuItem = new AuthPermissionItem("PosIDDiningHall", "posid_leftMenu_diningHall", "posid:diningHall", "menu", "true", Integer.valueOf(3));
        subMenuItem.setParentId(subMenuItem1.getId());
        subMenuItem.setActionLink("posIDDiningHall.do");
        subMenuItem = this.authPermissionService.saveItem(subMenuItem);
        subButtonItem = new AuthPermissionItem("PosIDDiningHallEdit", "common_op_edit", "posid:diningHall:edit", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("PosIDDiningHallRefresh", "common_op_refresh", "posid:diningHall:refresh", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("PosIDDiningHallAdd", "common_op_new", "posid:diningHall:add", "button", "true", Integer.valueOf(3));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("PosIDDiningHallDel", "common_op_del", "posid:diningHall:del", "button", "true", Integer.valueOf(4));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subMenuItem = new AuthPermissionItem("PosIDMeal", "posid_leftMenu_meal", "posid:meal", "menu", "true", Integer.valueOf(4));
        subMenuItem.setParentId(subMenuItem1.getId());
        subMenuItem.setActionLink("posIDMeal.do");
        subMenuItem = this.authPermissionService.saveItem(subMenuItem);
        subButtonItem = new AuthPermissionItem("PosIDMealEdit", "common_op_edit", "posid:meal:edit", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("PosIDMealRefresh", "common_op_refresh", "posid:meal:refresh", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subMenuItem = new AuthPermissionItem("PosIDProductCategory", "posid_leftMenu_productCategory", "posid:productCategory", "menu", "true", Integer.valueOf(5));
        subMenuItem.setParentId(subMenuItem1.getId());
        subMenuItem.setActionLink("posIDProductCategory.do");
        subMenuItem = this.authPermissionService.saveItem(subMenuItem);
        subButtonItem = new AuthPermissionItem("PosIDProductCategoryEdit", "common_op_edit", "posid:productCategory:edit", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("PosIDProductCategoryRefresh", "common_op_refresh", "posid:productCategory:refresh", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("PosIDProductCategoryAdd", "common_op_new", "posid:productCategory:add", "button", "true", Integer.valueOf(3));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("PosIDProductCategoryDel", "common_op_del", "posid:productCategory:del", "button", "true", Integer.valueOf(4));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subMenuItem = new AuthPermissionItem("PosIDStoreDetail", "posid_leftMenu_storeDetail", "posid:storeDetail", "menu", "true", Integer.valueOf(5));
        subMenuItem.setParentId(subMenuItem1.getId());
        subMenuItem.setActionLink("posIDStoreDetail.do");
        subMenuItem = this.authPermissionService.saveItem(subMenuItem);
        subButtonItem = new AuthPermissionItem("PosIDStoreDetailEdit", "common_op_edit", "posid:storeDetail:edit", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("PosIDStoreDetailRefresh", "common_op_refresh", "posid:storeDetail:refresh", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("PosIDStoreDetailAdd", "common_op_new", "posid:storeDetail:add", "button", "true", Integer.valueOf(3));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("PosIDStoreDetailDel", "common_op_del", "posid:storeDetail:del", "button", "true", Integer.valueOf(4));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subMenuItem = new AuthPermissionItem("PosIDAccountKind", "posid_leftMenu_icCard", "posid:accountKind", "menu", "true", Integer.valueOf(6));
        subMenuItem.setParentId(subMenuItem1.getId());
        subMenuItem.setActionLink("posIDAccountKind.do");
        subMenuItem = this.authPermissionService.saveItem(subMenuItem);
        subButtonItem = new AuthPermissionItem("PosIDAccountKindEdit", "common_op_edit", "posid:accountKind:edit", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("PosIDAccountKindRefresh", "common_op_refresh", "posid:accountKind:refresh", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("PosIDAccountKindAdd", "common_op_new", "posid:accountKind:add", "button", "true", Integer.valueOf(3));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("PosIDAccountKindDel", "common_op_del", "posid:accountKind:del", "button", "true", Integer.valueOf(4));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        if (this.language.equals("zh_CN")) {
            subMenuItem = new AuthPermissionItem("PosIDRechargeMoney", "posid_leftMenu_topUp", "posid:rechargeMoney", "menu", "true", Integer.valueOf(7));
            subMenuItem.setParentId(subMenuItem1.getId());
            subMenuItem.setActionLink("posIDRechargeMoney.do");
            subMenuItem = this.authPermissionService.saveItem(subMenuItem);
            subButtonItem = new AuthPermissionItem("PosIDRechargeMoneyEdit", "common_op_edit", "posid:rechargeMoney:edit", "button", "true", Integer.valueOf(1));
            subButtonItem.setParentId(subMenuItem.getId());
            subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        }
        subMenuItem = new AuthPermissionItem("PosIDSystemParam", "posid_leftMenu_setParam", "posid:systemParam", "menu", "true", Integer.valueOf(8));
        subMenuItem.setParentId(subMenuItem1.getId());
        subMenuItem.setActionLink("posIDSystemParam.do");
        subMenuItem = this.authPermissionService.saveItem(subMenuItem);
        subButtonItem = new AuthPermissionItem("PosIDSystemParamEdit", "common_op_edit", "posid:systemParam:edit", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subMenuItem = new AuthPermissionItem("PosIDPurchase", "posid_leftMenu_purchase", "posid:purchase", "menu", "true", Integer.valueOf(9));
        subMenuItem.setParentId(subMenuItem1.getId());
        subMenuItem.setActionLink("posIDPurchase.do");
        subMenuItem = this.authPermissionService.saveItem(subMenuItem);
        subButtonItem = new AuthPermissionItem("PosIDPurchaseEdit", "common_op_edit", "posid:purchase:edit", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("PosIDPurchaseRefresh", "common_op_refresh", "posid:purchase:refresh", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subMenuItem = new AuthPermissionItem("PosIDAdvert", "posid_leftMenu_advert", "posid:advert", "menu", "true", Integer.valueOf(10));
        subMenuItem.setParentId(subMenuItem1.getId());
        subMenuItem.setActionLink("posIDAdvert.do");
        subMenuItem = this.authPermissionService.saveItem(subMenuItem);
        subButtonItem = new AuthPermissionItem("PosIDAdvertAdd", "common_op_new", "posid:advert:add", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("PosIDAdvertDel", "common_op_del", "posid:advert:del", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("PosIDAdvertRefresh", "common_op_refresh", "posid:advert:refresh", "button", "true", Integer.valueOf(3));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subMenuItem1 = new AuthPermissionItem("PosIDDevice", "posid_leftMenu_devManage", "posid:device:manager", "menu", "true", Integer.valueOf(2));
        subMenuItem1.setParentId(systemItem.getId());
        subMenuItem1.setActionLink("posIDDevice.do");
        subMenuItem1.setImg("posid_device.png");
        subMenuItem1.setImgHover("posid_device_over.png");
        subMenuItem1 = this.authPermissionService.saveItem(subMenuItem1);
        subMenuItem = new AuthPermissionItem("PosIDDeviceSecond", "posid_leftMenu_devManage", "posid:device", "menu", "true", Integer.valueOf(1));
        subMenuItem.setParentId(subMenuItem1.getId());
        subMenuItem.setActionLink("posIDDevice.do");
        subMenuItem = this.authPermissionService.saveItem(subMenuItem);
        subButtonItem = new AuthPermissionItem("PosIDDeviceSecondEdit", "common_op_edit", "posid:device:edit", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("PosIDDeviceSecondRefresh", "common_op_refresh", "posid:device:refresh", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("PosIDDeviceSecondAdd", "common_op_new", "posid:device:add", "button", "true", Integer.valueOf(3));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("PosIDDeviceSecondDel", "common_op_del", "posid:device:del", "button", "true", Integer.valueOf(4));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("PosIDDeviceSecondDeleteCmd", "posid_op_deleteCmd", "posid:device:deleteCmd", "button", "true", Integer.valueOf(5));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("PosIDDeviceSecondReboot", "posid_op_reboot", "posid:device:reboot", "button", "true", Integer.valueOf(6));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("PosIDDeviceSecondSyncAllDataToDev", "posid_op_syncallDataToDev", "posid:device:syncAllDataToDev", "button", "true", Integer.valueOf(7));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("PosIDDeviceSecondSearchDev", "posid_dev_search", "posid:device:search", "button", "true", Integer.valueOf(8));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("PosIDDeviceSecondEnable", "common_enable", "posid:device:enable", "button", "true", Integer.valueOf(9));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("PosIDDeviceSecondDisable", "common_disable", "posid:device:disable", "button", "true", Integer.valueOf(10));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("PosIDDeviceSecondClearData", "posid_dev_menu_clearData", "posid:device:clearData", "button", "true", Integer.valueOf(11));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subMenuItem = new AuthPermissionItem("PosIDFaceConsumeDevice", "posid_leftMenu_devFace", "posid:faceConsumeDevice", "menu", "true", Integer.valueOf(2));
        subMenuItem.setParentId(subMenuItem1.getId());
        subMenuItem.setActionLink("posIDFaceConsumeDevice.do");
        subMenuItem = this.authPermissionService.saveItem(subMenuItem);
        subButtonItem = new AuthPermissionItem("PosIDFaceConsumeDeviceRefresh", "common_op_refresh", "posid:faceConsumeDevice:refresh", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("PosIDFaceConsumeDeviceDel", "common_op_del", "posid:faceConsumeDevice:del", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("PosIDFaceConsumeDeviceSearch", "posid_dev_search", "posid:faceConsumeDevice:search", "button", "true", Integer.valueOf(3));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("PosIDFaceConsumeDeviceEnable", "common_enable", "posid:faceConsumeDevice:enable", "button", "true", Integer.valueOf(4));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("PosIDFaceConsumeDeviceDisable", "common_disable", "posid:faceConsumeDevice:disable", "button", "true", Integer.valueOf(5));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("PosIDFaceConsumeDeviceSyncAllDataToDev", "posid_op_syncallDataToDev", "posid:faceConsumeDevice:syncAllDataToDev", "button", "true", Integer.valueOf(6));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("PosIDFaceConsumeDeviceSyncPersonDataToDev", "posid_dev_synchronization_person", "posid:faceConsumeDevice:syncPersonDataToDev", "button", "true", Integer.valueOf(7));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("PosIDFaceConsumeDeviceAdd", "common_op_new", "posid:faceConsumeDevice:add", "button", "true", Integer.valueOf(8));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("PosIDFaceConsumeDeviceCommandRefresh", "common_devMonitor_viewTheCommand", "posid:faceConsumeDevice:getCmd", "button", "true", Integer.valueOf(9));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("PosIDFaceConsumeDeviceCommandDel", "posid_command_flush_all", "posid:faceConsumeDevice:cmdDel", "button", "true", Integer.valueOf(10));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("PosIDFaceConsumeDeviceEdit", "common_op_edit", "posid:faceConsumeDevice:edit", "button", "true", Integer.valueOf(11));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("PosIDFaceConsumeDeviceSyncTime", "common_dev_syncTime", "posid:faceConsumeDevice:syncTime", "button", "true", Integer.valueOf(12));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("PosIDFaceConsumeDeviceBioSyncRecord", "posid_biotemplate_sync_fail", "posid:faceConsumeDevice:getBioSyncRecord", "button", "true", Integer.valueOf(13));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("PosIDFaceConsumeDeviceGetLog", "posid_devMonitor_viewTheLog", "posid:faceConsumeDevice:getLog", "button", "true", Integer.valueOf(14));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("PosIDFaceConsumeDeviceLogDel", "posid_fileLog_flush_all", "posid:faceConsumeDevice:logDel", "button", "true", Integer.valueOf(15));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("PosIDFaceConsumeDeviceUploadDevLog", "posid_dev_upload_log", "posid:faceConsumeDevice:uploadDevLog", "button", "true", Integer.valueOf(16));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subMenuItem1 = new AuthPermissionItem("PosIDCard", "posid_leftMenu_cardManageBar", "posid:card:manager", "menu", "true", Integer.valueOf(3));
        subMenuItem1.setParentId(systemItem.getId());
        subMenuItem1.setActionLink("posIDCard.do");
        subMenuItem1.setImg("posid_card.png");
        subMenuItem1.setImgHover("posid_card_over.png");
        subMenuItem1 = this.authPermissionService.saveItem(subMenuItem1);
        subMenuItem = new AuthPermissionItem("PosIDCardOperation", "posid_leftMenu_cardBusiness", "posid:cardOperation", "menu", "true", Integer.valueOf(1));
        subMenuItem.setParentId(subMenuItem1.getId());
        subMenuItem.setActionLink("skip.do?page=posid_cardBusiness_PosIDCardBusiness");
        subMenuItem = this.authPermissionService.saveItem(subMenuItem);
        subButtonItem = new AuthPermissionItem("PosIDCardOperationModifiedData", "posid_op_modifiedData", "posid:modifiedData:edit", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("PosIDCardOperationTopUp", "posid_op_topUp", "posid:topUp:edit", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("PosIDCardOperationRefund", "posid_op_refund", "posid:refund:edit", "button", "true", Integer.valueOf(3));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("PosIDCardOperationOpenAccount", "posid_op_open_account", "posid:openAccount:edit", "button", "true", Integer.valueOf(4));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("PosIDCardOperationModifiedSave", "common_op_edit", "posid:modifiedData:save", "button", "true", Integer.valueOf(5));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("PosIDCardOperationBatchTopUp", "posid_recharge_batch", "posid:batchTopUp:edit", "button", "true", Integer.valueOf(6));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("PosIDCardOperationAllowanceRefund", "posid_allowance_refund", "posid:allowanceRefund:edit", "button", "true", Integer.valueOf(7));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("PosIDCardOperationBatchRefund", "posid_refund_batch", "posid:batchRefund:edit", "button", "true", Integer.valueOf(8));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subMenuItem = new AuthPermissionItem("PosIDAccount", "posid_leftMenu_cardManage", "posid:account", "menu", "true", Integer.valueOf(2));
        subMenuItem.setParentId(subMenuItem1.getId());
        subMenuItem.setActionLink("posIDAccount.do");
        subMenuItem = this.authPermissionService.saveItem(subMenuItem);
        subButtonItem = new AuthPermissionItem("PosIDAccountRefresh", "common_op_refresh", "posid:account:refresh", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("PosIDAccountExport", "common_op_export", "posid:account:export", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("PosIDAccountEnable", "common_enable", "posid:account:enable", "button", "true", Integer.valueOf(3));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("PosIDAccountDisable", "common_disable", "posid:account:disable", "button", "true", Integer.valueOf(4));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("PosIDAccountSetOperator", "posid_account_set_admin", "posid:account:setOperator", "button", "true", Integer.valueOf(5));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("PosIDAccountSetCommonUser", "posid_account_set_consumer", "posid:account:setCommonUser", "button", "true", Integer.valueOf(6));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("PosIDAccountEditType", "posid_iccard_editAccountType", "posid:account:edit", "button", "true", Integer.valueOf(7));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subMenuItem = new AuthPermissionItem("PosIDWallet", "posid_leftMenu_wallet", "posid:wallet", "menu", "true", Integer.valueOf(3));
        subMenuItem.setParentId(subMenuItem1.getId());
        subMenuItem.setActionLink("posIDWallet.do");
        subMenuItem = this.authPermissionService.saveItem(subMenuItem);
        subButtonItem = new AuthPermissionItem("PosIDWalletRefresh", "common_op_refresh", "posid:wallet:refresh", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subMenuItem = new AuthPermissionItem("PosIDTransactionCard", "posid_leftMenu_carcashSZ", "posid:transactionCard", "menu", "true", Integer.valueOf(4));
        subMenuItem.setParentId(subMenuItem1.getId());
        subMenuItem.setActionLink("posIDTransactionCard.do");
        subMenuItem = this.authPermissionService.saveItem(subMenuItem);
        subButtonItem = new AuthPermissionItem("PosIDTransactionCardRefresh", "common_op_refresh", "posid:transactionCard:refresh", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("PosIDTransactionCardExport", "common_op_export", "posid:transactionCard:export", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subMenuItem = new AuthPermissionItem("PosIDAllowanceLogRecord", "posid_leftMenu_allowanceLogRecord", "posid:allowanceLogRecord", "menu", "true", Integer.valueOf(6));
        subMenuItem.setParentId(subMenuItem1.getId());
        subMenuItem.setActionLink("posIDAllowanceLogRecord.do");
        subMenuItem = this.authPermissionService.saveItem(subMenuItem);
        subButtonItem = new AuthPermissionItem("PosIDAllowanceLogRecordEdit", "common_op_edit", "posid:allowanceLogRecord:edit", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("PosIDAllowanceLogRecordRefresh", "common_op_refresh", "posid:allowanceLogRecord:refresh", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("PosIDAllowanceLogRecordExport", "common_op_export", "posid:allowanceLogRecord:export", "button", "true", Integer.valueOf(3));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("PosIDAllowanceLogRecordAdd", "common_op_new", "posid:allowanceLogRecord:add", "button", "true", Integer.valueOf(4));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("PosIDAllowanceLogRecordSetCheck", "posid_allowance_check", "posid:allowanceLogRecord:setCheck", "button", "true", Integer.valueOf(5));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("PosIDAllowanceLogRecordEnable", "posid_allowance_checkAll", "posid:allowanceLogRecord:enable", "button", "true", Integer.valueOf(6));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("PosIDAllowanceLogRecordImport", "posid_allowance_import", "posid:allowanceLogRecord:import", "button", "true", Integer.valueOf(8));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("PosIDAllowanceLogRecordDel", "common_op_del", "posid:allowanceLogRecord:del", "button", "true", Integer.valueOf(9));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("PosIDAllowanceLogRecordExportTemplet", "posid_import_template", "posid:allowanceLogRecord:exportTemplet", "button", "true", Integer.valueOf(10));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("PosIDAllowanceLogRecordBatchAdd", "posid_bulk_subsidy", "posid:allowanceLogRecord:batchAdd", "button", "true", Integer.valueOf(11));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        if (this.language.equals("zh_CN")) {
            subMenuItem = new AuthPermissionItem("PosIDAccountTransfer", "transfer_account_record", "posid:accountTransfer", "menu", "true", Integer.valueOf(7));
            subMenuItem.setParentId(subMenuItem1.getId());
            subMenuItem.setActionLink("posIDTransferAccount.do");
            subMenuItem = this.authPermissionService.saveItem(subMenuItem);
            subButtonItem = new AuthPermissionItem("PosIDAccountTransferRefresh", "common_op_refresh", "posid:accountTransfer:refresh", "button", "true", Integer.valueOf(1));
            subButtonItem.setParentId(subMenuItem.getId());
            subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        }
        subMenuItem1 = new AuthPermissionItem("PosIDTransaction", "posid_leftMenu_icConsumerList", "posid:transaction:manager", "menu", "true", Integer.valueOf(4));
        subMenuItem1.setParentId(systemItem.getId());
        subMenuItem1.setActionLink("posIDTransaction.do");
        subMenuItem1.setImg("posid_countReport.png");
        subMenuItem1.setImgHover("posid_countReport_over.png");
        subMenuItem1 = this.authPermissionService.saveItem(subMenuItem1);
        subMenuItem = new AuthPermissionItem("PosIDTransactionTable", "posid_consumption_details_table", "posid:transaction", "menu", "true", Integer.valueOf(1));
        subMenuItem.setParentId(subMenuItem1.getId());
        subMenuItem.setActionLink("posIDTransaction.do");
        subMenuItem = this.authPermissionService.saveItem(subMenuItem);
        subButtonItem = new AuthPermissionItem("PosIDTransactionTableRefresh", "common_op_refresh", "posid:transaction:refresh", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("PosIDTransactionTableExport", "common_op_export", "posid:transaction:export", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("PosIDTransactionErrorRecovery", "posid_consumerList_correction", "posid:transaction:errorRecovery", "button", "true", Integer.valueOf(3));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subMenuItem = new AuthPermissionItem("PosIDOfflineConsume", "posid_offline_consume", "posid:offlineConsume", "menu", "true", Integer.valueOf(2));
        subMenuItem.setParentId(subMenuItem1.getId());
        subMenuItem.setActionLink("posIDOfflineConsume.do");
        subMenuItem = this.authPermissionService.saveItem(subMenuItem);
        subButtonItem = new AuthPermissionItem("PosIDOfflineConsumeRefresh", "common_op_refresh", "posid:offlineConsume:refresh", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("PosIDOfflineConsumeVerification", "posid_allowance_check", "posid:offlineConsume:verification", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("PosIDOfflineConsumeImport", "posid_op_importUSBRecord", "posid:offlineConsume:import", "button", "true", Integer.valueOf(3));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subMenuItem = new AuthPermissionItem("PosIDHandConsume", "posid_leftMenu_handConsume", "posid:handConsume", "menu", "true", Integer.valueOf(4));
        subMenuItem.setParentId(subMenuItem1.getId());
        subMenuItem.setActionLink("posIDHandConsume.do");
        subMenuItem = this.authPermissionService.saveItem(subMenuItem);
        subButtonItem = new AuthPermissionItem("PosIDHandConsumeEdit", "common_op_edit", "posid:handConsume:edit", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("PosIDHandConsumeRefresh", "common_op_refresh", "posid:handConsume:refresh", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("PosIDHandConsumeExport", "common_op_export", "posid:handConsume:export", "button", "true", Integer.valueOf(3));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("PosIDHandConsumeAdd", "common_op_new", "posid:handConsume:add", "button", "true", Integer.valueOf(4));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        if (this.language.equals("zh_CN")) {
            subMenuItem = new AuthPermissionItem("PosIDOuterTransactionTable", "posid_outer_consumption_details_table", "posid:outerTransaction", "menu", "true", Integer.valueOf(5));
            subMenuItem.setParentId(subMenuItem1.getId());
            subMenuItem.setActionLink("posIDOuterTransaction.do");
            subMenuItem = this.authPermissionService.saveItem(subMenuItem);
            subButtonItem = new AuthPermissionItem("PosIDOuterTransactionTableRefresh", "common_op_refresh", "posid:outerTransaction:refresh", "button", "true", Integer.valueOf(1));
            subButtonItem.setParentId(subMenuItem.getId());
            subButtonItem = this.authPermissionService.saveItem(subButtonItem);
            subButtonItem = new AuthPermissionItem("PosIDOuterTransactionTableExport", "common_op_export", "posid:outerTransaction:export", "button", "true", Integer.valueOf(2));
            subButtonItem.setParentId(subMenuItem.getId());
            subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        }
        subMenuItem1 = new AuthPermissionItem("PosIDReport", "posid_leftMenu_posReportForm", "posid:report:manager", "menu", "true", Integer.valueOf(7));
        subMenuItem1.setParentId(systemItem.getId());
        subMenuItem1.setActionLink("posIDAllowanceLogRecord.do");
        subMenuItem1.setImg("posid_reportForm.png");
        subMenuItem1.setImgHover("posid_reportForm_over.png");
        subMenuItem1 = this.authPermissionService.saveItem(subMenuItem1);
        subMenuItem = new AuthPermissionItem("PosIDCardRechargeForm", "posid_card_recharge_table", "posid:rechargeForm", "menu", "true", Integer.valueOf(2));
        subMenuItem.setParentId(subMenuItem1.getId());
        subMenuItem.setActionLink("posIDTransactionCardRecord.do?requestType=rechargeForm");
        subMenuItem = this.authPermissionService.saveItem(subMenuItem);
        subButtonItem = new AuthPermissionItem("PosIDCardRechargeFormRefresh", "common_op_refresh", "posid:rechargeForm:refresh", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("PosIDCardRechargeFormExport", "common_op_export", "posid:rechargeForm:export", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subMenuItem = new AuthPermissionItem("PosIDCardRefund", "posid_card_refund_table", "posid:cardRefund", "menu", "true", Integer.valueOf(3));
        subMenuItem.setParentId(subMenuItem1.getId());
        subMenuItem.setActionLink("posIDTransactionCardRecord.do?requestType=cardRefund");
        subMenuItem = this.authPermissionService.saveItem(subMenuItem);
        subButtonItem = new AuthPermissionItem("PosIDCardRefundRefresh", "common_op_refresh", "posid:cardRefund:refresh", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("PosIDCardRefundExport", "common_op_export", "posid:cardRefund:export", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subMenuItem = new AuthPermissionItem("PosIDCardSubsidy", "posid_card_subsidy_table", "posid:cardSubsidy", "menu", "true", Integer.valueOf(4));
        subMenuItem.setParentId(subMenuItem1.getId());
        subMenuItem.setActionLink("posIDTransactionCardRecord.do?requestType=cardSubsidy");
        subMenuItem = this.authPermissionService.saveItem(subMenuItem);
        subButtonItem = new AuthPermissionItem("PosIDCardSubsidyRefresh", "common_op_refresh", "posid:cardSubsidy:refresh", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("PosIDCardSubsidyExport", "common_op_export", "posid:cardSubsidy:export", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subMenuItem = new AuthPermissionItem("PosIDCardBlance", "posid_card_blance_table", "posid:cardBlance", "menu", "true", Integer.valueOf(7));
        subMenuItem.setParentId(subMenuItem1.getId());
        subMenuItem.setActionLink("posIDTransactionCardRecord.do?requestType=cardBlance");
        subMenuItem = this.authPermissionService.saveItem(subMenuItem);
        subButtonItem = new AuthPermissionItem("PosIDCardBlanceRefresh", "common_op_refresh", "posid:cardBlance:refresh", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("PosIDCardBlanceExport", "common_op_export", "posid:cardBlance:export", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subMenuItem1 = new AuthPermissionItem("PosIDStatisticsReport", "posid_leftMenu_countTable", "posid:report:manager", "menu", "true", Integer.valueOf(8));
        subMenuItem1.setParentId(systemItem.getId());
        subMenuItem1.setActionLink("posIDAllowanceLogRecord.do");
        subMenuItem1.setImg("posid_countTable.png");
        subMenuItem1.setImgHover("posid_countTable_over.png");
        subMenuItem1 = this.authPermissionService.saveItem(subMenuItem1);
        subMenuItem = new AuthPermissionItem("PosIDPersonConsume", "posid_countTable_personConsume", "posid:personConsume", "menu", "true", Integer.valueOf(1));
        subMenuItem.setParentId(subMenuItem1.getId());
        subMenuItem.setActionLink("posIDPersonConsume.do");
        subMenuItem = this.authPermissionService.saveItem(subMenuItem);
        subButtonItem = new AuthPermissionItem("PosIDPersonConsumeRefresh", "common_op_refresh", "posid:personConsume:refresh", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("PosIDPersonConsumeExport", "common_op_export", "posid:personConsume:export", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        if (!this.language.equals("zh_CN")) {
            subMenuItem = new AuthPermissionItem("PosIDPersonTurnover", "posid_countTable_personTurnover", "posid:personTurnover", "menu", "true", Integer.valueOf(1));
            subMenuItem.setParentId(subMenuItem1.getId());
            subMenuItem.setActionLink("posIDPersonTurnover.do");
            subMenuItem = this.authPermissionService.saveItem(subMenuItem);
            subButtonItem = new AuthPermissionItem("PosIDPersonTurnoverRefresh", "common_op_refresh", "posid:personTurnover:refresh", "button", "true", Integer.valueOf(1));
            subButtonItem.setParentId(subMenuItem.getId());
            subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        }
        subMenuItem = new AuthPermissionItem("PosIDPersonTopUp", "posid_countTable_personTopUp", "posid:personTopUp", "menu", "true", Integer.valueOf(2));
        subMenuItem.setParentId(subMenuItem1.getId());
        subMenuItem.setActionLink("posIDPersonTopUp.do");
        subMenuItem = this.authPermissionService.saveItem(subMenuItem);
        subButtonItem = new AuthPermissionItem("PosIDPersonTopUpRefresh", "common_op_refresh", "posid:personTopUp:refresh", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("PosIDPersonTopUpExport", "common_op_export", "posid:personTopUp:export", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subMenuItem = new AuthPermissionItem("PosIDDeptConsume", "posid_countTable_deptConsume", "posid:deptConsume", "menu", "true", Integer.valueOf(3));
        subMenuItem.setParentId(subMenuItem1.getId());
        subMenuItem.setActionLink("posIDDeptConsume.do");
        subMenuItem = this.authPermissionService.saveItem(subMenuItem);
        subButtonItem = new AuthPermissionItem("PosIDDeptConsumeRefresh", "common_op_refresh", "posid:deptConsume:refresh", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("PosIDDeptConsumeExport", "common_op_export", "posid:deptConsume:export", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subMenuItem = new AuthPermissionItem("PosIDDiningHallConsume", "posid_countTable_diningHallConsume", "posid:diningHallConsume", "menu", "true", Integer.valueOf(4));
        subMenuItem.setParentId(subMenuItem1.getId());
        subMenuItem.setActionLink("posIDDiningHallConsume.do");
        subMenuItem = this.authPermissionService.saveItem(subMenuItem);
        subButtonItem = new AuthPermissionItem("PosIDDiningHallConsumeRefresh", "common_op_refresh", "posid:diningHallConsume:refresh", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("PosIDDiningHallConsumeExport", "common_op_export", "posid:diningHallConsume:export", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subMenuItem = new AuthPermissionItem("PosIDDeviceConsume", "posid_countTable_deviceConsume", "posid:deviceConsume", "menu", "true", Integer.valueOf(5));
        subMenuItem.setParentId(subMenuItem1.getId());
        subMenuItem.setActionLink("posIDDeviceConsume.do");
        subMenuItem = this.authPermissionService.saveItem(subMenuItem);
        subButtonItem = new AuthPermissionItem("PosIDDeviceConsumeRefresh", "common_op_refresh", "posid:deviceConsume:refresh", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("PosIDDeviceConsumeExport", "common_op_export", "posid:deviceConsume:export", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subMenuItem = new AuthPermissionItem("PosIDIncomeExpendConsume", "posid_countTable_incomeExpendConsume", "posid:incomeExpendConsume", "menu", "true", Integer.valueOf(6));
        subMenuItem.setParentId(subMenuItem1.getId());
        subMenuItem.setActionLink("posIDIncomeExpendConsume.do");
        subMenuItem = this.authPermissionService.saveItem(subMenuItem);
        subButtonItem = new AuthPermissionItem("PosIDIncomeExpendConsumeRefresh", "common_op_refresh", "posid:incomeExpendConsume:refresh", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("PosIDIncomeExpendConsumeExport", "common_op_export", "posid:incomeExpendConsume:export", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subMenuItem = new AuthPermissionItem("PosIDMealConsume", "posid_countTable_mealConsume", "posid:mealConsume", "menu", "true", Integer.valueOf(7));
        subMenuItem.setParentId(subMenuItem1.getId());
        subMenuItem.setActionLink("posIDMealConsume.do");
        subMenuItem = this.authPermissionService.saveItem(subMenuItem);
        subButtonItem = new AuthPermissionItem("PosIDMealConsumeRefresh", "common_op_refresh", "posid:mealConsume:refresh", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("PosIDMealConsumeExport", "common_op_export", "posid:mealConsume:export", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subMenuItem = new AuthPermissionItem("PosIDOutStock", "posid_countTable_storeDetail", "posid:outStock", "menu", "true", Integer.valueOf(8));
        subMenuItem.setParentId(subMenuItem1.getId());
        subMenuItem.setActionLink("posIDOutStock.do");
        subMenuItem = this.authPermissionService.saveItem(subMenuItem);
        subButtonItem = new AuthPermissionItem("PosIDOutStockRefresh", "common_op_refresh", "posid:outStock:refresh", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("PosIDOutStockExport", "common_op_export", "posid:outStock:export", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subMenuItem = new AuthPermissionItem("PosIDRechargeSummary", "posid_leftMenu_rechargeSummary", "posid:rechargeSummary", "menu", "true", Integer.valueOf(9));
        subMenuItem.setParentId(subMenuItem1.getId());
        subMenuItem.setActionLink("posIDRechargeSummary.do");
        subMenuItem = this.authPermissionService.saveItem(subMenuItem);
        subButtonItem = new AuthPermissionItem("PosIDRechargeSummaryRefresh", "common_op_refresh", "posid:rechargeSummary:refresh", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("PosIDRechargeSummaryExport", "common_op_export", "posid:rechargeSummary:export", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subMenuItem = new AuthPermissionItem("PosIDPersMealSummary", "posid_leftMenu_persMealSummary", "posid:persMealSummary", "menu", "true", Integer.valueOf(10));
        subMenuItem.setParentId(subMenuItem1.getId());
        subMenuItem.setActionLink("posIDPersMealSummary.do");
        subMenuItem = this.authPermissionService.saveItem(subMenuItem);
        subButtonItem = new AuthPermissionItem("PosIDPersMealSummaryRefresh", "common_op_refresh", "posid:persMealSummary:refresh", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("PosIDPersMealSummaryExport", "common_op_export", "posid:persMealSummary:export", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subMenuItem = new AuthPermissionItem("PosIDDevMealSummary", "posid_leftMenu_devMealSummary", "posid:devMealSummary", "menu", "true", Integer.valueOf(11));
        subMenuItem.setParentId(subMenuItem1.getId());
        subMenuItem.setActionLink("posIDDevMealSummary.do");
        subMenuItem = this.authPermissionService.saveItem(subMenuItem);
        subButtonItem = new AuthPermissionItem("PosIDDevMealSummaryRefresh", "common_op_refresh", "posid:devMealSummary:refresh", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("PosIDDevMealSummaryExport", "common_op_export", "posid:devMealSummary:export", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subMenuItem = new AuthPermissionItem("PosIDMonthlyStatement", "posid_leftMenu_monthlyStatement", "posid:monthlyStatement", "menu", "true", Integer.valueOf(12));
        subMenuItem.setParentId(subMenuItem1.getId());
        subMenuItem.setActionLink("posIDMonthlyStatement.do");
        subMenuItem = this.authPermissionService.saveItem(subMenuItem);
        subButtonItem = new AuthPermissionItem("PosIDMonthlyStatementRefresh", "common_op_refresh", "posid:monthlyStatement:refresh", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("PosIDMonthlyStatementExport", "common_op_export", "posid:monthlyStatement:export", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subMenuItem1 = new AuthPermissionItem("PosIDOrderMealManager", "posid_leftMenu_orderMeal", "posid:orderMeal:manager", "menu", "true", Integer.valueOf(9));
        subMenuItem1.setParentId(systemItem.getId());
        subMenuItem1.setActionLink("posIDOrderMeal.do");
        subMenuItem1.setImg("posid_ordering.png");
        subMenuItem1.setImgHover("posid_ordering_over.png");
        subMenuItem1 = this.authPermissionService.saveItem(subMenuItem1);
        subMenuItem = new AuthPermissionItem("PosIDOrderMeal", "posid_orderMeal_manage", "posid:orderMeal", "menu", "true", Integer.valueOf(1));
        subMenuItem.setParentId(subMenuItem1.getId());
        subMenuItem.setActionLink("posIDOrderMeal.do");
        subMenuItem = this.authPermissionService.saveItem(subMenuItem);
        subButtonItem = new AuthPermissionItem("PosIDOrderMealRefresh", "common_op_refresh", "posid:orderMeal:refresh", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("PosIDOrderMealEdit", "common_op_edit", "posid:orderMeal:edit", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("PosIDOrderMealAdd", "common_op_new", "posid:orderMeal:add", "button", "true", Integer.valueOf(3));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("PosIDOrderMealCancel", "posid_orderMeal_cancel", "posid:orderMeal:cancel", "button", "true", Integer.valueOf(4));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subMenuItem = new AuthPermissionItem("PosIDOrderMealSummary", "posid_order_meal_summary", "posid:orderMealSummary", "menu", "true", Integer.valueOf(2));
        subMenuItem.setParentId(subMenuItem1.getId());
        subMenuItem.setActionLink("posIDOrderMealSummary.do");
        subMenuItem = this.authPermissionService.saveItem(subMenuItem);
        subButtonItem = new AuthPermissionItem("PosIDOrderMealSummaryRefresh", "common_op_refresh", "posid:orderMealSummary:refresh", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("PosIDOrderMealSummaryExport", "common_op_export", "posid:orderMealSummary:export", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subMenuItem = new AuthPermissionItem("PosIDMealConsumeDetail", "posid_countTable_mealConsumeDetail", "posid:mealConsumeDetail", "menu", "true", Integer.valueOf(3));
        subMenuItem.setParentId(subMenuItem1.getId());
        subMenuItem.setActionLink("posIDMealConsumeDetail.do");
        subMenuItem = this.authPermissionService.saveItem(subMenuItem);
        subButtonItem = new AuthPermissionItem("PosIDMealConsumeDetailRefresh", "common_op_refresh", "posid:mealConsumeDetail:refresh", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("PosIDMealConsumeDetailExport", "common_op_export", "posid:mealConsumeDetail:export", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subMenuItem = new AuthPermissionItem("PosIDOrderProductSummary", "posid_order_product_statistics", "posid:orderProductSummary", "menu", "true", Integer.valueOf(4));
        subMenuItem.setParentId(subMenuItem1.getId());
        subMenuItem.setActionLink("posIDOrderProductSummary.do");
        subMenuItem = this.authPermissionService.saveItem(subMenuItem);
        subButtonItem = new AuthPermissionItem("PosIDOrderProductSummaryRefresh", "common_op_refresh", "posid:orderProductSummary:refresh", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("PosIDOrderProductSummaryList", "common_op_refresh", "posid:orderProductSummary:list", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("PosIDOrderProductStoreDetailList", "common_op_refresh", "posid:orderProductSummary:storeDetailList", "button", "true", Integer.valueOf(3));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
    }

    public void initPosSplitTime() {
        PosIDSplitTimeItem posSplitTimeInit1 = new PosIDSplitTimeItem("1", I18nUtil.i18nCode((String)"posid_splitTime_name0", (Object[])new Object[0]), String.valueOf("00:00"), String.valueOf("10:00"), Integer.valueOf(1000), Boolean.valueOf(true));
        PosIDSplitTimeItem posSplitTimeInit2 = new PosIDSplitTimeItem("2", I18nUtil.i18nCode((String)"posid_splitTime_name1", (Object[])new Object[0]), String.valueOf("10:01"), String.valueOf("14:00"), Integer.valueOf(1000), Boolean.valueOf(true));
        PosIDSplitTimeItem posSplitTimeInit3 = new PosIDSplitTimeItem("3", I18nUtil.i18nCode((String)"posid_splitTime_name2", (Object[])new Object[0]), String.valueOf("14:01"), String.valueOf("20:00"), Integer.valueOf(1000), Boolean.valueOf(true));
        PosIDSplitTimeItem posSplitTimeInit4 = new PosIDSplitTimeItem("4", I18nUtil.i18nCode((String)"posid_splitTime_name3", (Object[])new Object[0]), String.valueOf("20:01"), String.valueOf("23:59"), Integer.valueOf(1000), Boolean.valueOf(true));
        PosIDSplitTimeItem posSplitTimeInit5 = new PosIDSplitTimeItem("5", I18nUtil.i18nCode((String)"posid_splitTime_name4", (Object[])new Object[0]), String.valueOf("00:00"), String.valueOf("10:00"), Integer.valueOf(1000), Boolean.valueOf(false));
        PosIDSplitTimeItem posSplitTimeInit6 = new PosIDSplitTimeItem("6", I18nUtil.i18nCode((String)"posid_splitTime_name5", (Object[])new Object[0]), String.valueOf("10:01"), String.valueOf("14:00"), Integer.valueOf(1000), Boolean.valueOf(false));
        PosIDSplitTimeItem posSplitTimeInit7 = new PosIDSplitTimeItem("7", I18nUtil.i18nCode((String)"posid_splitTime_name6", (Object[])new Object[0]), String.valueOf("14:01"), String.valueOf("20:00"), Integer.valueOf(1000), Boolean.valueOf(false));
        PosIDSplitTimeItem posSplitTimeInit8 = new PosIDSplitTimeItem("8", I18nUtil.i18nCode((String)"posid_splitTime_name7", (Object[])new Object[0]), String.valueOf("20:01"), String.valueOf("23:59"), Integer.valueOf(1000), Boolean.valueOf(false));
        this.posIDSplitTimeService.initData(posSplitTimeInit1);
        this.posIDSplitTimeService.initData(posSplitTimeInit2);
        this.posIDSplitTimeService.initData(posSplitTimeInit3);
        this.posIDSplitTimeService.initData(posSplitTimeInit4);
        this.posIDSplitTimeService.initData(posSplitTimeInit5);
        this.posIDSplitTimeService.initData(posSplitTimeInit6);
        this.posIDSplitTimeService.initData(posSplitTimeInit7);
        this.posIDSplitTimeService.initData(posSplitTimeInit8);
    }

    public void initPosBatchTime() {
        String[] names = new String[]{I18nUtil.i18nCode((String)"posid_timeSeg_0", (Object[])new Object[0]), I18nUtil.i18nCode((String)"posid_timeSeg_1", (Object[])new Object[0]), I18nUtil.i18nCode((String)"posid_timeSeg_2", (Object[])new Object[0]), I18nUtil.i18nCode((String)"posid_timeSeg_3", (Object[])new Object[0]), I18nUtil.i18nCode((String)"posid_timeSeg_4", (Object[])new Object[0]), I18nUtil.i18nCode((String)"posid_timeSeg_5", (Object[])new Object[0]), I18nUtil.i18nCode((String)"posid_timeSeg_6", (Object[])new Object[0]), I18nUtil.i18nCode((String)"posid_timeSeg_7", (Object[])new Object[0]), I18nUtil.i18nCode((String)"posid_timeSeg_8", (Object[])new Object[0])};
        String[] starts = new String[]{"00:00", "10:01", "15:01", "20:01"};
        String[] ends = new String[]{"10:00", "15:00", "20:00", "23:59"};
        this.posIDBatchTimeService.initData(names, starts, ends);
    }

    public void initPosDiningHall() {
        PosIDDiningHallItem item = this.posIDDiningHallService.getItemByCode("1");
        if (item == null) {
            item = new PosIDDiningHallItem();
            item.setCode("1");
            item.setOrderMealType(Integer.valueOf(0));
            item.setType(Integer.valueOf(0));
            item.setOrderPaymentType(Integer.valueOf(0));
            item.setName(I18nUtil.i18nCode((String)"posid_diningHall_headquarters", (Object[])new Object[0]));
            item.setRemark(I18nUtil.i18nCode((String)"posid_diningHall_defaultDate", (Object[])new Object[0]));
            item.setInitFlag(Boolean.valueOf(true));
            item.setInventoryFlag(Boolean.valueOf(false));
            AuthAreaItem areaItem = this.authAreaService.getInitArea();
            if (Objects.nonNull(areaItem)) {
                item.setAreaId(areaItem.getId());
            }
            this.posIDDiningHallService.saveItem(item);
        }
    }

    public void initPosMeal() {
        PosIDMealItem posMealInit1 = new PosIDMealItem("1", I18nUtil.i18nCode((String)"posid_mealName_0", (Object[])new Object[0]), String.valueOf("00:00"), String.valueOf("10:00"), Boolean.valueOf(true));
        PosIDMealItem posMealInit2 = new PosIDMealItem("2", I18nUtil.i18nCode((String)"posid_mealName_1", (Object[])new Object[0]), String.valueOf("10:01"), String.valueOf("14:00"), Boolean.valueOf(true));
        PosIDMealItem posMealInit3 = new PosIDMealItem("3", I18nUtil.i18nCode((String)"posid_mealName_2", (Object[])new Object[0]), String.valueOf("14:01"), String.valueOf("20:00"), Boolean.valueOf(true));
        PosIDMealItem posMealInit4 = new PosIDMealItem("4", I18nUtil.i18nCode((String)"posid_mealName_3", (Object[])new Object[0]), String.valueOf("20:01"), String.valueOf("23:59"), Boolean.valueOf(true));
        PosIDMealItem posMealInit5 = new PosIDMealItem("5", I18nUtil.i18nCode((String)"posid_mealName_4", (Object[])new Object[0]), String.valueOf("00:00"), String.valueOf("10:00"), Boolean.valueOf(false));
        PosIDMealItem posMealInit6 = new PosIDMealItem("6", I18nUtil.i18nCode((String)"posid_mealName_5", (Object[])new Object[0]), String.valueOf("10:01"), String.valueOf("14:00"), Boolean.valueOf(false));
        PosIDMealItem posMealInit7 = new PosIDMealItem("7", I18nUtil.i18nCode((String)"posid_mealName_6", (Object[])new Object[0]), String.valueOf("14:01"), String.valueOf("20:00"), Boolean.valueOf(false));
        PosIDMealItem posMealInit8 = new PosIDMealItem("8", I18nUtil.i18nCode((String)"posid_mealName_7", (Object[])new Object[0]), String.valueOf("20:01"), String.valueOf("23:59"), Boolean.valueOf(false));
        this.posIDMealService.initData(posMealInit1);
        this.posIDMealService.initData(posMealInit2);
        this.posIDMealService.initData(posMealInit3);
        this.posIDMealService.initData(posMealInit4);
        this.posIDMealService.initData(posMealInit5);
        this.posIDMealService.initData(posMealInit6);
        this.posIDMealService.initData(posMealInit7);
        this.posIDMealService.initData(posMealInit8);
    }

    public void initPosIDAccountKind() {
        PosIDAccountKindItem item = this.posIDAccountKindService.getItemByCode("1");
        if (item == null) {
            PosIDBatchTimeItem posBatchTime = null;
            List itemList = this.posIDBatchTimeService.getItemByCode("1");
            if (itemList != null && itemList.size() > 0) {
                posBatchTime = (PosIDBatchTimeItem)itemList.get(0);
            }
            item = new PosIDAccountKindItem();
            item.setCode("1");
            item.setName(I18nUtil.i18nCode((String)"posid_iccard_initName", (Object[])new Object[0]));
            item.setDiscountType("0");
            item.setDiscountMoney(Integer.valueOf(0));
            item.setDiscount(Integer.valueOf(100));
            item.setDateMaxCount(Integer.valueOf(0));
            item.setDateMaxMoney(Integer.valueOf(0));
            item.setPerMaxMoney(Integer.valueOf(0));
            item.setMealMaxMoney(Integer.valueOf(0));
            item.setMealMaxCount(Integer.valueOf(0));
            item.setLessMoney(Integer.valueOf(0));
            item.setMaxMoney(PosIDConstants.CARD_SOLDE_MAX);
            item.setMonthMaxCount(Integer.valueOf(0));
            item.setMonthMaxMoney(Integer.valueOf(0));
            Calendar calendar = Calendar.getInstance();
            calendar.add(1, 1);
            Calendar c = Calendar.getInstance();
            c.add(1, 1);
            item.setUseDate(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(c.getTime()));
            item.setBatchTimeId(posBatchTime != null ? posBatchTime.getCode() : "");
            item.setBatchTimeName(posBatchTime != null ? posBatchTime.getName() : "");
            this.posIDAccountKindService.saveItem(item);
        }
    }

    private void initPosIDRechargeMoney() {
        PosIDRechargeMoneyItem item = new PosIDRechargeMoneyItem(Integer.valueOf(1000), Integer.valueOf(1));
        PosIDRechargeMoneyItem item1 = new PosIDRechargeMoneyItem(Integer.valueOf(3000), Integer.valueOf(2));
        PosIDRechargeMoneyItem item2 = new PosIDRechargeMoneyItem(Integer.valueOf(5000), Integer.valueOf(3));
        PosIDRechargeMoneyItem item3 = new PosIDRechargeMoneyItem(Integer.valueOf(10000), Integer.valueOf(4));
        PosIDRechargeMoneyItem item4 = new PosIDRechargeMoneyItem(Integer.valueOf(20000), Integer.valueOf(5));
        PosIDRechargeMoneyItem item5 = new PosIDRechargeMoneyItem(Integer.valueOf(30000), Integer.valueOf(6));
        PosIDRechargeMoneyItem item6 = new PosIDRechargeMoneyItem(Integer.valueOf(50000), Integer.valueOf(7));
        PosIDRechargeMoneyItem item7 = new PosIDRechargeMoneyItem(Integer.valueOf(80000), Integer.valueOf(8));
        PosIDRechargeMoneyItem item8 = new PosIDRechargeMoneyItem(Integer.valueOf(100000), Integer.valueOf(9));
        this.posIDRechargeMoneyService.initData(item);
        this.posIDRechargeMoneyService.initData(item1);
        this.posIDRechargeMoneyService.initData(item2);
        this.posIDRechargeMoneyService.initData(item3);
        this.posIDRechargeMoneyService.initData(item4);
        this.posIDRechargeMoneyService.initData(item5);
        this.posIDRechargeMoneyService.initData(item6);
        this.posIDRechargeMoneyService.initData(item7);
        this.posIDRechargeMoneyService.initData(item8);
    }

    public void initPosSystemParam() {
        this.baseSysParamService.initData(new BaseSysParamItem("posid.highLimit", PosIDConstants.CARD_SOLDE_MAX + "", I18nUtil.i18nCode((String)"posid_card_balance_limit", (Object[])new Object[0])));
        this.baseSysParamService.initData(new BaseSysParamItem("posid.cardModel", "1", I18nUtil.i18nCode((String)"posid_system_cardModel_dsc", (Object[])new Object[0])));
        this.baseSysParamService.initData(new BaseSysParamItem("posid.whiteList", "false", I18nUtil.i18nCode((String)"posid_system_whiteList_dsc", (Object[])new Object[0])));
        this.baseSysParamService.initData(new BaseSysParamItem("posid.oneSection", "1", I18nUtil.i18nCode((String)"posid_system_mainSec", (Object[])new Object[0])));
        this.baseSysParamService.initData(new BaseSysParamItem("posid.twoSection", "2", I18nUtil.i18nCode((String)"posid_system_backSec", (Object[])new Object[0])));
        this.baseSysParamService.initData(new BaseSysParamItem("posid.sectionCount", "15", I18nUtil.i18nCode((String)"posid_system_sectors", (Object[])new Object[0])));
        this.baseSysParamService.initData(new BaseSysParamItem("posid.toModify", "true", I18nUtil.i18nCode((String)"posid_system_modify_dsc", (Object[])new Object[0])));
        this.baseSysParamService.initData(new BaseSysParamItem("posid.switchTime", "1", I18nUtil.i18nCode((String)"posid_system_switchTime_dsc", (Object[])new Object[0])));
        this.baseSysParamService.initData(new BaseSysParamItem("posid.keyWord", "ZKBiosecurityPosSystemKey", I18nUtil.i18nCode((String)"posid_system_pluginKey", (Object[])new Object[0])));
        this.baseSysParamService.initData(new BaseSysParamItem("posid.consumeOrder", "0", I18nUtil.i18nCode((String)"posid_system_consumeOrder_dsc", (Object[])new Object[0])));
        this.baseSysParamService.initData(new BaseSysParamItem("posid.monthAllow", "false", I18nUtil.i18nCode((String)"posid_system_isMonthSubsidy", (Object[])new Object[0])));
        this.baseSysParamService.initData(new BaseSysParamItem("posid.confirmPassword", "123456", I18nUtil.i18nCode((String)"posid_system_confirm_password", (Object[])new Object[0])));
        this.baseSysParamService.initData(new BaseSysParamItem("posid.moneyDeclare", "1", I18nUtil.i18nCode((String)"posid_system_money_declare", (Object[])new Object[0])));
        this.baseSysParamService.initData(new BaseSysParamItem("posid.moneySign", "$", I18nUtil.i18nCode((String)"posid_system_money_declareSign", (Object[])new Object[0])));
        this.baseSysParamService.initData(new BaseSysParamItem("posid.timingConsumePrinciple", "0", I18nUtil.i18nCode((String)"posid_timing_consume_principle", (Object[])new Object[0])));
        this.baseSysParamService.initData(new BaseSysParamItem("posid.timingConsumeInfo", I18nUtil.i18nCode((String)"posid_timing_start_charging", (Object[])new Object[0]), I18nUtil.i18nCode((String)"posid_timing_consumeInfo", (Object[])new Object[0])));
        this.baseSysParamService.initData(new BaseSysParamItem("posid.allowanceLimitPersMonth", "99", I18nUtil.i18nCode((String)"posid_allowance_limit_pers_month", (Object[])new Object[0])));
        this.baseSysParamService.initData(new BaseSysParamItem("posid.thresholdValue", "0", I18nUtil.i18nCode((String)"posid_system_threshold_value", (Object[])new Object[0])));
        this.baseSysParamService.initData(new BaseSysParamItem("posid.thresholdMessage", I18nUtil.i18nCode((String)"posid_system_timely_recharge", (Object[])new Object[0]), I18nUtil.i18nCode((String)"posid_system_threshold_value_message", (Object[])new Object[0])));
        this.baseSysParamService.initData(new BaseSysParamItem("posid.memberAccount", "0", I18nUtil.i18nCode((String)"posid_system_member_account_threshold_value", (Object[])new Object[0])));
        this.baseSysParamService.initData(new BaseSysParamItem("posid.consumeMaxMoney", PosIDConstants.CARD_SOLDE_MAX + "", I18nUtil.i18nCode((String)"posid_system_single_consumption_max_money", (Object[])new Object[0])));
        this.baseSysParamService.initData(new BaseSysParamItem("posid.secondaryConfirmation", "1", I18nUtil.i18nCode((String)"posid_system_secondary_confirmation", (Object[])new Object[0])));
        this.baseSysParamService.initData(new BaseSysParamItem("posid.orderDinnerCanConsume", "0", I18nUtil.i18nCode((String)"posid_order_dinner_can_consume", (Object[])new Object[0])));
        this.baseSysParamService.initData(new BaseSysParamItem("posid.orderMealAdvanceDate", "1", I18nUtil.i18nCode((String)"posid_system_days_in_advance", (Object[])new Object[0])));
        this.baseSysParamService.initData(new BaseSysParamItem("posid.orderMealMaxDate", "7", I18nUtil.i18nCode((String)"posid_system_maximum_number", (Object[])new Object[0])));
        this.baseSysParamService.initData(new BaseSysParamItem("posid.cancelOrderMealTime", "60", I18nUtil.i18nCode((String)"posid_system_cancellation_of_order_time", (Object[])new Object[0])));
        this.baseSysParamService.initData(new BaseSysParamItem("posid.photo.encryptProp", "true", "\u4eba\u654f\u611f\u4fe1\u606f\u4fdd\u62a4-\u4eba\u8138\u6293\u62cd"));
        this.baseSysParamService.initData(new BaseSysParamItem("posid.autoOpenAccount", "1", "\u81ea\u52a8\u521b\u5efa\u6d88\u8d39\u8d26\u6237"));
        this.baseSysParamService.initData(new BaseSysParamItem("posid.alipayOuterConsume", "0", "\u652f\u4ed8\u5b9d\u8bbe\u5907\u662f\u5426\u652f\u6301\u5916\u90e8\u4eba\u5458\u6d88\u8d39"));
        this.baseSysParamService.initData(new BaseSysParamItem("posid.aliPayEnterprise", "0", "\u652f\u4ed8\u5b9d\u56e2\u9910\u652f\u4ed8"));
        this.baseSysParamService.initData(new BaseSysParamItem("posid.aliPayEnterpriseSign", "", "\u652f\u4ed8\u5b9d\u4f01\u4e1a\u7b7e\u7ea6\u72b6\u6001"));
    }

    private void initUpgradeVersion() {
        String curVersion = VersionUtil.getReleaseGitTags((String)"posid");
        if (StringUtils.isNotBlank((CharSequence)curVersion)) {
            BaseSysParamItem baseSysParamItem = this.baseSysParamService.findByParamName("PosIDUpgradeVersion");
            if (StringUtils.isBlank((CharSequence)baseSysParamItem.getId())) {
                baseSysParamItem = new BaseSysParamItem("PosIDUpgradeVersion", curVersion, "Posid Upgrade Version", Boolean.valueOf(true));
            }
            this.baseSysParamService.saveItem(baseSysParamItem);
        }
    }
}

