/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.att.vo;

import com.zkteco.zkbiosecurity.base.annotation.Column;
import com.zkteco.zkbiosecurity.base.annotation.Condition;
import com.zkteco.zkbiosecurity.base.annotation.From;
import com.zkteco.zkbiosecurity.base.annotation.GridColumn;
import com.zkteco.zkbiosecurity.base.annotation.GridConfig;
import com.zkteco.zkbiosecurity.base.annotation.GridOperate;
import com.zkteco.zkbiosecurity.base.annotation.OrderBy;
import com.zkteco.zkbiosecurity.base.annotation.Where;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import java.util.Date;

@From(after="ATT_LEAVE t LEFT JOIN ATT_LEAVETYPE alt ON t.LEAVETYPE_ID=alt.ID LEFT JOIN ATT_PERSON p ON t.PERS_PERSON_ID=p.PERS_PERSON_ID")
@Where(after="AND alt.LEAVETYPE_NO = 'L9'")
@OrderBy(after="t.CREATE_TIME DESC")
@GridConfig(operate=true, idField="id", winHeight=400, winWidth=600, operates={@GridOperate(type="del", permission="att:trip:del", url="attTrip.do?del&pins=(personPin)", label="common_op_del", filter="attApplyShowDel")})
public class AttTripItem
extends BaseItem {
    private static final long serialVersionUID = 1L;
    @Column(name="t.ID")
    @GridColumn(checkbox=true, width="40", sort="na")
    private String id;
    @Column(name="t.PERS_PERSON_PIN", equalTag="=")
    @GridColumn(label="att_person_pin", width="100")
    private String personPin;
    @Column(name="p.PERS_PERSON_NAME")
    @GridColumn(label="att_person_name", width="100", sort="na")
    private String personName;
    @Column(name="p.PERS_PERSON_LASTNAME")
    @GridColumn(label="att_person_lastName", showExpression="#language!='zh_CN'", width="100")
    private String personLastName;
    @GridColumn(label="pers_dept_deptNo", width="150", sort="na")
    private String deptCode;
    @GridColumn(label="pers_dept_deptName", width="150", sort="na")
    private String deptName;
    @Column(name="t.START_DATETIME")
    @GridColumn(label="common_startTime", width="150")
    private Date startDatetime;
    @Column(name="t.END_DATETIME")
    @GridColumn(label="common_endTime", width="130")
    private Date endDatetime;
    @Column(name="t.LEAVE_LONG")
    @GridColumn(label="att_trip_tripLongMinute", width="170")
    private Integer leaveLong;
    @GridColumn(label="att_trip_tripLongDay", width="130", show=false)
    private String tripLongDay;
    @GridColumn(label="att_trip_tripLongHour", width="130")
    private String tripHour;
    @Column(name="t.REMARK")
    @GridColumn(label="common_remark", width="130")
    private String remark;
    @Column(name="t.CREATE_TIME")
    @GridColumn(label="att_common_operateTime", width="130")
    private Date operateDatetime;
    @Column(name="t.AUTH_DEPT_ID")
    private String deptId;
    @Column(name="t.PERS_PERSON_ID")
    private String personId;
    @Condition(value="t.CREATE_TIME", equalTag=">")
    private Date startTime;
    @Condition(value="t.CREATE_TIME", equalTag="<")
    private Date endTime;
    @Condition(value="t.AUTH_DEPT_ID", equalTag="in")
    private String inDeptId;
    @Condition(value="t.PERS_PERSON_ID", equalTag="in")
    private String inPersonId;
    @Condition(value="t.PERS_PERSON_PIN", equalTag="in")
    private String inPersonPin;
    @Condition(value="(lower(p.PERS_PERSON_NAME) LIKE ''%{0}%'' OR lower(p.PERS_PERSON_LASTNAME) LIKE ''%{0}%'')")
    private String likeName;
    private String leaveTypeId;
    private String leaveImagePath;
    private String photoUrlList;
    private String applyNo;
    private String applyType;
    @Column(name="t.FLOW_STATUS", equalTag="=")
    private String flowStatus;
    private String flowNo;
    @Column(name="t.BUSINESS_KEY")
    private String businessKey;
    private String notifierPerIds;
    private String notifierPins;
    @Condition(value="t.END_DATETIME", equalTag=">=")
    private Date startApplyDateTime;
    @Condition(value="t.START_DATETIME", equalTag="<=")
    private Date endApplyDateTime;

    public AttTripItem() {
    }

    public AttTripItem(Boolean equals) {
        super(equals);
    }

    public AttTripItem(String id) {
        super(Boolean.valueOf(true));
        this.id = id;
    }

    public AttTripItem setId(String id) {
        this.id = id;
        return this;
    }

    public AttTripItem setPersonPin(String personPin) {
        this.personPin = personPin;
        return this;
    }

    public AttTripItem setPersonName(String personName) {
        this.personName = personName;
        return this;
    }

    public AttTripItem setPersonLastName(String personLastName) {
        this.personLastName = personLastName;
        return this;
    }

    public AttTripItem setDeptCode(String deptCode) {
        this.deptCode = deptCode;
        return this;
    }

    public AttTripItem setDeptName(String deptName) {
        this.deptName = deptName;
        return this;
    }

    public AttTripItem setStartDatetime(Date startDatetime) {
        this.startDatetime = startDatetime;
        return this;
    }

    public AttTripItem setEndDatetime(Date endDatetime) {
        this.endDatetime = endDatetime;
        return this;
    }

    public AttTripItem setLeaveLong(Integer leaveLong) {
        this.leaveLong = leaveLong;
        return this;
    }

    public AttTripItem setTripLongDay(String tripLongDay) {
        this.tripLongDay = tripLongDay;
        return this;
    }

    public AttTripItem setTripHour(String tripHour) {
        this.tripHour = tripHour;
        return this;
    }

    public AttTripItem setRemark(String remark) {
        this.remark = remark;
        return this;
    }

    public AttTripItem setOperateDatetime(Date operateDatetime) {
        this.operateDatetime = operateDatetime;
        return this;
    }

    public AttTripItem setDeptId(String deptId) {
        this.deptId = deptId;
        return this;
    }

    public AttTripItem setPersonId(String personId) {
        this.personId = personId;
        return this;
    }

    public AttTripItem setStartTime(Date startTime) {
        this.startTime = startTime;
        return this;
    }

    public AttTripItem setEndTime(Date endTime) {
        this.endTime = endTime;
        return this;
    }

    public AttTripItem setInDeptId(String inDeptId) {
        this.inDeptId = inDeptId;
        return this;
    }

    public AttTripItem setInPersonId(String inPersonId) {
        this.inPersonId = inPersonId;
        return this;
    }

    public AttTripItem setInPersonPin(String inPersonPin) {
        this.inPersonPin = inPersonPin;
        return this;
    }

    public AttTripItem setLikeName(String likeName) {
        this.likeName = likeName;
        return this;
    }

    public AttTripItem setLeaveTypeId(String leaveTypeId) {
        this.leaveTypeId = leaveTypeId;
        return this;
    }

    public AttTripItem setLeaveImagePath(String leaveImagePath) {
        this.leaveImagePath = leaveImagePath;
        return this;
    }

    public AttTripItem setPhotoUrlList(String photoUrlList) {
        this.photoUrlList = photoUrlList;
        return this;
    }

    public AttTripItem setApplyNo(String applyNo) {
        this.applyNo = applyNo;
        return this;
    }

    public AttTripItem setApplyType(String applyType) {
        this.applyType = applyType;
        return this;
    }

    public AttTripItem setFlowStatus(String flowStatus) {
        this.flowStatus = flowStatus;
        return this;
    }

    public AttTripItem setFlowNo(String flowNo) {
        this.flowNo = flowNo;
        return this;
    }

    public AttTripItem setBusinessKey(String businessKey) {
        this.businessKey = businessKey;
        return this;
    }

    public AttTripItem setNotifierPerIds(String notifierPerIds) {
        this.notifierPerIds = notifierPerIds;
        return this;
    }

    public AttTripItem setNotifierPins(String notifierPins) {
        this.notifierPins = notifierPins;
        return this;
    }

    public AttTripItem setStartApplyDateTime(Date startApplyDateTime) {
        this.startApplyDateTime = startApplyDateTime;
        return this;
    }

    public AttTripItem setEndApplyDateTime(Date endApplyDateTime) {
        this.endApplyDateTime = endApplyDateTime;
        return this;
    }

    public String getId() {
        return this.id;
    }

    public String getPersonPin() {
        return this.personPin;
    }

    public String getPersonName() {
        return this.personName;
    }

    public String getPersonLastName() {
        return this.personLastName;
    }

    public String getDeptCode() {
        return this.deptCode;
    }

    public String getDeptName() {
        return this.deptName;
    }

    public Date getStartDatetime() {
        return this.startDatetime;
    }

    public Date getEndDatetime() {
        return this.endDatetime;
    }

    public Integer getLeaveLong() {
        return this.leaveLong;
    }

    public String getTripLongDay() {
        return this.tripLongDay;
    }

    public String getTripHour() {
        return this.tripHour;
    }

    public String getRemark() {
        return this.remark;
    }

    public Date getOperateDatetime() {
        return this.operateDatetime;
    }

    public String getDeptId() {
        return this.deptId;
    }

    public String getPersonId() {
        return this.personId;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public String getInDeptId() {
        return this.inDeptId;
    }

    public String getInPersonId() {
        return this.inPersonId;
    }

    public String getInPersonPin() {
        return this.inPersonPin;
    }

    public String getLikeName() {
        return this.likeName;
    }

    public String getLeaveTypeId() {
        return this.leaveTypeId;
    }

    public String getLeaveImagePath() {
        return this.leaveImagePath;
    }

    public String getPhotoUrlList() {
        return this.photoUrlList;
    }

    public String getApplyNo() {
        return this.applyNo;
    }

    public String getApplyType() {
        return this.applyType;
    }

    public String getFlowStatus() {
        return this.flowStatus;
    }

    public String getFlowNo() {
        return this.flowNo;
    }

    public String getBusinessKey() {
        return this.businessKey;
    }

    public String getNotifierPerIds() {
        return this.notifierPerIds;
    }

    public String getNotifierPins() {
        return this.notifierPins;
    }

    public Date getStartApplyDateTime() {
        return this.startApplyDateTime;
    }

    public Date getEndApplyDateTime() {
        return this.endApplyDateTime;
    }
}

