/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.att.vo;

import com.zkteco.zkbiosecurity.base.annotation.Column;
import com.zkteco.zkbiosecurity.base.annotation.Condition;
import com.zkteco.zkbiosecurity.base.annotation.DateType;
import com.zkteco.zkbiosecurity.base.annotation.From;
import com.zkteco.zkbiosecurity.base.annotation.GridColumn;
import com.zkteco.zkbiosecurity.base.annotation.GridConfig;
import com.zkteco.zkbiosecurity.base.annotation.GridOperate;
import com.zkteco.zkbiosecurity.base.annotation.OrderBy;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

@From(after="ATT_TEMPSCH t LEFT JOIN ATT_GROUP ag ON ag.ID = t.GROUP_ID LEFT JOIN PERS_PERSON pp ON pp.pin = t.PERS_PERSON_PIN LEFT JOIN AUTH_DEPARTMENT ad ON (ad.ID = t.AUTH_DEPT_ID OR ad.ID = pp.auth_dept_id)")
@OrderBy(after="t.CREATE_TIME DESC")
@GridConfig(operate=true, idField="id", winHeight=700, winWidth=1080, operates={@GridOperate(type="edit", permission="att:schDetails:edit", url="attTempSch.do?edit", label="common_op_edit"), @GridOperate(type="custom", permission="att:schDetails:del", click="attSchDetailsDelVo", label="common_op_del")})
public class AttTempSchItem
extends BaseItem {
    private static final long serialVersionUID = 1L;
    @Column(name="t.ID")
    @GridColumn(checkbox=true, width="40", sort="na")
    private String id;
    @Column(name="t.PERS_PERSON_ID")
    private String personId;
    @Column(name="t.PERS_PERSON_PIN")
    @GridColumn(label="att_person_pin", sort="na", width="120", columnType="edit", editPermission="att:schDetails:edit", editUrl="attTempSch.do?edit", encryptMode="${pers.pin.encryptMode}", encryptProp="${pers.pin.encryptProp}")
    private String personPin;
    @Column(name="pp.NAME")
    @GridColumn(label="att_person_name", sort="na", width="120", columnType="edit", editPermission="att:schDetails:edit", editUrl="attTempSch.do?edit", encryptMode="${pers.name.encryptMode}", encryptProp="${pers.name.encryptProp}")
    private String personName;
    @Column(name="pp.LAST_NAME")
    @GridColumn(label="att_person_lastName", width="120", showExpression="#language!='zh_CN'", encryptMode="${pers.lastName.encryptMode}", encryptProp="${pers.lastName.encryptProp}")
    private String personLastName;
    private String likeName;
    @Column(name="t.AUTH_DEPT_ID", equalTag="=")
    @GridColumn(show=false)
    private String deptId;
    @Column(name="ad.CODE")
    private String deptCode;
    @Column(name="ad.NAME")
    @GridColumn(label="pers_dept_deptName", sort="na", width="120", columnType="edit", editPermission="att:schDetails:edit", editUrl="attTempSch.do?edit")
    private String deptName;
    @Column(name="ag.GROUP_NO")
    private String groupNo;
    @Column(name="ag.GROUP_NAME")
    @GridColumn(label="att_common_groupName", sort="na", width="120", columnType="edit", editPermission="att:schDetails:edit", editUrl="attTempSch.do?edit")
    private String groupName;
    @Column(name="t.TEMP_TYPE")
    private Short tempType;
    @Column(name="t.SCHEDULE_TYPE")
    private Short scheduleType;
    @Column(name="t.SHIFT_WORKTYPE")
    @GridColumn(label="att_shift_workType", width="120", format="normalWork=att_shift_normalWork,weekendOt=att_overtime_rest,holidayOt=att_shift_holidayOt", show=false)
    private String workType;
    @Column(name="t.START_DATE")
    @DateType(type="date")
    @GridColumn(label="common_startTime", width="120")
    private Date startDate;
    @Column(name="t.END_DATE")
    @DateType(type="date")
    @GridColumn(label="common_endTime", width="120")
    private Date endDate;
    private String shiftNo;
    private String shiftName;
    @GridColumn(label="att_personSch_timeSoltName", width="180", sort="na")
    private String timeSlotName;
    @Column(name="t.ATTENDANCE_MODE")
    @GridColumn(label="att_shift_attendanceMode", format="0=att_shift_shiftNormal,1=att_shift_oneDayOneCard,2=att_shift_onlyBrushTime,3=att_shift_notBrushCard", show=false)
    private Short attendanceMode;
    @Column(name="t.OVERTIME_MODE")
    @GridColumn(label="att_shift_overtimeMode", format="0=att_shift_autoCalc,1=att_shift_mustApply,2=att_shift_mustOvertime,3=att_shift_timeSmaller,4=att_shift_notOvertime", show=false)
    private Short overtimeMode;
    @Column(name="t.OVERTIME_REMARK")
    @GridColumn(label="att_shift_overtimeSign", format="0=att_shift_normal,1=att_shift_restday,2=common_leftMenu_holiday", show=false)
    private Short overtimeRemark;
    @Column(name="t.GROUP_ID")
    @GridColumn(show=false)
    private String groupId;
    @Condition(value="t.END_DATE", equalTag=">=")
    private Date startTime;
    @Condition(value="t.START_DATE", equalTag="<=")
    private Date endTime;
    @Condition(value="ad.ID", equalTag="in")
    private String inDeptId;
    @Condition(value="t.PERS_PERSON_ID", equalTag="in")
    private String inPersonId;
    private String inGroupId;
    @Condition(value="t.PERS_PERSON_PIN", equalTag="in")
    private String inPersonPin;
    private String shiftIds;
    private String timeSlotIds;
    @GridColumn(show=false)
    private Map<String, Object> map = new HashMap<String, Object>();
    private String isIncludeLower;

    public AttTempSchItem() {
    }

    public AttTempSchItem(Boolean equals) {
        super(equals);
    }

    public AttTempSchItem(String id) {
        super(Boolean.valueOf(true));
        this.id = id;
    }

    public AttTempSchItem(String id, Date startDate, Date endDate, Short scheduleType, Short tempType, Short attendanceMode, Short overtimeMode, Short overtimeRemark) {
        this.id = id;
        this.startDate = startDate;
        this.endDate = endDate;
        this.scheduleType = scheduleType;
        this.tempType = tempType;
        this.attendanceMode = attendanceMode;
        this.overtimeMode = overtimeMode;
        this.overtimeRemark = overtimeRemark;
    }

    public AttTempSchItem setId(String id) {
        this.id = id;
        return this;
    }

    public AttTempSchItem setPersonId(String personId) {
        this.personId = personId;
        return this;
    }

    public AttTempSchItem setPersonPin(String personPin) {
        this.personPin = personPin;
        return this;
    }

    public AttTempSchItem setPersonName(String personName) {
        this.personName = personName;
        return this;
    }

    public AttTempSchItem setPersonLastName(String personLastName) {
        this.personLastName = personLastName;
        return this;
    }

    public AttTempSchItem setLikeName(String likeName) {
        this.likeName = likeName;
        return this;
    }

    public AttTempSchItem setDeptId(String deptId) {
        this.deptId = deptId;
        return this;
    }

    public AttTempSchItem setDeptCode(String deptCode) {
        this.deptCode = deptCode;
        return this;
    }

    public AttTempSchItem setDeptName(String deptName) {
        this.deptName = deptName;
        return this;
    }

    public AttTempSchItem setGroupNo(String groupNo) {
        this.groupNo = groupNo;
        return this;
    }

    public AttTempSchItem setGroupName(String groupName) {
        this.groupName = groupName;
        return this;
    }

    public AttTempSchItem setTempType(Short tempType) {
        this.tempType = tempType;
        return this;
    }

    public AttTempSchItem setScheduleType(Short scheduleType) {
        this.scheduleType = scheduleType;
        return this;
    }

    public AttTempSchItem setWorkType(String workType) {
        this.workType = workType;
        return this;
    }

    public AttTempSchItem setStartDate(Date startDate) {
        this.startDate = startDate;
        return this;
    }

    public AttTempSchItem setEndDate(Date endDate) {
        this.endDate = endDate;
        return this;
    }

    public AttTempSchItem setShiftNo(String shiftNo) {
        this.shiftNo = shiftNo;
        return this;
    }

    public AttTempSchItem setShiftName(String shiftName) {
        this.shiftName = shiftName;
        return this;
    }

    public AttTempSchItem setTimeSlotName(String timeSlotName) {
        this.timeSlotName = timeSlotName;
        return this;
    }

    public AttTempSchItem setAttendanceMode(Short attendanceMode) {
        this.attendanceMode = attendanceMode;
        return this;
    }

    public AttTempSchItem setOvertimeMode(Short overtimeMode) {
        this.overtimeMode = overtimeMode;
        return this;
    }

    public AttTempSchItem setOvertimeRemark(Short overtimeRemark) {
        this.overtimeRemark = overtimeRemark;
        return this;
    }

    public AttTempSchItem setGroupId(String groupId) {
        this.groupId = groupId;
        return this;
    }

    public AttTempSchItem setStartTime(Date startTime) {
        this.startTime = startTime;
        return this;
    }

    public AttTempSchItem setEndTime(Date endTime) {
        this.endTime = endTime;
        return this;
    }

    public AttTempSchItem setInDeptId(String inDeptId) {
        this.inDeptId = inDeptId;
        return this;
    }

    public AttTempSchItem setInPersonId(String inPersonId) {
        this.inPersonId = inPersonId;
        return this;
    }

    public AttTempSchItem setInGroupId(String inGroupId) {
        this.inGroupId = inGroupId;
        return this;
    }

    public AttTempSchItem setInPersonPin(String inPersonPin) {
        this.inPersonPin = inPersonPin;
        return this;
    }

    public AttTempSchItem setShiftIds(String shiftIds) {
        this.shiftIds = shiftIds;
        return this;
    }

    public AttTempSchItem setTimeSlotIds(String timeSlotIds) {
        this.timeSlotIds = timeSlotIds;
        return this;
    }

    public AttTempSchItem setMap(Map<String, Object> map) {
        this.map = map;
        return this;
    }

    public AttTempSchItem setIsIncludeLower(String isIncludeLower) {
        this.isIncludeLower = isIncludeLower;
        return this;
    }

    public String getId() {
        return this.id;
    }

    public String getPersonId() {
        return this.personId;
    }

    public String getPersonPin() {
        return this.personPin;
    }

    public String getPersonName() {
        return this.personName;
    }

    public String getPersonLastName() {
        return this.personLastName;
    }

    public String getLikeName() {
        return this.likeName;
    }

    public String getDeptId() {
        return this.deptId;
    }

    public String getDeptCode() {
        return this.deptCode;
    }

    public String getDeptName() {
        return this.deptName;
    }

    public String getGroupNo() {
        return this.groupNo;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public Short getTempType() {
        return this.tempType;
    }

    public Short getScheduleType() {
        return this.scheduleType;
    }

    public String getWorkType() {
        return this.workType;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public String getShiftNo() {
        return this.shiftNo;
    }

    public String getShiftName() {
        return this.shiftName;
    }

    public String getTimeSlotName() {
        return this.timeSlotName;
    }

    public Short getAttendanceMode() {
        return this.attendanceMode;
    }

    public Short getOvertimeMode() {
        return this.overtimeMode;
    }

    public Short getOvertimeRemark() {
        return this.overtimeRemark;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public String getInDeptId() {
        return this.inDeptId;
    }

    public String getInPersonId() {
        return this.inPersonId;
    }

    public String getInGroupId() {
        return this.inGroupId;
    }

    public String getInPersonPin() {
        return this.inPersonPin;
    }

    public String getShiftIds() {
        return this.shiftIds;
    }

    public String getTimeSlotIds() {
        return this.timeSlotIds;
    }

    public Map<String, Object> getMap() {
        return this.map;
    }

    public String getIsIncludeLower() {
        return this.isIncludeLower;
    }
}

