/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.att.vo;

import com.zkteco.zkbiosecurity.base.annotation.Column;
import com.zkteco.zkbiosecurity.base.annotation.Condition;
import com.zkteco.zkbiosecurity.base.annotation.From;
import com.zkteco.zkbiosecurity.base.annotation.GridColumn;
import com.zkteco.zkbiosecurity.base.annotation.GridConfig;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;

@From(after="PERS_PERSON PP LEFT JOIN AUTH_DEPARTMENT AD ON PP.AUTH_DEPT_ID = AD.ID")
@GridConfig
public class AttPersonSelectItem
extends BaseItem {
    private static final long serialVersionUID = 1L;
    @Column(name="PP.ID")
    @GridColumn(checkbox=true, width="40", sort="na")
    private String id;
    @Column(name="PP.ID")
    private String personId;
    @Column(name="PP.PIN")
    @GridColumn(label="att_person_pin", width="100")
    private String personPin;
    @Column(name="PP.NAME")
    @GridColumn(label="att_person_name", width="100")
    private String personName;
    @Column(name="PP.LAST_NAME")
    @GridColumn(label="att_person_lastName", showExpression="#language!='zh_CN'", width="100")
    private String personLastName;
    @GridColumn(label="att_person_internalCard", width="100")
    private String cardNo;
    @Column(name="PP.GENDER")
    @GridColumn(label="common_gender", format="F=pers_person_female,M=pers_person_male,=---", width="60")
    private String gender;
    @Column(name="AD.ID")
    private String deptId;
    @Condition(value="AD.ID", equalTag="in")
    private String inDeptId;
    @Column(name="AD.CODE")
    private String deptCode;
    @Column(name="AD.NAME")
    @GridColumn(label="pers_dept_entity", width="*", sort="na")
    private String deptName;
    @Condition(value="(LOWER (PP.NAME) LIKE LOWER (''%{0}%'') OR LOWER (PP.LAST_NAME) LIKE LOWER (''%{0}%''))")
    private String likeName;
    @Condition(value="PP.AUTH_DEPT_ID IN (SELECT ud.AUTH_DEPT_ID FROM AUTH_USER_DEPT ud WHERE ud.AUTH_USER_ID = ''{0}'')")
    private String userId;
    @Condition(value="PP.ID NOT IN (SELECT AAP.PERS_PERSON_ID FROM ATT_AREA_PERSON AAP WHERE AAP.AUTH_AREA_ID = ''{0}'')")
    private String linkId;
    private String type;
    @Condition(value="PP.ID", equalTag="not in")
    private String selectId;
    private String isIncludeLower;

    public AttPersonSelectItem setId(String id) {
        this.id = id;
        return this;
    }

    public AttPersonSelectItem setPersonId(String personId) {
        this.personId = personId;
        return this;
    }

    public AttPersonSelectItem setPersonPin(String personPin) {
        this.personPin = personPin;
        return this;
    }

    public AttPersonSelectItem setPersonName(String personName) {
        this.personName = personName;
        return this;
    }

    public AttPersonSelectItem setPersonLastName(String personLastName) {
        this.personLastName = personLastName;
        return this;
    }

    public AttPersonSelectItem setCardNo(String cardNo) {
        this.cardNo = cardNo;
        return this;
    }

    public AttPersonSelectItem setGender(String gender) {
        this.gender = gender;
        return this;
    }

    public AttPersonSelectItem setDeptId(String deptId) {
        this.deptId = deptId;
        return this;
    }

    public AttPersonSelectItem setInDeptId(String inDeptId) {
        this.inDeptId = inDeptId;
        return this;
    }

    public AttPersonSelectItem setDeptCode(String deptCode) {
        this.deptCode = deptCode;
        return this;
    }

    public AttPersonSelectItem setDeptName(String deptName) {
        this.deptName = deptName;
        return this;
    }

    public AttPersonSelectItem setLikeName(String likeName) {
        this.likeName = likeName;
        return this;
    }

    public AttPersonSelectItem setUserId(String userId) {
        this.userId = userId;
        return this;
    }

    public AttPersonSelectItem setLinkId(String linkId) {
        this.linkId = linkId;
        return this;
    }

    public AttPersonSelectItem setType(String type) {
        this.type = type;
        return this;
    }

    public AttPersonSelectItem setSelectId(String selectId) {
        this.selectId = selectId;
        return this;
    }

    public AttPersonSelectItem setIsIncludeLower(String isIncludeLower) {
        this.isIncludeLower = isIncludeLower;
        return this;
    }

    public String getId() {
        return this.id;
    }

    public String getPersonId() {
        return this.personId;
    }

    public String getPersonPin() {
        return this.personPin;
    }

    public String getPersonName() {
        return this.personName;
    }

    public String getPersonLastName() {
        return this.personLastName;
    }

    public String getCardNo() {
        return this.cardNo;
    }

    public String getGender() {
        return this.gender;
    }

    public String getDeptId() {
        return this.deptId;
    }

    public String getInDeptId() {
        return this.inDeptId;
    }

    public String getDeptCode() {
        return this.deptCode;
    }

    public String getDeptName() {
        return this.deptName;
    }

    public String getLikeName() {
        return this.likeName;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getLinkId() {
        return this.linkId;
    }

    public String getType() {
        return this.type;
    }

    public String getSelectId() {
        return this.selectId;
    }

    public String getIsIncludeLower() {
        return this.isIncludeLower;
    }
}

