/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.att.vo;

import com.zkteco.zkbiosecurity.base.annotation.Column;
import com.zkteco.zkbiosecurity.base.annotation.Condition;
import com.zkteco.zkbiosecurity.base.annotation.From;
import com.zkteco.zkbiosecurity.base.annotation.GridColumn;
import com.zkteco.zkbiosecurity.base.annotation.GridConfig;
import com.zkteco.zkbiosecurity.base.annotation.GridOperate;
import com.zkteco.zkbiosecurity.base.annotation.OrderBy;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import java.util.Date;

@From(after="ATT_OVERTIME t LEFT JOIN AUTH_DEPARTMENT ad ON t.AUTH_DEPT_ID = ad.ID")
@OrderBy(after="t.CREATE_TIME DESC")
@GridConfig(operate=true, idField="id", winHeight=400, winWidth=600, operates={@GridOperate(type="del", permission="att:overtime:del", url="attOvertime.do?del&pins=(personPin)", label="common_op_del", filter="attApplyShowDel")})
public class AttOvertimeItem
extends BaseItem {
    private static final long serialVersionUID = 1L;
    @Column(name="t.ID")
    @GridColumn(checkbox=true, width="40", sort="na")
    private String id;
    @Column(name="t.PERS_PERSON_ID")
    private String personId;
    @Column(name="t.PERS_PERSON_PIN")
    @GridColumn(label="att_person_pin", width="120", encryptMode="${pers.pin.encryptMode}", encryptProp="${pers.pin.encryptProp}")
    private String personPin;
    @GridColumn(label="att_person_name", width="120", sort="na", encryptMode="${pers.name.encryptMode}", encryptProp="${pers.name.encryptProp}")
    private String personName;
    @GridColumn(label="att_person_lastName", showExpression="#language!='zh_CN'", width="120", encryptMode="${pers.lastName.encryptMode}", encryptProp="${pers.lastName.encryptProp}")
    private String personLastName;
    @Column(name="t.AUTH_DEPT_ID")
    private String deptId;
    @Column(name="ad.CODE")
    @GridColumn(label="att_common_deptNo", width="120", sort="na")
    private String deptCode;
    @Column(name="ad.NAME")
    @GridColumn(label="att_common_deptName", width="120", sort="na")
    private String deptName;
    @Column(name="t.OVERTIME_SIGN")
    @GridColumn(label="att_overtime_type", width="130", format="0=att_overtime_normal,1=att_overtime_rest,2=att_shift_holidayOt", show=false)
    private Short overtimeSign;
    @Column(name="t.START_DATETIME")
    @GridColumn(label="common_startTime", width="150")
    private Date startDatetime;
    @Column(name="t.END_DATETIME")
    @GridColumn(label="common_endTime", width="150")
    private Date endDatetime;
    @Column(name="t.OVERTIME_LONG")
    @GridColumn(label="att_overtime_overtimeLong", width="120", show=false)
    private Integer overtimeLong;
    @GridColumn(label="att_overtime_overtimeHour", width="120")
    private String overTimeHour;
    @GridColumn(label="common_status", width="120", format="0=att_approve_wait,1=att_exception_stop,2=att_apply_pass,3=att_apply_revoke,4=att_exception_delete,5=att_exception_refuse,6==att_exception_end")
    @Column(name="t.FLOW_STATUS", equalTag="=")
    private String flowStatus;
    @Column(name="t.REMARK")
    @GridColumn(label="common_remark", width="120")
    private String remark;
    @Column(name="t.CREATE_TIME")
    @GridColumn(label="att_common_operateTime", width="130")
    private Date operateDatetime;
    @Column(name="t.BUSINESS_KEY")
    private String businessKey;
    @Column(name="t.CREATE_TIME")
    private Date createTime;
    @Condition(value="t.END_DATETIME", equalTag=">=")
    private Date startApplyDateTime;
    @Condition(value="t.START_DATETIME", equalTag="<=")
    private Date endApplyDateTime;
    @Condition(value="t.FLOW_STATUS", equalTag="in")
    private String flowStatusIn;
    @Condition(value="t.START_DATETIME", equalTag=">=")
    private Date startTime;
    @Condition(value="t.END_DATETIME", equalTag="<=")
    private Date endTime;
    @Condition(value="t.AUTH_DEPT_ID", equalTag="in")
    private String inDeptId;
    @Condition(value="t.PERS_PERSON_ID", equalTag="in")
    private String inPersonId;
    @Condition(value="t.PERS_PERSON_PIN", equalTag="in")
    private String inPersonPin;
    @Condition(value="t.PERS_PERSON_PIN", equalTag="=")
    private String personPinEq;
    @Condition(value="t.AUTH_DEPT_ID IN (SELECT ud.AUTH_DEPT_ID FROM AUTH_USER_DEPT ud WHERE ud.AUTH_USER_ID=''{0}'')")
    private String userId;
    private String likeName;
    private String applyNo;
    private String applyType;
    private Integer rowNum;
    private String isIncludeLower;
    private String flowNo;
    private String notifierPerIds;
    private String notifierPins;

    public AttOvertimeItem() {
    }

    public AttOvertimeItem(Boolean equals) {
        super(equals);
    }

    public AttOvertimeItem(String id) {
        super(Boolean.valueOf(true));
        this.id = id;
    }

    public AttOvertimeItem setId(String id) {
        this.id = id;
        return this;
    }

    public AttOvertimeItem setPersonId(String personId) {
        this.personId = personId;
        return this;
    }

    public AttOvertimeItem setPersonPin(String personPin) {
        this.personPin = personPin;
        return this;
    }

    public AttOvertimeItem setPersonName(String personName) {
        this.personName = personName;
        return this;
    }

    public AttOvertimeItem setPersonLastName(String personLastName) {
        this.personLastName = personLastName;
        return this;
    }

    public AttOvertimeItem setDeptId(String deptId) {
        this.deptId = deptId;
        return this;
    }

    public AttOvertimeItem setDeptCode(String deptCode) {
        this.deptCode = deptCode;
        return this;
    }

    public AttOvertimeItem setDeptName(String deptName) {
        this.deptName = deptName;
        return this;
    }

    public AttOvertimeItem setOvertimeSign(Short overtimeSign) {
        this.overtimeSign = overtimeSign;
        return this;
    }

    public AttOvertimeItem setStartDatetime(Date startDatetime) {
        this.startDatetime = startDatetime;
        return this;
    }

    public AttOvertimeItem setEndDatetime(Date endDatetime) {
        this.endDatetime = endDatetime;
        return this;
    }

    public AttOvertimeItem setOvertimeLong(Integer overtimeLong) {
        this.overtimeLong = overtimeLong;
        return this;
    }

    public AttOvertimeItem setOverTimeHour(String overTimeHour) {
        this.overTimeHour = overTimeHour;
        return this;
    }

    public AttOvertimeItem setFlowStatus(String flowStatus) {
        this.flowStatus = flowStatus;
        return this;
    }

    public AttOvertimeItem setRemark(String remark) {
        this.remark = remark;
        return this;
    }

    public AttOvertimeItem setOperateDatetime(Date operateDatetime) {
        this.operateDatetime = operateDatetime;
        return this;
    }

    public AttOvertimeItem setBusinessKey(String businessKey) {
        this.businessKey = businessKey;
        return this;
    }

    public AttOvertimeItem setCreateTime(Date createTime) {
        this.createTime = createTime;
        return this;
    }

    public AttOvertimeItem setStartApplyDateTime(Date startApplyDateTime) {
        this.startApplyDateTime = startApplyDateTime;
        return this;
    }

    public AttOvertimeItem setEndApplyDateTime(Date endApplyDateTime) {
        this.endApplyDateTime = endApplyDateTime;
        return this;
    }

    public AttOvertimeItem setFlowStatusIn(String flowStatusIn) {
        this.flowStatusIn = flowStatusIn;
        return this;
    }

    public AttOvertimeItem setStartTime(Date startTime) {
        this.startTime = startTime;
        return this;
    }

    public AttOvertimeItem setEndTime(Date endTime) {
        this.endTime = endTime;
        return this;
    }

    public AttOvertimeItem setInDeptId(String inDeptId) {
        this.inDeptId = inDeptId;
        return this;
    }

    public AttOvertimeItem setInPersonId(String inPersonId) {
        this.inPersonId = inPersonId;
        return this;
    }

    public AttOvertimeItem setInPersonPin(String inPersonPin) {
        this.inPersonPin = inPersonPin;
        return this;
    }

    public AttOvertimeItem setPersonPinEq(String personPinEq) {
        this.personPinEq = personPinEq;
        return this;
    }

    public AttOvertimeItem setUserId(String userId) {
        this.userId = userId;
        return this;
    }

    public AttOvertimeItem setLikeName(String likeName) {
        this.likeName = likeName;
        return this;
    }

    public AttOvertimeItem setApplyNo(String applyNo) {
        this.applyNo = applyNo;
        return this;
    }

    public AttOvertimeItem setApplyType(String applyType) {
        this.applyType = applyType;
        return this;
    }

    public AttOvertimeItem setRowNum(Integer rowNum) {
        this.rowNum = rowNum;
        return this;
    }

    public AttOvertimeItem setIsIncludeLower(String isIncludeLower) {
        this.isIncludeLower = isIncludeLower;
        return this;
    }

    public AttOvertimeItem setFlowNo(String flowNo) {
        this.flowNo = flowNo;
        return this;
    }

    public AttOvertimeItem setNotifierPerIds(String notifierPerIds) {
        this.notifierPerIds = notifierPerIds;
        return this;
    }

    public AttOvertimeItem setNotifierPins(String notifierPins) {
        this.notifierPins = notifierPins;
        return this;
    }

    public String getId() {
        return this.id;
    }

    public String getPersonId() {
        return this.personId;
    }

    public String getPersonPin() {
        return this.personPin;
    }

    public String getPersonName() {
        return this.personName;
    }

    public String getPersonLastName() {
        return this.personLastName;
    }

    public String getDeptId() {
        return this.deptId;
    }

    public String getDeptCode() {
        return this.deptCode;
    }

    public String getDeptName() {
        return this.deptName;
    }

    public Short getOvertimeSign() {
        return this.overtimeSign;
    }

    public Date getStartDatetime() {
        return this.startDatetime;
    }

    public Date getEndDatetime() {
        return this.endDatetime;
    }

    public Integer getOvertimeLong() {
        return this.overtimeLong;
    }

    public String getOverTimeHour() {
        return this.overTimeHour;
    }

    public String getFlowStatus() {
        return this.flowStatus;
    }

    public String getRemark() {
        return this.remark;
    }

    public Date getOperateDatetime() {
        return this.operateDatetime;
    }

    public String getBusinessKey() {
        return this.businessKey;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public Date getStartApplyDateTime() {
        return this.startApplyDateTime;
    }

    public Date getEndApplyDateTime() {
        return this.endApplyDateTime;
    }

    public String getFlowStatusIn() {
        return this.flowStatusIn;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public String getInDeptId() {
        return this.inDeptId;
    }

    public String getInPersonId() {
        return this.inPersonId;
    }

    public String getInPersonPin() {
        return this.inPersonPin;
    }

    public String getPersonPinEq() {
        return this.personPinEq;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getLikeName() {
        return this.likeName;
    }

    public String getApplyNo() {
        return this.applyNo;
    }

    public String getApplyType() {
        return this.applyType;
    }

    public Integer getRowNum() {
        return this.rowNum;
    }

    public String getIsIncludeLower() {
        return this.isIncludeLower;
    }

    public String getFlowNo() {
        return this.flowNo;
    }

    public String getNotifierPerIds() {
        return this.notifierPerIds;
    }

    public String getNotifierPins() {
        return this.notifierPins;
    }
}

