/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.att.vo;

import com.zkteco.zkbiosecurity.base.annotation.Column;
import com.zkteco.zkbiosecurity.base.annotation.Condition;
import com.zkteco.zkbiosecurity.base.annotation.From;
import com.zkteco.zkbiosecurity.base.annotation.GridColumn;
import com.zkteco.zkbiosecurity.base.annotation.GridConfig;
import com.zkteco.zkbiosecurity.base.annotation.GroupBy;
import com.zkteco.zkbiosecurity.base.annotation.OrderBy;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

@From(after="ATT_RECORD t ")
@GroupBy(after="t.PERS_PERSON_PIN")
@OrderBy(after="t.PERS_PERSON_PIN DESC")
@GridConfig
public class AttMonthStatisticalReportItem
extends BaseItem {
    private static final long serialVersionUID = 1L;
    @GridColumn(show=false)
    private String id;
    @Column(name="t.PERS_PERSON_PIN")
    @GridColumn(label="att_common_person", secHeader="att_common_pin", sortNo=1, width="90", encryptMode="${pers.pin.encryptMode}", encryptProp="${pers.pin.encryptProp}")
    private String pin;
    @GridColumn(label="#cspan", secHeader="att_person_name", sortNo=2, width="90", encryptMode="${pers.name.encryptMode}", encryptProp="${pers.name.encryptProp}")
    private String name;
    @GridColumn(label="#cspan", secHeader="att_person_lastName", showExpression="#language!='zh_CN'", sortNo=3, width="90", encryptMode="${pers.lastName.encryptMode}", encryptProp="${pers.lastName.encryptProp}")
    private String lastName;
    @GridColumn(show=false, sortNo=4)
    @Condition(value="t.AUTH_DEPT_ID")
    private String deptId;
    @GridColumn(label="pers_dept_deptNo", width="90", sortNo=5, show=false)
    private String deptCode;
    @GridColumn(label="pers_dept_deptName", sortNo=6, width="130")
    private String deptName;
    @GridColumn(label="att_rule_arrive", secHeader="att_statistical_should", sortNo=7)
    private String shouldHour;
    @GridColumn(label="#cspan", secHeader="att_statistical_actual", sortNo=8)
    private String actualHour;
    @GridColumn(label="#cspan", secHeader="att_statistical_valid", sortNo=9)
    private String validHour;
    @GridColumn(label="att_common_late", secHeader="att_common_timeLongs", sortNo=10)
    private String lateMinute;
    @Column(name="(COALESCE(SUM(t.LATE_COUNT_TOTAL),0))")
    @GridColumn(label="#cspan", secHeader="att_statistical_numberOfTimes", sortNo=11)
    private String lateCountTotal;
    @GridColumn(label="att_common_early", secHeader="att_common_timeLongs", sortNo=12)
    private String earlyMinute;
    @Column(name="(COALESCE(SUM(t.EARLY_COUNT_TOTAL),0))")
    @GridColumn(label="#cspan", secHeader="att_statistical_numberOfTimes", sortNo=13)
    private String earlyCount;
    @GridColumn(label="att_leftMenu_overtime", secHeader="att_statistical_usually", sortNo=14)
    private String overtimeUsualHour;
    @GridColumn(label="#cspan", secHeader="att_statistical_rest", sortNo=15)
    private String overtimeRestHour;
    @GridColumn(label="#cspan", secHeader="att_statistical_holiday", sortNo=16)
    private String overtimeHolidayHour;
    @GridColumn(label="#cspan", secHeader="att_statistical_total", sortNo=17)
    private String overtimeHour;
    @GridColumn(label="att_common_absent", width="130", sortNo=60)
    private String absentHour;
    @GridColumn(dynamicColumn="attLeaveTypeDynamicColumn", sortNo=61, label="att_statistical_leaveDetail")
    private Map<String, Object> attMonthDetailReportLeaveHourMap = new HashMap<String, Object>();
    @Deprecated
    private String searchMonth;
    @Condition(value="t.ATT_DATE", equalTag=">=")
    private Date monthStart;
    @Condition(value="t.ATT_DATE", equalTag="<=")
    private Date monthEnd;
    @Condition(value="t.AUTH_DEPT_ID", equalTag="in")
    private String inDeptId;
    private String likeName;
    @Condition(value="t.PERS_PERSON_PIN", equalTag="in")
    private String inPersonPin;
    private String leaveMinuteTotal;
    private String should;
    private String actual;
    private String valid;
    private String late;
    private String early;
    private String absent;
    private String overtimeUsual;
    private String overtimeRest;
    private String overtimeHoliday;
    private String overtime;
    private String leave;
    private String trip;
    private String out;

    public AttMonthStatisticalReportItem() {
        this.id = UUID.randomUUID().toString();
    }

    public AttMonthStatisticalReportItem setId(String id) {
        this.id = id;
        return this;
    }

    public AttMonthStatisticalReportItem setPin(String pin) {
        this.pin = pin;
        return this;
    }

    public AttMonthStatisticalReportItem setName(String name) {
        this.name = name;
        return this;
    }

    public AttMonthStatisticalReportItem setLastName(String lastName) {
        this.lastName = lastName;
        return this;
    }

    public AttMonthStatisticalReportItem setDeptId(String deptId) {
        this.deptId = deptId;
        return this;
    }

    public AttMonthStatisticalReportItem setDeptCode(String deptCode) {
        this.deptCode = deptCode;
        return this;
    }

    public AttMonthStatisticalReportItem setDeptName(String deptName) {
        this.deptName = deptName;
        return this;
    }

    public AttMonthStatisticalReportItem setShouldHour(String shouldHour) {
        this.shouldHour = shouldHour;
        return this;
    }

    public AttMonthStatisticalReportItem setActualHour(String actualHour) {
        this.actualHour = actualHour;
        return this;
    }

    public AttMonthStatisticalReportItem setValidHour(String validHour) {
        this.validHour = validHour;
        return this;
    }

    public AttMonthStatisticalReportItem setLateMinute(String lateMinute) {
        this.lateMinute = lateMinute;
        return this;
    }

    public AttMonthStatisticalReportItem setLateCountTotal(String lateCountTotal) {
        this.lateCountTotal = lateCountTotal;
        return this;
    }

    public AttMonthStatisticalReportItem setEarlyMinute(String earlyMinute) {
        this.earlyMinute = earlyMinute;
        return this;
    }

    public AttMonthStatisticalReportItem setEarlyCount(String earlyCount) {
        this.earlyCount = earlyCount;
        return this;
    }

    public AttMonthStatisticalReportItem setOvertimeUsualHour(String overtimeUsualHour) {
        this.overtimeUsualHour = overtimeUsualHour;
        return this;
    }

    public AttMonthStatisticalReportItem setOvertimeRestHour(String overtimeRestHour) {
        this.overtimeRestHour = overtimeRestHour;
        return this;
    }

    public AttMonthStatisticalReportItem setOvertimeHolidayHour(String overtimeHolidayHour) {
        this.overtimeHolidayHour = overtimeHolidayHour;
        return this;
    }

    public AttMonthStatisticalReportItem setOvertimeHour(String overtimeHour) {
        this.overtimeHour = overtimeHour;
        return this;
    }

    public AttMonthStatisticalReportItem setAbsentHour(String absentHour) {
        this.absentHour = absentHour;
        return this;
    }

    public AttMonthStatisticalReportItem setAttMonthDetailReportLeaveHourMap(Map<String, Object> attMonthDetailReportLeaveHourMap) {
        this.attMonthDetailReportLeaveHourMap = attMonthDetailReportLeaveHourMap;
        return this;
    }

    @Deprecated
    public AttMonthStatisticalReportItem setSearchMonth(String searchMonth) {
        this.searchMonth = searchMonth;
        return this;
    }

    public AttMonthStatisticalReportItem setMonthStart(Date monthStart) {
        this.monthStart = monthStart;
        return this;
    }

    public AttMonthStatisticalReportItem setMonthEnd(Date monthEnd) {
        this.monthEnd = monthEnd;
        return this;
    }

    public AttMonthStatisticalReportItem setInDeptId(String inDeptId) {
        this.inDeptId = inDeptId;
        return this;
    }

    public AttMonthStatisticalReportItem setLikeName(String likeName) {
        this.likeName = likeName;
        return this;
    }

    public AttMonthStatisticalReportItem setInPersonPin(String inPersonPin) {
        this.inPersonPin = inPersonPin;
        return this;
    }

    public AttMonthStatisticalReportItem setLeaveMinuteTotal(String leaveMinuteTotal) {
        this.leaveMinuteTotal = leaveMinuteTotal;
        return this;
    }

    public AttMonthStatisticalReportItem setShould(String should) {
        this.should = should;
        return this;
    }

    public AttMonthStatisticalReportItem setActual(String actual) {
        this.actual = actual;
        return this;
    }

    public AttMonthStatisticalReportItem setValid(String valid) {
        this.valid = valid;
        return this;
    }

    public AttMonthStatisticalReportItem setLate(String late) {
        this.late = late;
        return this;
    }

    public AttMonthStatisticalReportItem setEarly(String early) {
        this.early = early;
        return this;
    }

    public AttMonthStatisticalReportItem setAbsent(String absent) {
        this.absent = absent;
        return this;
    }

    public AttMonthStatisticalReportItem setOvertimeUsual(String overtimeUsual) {
        this.overtimeUsual = overtimeUsual;
        return this;
    }

    public AttMonthStatisticalReportItem setOvertimeRest(String overtimeRest) {
        this.overtimeRest = overtimeRest;
        return this;
    }

    public AttMonthStatisticalReportItem setOvertimeHoliday(String overtimeHoliday) {
        this.overtimeHoliday = overtimeHoliday;
        return this;
    }

    public AttMonthStatisticalReportItem setOvertime(String overtime) {
        this.overtime = overtime;
        return this;
    }

    public AttMonthStatisticalReportItem setLeave(String leave) {
        this.leave = leave;
        return this;
    }

    public AttMonthStatisticalReportItem setTrip(String trip) {
        this.trip = trip;
        return this;
    }

    public AttMonthStatisticalReportItem setOut(String out) {
        this.out = out;
        return this;
    }

    public String getId() {
        return this.id;
    }

    public String getPin() {
        return this.pin;
    }

    public String getName() {
        return this.name;
    }

    public String getLastName() {
        return this.lastName;
    }

    public String getDeptId() {
        return this.deptId;
    }

    public String getDeptCode() {
        return this.deptCode;
    }

    public String getDeptName() {
        return this.deptName;
    }

    public String getShouldHour() {
        return this.shouldHour;
    }

    public String getActualHour() {
        return this.actualHour;
    }

    public String getValidHour() {
        return this.validHour;
    }

    public String getLateMinute() {
        return this.lateMinute;
    }

    public String getLateCountTotal() {
        return this.lateCountTotal;
    }

    public String getEarlyMinute() {
        return this.earlyMinute;
    }

    public String getEarlyCount() {
        return this.earlyCount;
    }

    public String getOvertimeUsualHour() {
        return this.overtimeUsualHour;
    }

    public String getOvertimeRestHour() {
        return this.overtimeRestHour;
    }

    public String getOvertimeHolidayHour() {
        return this.overtimeHolidayHour;
    }

    public String getOvertimeHour() {
        return this.overtimeHour;
    }

    public String getAbsentHour() {
        return this.absentHour;
    }

    public Map<String, Object> getAttMonthDetailReportLeaveHourMap() {
        return this.attMonthDetailReportLeaveHourMap;
    }

    @Deprecated
    public String getSearchMonth() {
        return this.searchMonth;
    }

    public Date getMonthStart() {
        return this.monthStart;
    }

    public Date getMonthEnd() {
        return this.monthEnd;
    }

    public String getInDeptId() {
        return this.inDeptId;
    }

    public String getLikeName() {
        return this.likeName;
    }

    public String getInPersonPin() {
        return this.inPersonPin;
    }

    public String getLeaveMinuteTotal() {
        return this.leaveMinuteTotal;
    }

    public String getShould() {
        return this.should;
    }

    public String getActual() {
        return this.actual;
    }

    public String getValid() {
        return this.valid;
    }

    public String getLate() {
        return this.late;
    }

    public String getEarly() {
        return this.early;
    }

    public String getAbsent() {
        return this.absent;
    }

    public String getOvertimeUsual() {
        return this.overtimeUsual;
    }

    public String getOvertimeRest() {
        return this.overtimeRest;
    }

    public String getOvertimeHoliday() {
        return this.overtimeHoliday;
    }

    public String getOvertime() {
        return this.overtime;
    }

    public String getLeave() {
        return this.leave;
    }

    public String getTrip() {
        return this.trip;
    }

    public String getOut() {
        return this.out;
    }
}

