/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.att.vo;

import com.zkteco.zkbiosecurity.base.annotation.Column;
import com.zkteco.zkbiosecurity.base.annotation.Condition;
import com.zkteco.zkbiosecurity.base.annotation.From;
import com.zkteco.zkbiosecurity.base.annotation.GridColumn;
import com.zkteco.zkbiosecurity.base.annotation.GridConfig;
import com.zkteco.zkbiosecurity.base.annotation.GridOperate;
import com.zkteco.zkbiosecurity.base.annotation.OrderBy;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import java.util.Date;

@From(after="ATT_LEAVE t LEFT JOIN ATT_LEAVETYPE alt ON alt.ID = t.LEAVETYPE_ID LEFT JOIN AUTH_DEPARTMENT ad ON t.AUTH_DEPT_ID = ad.ID")
@OrderBy(after="t.CREATE_TIME DESC")
@GridConfig(operate=true, idField="id", winHeight=400, winWidth=600, operates={@GridOperate(type="del", permission="att:leave:del", url="attLeave.do?del&pins=(personPin)", label="common_op_del", filter="attApplyShowDel"), @GridOperate(type="custom", permission="att:leave:image", click="openLeaveImage", label="att_leave_image")})
public class AttLeaveItem
extends BaseItem {
    private static final long serialVersionUID = 1L;
    @Column(name="t.ID")
    @GridColumn(checkbox=true, width="40", sort="na")
    private String id;
    @Column(name="t.PERS_PERSON_ID")
    private String personId;
    @Column(name="t.PERS_PERSON_PIN")
    @GridColumn(label="att_person_pin", width="120", encryptMode="${pers.pin.encryptMode}", encryptProp="${pers.pin.encryptProp}")
    private String personPin;
    @GridColumn(label="att_person_name", width="120", encryptMode="${pers.name.encryptMode}", encryptProp="${pers.name.encryptProp}")
    private String personName;
    @GridColumn(label="att_person_lastName", showExpression="#language!='zh_CN'", width="120", encryptMode="${pers.lastName.encryptMode}", encryptProp="${pers.lastName.encryptProp}")
    private String personLastName;
    @Column(name="t.AUTH_DEPT_ID")
    private String deptId;
    @Column(name="ad.CODE")
    @GridColumn(label="att_common_deptNo", width="120")
    private String deptCode;
    @Column(name="ad.NAME")
    @GridColumn(label="att_common_deptName", width="120")
    private String deptName;
    @Column(name="alt.LEAVETYPE_NAME")
    @GridColumn(label="att_leave_arilName", width="120", i18n=true, sort="na")
    private String leaveTypeName;
    @Column(name="alt.LEAVETYPE_NO")
    private String leaveTypeNo;
    @Column(name="t.START_DATETIME")
    @GridColumn(label="common_startTime", width="150")
    private Date startDatetime;
    @Column(name="t.END_DATETIME")
    @GridColumn(label="common_endTime", width="150")
    private Date endDatetime;
    @Column(name="t.LEAVE_LONG")
    @GridColumn(label="att_leave_leaveLongMinute", width="120")
    private Integer leaveLong;
    @GridColumn(label="att_leave_leaveLongHour", width="120", sort="na")
    private String leaveLongHour;
    @Column(name="t.DAYS")
    private Float days;
    @GridColumn(label="common_status", width="120", format="0=att_approve_wait,1=att_exception_stop,2=att_apply_pass,3=att_apply_revoke,4=att_exception_delete,5=att_exception_refuse,6=att_exception_end")
    @Column(name="t.FLOW_STATUS", equalTag="=")
    private String flowStatus;
    @Column(name="t.REMARK")
    @GridColumn(label="common_remark", width="120")
    private String remark;
    @Column(name="t.CREATE_TIME")
    @GridColumn(label="att_common_operateTime", width="130")
    private Date operateDatetime;
    @Column(name="t.LEAVE_IMAGE_PATH")
    private String leaveImagePath;
    @Column(name="t.CLOUD_IMAGE_URL")
    private String cloudImageUrl;
    private String photoUrlList;
    @Column(name="t.LEAVETYPE_ID")
    private String leaveTypeId;
    @Column(name="t.BUSINESS_KEY")
    private String businessKey;
    @Condition(value="t.AUTH_DEPT_ID", equalTag="in")
    private String inDeptId;
    @Condition(value="t.PERS_PERSON_ID", equalTag="in")
    private String inPersonId;
    @Condition(value="t.PERS_PERSON_PIN", equalTag="in")
    private String inPersonPin;
    @Condition(value="t.PERS_PERSON_PIN", equalTag="=")
    private String personPinEq;
    @Condition(value="alt.LEAVETYPE_NO", equalTag="not in")
    private String notInLeaveTypeNo;
    @Condition(value="t.END_DATETIME", equalTag=">=")
    private Date startApplyDateTime;
    @Condition(value="t.START_DATETIME", equalTag="<=")
    private Date endApplyDateTime;
    @Condition(value="t.FLOW_STATUS", equalTag="in")
    private String flowStatusIn;
    @Condition(value="t.AUTH_DEPT_ID IN (SELECT ud.AUTH_DEPT_ID FROM AUTH_USER_DEPT ud WHERE ud.AUTH_USER_ID=''{0}'')")
    private String userId;
    private String likeName;
    private String isIncludeLower;
    private Integer rowNum;
    private String applyNo;
    private String applyType;
    private String flowNo;
    private String notifierPerIds;
    private String notifierPins;
    private String createrId;
    private String createrCode;
    private String createrName;

    public AttLeaveItem() {
    }

    public AttLeaveItem(Boolean equals) {
        super(equals);
    }

    public AttLeaveItem(String id) {
        super(Boolean.valueOf(true));
        this.id = id;
    }

    public AttLeaveItem setId(String id) {
        this.id = id;
        return this;
    }

    public AttLeaveItem setPersonId(String personId) {
        this.personId = personId;
        return this;
    }

    public AttLeaveItem setPersonPin(String personPin) {
        this.personPin = personPin;
        return this;
    }

    public AttLeaveItem setPersonName(String personName) {
        this.personName = personName;
        return this;
    }

    public AttLeaveItem setPersonLastName(String personLastName) {
        this.personLastName = personLastName;
        return this;
    }

    public AttLeaveItem setDeptId(String deptId) {
        this.deptId = deptId;
        return this;
    }

    public AttLeaveItem setDeptCode(String deptCode) {
        this.deptCode = deptCode;
        return this;
    }

    public AttLeaveItem setDeptName(String deptName) {
        this.deptName = deptName;
        return this;
    }

    public AttLeaveItem setLeaveTypeName(String leaveTypeName) {
        this.leaveTypeName = leaveTypeName;
        return this;
    }

    public AttLeaveItem setLeaveTypeNo(String leaveTypeNo) {
        this.leaveTypeNo = leaveTypeNo;
        return this;
    }

    public AttLeaveItem setStartDatetime(Date startDatetime) {
        this.startDatetime = startDatetime;
        return this;
    }

    public AttLeaveItem setEndDatetime(Date endDatetime) {
        this.endDatetime = endDatetime;
        return this;
    }

    public AttLeaveItem setLeaveLong(Integer leaveLong) {
        this.leaveLong = leaveLong;
        return this;
    }

    public AttLeaveItem setLeaveLongHour(String leaveLongHour) {
        this.leaveLongHour = leaveLongHour;
        return this;
    }

    public AttLeaveItem setDays(Float days) {
        this.days = days;
        return this;
    }

    public AttLeaveItem setFlowStatus(String flowStatus) {
        this.flowStatus = flowStatus;
        return this;
    }

    public AttLeaveItem setRemark(String remark) {
        this.remark = remark;
        return this;
    }

    public AttLeaveItem setOperateDatetime(Date operateDatetime) {
        this.operateDatetime = operateDatetime;
        return this;
    }

    public AttLeaveItem setLeaveImagePath(String leaveImagePath) {
        this.leaveImagePath = leaveImagePath;
        return this;
    }

    public AttLeaveItem setCloudImageUrl(String cloudImageUrl) {
        this.cloudImageUrl = cloudImageUrl;
        return this;
    }

    public AttLeaveItem setPhotoUrlList(String photoUrlList) {
        this.photoUrlList = photoUrlList;
        return this;
    }

    public AttLeaveItem setLeaveTypeId(String leaveTypeId) {
        this.leaveTypeId = leaveTypeId;
        return this;
    }

    public AttLeaveItem setBusinessKey(String businessKey) {
        this.businessKey = businessKey;
        return this;
    }

    public AttLeaveItem setInDeptId(String inDeptId) {
        this.inDeptId = inDeptId;
        return this;
    }

    public AttLeaveItem setInPersonId(String inPersonId) {
        this.inPersonId = inPersonId;
        return this;
    }

    public AttLeaveItem setInPersonPin(String inPersonPin) {
        this.inPersonPin = inPersonPin;
        return this;
    }

    public AttLeaveItem setPersonPinEq(String personPinEq) {
        this.personPinEq = personPinEq;
        return this;
    }

    public AttLeaveItem setNotInLeaveTypeNo(String notInLeaveTypeNo) {
        this.notInLeaveTypeNo = notInLeaveTypeNo;
        return this;
    }

    public AttLeaveItem setStartApplyDateTime(Date startApplyDateTime) {
        this.startApplyDateTime = startApplyDateTime;
        return this;
    }

    public AttLeaveItem setEndApplyDateTime(Date endApplyDateTime) {
        this.endApplyDateTime = endApplyDateTime;
        return this;
    }

    public AttLeaveItem setFlowStatusIn(String flowStatusIn) {
        this.flowStatusIn = flowStatusIn;
        return this;
    }

    public AttLeaveItem setUserId(String userId) {
        this.userId = userId;
        return this;
    }

    public AttLeaveItem setLikeName(String likeName) {
        this.likeName = likeName;
        return this;
    }

    public AttLeaveItem setIsIncludeLower(String isIncludeLower) {
        this.isIncludeLower = isIncludeLower;
        return this;
    }

    public AttLeaveItem setRowNum(Integer rowNum) {
        this.rowNum = rowNum;
        return this;
    }

    public AttLeaveItem setApplyNo(String applyNo) {
        this.applyNo = applyNo;
        return this;
    }

    public AttLeaveItem setApplyType(String applyType) {
        this.applyType = applyType;
        return this;
    }

    public AttLeaveItem setFlowNo(String flowNo) {
        this.flowNo = flowNo;
        return this;
    }

    public AttLeaveItem setNotifierPerIds(String notifierPerIds) {
        this.notifierPerIds = notifierPerIds;
        return this;
    }

    public AttLeaveItem setNotifierPins(String notifierPins) {
        this.notifierPins = notifierPins;
        return this;
    }

    public AttLeaveItem setCreaterId(String createrId) {
        this.createrId = createrId;
        return this;
    }

    public AttLeaveItem setCreaterCode(String createrCode) {
        this.createrCode = createrCode;
        return this;
    }

    public AttLeaveItem setCreaterName(String createrName) {
        this.createrName = createrName;
        return this;
    }

    public String getId() {
        return this.id;
    }

    public String getPersonId() {
        return this.personId;
    }

    public String getPersonPin() {
        return this.personPin;
    }

    public String getPersonName() {
        return this.personName;
    }

    public String getPersonLastName() {
        return this.personLastName;
    }

    public String getDeptId() {
        return this.deptId;
    }

    public String getDeptCode() {
        return this.deptCode;
    }

    public String getDeptName() {
        return this.deptName;
    }

    public String getLeaveTypeName() {
        return this.leaveTypeName;
    }

    public String getLeaveTypeNo() {
        return this.leaveTypeNo;
    }

    public Date getStartDatetime() {
        return this.startDatetime;
    }

    public Date getEndDatetime() {
        return this.endDatetime;
    }

    public Integer getLeaveLong() {
        return this.leaveLong;
    }

    public String getLeaveLongHour() {
        return this.leaveLongHour;
    }

    public Float getDays() {
        return this.days;
    }

    public String getFlowStatus() {
        return this.flowStatus;
    }

    public String getRemark() {
        return this.remark;
    }

    public Date getOperateDatetime() {
        return this.operateDatetime;
    }

    public String getLeaveImagePath() {
        return this.leaveImagePath;
    }

    public String getCloudImageUrl() {
        return this.cloudImageUrl;
    }

    public String getPhotoUrlList() {
        return this.photoUrlList;
    }

    public String getLeaveTypeId() {
        return this.leaveTypeId;
    }

    public String getBusinessKey() {
        return this.businessKey;
    }

    public String getInDeptId() {
        return this.inDeptId;
    }

    public String getInPersonId() {
        return this.inPersonId;
    }

    public String getInPersonPin() {
        return this.inPersonPin;
    }

    public String getPersonPinEq() {
        return this.personPinEq;
    }

    public String getNotInLeaveTypeNo() {
        return this.notInLeaveTypeNo;
    }

    public Date getStartApplyDateTime() {
        return this.startApplyDateTime;
    }

    public Date getEndApplyDateTime() {
        return this.endApplyDateTime;
    }

    public String getFlowStatusIn() {
        return this.flowStatusIn;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getLikeName() {
        return this.likeName;
    }

    public String getIsIncludeLower() {
        return this.isIncludeLower;
    }

    public Integer getRowNum() {
        return this.rowNum;
    }

    public String getApplyNo() {
        return this.applyNo;
    }

    public String getApplyType() {
        return this.applyType;
    }

    public String getFlowNo() {
        return this.flowNo;
    }

    public String getNotifierPerIds() {
        return this.notifierPerIds;
    }

    public String getNotifierPins() {
        return this.notifierPins;
    }

    public String getCreaterId() {
        return this.createrId;
    }

    public String getCreaterCode() {
        return this.createrCode;
    }

    public String getCreaterName() {
        return this.createrName;
    }
}

