/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.att.vo;

import com.zkteco.zkbiosecurity.base.annotation.Column;
import com.zkteco.zkbiosecurity.base.annotation.Condition;
import com.zkteco.zkbiosecurity.base.annotation.From;
import com.zkteco.zkbiosecurity.base.annotation.GridColumn;
import com.zkteco.zkbiosecurity.base.annotation.GridConfig;
import com.zkteco.zkbiosecurity.base.annotation.GroupBy;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

@From(after="ATT_RECORD t ")
@GroupBy(after="t.AUTH_DEPT_ID")
@GridConfig(operate=false, idField="id", winHeight=400, winWidth=600)
public class AttDeptStatisticalReportItem
extends BaseItem {
    private static final long serialVersionUID = 1L;
    @GridColumn(show=false)
    private String id;
    @GridColumn(show=false, sortNo=1)
    @Column(name="t.AUTH_DEPT_ID")
    private String deptId;
    @GridColumn(label="att_common_dept", secHeader="common_number", sortNo=2, width="90")
    private String deptCode;
    @GridColumn(label="#cspan", secHeader="common_name", sortNo=3, width="130")
    private String deptName;
    @GridColumn(label="att_rule_arrive", secHeader="att_statistical_should", sortNo=4)
    private String shouldHour;
    @GridColumn(label="#cspan", secHeader="att_statistical_actual", sortNo=5)
    private String actualHour;
    @GridColumn(label="#cspan", secHeader="att_statistical_valid", sortNo=6)
    private String validHour;
    @GridColumn(label="att_common_late", secHeader="att_common_timeLongs", sortNo=7)
    private String lateMinute;
    @Column(name="(COALESCE(SUM(t.LATE_COUNT_TOTAL),0))")
    @GridColumn(label="#cspan", secHeader="att_statistical_numberOfTimes", sortNo=8)
    private String lateCountTotal;
    @GridColumn(label="att_common_early", secHeader="att_common_timeLongs", sortNo=9)
    private String earlyMinute;
    @Column(name="(COALESCE(SUM(t.EARLY_COUNT_TOTAL),0))")
    @GridColumn(label="#cspan", secHeader="att_statistical_numberOfTimes", sortNo=10)
    private String earlyCount;
    @GridColumn(label="att_common_overtime", secHeader="att_statistical_usually", sortNo=11)
    private String overtimeUsualHour;
    @GridColumn(label="#cspan", secHeader="att_statistical_rest", sortNo=12)
    private String overtimeRestHour;
    @GridColumn(label="#cspan", secHeader="att_statistical_holiday", sortNo=13)
    private String overtimeHolidayHour;
    @GridColumn(label="#cspan", secHeader="att_statistical_total", sortNo=14)
    private String overtimeHour;
    @GridColumn(label="att_common_absent", sortNo=60, width="130")
    private String absentHour;
    @GridColumn(dynamicColumn="attLeaveTypeDynamicColumn", sortNo=63, label="att_statistical_leaveDetail")
    private Map<String, Object> attMonthDetailReportLeaveHourMap = new HashMap<String, Object>();
    private String searchMonth;
    @Condition(value="t.ATT_DATE", equalTag=">=")
    private Date monthStart;
    @Condition(value="t.ATT_DATE", equalTag="<=")
    private Date monthEnd;
    @Condition(value="t.AUTH_DEPT_ID", equalTag="in")
    private String inDeptId;

    public AttDeptStatisticalReportItem() {
        this.id = UUID.randomUUID().toString();
    }

    public AttDeptStatisticalReportItem setId(String id) {
        this.id = id;
        return this;
    }

    public AttDeptStatisticalReportItem setDeptId(String deptId) {
        this.deptId = deptId;
        return this;
    }

    public AttDeptStatisticalReportItem setDeptCode(String deptCode) {
        this.deptCode = deptCode;
        return this;
    }

    public AttDeptStatisticalReportItem setDeptName(String deptName) {
        this.deptName = deptName;
        return this;
    }

    public AttDeptStatisticalReportItem setShouldHour(String shouldHour) {
        this.shouldHour = shouldHour;
        return this;
    }

    public AttDeptStatisticalReportItem setActualHour(String actualHour) {
        this.actualHour = actualHour;
        return this;
    }

    public AttDeptStatisticalReportItem setValidHour(String validHour) {
        this.validHour = validHour;
        return this;
    }

    public AttDeptStatisticalReportItem setLateMinute(String lateMinute) {
        this.lateMinute = lateMinute;
        return this;
    }

    public AttDeptStatisticalReportItem setLateCountTotal(String lateCountTotal) {
        this.lateCountTotal = lateCountTotal;
        return this;
    }

    public AttDeptStatisticalReportItem setEarlyMinute(String earlyMinute) {
        this.earlyMinute = earlyMinute;
        return this;
    }

    public AttDeptStatisticalReportItem setEarlyCount(String earlyCount) {
        this.earlyCount = earlyCount;
        return this;
    }

    public AttDeptStatisticalReportItem setOvertimeUsualHour(String overtimeUsualHour) {
        this.overtimeUsualHour = overtimeUsualHour;
        return this;
    }

    public AttDeptStatisticalReportItem setOvertimeRestHour(String overtimeRestHour) {
        this.overtimeRestHour = overtimeRestHour;
        return this;
    }

    public AttDeptStatisticalReportItem setOvertimeHolidayHour(String overtimeHolidayHour) {
        this.overtimeHolidayHour = overtimeHolidayHour;
        return this;
    }

    public AttDeptStatisticalReportItem setOvertimeHour(String overtimeHour) {
        this.overtimeHour = overtimeHour;
        return this;
    }

    public AttDeptStatisticalReportItem setAbsentHour(String absentHour) {
        this.absentHour = absentHour;
        return this;
    }

    public AttDeptStatisticalReportItem setAttMonthDetailReportLeaveHourMap(Map<String, Object> attMonthDetailReportLeaveHourMap) {
        this.attMonthDetailReportLeaveHourMap = attMonthDetailReportLeaveHourMap;
        return this;
    }

    public AttDeptStatisticalReportItem setSearchMonth(String searchMonth) {
        this.searchMonth = searchMonth;
        return this;
    }

    public AttDeptStatisticalReportItem setMonthStart(Date monthStart) {
        this.monthStart = monthStart;
        return this;
    }

    public AttDeptStatisticalReportItem setMonthEnd(Date monthEnd) {
        this.monthEnd = monthEnd;
        return this;
    }

    public AttDeptStatisticalReportItem setInDeptId(String inDeptId) {
        this.inDeptId = inDeptId;
        return this;
    }

    public String getId() {
        return this.id;
    }

    public String getDeptId() {
        return this.deptId;
    }

    public String getDeptCode() {
        return this.deptCode;
    }

    public String getDeptName() {
        return this.deptName;
    }

    public String getShouldHour() {
        return this.shouldHour;
    }

    public String getActualHour() {
        return this.actualHour;
    }

    public String getValidHour() {
        return this.validHour;
    }

    public String getLateMinute() {
        return this.lateMinute;
    }

    public String getLateCountTotal() {
        return this.lateCountTotal;
    }

    public String getEarlyMinute() {
        return this.earlyMinute;
    }

    public String getEarlyCount() {
        return this.earlyCount;
    }

    public String getOvertimeUsualHour() {
        return this.overtimeUsualHour;
    }

    public String getOvertimeRestHour() {
        return this.overtimeRestHour;
    }

    public String getOvertimeHolidayHour() {
        return this.overtimeHolidayHour;
    }

    public String getOvertimeHour() {
        return this.overtimeHour;
    }

    public String getAbsentHour() {
        return this.absentHour;
    }

    public Map<String, Object> getAttMonthDetailReportLeaveHourMap() {
        return this.attMonthDetailReportLeaveHourMap;
    }

    public String getSearchMonth() {
        return this.searchMonth;
    }

    public Date getMonthStart() {
        return this.monthStart;
    }

    public Date getMonthEnd() {
        return this.monthEnd;
    }

    public String getInDeptId() {
        return this.inDeptId;
    }
}

