/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.att.vo;

import com.zkteco.zkbiosecurity.base.annotation.Column;
import com.zkteco.zkbiosecurity.base.annotation.Condition;
import com.zkteco.zkbiosecurity.base.annotation.From;
import com.zkteco.zkbiosecurity.base.annotation.GroupBy;
import com.zkteco.zkbiosecurity.base.annotation.OrderBy;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import java.util.UUID;

@From(after="ATT_TRANSACTION t ")
@GroupBy(after="t.PERS_PERSON_PIN, t.ATT_DATE")
@OrderBy(after="t.ATT_DATE ASC")
public class AttDayCardDetailReportItem
extends BaseItem {
    private static final long serialVersionUID = 1L;
    private String id;
    @Column(name="t.PERS_PERSON_PIN")
    private String personPin;
    @Column(name="t.ATT_DATE")
    private String attDate;
    @Column(name="(COUNT(t.ATT_DATE))")
    private Integer cardCount;
    @Column(name="MIN(t.ATT_TIME)")
    private String earliestTime;
    @Column(name="MAX(t.ATT_TIME)")
    private String latestTime;
    @Condition(value="t.PERS_PERSON_PIN", equalTag="in")
    private String inPersonPin;
    @Condition(value="t.ATT_DATE", equalTag=">=")
    private String attDateBegin;

    public AttDayCardDetailReportItem() {
        this.id = UUID.randomUUID().toString();
    }

    public AttDayCardDetailReportItem(String attDate, String inPersonPin) {
        this.attDate = attDate;
        this.inPersonPin = inPersonPin;
    }

    public AttDayCardDetailReportItem setId(String id) {
        this.id = id;
        return this;
    }

    public AttDayCardDetailReportItem setPersonPin(String personPin) {
        this.personPin = personPin;
        return this;
    }

    public AttDayCardDetailReportItem setAttDate(String attDate) {
        this.attDate = attDate;
        return this;
    }

    public AttDayCardDetailReportItem setCardCount(Integer cardCount) {
        this.cardCount = cardCount;
        return this;
    }

    public AttDayCardDetailReportItem setEarliestTime(String earliestTime) {
        this.earliestTime = earliestTime;
        return this;
    }

    public AttDayCardDetailReportItem setLatestTime(String latestTime) {
        this.latestTime = latestTime;
        return this;
    }

    public AttDayCardDetailReportItem setInPersonPin(String inPersonPin) {
        this.inPersonPin = inPersonPin;
        return this;
    }

    public AttDayCardDetailReportItem setAttDateBegin(String attDateBegin) {
        this.attDateBegin = attDateBegin;
        return this;
    }

    public String getId() {
        return this.id;
    }

    public String getPersonPin() {
        return this.personPin;
    }

    public String getAttDate() {
        return this.attDate;
    }

    public Integer getCardCount() {
        return this.cardCount;
    }

    public String getEarliestTime() {
        return this.earliestTime;
    }

    public String getLatestTime() {
        return this.latestTime;
    }

    public String getInPersonPin() {
        return this.inPersonPin;
    }

    public String getAttDateBegin() {
        return this.attDateBegin;
    }
}

