/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.att.vo;

import com.zkteco.zkbiosecurity.base.annotation.Column;
import com.zkteco.zkbiosecurity.base.annotation.Condition;
import com.zkteco.zkbiosecurity.base.annotation.DateType;
import com.zkteco.zkbiosecurity.base.annotation.From;
import com.zkteco.zkbiosecurity.base.annotation.GridColumn;
import com.zkteco.zkbiosecurity.base.annotation.GridConfig;
import com.zkteco.zkbiosecurity.base.annotation.GridOperate;
import com.zkteco.zkbiosecurity.base.annotation.OrderBy;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import java.io.Serializable;
import java.util.Date;

@From(after="ATT_CYCLESCH t LEFT JOIN ATT_GROUP ag ON ag.ID = t.GROUP_ID LEFT JOIN PERS_PERSON pp ON pp.pin = t.PERS_PERSON_PIN LEFT JOIN AUTH_DEPARTMENT ad ON (ad.ID = t.AUTH_DEPT_ID OR ad.ID = pp.auth_dept_id)")
@OrderBy(after="t.CREATE_TIME DESC")
@GridConfig(operate=true, idField="id", winWidth=440, winHeight=540, operates={@GridOperate(type="edit", permission="att:schDetails:edit", url="attCycleSch.do?edit", label="common_op_edit"), @GridOperate(type="custom", permission="att:schDetails:del", click="attSchDetailsDelVo", label="common_op_del")})
public class AttCycleSchItem
extends BaseItem
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Column(name="t.ID")
    @GridColumn(checkbox=true, width="40", sort="na")
    private String id;
    @Column(name="t.PERS_PERSON_ID")
    private String personId;
    @Column(name="t.PERS_PERSON_PIN")
    @GridColumn(label="att_person_pin", width="120", sort="na", columnType="edit", editPermission="att:schDetails:edit", editUrl="attCycleSch.do?edit", encryptMode="${pers.pin.encryptMode}", encryptProp="${pers.pin.encryptProp}")
    private String personPin;
    @Column(name="pp.NAME")
    @GridColumn(label="att_person_name", width="120", sort="na", columnType="edit", editPermission="att:schDetails:edit", editUrl="attCycleSch.do?edit", encryptMode="${pers.name.encryptMode}", encryptProp="${pers.name.encryptProp}")
    private String personName;
    @Column(name="pp.LAST_NAME")
    @GridColumn(label="att_person_lastName", showExpression="#language!='zh_CN'", width="120", encryptMode="${pers.lastName.encryptMode}", encryptProp="${pers.lastName.encryptProp}")
    private String personLastName;
    @Column(name="ad.ID")
    private String deptId;
    @Column(name="ad.CODE")
    private String deptCode;
    @Column(name="ad.NAME")
    @GridColumn(label="att_common_deptName", width="120", sort="na", columnType="edit", editPermission="att:schDetails:edit", editUrl="attCycleSch.do?edit")
    private String deptName;
    @Column(name="t.GROUP_ID")
    private String groupId;
    @Column(name="ag.GROUP_NAME")
    @GridColumn(label="att_common_groupName", width="120", sort="na", columnType="edit", editPermission="att:schDetails:edit", editUrl="attCycleSch.do?edit")
    private String groupName;
    @Column(name="t.START_DATE")
    @DateType(type="date")
    @GridColumn(label="common_startTime", width="120")
    private Date startDate;
    @Column(name="t.END_DATE")
    @DateType(type="date")
    @GridColumn(label="common_endTime", width="120")
    private Date endDate;
    @Condition(value="t.END_DATE", equalTag=">=")
    private Date startTime;
    @Condition(value="t.START_DATE", equalTag="<=")
    private Date endTime;
    @GridColumn(label="att_shift_name", width="180", sort="na")
    private String shiftName;
    @Column(name="t.SCHEDULE_TYPE")
    @GridColumn(label="att_schedule_type", width="120", format="0=att_schedule_normal,1=att_schedule_intelligent")
    private Short scheduleType;
    @Column(name="t.CYCLE_TYPE")
    private Short cycleType;
    @Condition(value="t.PERS_PERSON_PIN", equalTag="in")
    private String inPersonPin;
    @Condition(value="ad.ID", equalTag="in")
    private String inDeptId;
    @Condition(value="t.GROUP_ID", equalTag="in")
    private String inGroupId;
    private String shiftIds;
    private String isIncludeLower;

    public AttCycleSchItem(String id) {
        super(Boolean.valueOf(true));
        this.id = id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setPersonId(String personId) {
        this.personId = personId;
    }

    public void setPersonPin(String personPin) {
        this.personPin = personPin;
    }

    public void setPersonName(String personName) {
        this.personName = personName;
    }

    public void setPersonLastName(String personLastName) {
        this.personLastName = personLastName;
    }

    public void setDeptId(String deptId) {
        this.deptId = deptId;
    }

    public void setDeptCode(String deptCode) {
        this.deptCode = deptCode;
    }

    public void setDeptName(String deptName) {
        this.deptName = deptName;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public void setShiftName(String shiftName) {
        this.shiftName = shiftName;
    }

    public void setScheduleType(Short scheduleType) {
        this.scheduleType = scheduleType;
    }

    public void setCycleType(Short cycleType) {
        this.cycleType = cycleType;
    }

    public void setInPersonPin(String inPersonPin) {
        this.inPersonPin = inPersonPin;
    }

    public void setInDeptId(String inDeptId) {
        this.inDeptId = inDeptId;
    }

    public void setInGroupId(String inGroupId) {
        this.inGroupId = inGroupId;
    }

    public void setShiftIds(String shiftIds) {
        this.shiftIds = shiftIds;
    }

    public void setIsIncludeLower(String isIncludeLower) {
        this.isIncludeLower = isIncludeLower;
    }

    public String getId() {
        return this.id;
    }

    public String getPersonId() {
        return this.personId;
    }

    public String getPersonPin() {
        return this.personPin;
    }

    public String getPersonName() {
        return this.personName;
    }

    public String getPersonLastName() {
        return this.personLastName;
    }

    public String getDeptId() {
        return this.deptId;
    }

    public String getDeptCode() {
        return this.deptCode;
    }

    public String getDeptName() {
        return this.deptName;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public String getShiftName() {
        return this.shiftName;
    }

    public Short getScheduleType() {
        return this.scheduleType;
    }

    public Short getCycleType() {
        return this.cycleType;
    }

    public String getInPersonPin() {
        return this.inPersonPin;
    }

    public String getInDeptId() {
        return this.inDeptId;
    }

    public String getInGroupId() {
        return this.inGroupId;
    }

    public String getShiftIds() {
        return this.shiftIds;
    }

    public String getIsIncludeLower() {
        return this.isIncludeLower;
    }

    public AttCycleSchItem() {
    }
}

