/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.att.vo;

import com.zkteco.zkbiosecurity.base.annotation.Column;
import com.zkteco.zkbiosecurity.base.annotation.Condition;
import com.zkteco.zkbiosecurity.base.annotation.DateType;
import com.zkteco.zkbiosecurity.base.annotation.From;
import com.zkteco.zkbiosecurity.base.annotation.GridColumn;
import com.zkteco.zkbiosecurity.base.annotation.GridConfig;
import com.zkteco.zkbiosecurity.base.annotation.OrderBy;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import java.util.Date;

@From(after="ATT_PERSON t LEFT JOIN PERS_PERSON p ON t.PERS_PERSON_PIN = p.PIN LEFT JOIN AUTH_DEPARTMENT d ON p.AUTH_DEPT_ID = d.ID")
@OrderBy(after="t.CREATE_TIME DESC")
@GridConfig
public class AttAnnualLeaveReportItem
extends BaseItem {
    private static final long serialVersionUID = 1L;
    @Column(name="t.ID")
    @GridColumn(checkbox=true, width="40", sort="na")
    private String id;
    @Column(name="t.PERS_PERSON_PIN")
    @GridColumn(label="att_common_pin", sortNo=1, width="110", encryptMode="${pers.pin.encryptMode}", encryptProp="${pers.pin.encryptProp}")
    private String persPin;
    @Column(name="p.NAME")
    @GridColumn(label="att_person_name", sortNo=2, width="110", encryptMode="${pers.name.encryptMode}", encryptProp="${pers.name.encryptProp}")
    private String persName;
    @Column(name="p.LAST_NAME")
    @GridColumn(label="att_person_lastName", showExpression="#language!='zh_CN'", sortNo=3, width="110", encryptMode="${pers.lastName.encryptMode}", encryptProp="${pers.lastName.encryptProp}")
    private String personLastName;
    @Column(name="p.AUTH_DEPT_ID")
    private String deptId;
    @Column(name="d.CODE")
    @GridColumn(label="att_common_dept", sortNo=4, show=false, width="110")
    private String deptCode;
    @Column(name="d.NAME")
    @GridColumn(label="pers_dept_deptName", sort="na", sortNo=5, width="110")
    private String deptName;
    @Column(name="p.HIRE_DATE")
    @DateType(type="date")
    @GridColumn(label="pers_cardTemplate_entryDate", sortNo=6, width="110")
    private Date hireDate;
    @Column(name="t.WORK_LONG")
    @GridColumn(label="att_annualLeave_years", sortNo=7, width="110")
    private String workLong;
    @Column(name="t.ANNUAL_LEAVE_DAYS")
    @GridColumn(label="att_annualLeave_calculateDay", sortNo=9, width="110")
    private Integer annualLeaveDays;
    @Column(name="t.ANNUAL_ADJUST_DAYS")
    @GridColumn(label="att_annualLeave_adjustDay", sortNo=10, width="110")
    private Integer annualAdjustDays;
    @GridColumn(label="att_annualLeave_remainingDays", sortNo=11, width="110", columnType="custom", convert="attAnnualLeaveViewDetail")
    private Float annualRemaining;
    @Column(name="t.ANNUAL_VALID_DATE")
    @DateType(type="date")
    private Date annualValidDate;
    @GridColumn(label="att_annualLeave_validDate", sortNo=12, minWidth="200")
    private String annualValidDateStr;
    @Column(name="p.AUTH_DEPT_ID", equalTag="in")
    private String inDeptId;
    @Condition(value="(lower(p.NAME) LIKE ''%{0}%'' OR lower(p.LAST_NAME) LIKE ''%{0}%'')")
    private String likeName;

    public AttAnnualLeaveReportItem() {
    }

    public AttAnnualLeaveReportItem(String id) {
        super(Boolean.valueOf(true));
        this.id = id;
    }

    public AttAnnualLeaveReportItem setId(String id) {
        this.id = id;
        return this;
    }

    public AttAnnualLeaveReportItem setPersPin(String persPin) {
        this.persPin = persPin;
        return this;
    }

    public AttAnnualLeaveReportItem setPersName(String persName) {
        this.persName = persName;
        return this;
    }

    public AttAnnualLeaveReportItem setPersonLastName(String personLastName) {
        this.personLastName = personLastName;
        return this;
    }

    public AttAnnualLeaveReportItem setDeptId(String deptId) {
        this.deptId = deptId;
        return this;
    }

    public AttAnnualLeaveReportItem setDeptCode(String deptCode) {
        this.deptCode = deptCode;
        return this;
    }

    public AttAnnualLeaveReportItem setDeptName(String deptName) {
        this.deptName = deptName;
        return this;
    }

    public AttAnnualLeaveReportItem setHireDate(Date hireDate) {
        this.hireDate = hireDate;
        return this;
    }

    public AttAnnualLeaveReportItem setWorkLong(String workLong) {
        this.workLong = workLong;
        return this;
    }

    public AttAnnualLeaveReportItem setAnnualLeaveDays(Integer annualLeaveDays) {
        this.annualLeaveDays = annualLeaveDays;
        return this;
    }

    public AttAnnualLeaveReportItem setAnnualAdjustDays(Integer annualAdjustDays) {
        this.annualAdjustDays = annualAdjustDays;
        return this;
    }

    public AttAnnualLeaveReportItem setAnnualRemaining(Float annualRemaining) {
        this.annualRemaining = annualRemaining;
        return this;
    }

    public AttAnnualLeaveReportItem setAnnualValidDate(Date annualValidDate) {
        this.annualValidDate = annualValidDate;
        return this;
    }

    public AttAnnualLeaveReportItem setAnnualValidDateStr(String annualValidDateStr) {
        this.annualValidDateStr = annualValidDateStr;
        return this;
    }

    public AttAnnualLeaveReportItem setInDeptId(String inDeptId) {
        this.inDeptId = inDeptId;
        return this;
    }

    public AttAnnualLeaveReportItem setLikeName(String likeName) {
        this.likeName = likeName;
        return this;
    }

    public String getId() {
        return this.id;
    }

    public String getPersPin() {
        return this.persPin;
    }

    public String getPersName() {
        return this.persName;
    }

    public String getPersonLastName() {
        return this.personLastName;
    }

    public String getDeptId() {
        return this.deptId;
    }

    public String getDeptCode() {
        return this.deptCode;
    }

    public String getDeptName() {
        return this.deptName;
    }

    public Date getHireDate() {
        return this.hireDate;
    }

    public String getWorkLong() {
        return this.workLong;
    }

    public Integer getAnnualLeaveDays() {
        return this.annualLeaveDays;
    }

    public Integer getAnnualAdjustDays() {
        return this.annualAdjustDays;
    }

    public Float getAnnualRemaining() {
        return this.annualRemaining;
    }

    public Date getAnnualValidDate() {
        return this.annualValidDate;
    }

    public String getAnnualValidDateStr() {
        return this.annualValidDateStr;
    }

    public String getInDeptId() {
        return this.inDeptId;
    }

    public String getLikeName() {
        return this.likeName;
    }
}

