/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.att.api.vo;

import com.zkteco.zkbiosecurity.base.annotation.Column;
import com.zkteco.zkbiosecurity.base.annotation.Condition;
import com.zkteco.zkbiosecurity.base.annotation.From;
import com.zkteco.zkbiosecurity.base.annotation.GroupBy;
import com.zkteco.zkbiosecurity.base.annotation.OrderBy;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import java.util.Date;
import java.util.UUID;

@From(after="ATT_RECORD t ")
@GroupBy(after="t.PERS_PERSON_PIN")
@OrderBy(after="t.PERS_PERSON_PIN DESC")
public class AttApiMonthStatisticalReportItem
extends BaseItem {
    private static final long serialVersionUID = 1L;
    private String id = UUID.randomUUID().toString();
    @Column(name="t.PERS_PERSON_PIN")
    private String pin;
    @Column(name="MAX(t.PERS_PERSON_NAME)")
    private String name;
    @Column(name="MAX(t.PERS_PERSON_LAST_NAME)")
    private String lastName;
    @Column(name="MAX(t.AUTH_DEPT_ID)")
    private String deptId;
    @Column(name="MAX(t.AUTH_DEPT_CODE)")
    private String deptCode;
    @Column(name="MAX(t.AUTH_DEPT_NAME)")
    private String deptName;
    @Column(name="(COALESCE(SUM(t.SHOULD_MINUTE),0))")
    private String shouldHour;
    @Column(name="(COALESCE(SUM(t.ACTUAL_MINUTE),0))")
    private String actualHour;
    @Condition(value="(COALESCE(SUM(t.ACTUAL_MINUTE),0))", equalTag=">=", coditionType="having")
    private Integer actualMinuteGe;
    @Column(name="(COALESCE(SUM(t.VALID_MINUTE),0))")
    private String validHour;
    @Column(name="(COALESCE(SUM(t.SHOULD_DAYS),0))")
    private String shouldDay;
    @Column(name="(COALESCE(SUM(t.ACTUAL_DAYS),0))")
    private String actualDay;
    @Column(name="(COALESCE(SUM(t.VALID_DAYS),0))")
    private String validDay;
    @Column(name="(COALESCE(SUM(t.LATE_MINUTE_TOTAL),0))")
    private String lateMinute;
    @Column(name="(COALESCE(SUM(t.LATE_COUNT_TOTAL),0))")
    private String lateCountTotal;
    @Column(name="(COALESCE(SUM(t.EARLY_MINUTE_TOTAL),0))")
    private String earlyMinute;
    @Column(name="(COALESCE(SUM(t.EARLY_COUNT_TOTAL),0))")
    private String earlyCount;
    @Column(name="(COALESCE(SUM(t.OVERTIME_USUAL_MINUTE),0))")
    private String overtimeUsualHour;
    @Column(name="(COALESCE(SUM(t.OVERTIME_REST_MINUTE),0))")
    private String overtimeRestHour;
    @Column(name="(COALESCE(SUM(t.OVERTIME_HOLIDAY_MINUTE),0))")
    private String overtimeHolidayHour;
    @Column(name="(COALESCE(SUM(t.OVERTIME_MINUTE),0))")
    private String overtimeHour;
    @Column(name="(COALESCE(SUM(t.ABSENT_MINUTE),0))")
    private String absentHour;
    @Column(name="(COALESCE(SUM(t.LEAVE_MINUTE),0))")
    private String leaveHour;
    @Column(name="(COALESCE(SUM(t.TRIP_MINUTE),0))")
    private String tripHour;
    @Column(name="(COALESCE(SUM(t.OUT_MINUTE),0))")
    private String outHour;
    @Column(name="(COALESCE(SUM(t.ABSENT_DAYS),0))")
    private String absentDay;
    @Column(name="(COALESCE(SUM(t.LEAVE_DAYS),0))")
    private String leaveDay;
    @Column(name="(COALESCE(SUM(t.TRIP_DAYS),0))")
    private String tripDay;
    @Column(name="(COALESCE(SUM(t.OUT_DAYS),0))")
    private String outDay;
    @Column(name="(COALESCE(SUM(t.LEAVE_MINUTE),0))")
    private String leaveMinuteTotal;
    private String searchMonth;
    @Condition(value="t.ATT_DATE", equalTag=">=")
    private Date monthStart;
    @Condition(value="t.ATT_DATE", equalTag="<=")
    private Date monthEnd;
    @Condition(value="t.AUTH_DEPT_ID", equalTag="in")
    private String inDeptId;
    @Condition(value="(lower(t.PERS_PERSON_NAME) LIKE ''%{0}%'' OR lower(t.PERS_PERSON_LAST_NAME) LIKE ''%{0}%'')")
    private String likeName;

    public AttApiMonthStatisticalReportItem setId(String id) {
        this.id = id;
        return this;
    }

    public AttApiMonthStatisticalReportItem setPin(String pin) {
        this.pin = pin;
        return this;
    }

    public AttApiMonthStatisticalReportItem setName(String name) {
        this.name = name;
        return this;
    }

    public AttApiMonthStatisticalReportItem setLastName(String lastName) {
        this.lastName = lastName;
        return this;
    }

    public AttApiMonthStatisticalReportItem setDeptId(String deptId) {
        this.deptId = deptId;
        return this;
    }

    public AttApiMonthStatisticalReportItem setDeptCode(String deptCode) {
        this.deptCode = deptCode;
        return this;
    }

    public AttApiMonthStatisticalReportItem setDeptName(String deptName) {
        this.deptName = deptName;
        return this;
    }

    public AttApiMonthStatisticalReportItem setShouldHour(String shouldHour) {
        this.shouldHour = shouldHour;
        return this;
    }

    public AttApiMonthStatisticalReportItem setActualHour(String actualHour) {
        this.actualHour = actualHour;
        return this;
    }

    public AttApiMonthStatisticalReportItem setActualMinuteGe(Integer actualMinuteGe) {
        this.actualMinuteGe = actualMinuteGe;
        return this;
    }

    public AttApiMonthStatisticalReportItem setValidHour(String validHour) {
        this.validHour = validHour;
        return this;
    }

    public AttApiMonthStatisticalReportItem setShouldDay(String shouldDay) {
        this.shouldDay = shouldDay;
        return this;
    }

    public AttApiMonthStatisticalReportItem setActualDay(String actualDay) {
        this.actualDay = actualDay;
        return this;
    }

    public AttApiMonthStatisticalReportItem setValidDay(String validDay) {
        this.validDay = validDay;
        return this;
    }

    public AttApiMonthStatisticalReportItem setLateMinute(String lateMinute) {
        this.lateMinute = lateMinute;
        return this;
    }

    public AttApiMonthStatisticalReportItem setLateCountTotal(String lateCountTotal) {
        this.lateCountTotal = lateCountTotal;
        return this;
    }

    public AttApiMonthStatisticalReportItem setEarlyMinute(String earlyMinute) {
        this.earlyMinute = earlyMinute;
        return this;
    }

    public AttApiMonthStatisticalReportItem setEarlyCount(String earlyCount) {
        this.earlyCount = earlyCount;
        return this;
    }

    public AttApiMonthStatisticalReportItem setOvertimeUsualHour(String overtimeUsualHour) {
        this.overtimeUsualHour = overtimeUsualHour;
        return this;
    }

    public AttApiMonthStatisticalReportItem setOvertimeRestHour(String overtimeRestHour) {
        this.overtimeRestHour = overtimeRestHour;
        return this;
    }

    public AttApiMonthStatisticalReportItem setOvertimeHolidayHour(String overtimeHolidayHour) {
        this.overtimeHolidayHour = overtimeHolidayHour;
        return this;
    }

    public AttApiMonthStatisticalReportItem setOvertimeHour(String overtimeHour) {
        this.overtimeHour = overtimeHour;
        return this;
    }

    public AttApiMonthStatisticalReportItem setAbsentHour(String absentHour) {
        this.absentHour = absentHour;
        return this;
    }

    public AttApiMonthStatisticalReportItem setLeaveHour(String leaveHour) {
        this.leaveHour = leaveHour;
        return this;
    }

    public AttApiMonthStatisticalReportItem setTripHour(String tripHour) {
        this.tripHour = tripHour;
        return this;
    }

    public AttApiMonthStatisticalReportItem setOutHour(String outHour) {
        this.outHour = outHour;
        return this;
    }

    public AttApiMonthStatisticalReportItem setAbsentDay(String absentDay) {
        this.absentDay = absentDay;
        return this;
    }

    public AttApiMonthStatisticalReportItem setLeaveDay(String leaveDay) {
        this.leaveDay = leaveDay;
        return this;
    }

    public AttApiMonthStatisticalReportItem setTripDay(String tripDay) {
        this.tripDay = tripDay;
        return this;
    }

    public AttApiMonthStatisticalReportItem setOutDay(String outDay) {
        this.outDay = outDay;
        return this;
    }

    public AttApiMonthStatisticalReportItem setLeaveMinuteTotal(String leaveMinuteTotal) {
        this.leaveMinuteTotal = leaveMinuteTotal;
        return this;
    }

    public AttApiMonthStatisticalReportItem setSearchMonth(String searchMonth) {
        this.searchMonth = searchMonth;
        return this;
    }

    public AttApiMonthStatisticalReportItem setMonthStart(Date monthStart) {
        this.monthStart = monthStart;
        return this;
    }

    public AttApiMonthStatisticalReportItem setMonthEnd(Date monthEnd) {
        this.monthEnd = monthEnd;
        return this;
    }

    public AttApiMonthStatisticalReportItem setInDeptId(String inDeptId) {
        this.inDeptId = inDeptId;
        return this;
    }

    public AttApiMonthStatisticalReportItem setLikeName(String likeName) {
        this.likeName = likeName;
        return this;
    }

    public String getId() {
        return this.id;
    }

    public String getPin() {
        return this.pin;
    }

    public String getName() {
        return this.name;
    }

    public String getLastName() {
        return this.lastName;
    }

    public String getDeptId() {
        return this.deptId;
    }

    public String getDeptCode() {
        return this.deptCode;
    }

    public String getDeptName() {
        return this.deptName;
    }

    public String getShouldHour() {
        return this.shouldHour;
    }

    public String getActualHour() {
        return this.actualHour;
    }

    public Integer getActualMinuteGe() {
        return this.actualMinuteGe;
    }

    public String getValidHour() {
        return this.validHour;
    }

    public String getShouldDay() {
        return this.shouldDay;
    }

    public String getActualDay() {
        return this.actualDay;
    }

    public String getValidDay() {
        return this.validDay;
    }

    public String getLateMinute() {
        return this.lateMinute;
    }

    public String getLateCountTotal() {
        return this.lateCountTotal;
    }

    public String getEarlyMinute() {
        return this.earlyMinute;
    }

    public String getEarlyCount() {
        return this.earlyCount;
    }

    public String getOvertimeUsualHour() {
        return this.overtimeUsualHour;
    }

    public String getOvertimeRestHour() {
        return this.overtimeRestHour;
    }

    public String getOvertimeHolidayHour() {
        return this.overtimeHolidayHour;
    }

    public String getOvertimeHour() {
        return this.overtimeHour;
    }

    public String getAbsentHour() {
        return this.absentHour;
    }

    public String getLeaveHour() {
        return this.leaveHour;
    }

    public String getTripHour() {
        return this.tripHour;
    }

    public String getOutHour() {
        return this.outHour;
    }

    public String getAbsentDay() {
        return this.absentDay;
    }

    public String getLeaveDay() {
        return this.leaveDay;
    }

    public String getTripDay() {
        return this.tripDay;
    }

    public String getOutDay() {
        return this.outDay;
    }

    public String getLeaveMinuteTotal() {
        return this.leaveMinuteTotal;
    }

    public String getSearchMonth() {
        return this.searchMonth;
    }

    public Date getMonthStart() {
        return this.monthStart;
    }

    public Date getMonthEnd() {
        return this.monthEnd;
    }

    public String getInDeptId() {
        return this.inDeptId;
    }

    public String getLikeName() {
        return this.likeName;
    }
}

