/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.event.center.vo;

import com.zkteco.zkbiosecurity.base.annotation.Column;
import com.zkteco.zkbiosecurity.base.annotation.Condition;
import com.zkteco.zkbiosecurity.base.annotation.From;
import com.zkteco.zkbiosecurity.base.annotation.GridColumn;
import com.zkteco.zkbiosecurity.base.annotation.GridConfig;
import com.zkteco.zkbiosecurity.base.annotation.OrderBy;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import java.io.Serializable;
import java.util.Date;

@From(after="EVENT_RECORD t")
@OrderBy(after="t.EVENT_TIME DESC")
@GridConfig(operate=true, idField="id")
public class EventRecordItem
extends BaseItem
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Column(name="t.ID")
    @GridColumn(columnType="ra", width="40", sort="na", isExportExcel=false)
    private String id;
    @Column(name="t.OBJ_NAME")
    @GridColumn(label="event_center_objName", width="150", sort="na")
    private String objName;
    @Condition(value="t.OBJ_NAME NOT IN (%s)", formatType="quote")
    private String objNameNotIn;
    @Column(name="t.OBJ_TYPE", equalTag="=")
    @GridColumn(label="event_center_objType", width="80", sort="na", format="0=event_objType_per,1=event_objType_car,2=event_objType_stuff,3=event_objType_dev,4=event_objType_subset,5=event_objType_system", show=false)
    private String objType;
    @Condition(value="t.OBJ_TYPE NOT IN (%s)", formatType="quote")
    private String objTypeNotIn;
    @Column(name="t.OBJ_KEY", equalTag="=")
    @GridColumn(label="event_center_objKey", width="150", sort="na", show=false)
    private String objKey;
    @Column(name="t.EVENT_NAME")
    @GridColumn(label="event_center_eventName", width="150", sort="na")
    private String eventName;
    @Column(name="t.LEVEL_VAL", equalTag="=")
    private String eventLevelVal;
    @Column(name="t.LEVEL_NAME")
    @GridColumn(label="event_center_eventLevelName", width="80", sort="na")
    private String eventLevelName;
    @Column(name="t.EVENT_TIME")
    @GridColumn(label="event_center_eventTime", width="150")
    private Date eventTime;
    @Column(name="t.EVENT_TIME", equalTag=">=")
    private Date startTime;
    @Column(name="t.EVENT_TIME", equalTag="<=")
    private Date endTime;
    @Column(name="t.SOURCE_KEY")
    private String sourceKey;
    @Column(name="t.SOURCE_NAME")
    @GridColumn(label="event_center_sourceName", width="150", sort="na")
    private String sourceName;
    @Column(name="t.AREA_ID")
    private String areaId;
    @Condition(value="t.AREA_ID", equalTag="not in")
    private String areaIdNotIn;
    @Condition(value="t.AREA_ID", equalTag="in")
    private String areaIdIn;
    @Column(name="t.AREA_NAME")
    @GridColumn(label="event_center_areaName", width="100", sort="na")
    private String areaName;
    @Column(name="t.SOURCE_MODULE", equalTag="in")
    @GridColumn(label="event_center_sourceModule", width="80", sort="na", i18n=true)
    private String sourceModule;
    @Column(name="t.CAPTURE_IMG_URL")
    @GridColumn(label="event_center_captureImgURL", width="80", sort="na", columnType="custom", convert="photoLinkageConvert", isExportExcel=false)
    private String captureImgURL;
    @Column(name="t.PANORAMA_IMG_URL")
    @GridColumn(label="event_center_panoramaImgURL", width="80", sort="na", columnType="custom", convert="photoLinkageConvert", isExportExcel=false)
    private String panoramaImgURL;
    @Column(name="t.EVENT_TYPE_ID")
    private String eventTypeId;
    @Column(name="t.TYPE_CODE")
    @GridColumn(label="event_center_eventTypeName", width="100", sort="na", show=false)
    private String eventTypeCode;
    @Condition(value="t.LEVEL_VAL IN (%s)", formatType="quote")
    private String eventLevelValIn;
    @Column(name="t.PROCESS_STATE")
    @GridColumn(label="event_center_processState", width="80", sort="na", format="0=event_center_processState0,1=event_center_processState1,2=base_rt_event_normal")
    private String processState;
    @Condition(value="t.PROCESS_STATE IN (%s)", formatType="quote")
    private String processStateIn;
    @Column(name="t.UPDATER_CODE")
    @GridColumn(label="event_center_processor", width="80", sort="na")
    private String updaterCode;
    @Column(name="t.EVENT_REMARK")
    @GridColumn(label="event_center_eventRemark", width="150", sort="na")
    private String eventRemark;
    @Column(name="t.VIDEO_CHANNEL_ID")
    private String videoChannelId;
    @Condition(value="t.SOURCE_MODULE IN (%s)", formatType="quote")
    private String sourceModuleIn;
    @Condition(value="t.ID IN (%s)", formatType="quote")
    private String eventIds;
    @Condition(value="t.SOURCE_KEY IN (%s)", formatType="quote")
    private String sourceKeyIn;
    private String snapshot;
    private String panorama;
    @Column(name="t.RE_ID")
    private String reId;
    @Condition(value="t.RE_ID IN (%s)", formatType="quote")
    private String reIds;
    @Column(name="t.FACE_RATE")
    private String faceRate;
    @Condition(value="t.AREA_ID IN (SELECT ud.AUTH_AREA_ID FROM AUTH_USER_AREA ud WHERE ud.AUTH_USER_ID=''{0}'')")
    private String areaIdInByUserId;
    private String groupBy;
    @Column(name="t.EVENT_TIME")
    private String eventTimeStr;
    private String deviceSn;
    private String subsetNo;

    public EventRecordItem() {
    }

    public EventRecordItem(String id) {
        this.id = id;
    }

    public EventRecordItem setId(String id) {
        this.id = id;
        return this;
    }

    public EventRecordItem setObjName(String objName) {
        this.objName = objName;
        return this;
    }

    public EventRecordItem setObjNameNotIn(String objNameNotIn) {
        this.objNameNotIn = objNameNotIn;
        return this;
    }

    public EventRecordItem setObjType(String objType) {
        this.objType = objType;
        return this;
    }

    public EventRecordItem setObjTypeNotIn(String objTypeNotIn) {
        this.objTypeNotIn = objTypeNotIn;
        return this;
    }

    public EventRecordItem setObjKey(String objKey) {
        this.objKey = objKey;
        return this;
    }

    public EventRecordItem setEventName(String eventName) {
        this.eventName = eventName;
        return this;
    }

    public EventRecordItem setEventLevelVal(String eventLevelVal) {
        this.eventLevelVal = eventLevelVal;
        return this;
    }

    public EventRecordItem setEventLevelName(String eventLevelName) {
        this.eventLevelName = eventLevelName;
        return this;
    }

    public EventRecordItem setEventTime(Date eventTime) {
        this.eventTime = eventTime;
        return this;
    }

    public EventRecordItem setStartTime(Date startTime) {
        this.startTime = startTime;
        return this;
    }

    public EventRecordItem setEndTime(Date endTime) {
        this.endTime = endTime;
        return this;
    }

    public EventRecordItem setSourceKey(String sourceKey) {
        this.sourceKey = sourceKey;
        return this;
    }

    public EventRecordItem setSourceName(String sourceName) {
        this.sourceName = sourceName;
        return this;
    }

    public EventRecordItem setAreaId(String areaId) {
        this.areaId = areaId;
        return this;
    }

    public EventRecordItem setAreaIdNotIn(String areaIdNotIn) {
        this.areaIdNotIn = areaIdNotIn;
        return this;
    }

    public EventRecordItem setAreaIdIn(String areaIdIn) {
        this.areaIdIn = areaIdIn;
        return this;
    }

    public EventRecordItem setAreaName(String areaName) {
        this.areaName = areaName;
        return this;
    }

    public EventRecordItem setSourceModule(String sourceModule) {
        this.sourceModule = sourceModule;
        return this;
    }

    public EventRecordItem setCaptureImgURL(String captureImgURL) {
        this.captureImgURL = captureImgURL;
        return this;
    }

    public EventRecordItem setPanoramaImgURL(String panoramaImgURL) {
        this.panoramaImgURL = panoramaImgURL;
        return this;
    }

    public EventRecordItem setEventTypeId(String eventTypeId) {
        this.eventTypeId = eventTypeId;
        return this;
    }

    public EventRecordItem setEventTypeCode(String eventTypeCode) {
        this.eventTypeCode = eventTypeCode;
        return this;
    }

    public EventRecordItem setEventLevelValIn(String eventLevelValIn) {
        this.eventLevelValIn = eventLevelValIn;
        return this;
    }

    public EventRecordItem setProcessState(String processState) {
        this.processState = processState;
        return this;
    }

    public EventRecordItem setProcessStateIn(String processStateIn) {
        this.processStateIn = processStateIn;
        return this;
    }

    public EventRecordItem setUpdaterCode(String updaterCode) {
        this.updaterCode = updaterCode;
        return this;
    }

    public EventRecordItem setEventRemark(String eventRemark) {
        this.eventRemark = eventRemark;
        return this;
    }

    public EventRecordItem setVideoChannelId(String videoChannelId) {
        this.videoChannelId = videoChannelId;
        return this;
    }

    public EventRecordItem setSourceModuleIn(String sourceModuleIn) {
        this.sourceModuleIn = sourceModuleIn;
        return this;
    }

    public EventRecordItem setEventIds(String eventIds) {
        this.eventIds = eventIds;
        return this;
    }

    public EventRecordItem setSourceKeyIn(String sourceKeyIn) {
        this.sourceKeyIn = sourceKeyIn;
        return this;
    }

    public EventRecordItem setSnapshot(String snapshot) {
        this.snapshot = snapshot;
        return this;
    }

    public EventRecordItem setPanorama(String panorama) {
        this.panorama = panorama;
        return this;
    }

    public EventRecordItem setReId(String reId) {
        this.reId = reId;
        return this;
    }

    public EventRecordItem setReIds(String reIds) {
        this.reIds = reIds;
        return this;
    }

    public EventRecordItem setFaceRate(String faceRate) {
        this.faceRate = faceRate;
        return this;
    }

    public EventRecordItem setAreaIdInByUserId(String areaIdInByUserId) {
        this.areaIdInByUserId = areaIdInByUserId;
        return this;
    }

    public EventRecordItem setGroupBy(String groupBy) {
        this.groupBy = groupBy;
        return this;
    }

    public EventRecordItem setEventTimeStr(String eventTimeStr) {
        this.eventTimeStr = eventTimeStr;
        return this;
    }

    public EventRecordItem setDeviceSn(String deviceSn) {
        this.deviceSn = deviceSn;
        return this;
    }

    public EventRecordItem setSubsetNo(String subsetNo) {
        this.subsetNo = subsetNo;
        return this;
    }

    public String getId() {
        return this.id;
    }

    public String getObjName() {
        return this.objName;
    }

    public String getObjNameNotIn() {
        return this.objNameNotIn;
    }

    public String getObjType() {
        return this.objType;
    }

    public String getObjTypeNotIn() {
        return this.objTypeNotIn;
    }

    public String getObjKey() {
        return this.objKey;
    }

    public String getEventName() {
        return this.eventName;
    }

    public String getEventLevelVal() {
        return this.eventLevelVal;
    }

    public String getEventLevelName() {
        return this.eventLevelName;
    }

    public Date getEventTime() {
        return this.eventTime;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public String getSourceKey() {
        return this.sourceKey;
    }

    public String getSourceName() {
        return this.sourceName;
    }

    public String getAreaId() {
        return this.areaId;
    }

    public String getAreaIdNotIn() {
        return this.areaIdNotIn;
    }

    public String getAreaIdIn() {
        return this.areaIdIn;
    }

    public String getAreaName() {
        return this.areaName;
    }

    public String getSourceModule() {
        return this.sourceModule;
    }

    public String getCaptureImgURL() {
        return this.captureImgURL;
    }

    public String getPanoramaImgURL() {
        return this.panoramaImgURL;
    }

    public String getEventTypeId() {
        return this.eventTypeId;
    }

    public String getEventTypeCode() {
        return this.eventTypeCode;
    }

    public String getEventLevelValIn() {
        return this.eventLevelValIn;
    }

    public String getProcessState() {
        return this.processState;
    }

    public String getProcessStateIn() {
        return this.processStateIn;
    }

    public String getUpdaterCode() {
        return this.updaterCode;
    }

    public String getEventRemark() {
        return this.eventRemark;
    }

    public String getVideoChannelId() {
        return this.videoChannelId;
    }

    public String getSourceModuleIn() {
        return this.sourceModuleIn;
    }

    public String getEventIds() {
        return this.eventIds;
    }

    public String getSourceKeyIn() {
        return this.sourceKeyIn;
    }

    public String getSnapshot() {
        return this.snapshot;
    }

    public String getPanorama() {
        return this.panorama;
    }

    public String getReId() {
        return this.reId;
    }

    public String getReIds() {
        return this.reIds;
    }

    public String getFaceRate() {
        return this.faceRate;
    }

    public String getAreaIdInByUserId() {
        return this.areaIdInByUserId;
    }

    public String getGroupBy() {
        return this.groupBy;
    }

    public String getEventTimeStr() {
        return this.eventTimeStr;
    }

    public String getDeviceSn() {
        return this.deviceSn;
    }

    public String getSubsetNo() {
        return this.subsetNo;
    }

    public String toString() {
        return "EventRecordItem(id=" + this.getId() + ", objName=" + this.getObjName() + ", objNameNotIn=" + this.getObjNameNotIn() + ", objType=" + this.getObjType() + ", objTypeNotIn=" + this.getObjTypeNotIn() + ", objKey=" + this.getObjKey() + ", eventName=" + this.getEventName() + ", eventLevelVal=" + this.getEventLevelVal() + ", eventLevelName=" + this.getEventLevelName() + ", eventTime=" + this.getEventTime() + ", startTime=" + this.getStartTime() + ", endTime=" + this.getEndTime() + ", sourceKey=" + this.getSourceKey() + ", sourceName=" + this.getSourceName() + ", areaId=" + this.getAreaId() + ", areaIdNotIn=" + this.getAreaIdNotIn() + ", areaIdIn=" + this.getAreaIdIn() + ", areaName=" + this.getAreaName() + ", sourceModule=" + this.getSourceModule() + ", captureImgURL=" + this.getCaptureImgURL() + ", panoramaImgURL=" + this.getPanoramaImgURL() + ", eventTypeId=" + this.getEventTypeId() + ", eventTypeCode=" + this.getEventTypeCode() + ", eventLevelValIn=" + this.getEventLevelValIn() + ", processState=" + this.getProcessState() + ", processStateIn=" + this.getProcessStateIn() + ", updaterCode=" + this.getUpdaterCode() + ", eventRemark=" + this.getEventRemark() + ", videoChannelId=" + this.getVideoChannelId() + ", sourceModuleIn=" + this.getSourceModuleIn() + ", eventIds=" + this.getEventIds() + ", sourceKeyIn=" + this.getSourceKeyIn() + ", snapshot=" + this.getSnapshot() + ", panorama=" + this.getPanorama() + ", reId=" + this.getReId() + ", reIds=" + this.getReIds() + ", faceRate=" + this.getFaceRate() + ", areaIdInByUserId=" + this.getAreaIdInByUserId() + ", groupBy=" + this.getGroupBy() + ", eventTimeStr=" + this.getEventTimeStr() + ", deviceSn=" + this.getDeviceSn() + ", subsetNo=" + this.getSubsetNo() + ")";
    }
}

