/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.sms.modem.web.controller;

import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import com.zkteco.zkbiosecurity.sms.modem.remote.SmsModemMessageRemote;
import com.zkteco.zkbiosecurity.sms.modem.service.SmsModemMessageService;
import com.zkteco.zkbiosecurity.sms.modem.vo.SmsModemMessageBeanItem;
import com.zkteco.zkbiosecurity.sms.modem.vo.SmsModemMessageItem;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class SmsModemMessageController
extends BaseController
implements SmsModemMessageRemote {
    @Autowired
    private SmsModemMessageService smsModemMessageService;

    @RequiresPermissions(value={"smsModem:message"})
    public ModelAndView index() {
        return new ModelAndView("sms/modem/message/smsModemMessage");
    }

    @RequiresPermissions(value={"smsModem:message:refresh"})
    public DxGrid list(SmsModemMessageItem condition) {
        Pager pager = this.smsModemMessageService.getItemsByPage((BaseItem)condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @RequiresPermissions(value={"smsModem:message:del"})
    @LogRequest(module="system_module", object="smsModem_message_management", opType="common_op_del", requestParams={"sendTime"}, opContent="common_op_del")
    public ZKResultMsg del(@RequestParam(value="ids") String ids) {
        this.smsModemMessageService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    @RequiresPermissions(value={"smsModem:message:paramSetting"})
    public ModelAndView getSmsModemMessageParam() {
        Map smsModemMessageParams = this.smsModemMessageService.getSmsModemMessageParams();
        this.request.setAttribute("smsModemMessageParams", (Object)smsModemMessageParams);
        this.request.setAttribute("editPage", (Object)"true");
        return new ModelAndView("sms/modem/message/setSmsModemMessageParams");
    }

    @RequiresPermissions(value={"smsModem:message:paramSetting"})
    @LogRequest(module="system_module", object="smsModem_message_management", opType="smsModem_message_paramSetting", opContent="common_op_edit")
    public ZKResultMsg saveSmsModemMessageParam(@RequestParam Map<String, String> params) {
        String smsEnable = params.get("smsModem.smsEnable");
        if (StringUtils.isBlank((CharSequence)smsEnable)) {
            params.put("smsModem.smsEnable", "0");
        }
        this.smsModemMessageService.saveSmsModemMessageParam(params);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    public ZKResultMsg testSendMessage() {
        Short ret;
        String smsc = this.request.getParameter("smsc");
        String port = this.request.getParameter("port");
        if (StringUtils.isNotBlank((CharSequence)smsc) && StringUtils.isNotBlank((CharSequence)port)) {
            String receiver = this.request.getParameter("receiver");
            String content = this.request.getParameter("content");
            SmsModemMessageBeanItem smsModemMessageBeanItem = new SmsModemMessageBeanItem();
            smsModemMessageBeanItem.setSmsc(smsc);
            smsModemMessageBeanItem.setPortName(port);
            smsModemMessageBeanItem.setReceiver(receiver);
            smsModemMessageBeanItem.setContent(content);
            ret = this.smsModemMessageService.testSend(smsModemMessageBeanItem);
        } else {
            ret = -8;
        }
        return new ZKResultMsg((Object)(ret + ""));
    }

    public ZKResultMsg getSmscNumber(@RequestParam Map<String, String> params) {
        String ret;
        this.smsModemMessageService.disConnect();
        String port = this.request.getParameter("port");
        HashMap<String, String> param = new HashMap<String, String>();
        if (StringUtils.isNotBlank((CharSequence)port)) {
            param.put("smsModem.port", port);
            this.smsModemMessageService.saveSmsModemMessageParam(param);
            this.smsModemMessageService.connect(port);
        }
        if ("error".equals(ret = this.smsModemMessageService.getSmscNumber())) {
            return I18nUtil.i18nMsg((ZKResultMsg)ZKResultMsg.failMsg());
        }
        param.put("smsModem.smsc", ret);
        this.smsModemMessageService.saveSmsModemMessageParam(param);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg((Object)ret));
    }

    public ZKResultMsg testAwsSendMessage() {
        Short ret;
        String smsAccessKey = this.request.getParameter("smsAccessKey");
        String smsSecretKey = this.request.getParameter("smsSecretKey");
        if (StringUtils.isNotBlank((CharSequence)smsAccessKey) && StringUtils.isNotBlank((CharSequence)smsSecretKey)) {
            String receiver = this.request.getParameter("receiver");
            String content = this.request.getParameter("content");
            SmsModemMessageBeanItem smsModemMessageBeanItem = new SmsModemMessageBeanItem();
            smsModemMessageBeanItem.setSmsAccessKey(smsAccessKey);
            smsModemMessageBeanItem.setSmsSecretKey(smsSecretKey);
            smsModemMessageBeanItem.setReceiver(receiver);
            smsModemMessageBeanItem.setContent(content);
            ret = this.smsModemMessageService.testAwsSend(smsModemMessageBeanItem);
        } else {
            ret = -8;
        }
        return new ZKResultMsg((Object)(ret + ""));
    }
}

